/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage loadCompatibleImage(InputStream stream) throws IOException {
        BufferedImage image = ImageIO.read(stream);
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (GraphicsUtilities.isHeadless()) {
            return image;
        }
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g10 = compatibleImage.getGraphics();
        g10.drawImage(image, 0, 0, null);
        g10.dispose();
        return compatibleImage;
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return environment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage createTranslucentCompatibleImage(int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    public static int[] getPixels(BufferedImage img, int x10, int y10, int w10, int h10, int[] pixels) {
        if (w10 == 0 || h10 == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w10 * h10];
        } else if (pixels.length < w10 * h10) {
            throw new IllegalArgumentException("Pixels array must have a length >= w * h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x10, y10, w10, h10, pixels);
        }
        return img.getRGB(x10, y10, w10, h10, pixels, 0, w10);
    }
}

