/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.apk.analyzer.internal.rewriters.FieldReferenceWithNameRewriter;
import com.android.tools.apk.analyzer.internal.rewriters.MethodReferenceWithNameRewriter;
import com.android.tools.proguard.ProguardMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.rewriter.DexRewriter;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterModule;
import org.jf.dexlib2.rewriter.Rewriters;
import org.jf.dexlib2.rewriter.TypeRewriter;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.IndentingWriter;

public class DexDisassembler {
    private final DexFile dexFile;
    private final ProguardMap proguardMap;

    public DexDisassembler(DexBackedDexFile dexFile, ProguardMap proguardMap) {
        this.dexFile = proguardMap == null ? dexFile : DexDisassembler.rewriteDexFile((DexFile)dexFile, proguardMap);
        this.proguardMap = proguardMap;
    }

    public String disassembleMethod(String fqcn, String methodDescriptor) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        Optional<Method> method = StreamSupport.stream(classDef.get().getMethods().spliterator(), false).filter(m10 -> methodDescriptor.equals(ReferenceUtil.getMethodDescriptor((MethodReference)m10))).findFirst();
        if (!method.isPresent()) {
            throw new IllegalStateException("Unable to locate method definition in class for method " + methodDescriptor);
        }
        return DexDisassembler.getMethodDexCode(classDef.get(), method.get());
    }

    public String disassembleMethod(String fqcn, MethodReference methodRef) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        MethodReference finalMethodRef = this.proguardMap != null ? (MethodReference)DexDisassembler.getRewriter(this.proguardMap).getMethodReferenceRewriter().rewrite((Object)methodRef) : methodRef;
        Optional<Method> method = StreamSupport.stream(classDef.get().getMethods().spliterator(), false).filter(arg_0 -> ((MethodReference)finalMethodRef).equals(arg_0)).findFirst();
        if (!method.isPresent()) {
            throw new IllegalStateException("Unable to locate method definition in class for method " + methodRef);
        }
        return DexDisassembler.getMethodDexCode(classDef.get(), method.get());
    }

    private static String getMethodDexCode(ClassDef classDef, Method method) throws IOException {
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef);
        StringWriter writer = new StringWriter(1024);
        try (IndentingWriter iw2 = new IndentingWriter((Writer)writer);){
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null) {
                MethodDefinition.writeEmptyMethodTo((IndentingWriter)iw2, (Method)method, (BaksmaliOptions)options);
            } else {
                MethodDefinition methodDefinition = new MethodDefinition(classDefinition, method, methodImpl);
                methodDefinition.writeTo(iw2);
            }
        }
        return writer.toString().replace("\r", "");
    }

    public String disassembleClass(String fqcn) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef.get());
        StringWriter writer = new StringWriter(1024);
        try (IndentingWriter iw2 = new IndentingWriter((Writer)writer);){
            classDefinition.writeTo(iw2);
        }
        return writer.toString().replace("\r", "");
    }

    private static DexFile rewriteDexFile(DexFile dexFile, ProguardMap map) {
        DexRewriter rewriter = DexDisassembler.getRewriter(map);
        return rewriter.rewriteDexFile(dexFile);
    }

    private static DexRewriter getRewriter(final ProguardMap map) {
        return new DexRewriter(new RewriterModule(){

            public Rewriter<String> getTypeRewriter(Rewriters rewriters) {
                return new TypeRewriter(){

                    public String rewrite(String typeName) {
                        return SigUtils.typeToSignature(PackageTreeCreator.decodeClassName(typeName, map));
                    }
                };
            }

            public Rewriter<FieldReference> getFieldReferenceRewriter(Rewriters rewriters) {
                return new FieldReferenceWithNameRewriter(rewriters){

                    @Override
                    public String rewriteName(FieldReference fieldReference) {
                        return PackageTreeCreator.decodeFieldName(fieldReference, map);
                    }
                };
            }

            public Rewriter<MethodReference> getMethodReferenceRewriter(Rewriters rewriters) {
                return new MethodReferenceWithNameRewriter(rewriters){

                    @Override
                    public String rewriteName(MethodReference methodReference) {
                        return PackageTreeCreator.decodeMethodName(methodReference, map);
                    }
                };
            }
        });
    }

    private Optional<? extends ClassDef> getClassDef(String fqcn) {
        return this.dexFile.getClasses().stream().filter(c10 -> fqcn.equals(SigUtils.signatureToName(c10.getType()))).findFirst();
    }
}

