/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.IDevice;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ApkVerifierTracker {
    @VisibleForTesting
    static final String SKIP_VERIFICATION_OPTION = "--skip-verification";
    @VisibleForTesting
    static final long TIME_BETWEEN_VERIFICATIONS_MS = TimeUnit.HOURS.toMillis(1L);
    private static final Map<String, Long> lastVerifiedTimeMap = new HashMap<String, Long>();

    public static synchronized String getSkipVerificationInstallationFlag(IDevice device, String packageName) {
        return ApkVerifierTracker.getSkipVerificationInstallationFlag(device, packageName, System.currentTimeMillis());
    }

    @VisibleForTesting
    static String getSkipVerificationInstallationFlag(IDevice device, String packageName, long currentTimeMs) {
        long lastVerifiedTime;
        if (!device.supportsFeature(IDevice.Feature.SKIP_VERIFICATION)) {
            return null;
        }
        String key = ApkVerifierTracker.getVerifiedTimeMapKey(device, packageName);
        if (!lastVerifiedTimeMap.containsKey(key)) {
            lastVerifiedTimeMap.put(key, currentTimeMs - TIME_BETWEEN_VERIFICATIONS_MS);
        }
        if (currentTimeMs - (lastVerifiedTime = lastVerifiedTimeMap.get(key).longValue()) < TIME_BETWEEN_VERIFICATIONS_MS) {
            return SKIP_VERIFICATION_OPTION;
        }
        lastVerifiedTimeMap.put(key, currentTimeMs);
        return null;
    }

    @VisibleForTesting
    static void clear() {
        lastVerifiedTimeMap.clear();
    }

    private static String getVerifiedTimeMapKey(IDevice device, String packageName) {
        return String.format("%s:%s", device.getSerialNumber(), packageName);
    }
}

