/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkMap;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;

public class PatchGenerator {
    private ILogger logger;

    public PatchGenerator(ILogger logger) {
        this.logger = logger;
    }

    public Patch generate(Apk remoteApk, Apk localApk) throws IOException {
        String sourcePath = remoteApk.path;
        long destinationSize = Files.size(Paths.get(localApk.path, new String[0]));
        List<ApkMap.Area> dirtyAreas = this.generateDirtyMap(remoteApk, localApk);
        int patchSize = 0;
        for (ApkMap.Area dirtyArea : dirtyAreas) {
            patchSize = (int)((long)patchSize + dirtyArea.size());
        }
        if (patchSize > 0x2800000) {
            return new Patch(Patch.Status.SizeThresholdExceeded);
        }
        ByteBuffer data = ByteBuffer.wrap(new byte[patchSize]);
        ByteBuffer instructions = ByteBuffer.wrap(new byte[dirtyAreas.size() * 8]).order(ByteOrder.LITTLE_ENDIAN);
        Trace.begin("building patch");
        try (FileChannel fileChannel = FileChannel.open(Paths.get(localApk.path, new String[0]), StandardOpenOption.READ);){
            for (ApkMap.Area dirtyArea : dirtyAreas) {
                instructions.putInt((int)dirtyArea.start);
                instructions.putInt((int)dirtyArea.size());
                data.limit((int)((long)data.position() + dirtyArea.size()));
                fileChannel.read(data, dirtyArea.start);
            }
        }
        Trace.end();
        data.rewind();
        instructions.rewind();
        return new Patch(data, instructions, sourcePath, destinationSize);
    }

    public Patch generateCleanPatch(Apk remoteApk, Apk localApk) throws IOException {
        String sourcePath = remoteApk.path;
        long destinationSize = Files.size(Paths.get(localApk.path, new String[0]));
        return new Patch(null, null, sourcePath, destinationSize);
    }

    private List<ApkMap.Area> generateDirtyMap(Apk remoteApk, Apk localApk) throws IOException {
        Trace.begin("marking dirty");
        ApkMap dirtyMap = new ApkMap(Files.size(Paths.get(localApk.path, new String[0])));
        for (ApkEntry remoteEntry : remoteApk.apkEntries.values()) {
            ApkEntry localEntry = localApk.apkEntries.get(remoteEntry.getName());
            if (localEntry == null || !Arrays.equals(remoteEntry.getZipEntry().localFileHeader, localEntry.getZipEntry().localFileHeader)) continue;
            ApkMap.Area cleanArea = new ApkMap.Area(localEntry.getZipEntry().start, localEntry.getZipEntry().approx_end);
            dirtyMap.markClean(cleanArea);
        }
        Trace.end();
        this.logger.info("Num dirty areas %d", new Object[]{dirtyMap.getDirtyAreas().size()});
        return dirtyMap.getDirtyAreas();
    }

    public static class Patch {
        final Status status;
        final ByteBuffer data;
        final ByteBuffer instructions;
        final String sourcePath;
        final long destinationSize;

        Patch(ByteBuffer data, ByteBuffer instructions, String sourcePath, long destinationSize) {
            this.data = data;
            this.instructions = instructions;
            this.sourcePath = sourcePath;
            this.destinationSize = destinationSize;
            this.status = Status.Ok;
        }

        Patch(Status status) {
            this.data = null;
            this.instructions = null;
            this.sourcePath = null;
            this.destinationSize = 0L;
            this.status = status;
        }

        static enum Status {
            Ok,
            SizeThresholdExceeded;

        }
    }
}

