/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.Installer;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class LiveLiteralDeployer {
    public List<UpdateLiveLiteralError> updateLiveLiteral(Installer installer, AdbClient adb, String packageName, Collection<UpdateLiveLiteralParam> params) {
        List<Integer> pids = adb.getPids(packageName);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveLiteralUpdateRequest.Builder requestBuilder = Deploy.LiveLiteralUpdateRequest.newBuilder();
        for (UpdateLiveLiteralParam param : params) {
            requestBuilder.addUpdates(Deploy.LiveLiteral.newBuilder().setKey(param.key).setOffset(param.offset).setHelperClass(param.helper).setType(param.type).setValue(param.value));
        }
        requestBuilder.setPackageName(packageName);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.LiveLiteralUpdateRequest request = requestBuilder.build();
        LinkedList<UpdateLiveLiteralError> errors = new LinkedList<UpdateLiveLiteralError>();
        try {
            Deploy.LiveLiteralUpdateResponse response = installer.updateLiveLiterals(request);
            for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                errors.add(new UpdateLiveLiteralError(failure.getLiveLiteralResponse().getExtra()));
            }
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
        return errors;
    }

    public static class UpdateLiveLiteralError {
        public final String msg;

        public UpdateLiveLiteralError(String msg) {
            this.msg = msg;
        }
    }

    public static class UpdateLiveLiteralParam {
        final String key;
        final String type;
        final String value;
        final int offset;
        final String helper;

        public UpdateLiveLiteralParam(String key, int offset, String helper, String type, String value) {
            this.key = key;
            this.offset = offset;
            this.helper = helper;
            this.type = type;
            this.value = value;
        }
    }
}

