/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelVariant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bJ\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J$\u0010\u0019\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\u001b\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/BlockedDependencies;", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/detector/api/Project;)V", "map", "", "", "", "Lcom/android/tools/lint/model/LintModelDependency;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "checkDependency", "groupId", "artifactId", "remove", "", "checkLibrary", "", "stack", "Ljava/util/ArrayDeque;", "library", "getForbiddenDependencies", "isForbiddenDependency", "mavenName", "visitLibraries", "libraries", "visitLibrary", "android.sdktools.lint-checks"})
public final class BlockedDependencies {
    @NotNull
    private final Project project;
    @Nullable
    private Map<String, List<LintModelDependency>> map;

    public BlockedDependencies(@NotNull Project project) {
        LintModelDependencyGraph lintModelDependencyGraph;
        LintModelDependencies lintModelDependencies;
        LintModelAndroidArtifact lintModelAndroidArtifact;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        LintModelVariant lintModelVariant = this.project.getBuildVariant();
        if (lintModelVariant != null && (lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) != null && (lintModelDependencies = lintModelAndroidArtifact.getDependencies()) != null && (lintModelDependencyGraph = lintModelDependencies.getCompileDependencies()) != null) {
            LintModelDependencyGraph lintModelDependencyGraph2 = lintModelDependencyGraph;
            boolean bl2 = false;
            boolean bl3 = false;
            LintModelDependencyGraph it2 = lintModelDependencyGraph2;
            boolean bl4 = false;
            this.visitLibraries(new ArrayDeque<LintModelDependency>(), it2.getRoots());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final List<LintModelDependency> checkDependency(@NotNull String groupId, @NotNull String artifactId, boolean remove) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Map<String, List<LintModelDependency>> map = this.map;
        if (map == null) {
            return null;
        }
        Map<String, List<LintModelDependency>> map2 = map;
        String coordinate = groupId + ':' + artifactId;
        List<LintModelDependency> list2 = map2.get(coordinate);
        if (list2 == null) {
            return null;
        }
        List<LintModelDependency> path2 = list2;
        if (remove) {
            map2.remove(coordinate);
        }
        return path2;
    }

    @NotNull
    public final List<List<LintModelDependency>> getForbiddenDependencies() {
        Map<String, List<LintModelDependency>> map = this.map;
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<String, List<LintModelDependency>> map2 = map;
        Iterable $this$sortedBy$iv = CollectionsKt.toMutableList(map2.values());
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a10, T b10) {
                boolean bl2 = false;
                List it2 = (List)a10;
                boolean bl3 = false;
                Comparable comparable = (Comparable)((Object)((LintModelDependency)it2.get(0)).getArtifactName());
                it2 = (List)b10;
                Comparable comparable2 = comparable;
                bl3 = false;
                String string = ((LintModelDependency)it2.get(0)).getArtifactName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
    }

    private final void visitLibraries(ArrayDeque<LintModelDependency> stack, List<? extends LintModelDependency> libraries2) {
        for (LintModelDependency lintModelDependency : libraries2) {
            this.visitLibrary(stack, lintModelDependency);
        }
    }

    private final void visitLibrary(ArrayDeque<LintModelDependency> stack, LintModelDependency library2) {
        stack.addLast(library2);
        this.checkLibrary(stack, library2);
        this.visitLibraries(stack, library2.getDependencies());
        stack.removeLast();
    }

    private final void checkLibrary(ArrayDeque<LintModelDependency> stack, LintModelDependency library2) {
        if (this.isForbiddenDependency(library2.getArtifactName())) {
            if (this.map == null) {
                this.map = new HashMap();
            }
            String root = stack.getFirst().getArtifactName();
            Map<String, List<LintModelDependency>> map = this.map;
            if (map != null) {
                List cfr_ignored_0 = map.put(root, new ArrayList(stack));
            }
        }
    }

    private final boolean isForbiddenDependency(String mavenName) {
        switch (mavenName) {
            case "org.khronos:opengl-api": 
            case "org.apache.httpcomponents:httpclient": 
            case "com.google.android:android": 
            case "xerces:xmlParserAPIs": 
            case "xpp3:xpp3": 
            case "commons-logging:commons-logging": 
            case "org.json:json": {
                return true;
            }
        }
        return false;
    }
}

