/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "customVisitor", "", "getCustomVisitor", "()Z", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "run", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "Issues", "android.sdktools.lint-checks"})
public final class ByteOrderMarkDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
GradleScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue BOM;

    @Override
    public void beforeCheckFile(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2 instanceof XmlContext && ((XmlContext)context2).getResourceFolderType() == ResourceFolderType.RAW) {
            return;
        }
        CharSequence charSequence = context2.getContents();
        if (charSequence == null) {
            return;
        }
        int n10 = 1;
        CharSequence source = charSequence;
        int max = source.length();
        if (n10 < max) {
            do {
                UFile file;
                int i10;
                char c10;
                if ((c10 = source.charAt(i10 = n10++)) != '\ufeff') continue;
                Location location = Location.Companion.create(context2.file, source, i10, i10 + 1);
                String message2 = "Found byte-order-mark in the middle of a file";
                if (context2 instanceof XmlContext) {
                    Node leaf = ((XmlContext)context2).getParser().findNodeAt((XmlContext)context2, i10);
                    if (leaf != null) {
                        XmlContext.report$default((XmlContext)context2, BOM, leaf, location, message2, null, 16, null);
                        continue;
                    }
                } else if (context2 instanceof JavaContext && (file = ((JavaContext)context2).getUastFile()) != null) {
                    PsiFile psi = file.getPsi();
                    PsiElement closest = psi.findElementAt(i10);
                    if (closest == null) {
                        Collection collection = file.getClasses();
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            closest = (PsiElement)file.getClasses().get(0);
                        }
                    }
                    if (closest != null) {
                        JavaContext.report$default((JavaContext)context2, BOM, closest, location, message2, null, 16, null);
                        continue;
                    }
                }
                Context.report$default(context2, BOM, location, message2, null, 8, null);
            } while (n10 < max);
        }
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return null;
    }

    @Override
    public void run(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
    }

    @Override
    public boolean getCustomVisitor() {
        return true;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.I18N;
        Severity severity = Severity.ERROR;
        Object[] objectArray = new Scope[]{Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.PROPERTY_FILE, Scope.PROGUARD_FILE};
        EnumSet<Enum[]> enumSet = EnumSet.of((Enum)Scope.MANIFEST, (Enum[])objectArray);
        objectArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.PROPERTY_SCOPE, Scope.PROGUARD_SCOPE};
        Implementation implementation = new Implementation((Class<? extends Detector>)ByteOrderMarkDetector.class, (EnumSet<Scope>)enumSet, (EnumSet<Scope>[])objectArray);
        BOM = Issue.Companion.create$default(companion, "ByteOrderMark", "Byte order mark inside files", "\n            Lint will flag any byte-order-mark (BOM) characters it finds in the middle of a file. Since we \\\n            expect files to be encoded with UTF-8 (see the EnforceUTF8 issue), the BOM characters are not \\\n            necessary, and they are not handled correctly by all tools. For example, if you have a BOM as \\\n            part of a resource name in one particular translation, that name will not be considered identical \\\n            to the base resource's name and the translation will not be used.", implementation, "https://en.wikipedia.org/wiki/Byte_order_mark", category, 8, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector$Issues;", "", "()V", "BOM", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

