/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUTernaryIfExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J|\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkResult", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMemberAnnotations", "allClassAnnotations", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allPackageAnnotations", "Companion", "android.sdktools.lint-checks"})
public final class CheckResultDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY_SUGGESTION = "suggestion";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CheckResultDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CHECK_RESULT = Issue.Companion.create("CheckResult", "Ignoring results", "\n                Some methods have no side effects, and calling them without doing something \\\n                without the result is suspicious.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue CHECK_PERMISSION;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[7];
        String string = AnnotationDetector.CHECK_RESULT_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CHECK_RESULT_ANNOTATION.oldName()");
        objectArray[0] = string;
        string = AnnotationDetector.CHECK_RESULT_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CHECK_RESULT_ANNOTATION.newName()");
        objectArray[1] = string;
        objectArray[2] = "edu.umd.cs.findbugs.annotations.CheckReturnValue";
        objectArray[3] = "javax.annotation.CheckReturnValue";
        objectArray[4] = "com.google.errorprone.annotations.CanIgnoreReturnValue";
        objectArray[5] = "io.reactivex.annotations.CheckReturnValue";
        objectArray[6] = "com.google.errorprone.annotations.CheckReturnValue";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            return;
        }
        if (allPackageAnnotations.contains(annotation)) {
            return;
        }
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)"com.google.errorprone.annotations.CanIgnoreReturnValue")) {
            return;
        }
        this.checkResult(context2, usage, method, annotation, allMemberAnnotations, allClassAnnotations);
    }

    private final void checkResult(JavaContext context2, UElement element, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMemberAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        if (Companion.isExpressionValueUnused(element)) {
            LintFix lintFix;
            if (UastLintUtils.Companion.containsAnnotation(allMemberAnnotations, "com.google.errorprone.annotations.CanIgnoreReturnValue") || UastLintUtils.Companion.containsAnnotation(allClassAnnotations, "com.google.errorprone.annotations.CanIgnoreReturnValue")) {
                return;
            }
            if (Intrinsics.areEqual((Object)method.getReturnType(), (Object)PsiType.VOID) || method.isConstructor()) {
                return;
            }
            String methodName = JavaContext.Companion.getMethodName(element);
            String suggested = UastLintUtils.Companion.getAnnotationStringValue(annotation, "suggest");
            Issue issue = CHECK_RESULT;
            if (methodName != null && StringsKt.startsWith$default((String)methodName, (String)"check", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)methodName, (CharSequence)"Permission", (boolean)false, (int)2, null)) {
                issue = CHECK_PERMISSION;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = "The result of `%1$s` is not used";
            Object[] objectArray2 = new Object[]{methodName};
            boolean bl2 = false;
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            String message2 = string;
            if (suggested != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                objectArray = "The result of `%1$s` is not used; did you mean to call `%2$s`?";
                objectArray2 = new Object[]{methodName, suggested};
                bl2 = false;
                String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                message2 = string2;
            } else if (Intrinsics.areEqual((Object)"intersect", (Object)methodName) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message2 = Intrinsics.stringPlus((String)message2, (Object)". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.");
            }
            if (suggested != null) {
                objectArray = new Object[]{KEY_SUGGESTION, suggested};
                lintFix = this.fix().data(objectArray);
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Location location = context2.getLocation(element);
            this.report(context2, issue, element, location, message2, fix);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CHECK_PERMISSION = Issue.Companion.create$default(companion, "UseCheckPermission", "Using the result of check permission calls", "\n                You normally want to use the result of checking a permission; these methods \\\n                return whether the permission is held; they do not throw an error if the \\\n                permission is not granted. Code which does not do anything with the return \\\n                value probably meant to be calling the enforce methods instead, e.g. rather \\\n                than `Context#checkCallingPermission` it should call \\\n                `Context#enforceCallingPermission`.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector$Companion;", "", "()V", "CHECK_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "CHECK_RESULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_SUGGESTION", "", "isExpressionValueUnused", "", "element", "Lorg/jetbrains/uast/UElement;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExpressionValueUnused(@NotNull UElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof UParenthesizedExpression) {
                boolean bl2;
                UElement uElement = element.getUastParent();
                if (uElement == null) {
                    bl2 = true;
                } else {
                    boolean bl3;
                    UElement uElement2 = uElement;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    UElement p02 = uElement2;
                    boolean bl6 = false;
                    bl2 = bl3 = this.isExpressionValueUnused(p02);
                }
                return bl2;
            }
            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
            if (uExpression == null) {
                return true;
            }
            UExpression prev = uExpression;
            UElement uElement = Lint.skipParentheses(prev.getUastParent());
            if (uElement == null) {
                return true;
            }
            UElement curr = uElement;
            while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev) {
                prev = (UExpression)curr;
                uElement = Lint.skipParentheses(curr.getUastParent());
                if (uElement == null) {
                    return true;
                }
                curr = uElement;
            }
            if (curr instanceof UBlockExpression) {
                UElement block = curr;
                UExpression expression = prev;
                int index = ((UBlockExpression)block).getExpressions().indexOf(expression);
                if (index == -1) {
                    return true;
                }
                if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                    return true;
                }
                UElement parent = Lint.skipParentheses(curr.getUastParent());
                if (parent instanceof ULambdaExpression && Lint.isKotlin(curr.getSourcePsi())) {
                    String expressionType;
                    PsiType psiType = ((ULambdaExpression)parent).getExpressionType();
                    String string = expressionType = psiType == null ? null : psiType.getCanonicalText();
                    return expressionType != null && StringsKt.startsWith$default((String)expressionType, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionType, (String)"kotlin.Unit>", (boolean)false, (int)2, null);
                }
                if (Lint.isJava(curr.getSourcePsi())) {
                    return true;
                }
                UElement uElement3 = parent;
                if (uElement3 == null) {
                    return true;
                }
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(parent);
            }
            if (curr instanceof UMethod && ((UMethod)curr).isConstructor()) {
                return true;
            }
            if (curr instanceof UIfExpression) {
                if (((UIfExpression)curr).getCondition() == prev) {
                    return false;
                }
                if (curr instanceof JavaUTernaryIfExpression) {
                    return false;
                }
                UElement expression = Lint.skipParentheses(curr.getUastParent());
                if (expression == null) {
                    return true;
                }
                UElement parent = expression;
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(curr);
            }
            if (curr instanceof UMethod || curr instanceof UClassInitializer) {
                return true;
            }
            if (curr instanceof UYieldExpression) {
                USwitchClauseExpressionWithBody index;
                UElement expression = Lint.skipParentheses(curr.getUastParent());
                UElement p22 = Lint.skipParentheses(expression == null ? null : expression.getUastParent());
                USwitchClauseExpressionWithBody uSwitchClauseExpressionWithBody = index = p22 instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)p22 : null;
                if (index == null) {
                    return false;
                }
                USwitchClauseExpressionWithBody body = index;
                USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType$default((UElement)((UElement)body), USwitchExpression.class, (boolean)false, (int)2, null);
                if (uSwitchExpression == null) {
                    return true;
                }
                USwitchExpression uSwitchExpression2 = uSwitchExpression;
                return this.isExpressionValueUnused((UElement)uSwitchExpression2);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

