/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutConsistencyDetector
extends LayoutDetector
implements SourceCodeScanner {
    private final Map<String, List<Pair<File, Map<String, String>>>> mMap = Maps.newHashMapWithExpectedSize((int)64);
    private final Set<String> mRelevantIds = Sets.newLinkedHashSetWithExpectedSize((int)64);
    private Map<String, Map<String, List<Location>>> mLocations;
    private Map<String, Map<String, String>> mErrorMessages;
    public static final Issue INCONSISTENT_IDS = Issue.create("InconsistentLayout", "Inconsistent Layouts", "This check ensures that a layout resource which is defined in multiple resource folders, specifies the same set of widgets.\n\nThis finds cases where you have accidentally forgotten to add a widget to all variations of the layout, which could result in a runtime crash for some resource configurations when a `findViewById()` fails.\n\nThere **are** cases where this is intentional. For example, you may have a dedicated large tablet layout which adds some extra widgets that are not present in the phone version of the layout. As long as the code accessing the layout resource is careful to handle this properly, it is valid. In that case, you can suppress this lint check for the given extra or missing views, or the whole layout", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(LayoutConsistencyDetector.class, Scope.JAVA_AND_RESOURCE_FILES));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root != null) {
            if (context2.getPhase() == 1) {
                HashMap fileMap = Maps.newHashMapWithExpectedSize((int)10);
                LayoutConsistencyDetector.addIds(root, fileMap);
                this.getFileMapList(context2).add((Pair<File, Map<String, String>>)Pair.of((Object)context2.file, (Object)fileMap));
            } else {
                String name = Lint.getLayoutName(context2.file);
                Map<String, List<Location>> map = this.mLocations.get(name);
                if (map != null) {
                    LayoutConsistencyDetector.lookupLocations(context2, root, map);
                }
            }
        }
    }

    private List<Pair<File, Map<String, String>>> getFileMapList(XmlContext context2) {
        String name = Lint.getLayoutName(context2.file);
        ArrayList list2 = this.mMap.get(name);
        if (list2 == null) {
            list2 = Lists.newArrayListWithCapacity((int)4);
            this.mMap.put(name, list2);
        }
        return list2;
    }

    private static String getId(Element element) {
        String id2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id2 != null && !id2.isEmpty() && !id2.startsWith("@android:")) {
            return Lint.stripIdPrefix(id2);
        }
        return null;
    }

    private static void addIds(Element element, Map<String, String> map) {
        String id2 = LayoutConsistencyDetector.getId(element);
        if (id2 != null) {
            String s10 = Lint.stripIdPrefix(id2);
            map.put(s10, element.getTagName());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i10 = 0; i10 < childNodes.getLength(); ++i10) {
            Node child = childNodes.item(i10);
            if (child.getNodeType() != 1) continue;
            LayoutConsistencyDetector.addIds((Element)child, map);
        }
    }

    private static void lookupLocations(XmlContext context2, Element element, Map<String, List<Location>> map) {
        String id2 = LayoutConsistencyDetector.getId(element);
        if (id2 != null && map.containsKey(id2)) {
            if (context2.getDriver().isSuppressed(context2, INCONSISTENT_IDS, element)) {
                map.remove(id2);
                return;
            }
            ArrayList locations = map.get(id2);
            if (locations == null) {
                locations = Lists.newArrayList();
                map.put(id2, locations);
            }
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id");
            assert (attr != null);
            Location location = context2.getLocation(attr);
            String folder = context2.file.getParentFile().getName();
            location.setMessage(String.format("Occurrence in %1$s", folder));
            locations.add(location);
        }
        NodeList childNodes = element.getChildNodes();
        for (int i10 = 0; i10 < childNodes.getLength(); ++i10) {
            Node child = childNodes.item(i10);
            if (child.getNodeType() != 1) continue;
            LayoutConsistencyDetector.lookupLocations(context2, (Element)child, map);
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        LintDriver driver = context2.getDriver();
        if (driver.getPhase() == 1) {
            for (Map.Entry<String, List<Pair<File, Map<String, String>>>> entry : this.mMap.entrySet()) {
                String layout = entry.getKey();
                List<Pair<File, Map<String, String>>> files = entry.getValue();
                if (files.size() < 2) continue;
                this.checkConsistentIds(layout, files);
            }
            if (this.mLocations != null) {
                driver.requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else if (!this.mLocations.isEmpty()) {
            this.reportErrors(context2);
        }
    }

    private Set<String> stripIrrelevantIds(Set<String> ids) {
        if (!this.mRelevantIds.isEmpty()) {
            HashSet<String> stripped = new HashSet<String>(ids);
            stripped.retainAll(this.mRelevantIds);
            return stripped;
        }
        return Collections.emptySet();
    }

    private void checkConsistentIds(String layout, List<Pair<File, Map<String, String>>> files) {
        int layoutCount = files.size();
        assert (layoutCount >= 2);
        Map<File, Set<String>> idMap = this.getIdMap(files, layoutCount);
        Set<String> inconsistent = LayoutConsistencyDetector.getInconsistentIds(idMap);
        if (inconsistent.isEmpty()) {
            return;
        }
        if (this.mLocations == null) {
            this.mLocations = Maps.newHashMap();
        }
        if (this.mErrorMessages == null) {
            this.mErrorMessages = Maps.newHashMap();
        }
        int idCount = inconsistent.size();
        HashMap presence = Maps.newHashMapWithExpectedSize((int)idCount);
        HashSet allLayouts = Sets.newHashSetWithExpectedSize((int)layoutCount);
        for (Map.Entry<File, Set<String>> entry : idMap.entrySet()) {
            File file = entry.getKey();
            String folder = file.getParentFile().getName();
            allLayouts.add(folder);
            Set<String> ids = entry.getValue();
            for (String id2 : ids) {
                List list2 = (List)presence.get(id2);
                if (list2 == null) {
                    list2 = Lists.newArrayListWithExpectedSize((int)layoutCount);
                    presence.put(id2, list2);
                }
                list2.add(folder);
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)idCount);
        this.mLocations.put(layout, map);
        HashMap messages = Maps.newHashMapWithExpectedSize((int)idCount);
        this.mErrorMessages.put(layout, messages);
        for (String id3 : inconsistent) {
            map.put(id3, null);
            List layouts = (List)presence.get(id3);
            Collections.sort(layouts);
            HashSet missingSet = new HashSet(allLayouts);
            missingSet.removeAll(layouts);
            ArrayList<String> missing = new ArrayList<String>(missingSet);
            Collections.sort(missing);
            String message2 = layouts.size() < layoutCount / 2 ? String.format("The id \"%1$s\" in layout \"%2$s\" is only present in the following layout configurations: %3$s (missing from %4$s)", id3, layout, Lint.formatList(layouts, Integer.MAX_VALUE), Lint.formatList(missing, Integer.MAX_VALUE)) : String.format("The id \"%1$s\" in layout \"%2$s\" is missing from the following layout configurations: %3$s (present in %4$s)", id3, layout, Lint.formatList(missing, Integer.MAX_VALUE), Lint.formatList(layouts, Integer.MAX_VALUE));
            messages.put(id3, message2);
        }
    }

    private static Set<String> getInconsistentIds(Map<File, Set<String>> idMap) {
        Set<String> union = LayoutConsistencyDetector.getAllIds(idMap);
        HashSet<String> inconsistent = new HashSet<String>();
        for (Map.Entry<File, Set<String>> entry : idMap.entrySet()) {
            Set<String> ids = entry.getValue();
            if (ids.size() >= union.size()) continue;
            HashSet<String> missing = new HashSet<String>(union);
            missing.removeAll(ids);
            inconsistent.addAll(missing);
        }
        return inconsistent;
    }

    private static Set<String> getAllIds(Map<File, Set<String>> idMap) {
        Iterator<Set<String>> iterator = idMap.values().iterator();
        assert (iterator.hasNext());
        HashSet<String> union = new HashSet<String>((Collection)iterator.next());
        while (iterator.hasNext()) {
            union.addAll((Collection<String>)iterator.next());
        }
        return union;
    }

    private Map<File, Set<String>> getIdMap(List<Pair<File, Map<String, String>>> files, int layoutCount) {
        HashMap<File, Set<String>> idMap = new HashMap<File, Set<String>>(layoutCount);
        for (Pair<File, Map<String, String>> pair : files) {
            File file = (File)pair.getFirst();
            Map typeMap = (Map)pair.getSecond();
            Set<String> ids = typeMap.keySet();
            idMap.put(file, this.stripIrrelevantIds(ids));
        }
        return idMap;
    }

    private void reportErrors(Context context2) {
        ArrayList<String> layouts = new ArrayList<String>(this.mLocations.keySet());
        Collections.sort(layouts);
        for (String layout : layouts) {
            Map<String, List<Location>> locationMap = this.mLocations.get(layout);
            Map<String, String> messageMap = this.mErrorMessages.get(layout);
            assert (locationMap != null);
            assert (messageMap != null);
            ArrayList<String> ids = new ArrayList<String>(locationMap.keySet());
            Collections.sort(ids);
            for (String id2 : ids) {
                String message2 = messageMap.get(id2);
                List<Location> locations = locationMap.get(id2);
                if (locations == null) continue;
                Location location = LayoutConsistencyDetector.chainLocations(locations);
                context2.report(INCONSISTENT_IDS, location, message2);
            }
        }
    }

    private static Location chainLocations(List<Location> locations) {
        assert (!locations.isEmpty());
        if (locations.size() > 1) {
            locations.sort((location1, location2) -> {
                File file1 = location1.getFile();
                File file2 = location2.getFile();
                String folder1 = file1.getParentFile().getName();
                String folder2 = file2.getParentFile().getName();
                return folder1.compareTo(folder2);
            });
            Iterator<Location> iterator = locations.iterator();
            assert (iterator.hasNext());
            Location prev = iterator.next();
            while (iterator.hasNext()) {
                Location next = iterator.next();
                prev.setSecondary(next);
                prev = next;
            }
        }
        return locations.get(0);
    }

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(JavaContext context2, UElement node, ResourceType type, String name, boolean isFramework) {
        if (!isFramework && type == ResourceType.ID) {
            this.mRelevantIds.add(name);
        }
    }
}

