/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NetworkSecurityConfigDetector
extends ResourceXmlDetector {
    public static final Implementation IMPLEMENTATION = new Implementation(NetworkSecurityConfigDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("NetworkSecurityConfig", "Valid Network Security Config File", "Ensures that a `<network-security-config>` file, which is pointed to by an `android:networkSecurityConfig` attribute in the manifest file, is valid", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION).addMoreInfo("https://developer.android.com/preview/features/security-config.html");
    public static final Issue PIN_SET_EXPIRY = Issue.create("PinSetExpiry", "Validate `<pin-set>` expiration attribute", "Ensures that the `expiration` attribute of the `<pin-set>` element is valid and has not already expired or is expiring soon", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/preview/features/security-config.html");
    public static final Issue MISSING_BACKUP_PIN = Issue.create("MissingBackupPin", "Missing Backup Pin", "It is highly recommended to declare a backup `<pin>` element. Not having a second pin defined can cause connection failures when the particular site certificate is rotated and the app has not yet been updated.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/preview/features/security-config.html");
    public static final Issue INSECURE_CONFIGURATION = Issue.create("InsecureBaseConfiguration", "Insecure Base Configuration", "Permitting cleartext traffic could allow eavesdroppers to intercept data sent by your app, which impacts the privacy of your users. Consider only allowing encrypted traffic by setting the `cleartextTrafficPermitted` tag to `\"false\"`.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/preview/features/security-config.html");
    public static final Issue ACCEPTS_USER_CERTIFICATES = Issue.create("AcceptsUserCertificates", "Allowing User Certificates", "Allowing user certificates could allow eavesdroppers to intercept data sent by your app, 'which could impact the privacy of your users. Consider nesting your app's `trust-anchors` inside a `<debug-overrides>` element to make sure they are only available when `android:debuggable` is set to `\"true\"`.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/articles/security-config#TrustingDebugCa");
    public static final String ATTR_DIGEST = "digest";
    private static final String TAG_NETWORK_SECURITY_CONFIG = "network-security-config";
    private static final String TAG_BASE_CONFIG = "base-config";
    private static final String TAG_DOMAIN_CONFIG = "domain-config";
    private static final String TAG_DEBUG_OVERRIDES = "debug-overrides";
    private static final String TAG_DOMAIN = "domain";
    private static final String TAG_PIN_SET = "pin-set";
    private static final String TAG_TRUST_ANCHORS = "trust-anchors";
    private static final String TAG_CERTIFICATES = "certificates";
    private static final String TAG_PIN = "pin";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_INCLUDE_SUBDOMAINS = "includeSubdomains";
    private static final String ATTR_EXPIRATION = "expiration";
    private static final String ATTR_CLEARTEXT_TRAFFIC_PERMITTED = "cleartextTrafficPermitted";
    private static final String PIN_DIGEST_ALGORITHM = "SHA-256";
    private static final int PIN_DECODED_DIGEST_LEN_SHA_256 = 32;
    private static final Set<String> VALID_CONFIG_TAGS = ImmutableSet.of((Object)"domain", (Object)"trust-anchors", (Object)"pin-set", (Object)"domain-config");
    public static final Set<String> VALID_BASE_TAGS = ImmutableSet.of((Object)"domain-config", (Object)"base-config", (Object)"debug-overrides");
    private static final String UNEXPECTED_ELEMENT_MESSAGE = "Unexpected element `<%1$s>`";
    private static final String ALREADY_DECLARED_MESSAGE = "Already declared here";
    private Location.Handle mDebugOverridesHandle;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        this.mDebugOverridesHandle = null;
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        if (!TAG_NETWORK_SECURITY_CONFIG.equals(root.getTagName())) {
            return;
        }
        Location.Handle baseConfigHandle = null;
        HashMap seenDomains2Nodes = Maps.newHashMap();
        for (Element child : XmlUtils.getSubTags((Node)root)) {
            String tagName = child.getTagName();
            if (TAG_BASE_CONFIG.equals(tagName)) {
                if (baseConfigHandle != null) {
                    NetworkSecurityConfigDetector.reportExceeded(context2, TAG_BASE_CONFIG, child, baseConfigHandle);
                    continue;
                }
                baseConfigHandle = context2.createLocationHandle(child);
                this.handleConfigElement(context2, child, seenDomains2Nodes);
                this.handleBaseConfigElement(context2, child);
                continue;
            }
            if (TAG_DEBUG_OVERRIDES.equals(tagName)) {
                if (this.mDebugOverridesHandle != null) {
                    NetworkSecurityConfigDetector.reportExceeded(context2, TAG_DEBUG_OVERRIDES, child, this.mDebugOverridesHandle);
                    continue;
                }
                this.mDebugOverridesHandle = context2.createLocationHandle(child);
                this.handleConfigElement(context2, child, seenDomains2Nodes);
                continue;
            }
            if (TAG_DOMAIN_CONFIG.equals(tagName)) {
                this.handleConfigElement(context2, child, seenDomains2Nodes);
                continue;
            }
            if (NetworkSecurityConfigDetector.checkForTyposInTags(context2, child, VALID_BASE_TAGS)) continue;
            context2.report(ISSUE, child, context2.getNameLocation(child), String.format(UNEXPECTED_ELEMENT_MESSAGE, tagName));
        }
    }

    private void handleConfigElement(XmlContext context2, Element config, Map<String, Node> seenDomainsToLocations) {
        String configName = config.getTagName();
        boolean isDomainConfig = TAG_DOMAIN_CONFIG.equals(configName);
        String message2 = "`%1$s` element not allowed in `%2$s`";
        Element trustAnchorsNode = null;
        Element pinSetNode = null;
        NetworkSecurityConfigDetector.checkForTyposInAttributes(context2, config, ATTR_CLEARTEXT_TRAFFIC_PERMITTED, false);
        for (Element node : XmlUtils.getSubTags((Node)config)) {
            String tagName = node.getTagName();
            if (TAG_DOMAIN.equals(tagName)) {
                if (!isDomainConfig) {
                    context2.report(ISSUE, node, context2.getNameLocation(node), String.format(message2, TAG_DOMAIN, configName));
                    continue;
                }
                NetworkSecurityConfigDetector.checkForTyposInAttributes(context2, node, ATTR_INCLUDE_SUBDOMAINS, true);
                String domainName = node.getTextContent().trim().toLowerCase(Locale.US);
                if (seenDomainsToLocations.containsKey(domainName)) {
                    String duplicateMessage = "Duplicate domain names are not allowed";
                    Node previousNode = seenDomainsToLocations.get(domainName);
                    context2.report(ISSUE, node.getFirstChild(), context2.getLocation(node.getFirstChild()).withSecondary(context2.getLocation(previousNode), ALREADY_DECLARED_MESSAGE), duplicateMessage);
                    continue;
                }
                seenDomainsToLocations.put(domainName, node.getFirstChild());
                continue;
            }
            if (TAG_TRUST_ANCHORS.equals(tagName)) {
                if (trustAnchorsNode != null) {
                    String anchorMessage = "Multiple `<trust-anchors>` elements are not allowed";
                    context2.report(ISSUE, node, context2.getNameLocation(node).withSecondary(context2.getNameLocation(trustAnchorsNode), ALREADY_DECLARED_MESSAGE), anchorMessage);
                    continue;
                }
                trustAnchorsNode = node;
                NetworkSecurityConfigDetector.handleTrustAnchors(context2, node);
                continue;
            }
            if (TAG_DOMAIN_CONFIG.equals(tagName)) {
                if (!isDomainConfig) {
                    context2.report(ISSUE, node, context2.getNameLocation(node), String.format("Nested `<domain-config>` elements are not allowed in `%1$s`", configName));
                    continue;
                }
                this.handleConfigElement(context2, node, seenDomainsToLocations);
                continue;
            }
            if (TAG_PIN_SET.equals(tagName)) {
                if (!isDomainConfig) {
                    context2.report(ISSUE, node, context2.getNameLocation(node), String.format(message2, TAG_PIN_SET, configName));
                }
                if (pinSetNode != null) {
                    String pinSetMessage = "Multiple `<pin-set>` elements are not allowed";
                    context2.report(ISSUE, node, context2.getNameLocation(node).withSecondary(context2.getNameLocation(pinSetNode), ALREADY_DECLARED_MESSAGE), pinSetMessage);
                    continue;
                }
                pinSetNode = node;
                NetworkSecurityConfigDetector.handlePinSet(context2, node);
                continue;
            }
            NetworkSecurityConfigDetector.checkForTyposInTags(context2, node, VALID_CONFIG_TAGS);
        }
        if (isDomainConfig && seenDomainsToLocations.isEmpty()) {
            context2.report(ISSUE, config, context2.getNameLocation(config), "No `<domain>` elements in `<domain-config>`");
        }
    }

    private void handleBaseConfigElement(XmlContext context2, Element node) {
        Attr cleartextTrafficAttribute;
        if (node.hasAttribute(ATTR_CLEARTEXT_TRAFFIC_PERMITTED) && (cleartextTrafficAttribute = node.getAttributeNode(ATTR_CLEARTEXT_TRAFFIC_PERMITTED)).getValue().equals("true")) {
            Location attributeLocation = context2.getValueLocation(cleartextTrafficAttribute);
            LintFix fix = this.fix().replace().range(attributeLocation).with("false").build();
            context2.report(INSECURE_CONFIGURATION, node, attributeLocation, "Insecure Base Configuration", fix);
        }
        for (Element child : XmlUtils.getSubTags((Node)node)) {
            if (!TAG_TRUST_ANCHORS.equals(child.getTagName())) continue;
            for (Element grandchild : XmlUtils.getSubTags((Node)child)) {
                Attr sourceIdAttr;
                if (!TAG_CERTIFICATES.equals(grandchild.getTagName()) || (sourceIdAttr = grandchild.getAttributeNode(ATTR_SRC)) == null || !"user".equals(sourceIdAttr.getValue())) continue;
                context2.report(ACCEPTS_USER_CERTIFICATES, grandchild, context2.getLocation(grandchild), "The Network Security Configuration allows the use of user certificates in the release version of your app");
            }
        }
    }

    private static void handlePinSet(XmlContext context2, Element node) {
        if (node.hasAttribute(ATTR_EXPIRATION)) {
            Attr expirationAttr = node.getAttributeNode(ATTR_EXPIRATION);
            String message2 = null;
            try {
                LocalDate date = LocalDate.parse(expirationAttr.getValue(), DateTimeFormatter.ISO_LOCAL_DATE);
                LocalDate now = LocalDate.now();
                if (date.isBefore(now)) {
                    message2 = "`pin-set` has already expired";
                } else if (date.isBefore(now.plusDays(10L))) {
                    message2 = "`pin-set` is expiring soon";
                }
            }
            catch (DateTimeParseException e10) {
                context2.report(ISSUE, expirationAttr, context2.getValueLocation(expirationAttr), "Invalid expiration in `pin-set`");
            }
            if (message2 != null) {
                context2.report(PIN_SET_EXPIRY, expirationAttr, context2.getValueLocation(expirationAttr), message2);
            }
        } else {
            NetworkSecurityConfigDetector.checkForTyposInAttributes(context2, node, ATTR_EXPIRATION, false);
        }
        int pinElementCount = 0;
        boolean foundTyposInPin = false;
        for (Element child : XmlUtils.getSubTags((Node)node)) {
            String tagName = child.getTagName();
            if (TAG_PIN.equals(tagName)) {
                Node digestNode;
                ++pinElementCount;
                if (child.hasAttribute(ATTR_DIGEST)) {
                    Attr digestAttr = child.getAttributeNode(ATTR_DIGEST);
                    if (!PIN_DIGEST_ALGORITHM.equalsIgnoreCase(digestAttr.getValue())) {
                        String values = Lint.formatList(NetworkSecurityConfigDetector.getSupportedPinDigestAlgorithms(), 2);
                        LintFix.GroupBuilder fixBuilder = LintFix.create().group();
                        for (String algorithm : NetworkSecurityConfigDetector.getSupportedPinDigestAlgorithms()) {
                            fixBuilder.add(LintFix.create().name(String.format("Set digest to \"%1$s\"", algorithm)).replace().all().with(algorithm).build());
                        }
                        LintFix fix = fixBuilder.build();
                        context2.report(ISSUE, digestAttr, context2.getValueLocation(digestAttr), String.format("Invalid digest algorithm. Supported digests: `%1$s`", values), fix);
                    }
                } else {
                    NetworkSecurityConfigDetector.checkForTyposInAttributes(context2, child, ATTR_DIGEST, true);
                }
                if (!child.hasChildNodes() || (digestNode = child.getFirstChild()) == null || digestNode.getNodeType() != 3) {
                    context2.report(ISSUE, child, context2.getLocation(child), "Missing pin digest");
                    continue;
                }
                try {
                    byte[] decodedDigest = Base64.getDecoder().decode(digestNode.getNodeValue());
                    if (decodedDigest.length == 32) continue;
                    String message3 = String.format("Decoded digest length `%1$d` does not match expected length for `%2$s` of `%3$d`", decodedDigest.length, PIN_DIGEST_ALGORITHM, 32);
                    context2.report(ISSUE, digestNode, context2.getLocation(digestNode), message3);
                }
                catch (Exception ex2) {
                    context2.report(ISSUE, digestNode, context2.getLocation(digestNode), "Invalid pin digest");
                }
                continue;
            }
            foundTyposInPin |= NetworkSecurityConfigDetector.checkForTyposInTags(context2, child, Collections.singleton(TAG_PIN));
        }
        if (!foundTyposInPin) {
            if (pinElementCount == 0) {
                context2.report(ISSUE, node, context2.getNameLocation(node), "Missing `<pin>` element(s)");
            } else if (pinElementCount == 1) {
                context2.report(MISSING_BACKUP_PIN, node, context2.getNameLocation(node), "A backup `<pin>` declaration is highly recommended");
            }
        }
    }

    private static void handleTrustAnchors(XmlContext context2, Element node) {
        for (Element child : XmlUtils.getSubTags((Node)node)) {
            if (TAG_CERTIFICATES.equals(child.getTagName())) {
                Project project;
                ResourceRepository resources;
                if (!child.hasAttribute(ATTR_SRC)) {
                    NetworkSecurityConfigDetector.checkForTyposInAttributes(context2, child, ATTR_SRC, true);
                    continue;
                }
                Attr sourceIdAttr = child.getAttributeNode(ATTR_SRC);
                String sourceId = sourceIdAttr.getValue();
                ResourceUrl resourceUrl = ResourceUrl.parse((String)sourceId);
                LintClient client = context2.getClient();
                if (resourceUrl != null && !resourceUrl.isFramework() && !(resources = client.getResources(project = context2.getProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES)).hasResources(ResourceNamespace.TODO(), resourceUrl.type, resourceUrl.name)) {
                    context2.report(ISSUE, sourceIdAttr, context2.getValueLocation(sourceIdAttr), "Missing `src` resource");
                }
                if (resourceUrl != null || "user".equals(sourceId) || "system".equals(sourceId)) continue;
                context2.report(ISSUE, sourceIdAttr, context2.getValueLocation(sourceIdAttr), "Unknown certificates `src` attribute. Expecting `system`, `user` or an @resource value");
                continue;
            }
            NetworkSecurityConfigDetector.checkForTyposInTags(context2, child, Collections.singleton(TAG_CERTIFICATES));
        }
    }

    private static boolean checkForTyposInTags(XmlContext context2, Element node, Collection<String> validPossibleTags) {
        String tagName = node.getTagName();
        List<String> suggestions = NetworkSecurityConfigDetector.generateTypoSuggestions(tagName, validPossibleTags);
        if (suggestions != null) {
            assert (!suggestions.isEmpty());
            String suggestionString = suggestions.size() == 1 ? suggestions.get(0) : (suggestions.size() == 2 ? String.format("%1$s or %2$s", suggestions.get(0), suggestions.get(1)) : Lint.formatList(suggestions, -1));
            String message2 = String.format("Misspelled tag `<%1$s>`: Did you mean `%2$s` ?", tagName, suggestionString);
            context2.report(ISSUE, node, context2.getNameLocation(node), message2);
            return true;
        }
        return false;
    }

    private static void checkForTyposInAttributes(XmlContext context2, Element node, String attrName, boolean requiredAttribute) {
        if (node.hasAttribute(attrName)) {
            return;
        }
        List<String> suggestions = null;
        NamedNodeMap attributes = node.getAttributes();
        boolean foundSpellingError = false;
        Set<String> validAttributeNames = Collections.singleton(attrName);
        for (int i10 = 0; i10 < attributes.getLength(); ++i10) {
            Node attr = attributes.item(i10);
            String nodeName = attr.getNodeName();
            if (nodeName != null) {
                suggestions = NetworkSecurityConfigDetector.generateTypoSuggestions(nodeName, validAttributeNames);
            }
            if (suggestions == null || suggestions.size() != 1) continue;
            context2.report(ISSUE, attr, context2.getNameLocation(attr), String.format("Misspelled attribute `%1$s`: Did you mean `%2$s` ?", nodeName, attrName));
            foundSpellingError |= true;
        }
        if (!foundSpellingError && requiredAttribute) {
            context2.report(ISSUE, node, context2.getNameLocation(node), String.format("Missing `%1$s` attribute", attrName));
        }
    }

    private static List<String> generateTypoSuggestions(String name, Collection<String> validAttributeNames) {
        ArrayList<String> suggestions = null;
        for (String suggestion : validAttributeNames) {
            if (!Lint.isEditableTo(suggestion, name, 3)) continue;
            if (suggestions == null) {
                suggestions = new ArrayList<String>(validAttributeNames.size());
            }
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private static void reportExceeded(XmlContext context2, String elementName, Element element, Location.Handle handle) {
        context2.report(ISSUE, element, context2.getNameLocation(element).withSecondary(handle.resolve(), ALREADY_DECLARED_MESSAGE), String.format("Expecting at most 1 `<%1$s>`", elementName));
    }

    public static boolean isAttributeSpellingError(String errorMessage) {
        return errorMessage.startsWith("Misspelled attribute");
    }

    public static List<String> getAttributeSpellingSuggestions(String errorAttribute, String parentTag) {
        Set<String> validAttributes;
        switch (parentTag) {
            case "base-config": 
            case "domain-config": 
            case "debug-overrides": {
                validAttributes = Collections.singleton(ATTR_CLEARTEXT_TRAFFIC_PERMITTED);
                break;
            }
            case "certificates": {
                validAttributes = Collections.singleton(ATTR_SRC);
                break;
            }
            case "domain": {
                validAttributes = Collections.singleton(ATTR_INCLUDE_SUBDOMAINS);
                break;
            }
            case "pin-set": {
                validAttributes = Collections.singleton(ATTR_EXPIRATION);
                break;
            }
            case "pin": {
                validAttributes = Collections.singleton(ATTR_DIGEST);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        List<String> result2 = NetworkSecurityConfigDetector.generateTypoSuggestions(errorAttribute, validAttributes);
        return result2 == null ? Collections.emptyList() : result2;
    }

    public static boolean isTagSpellingError(String errorMessage) {
        return errorMessage.startsWith("Misspelled tag");
    }

    public static List<String> getTagSpellingSuggestions(String errorTag, String parentTag) {
        Set<String> validTags;
        switch (parentTag) {
            case "network-security-config": {
                validTags = VALID_BASE_TAGS;
                break;
            }
            case "base-config": 
            case "domain-config": 
            case "debug-overrides": {
                validTags = VALID_CONFIG_TAGS;
                break;
            }
            case "trust-anchors": {
                validTags = Collections.singleton(TAG_CERTIFICATES);
                break;
            }
            case "pin-set": {
                validTags = Collections.singleton(TAG_PIN);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        List<String> result2 = NetworkSecurityConfigDetector.generateTypoSuggestions(errorTag, validTags);
        return result2 == null ? Collections.emptyList() : result2;
    }

    public static List<String> getSupportedPinDigestAlgorithms() {
        return Collections.singletonList(PIN_DIGEST_ALGORITHM);
    }
}

