/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016J<\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002J\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\"\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tH\u0002J\u001e\u0010*\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010,\u001a\u00020\tH\u0002J|\u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u0002002\u0006\u00101\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u00102\u001a\u0004\u0018\u00010\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002000\u00122\f\u00103\u001a\b\u0012\u0004\u0012\u0002000\u00122\f\u00104\u001a\b\u0012\u0004\u0012\u0002000\u00122\f\u00105\u001a\b\u0012\u0004\u0012\u0002000\u0012H\u0016J\f\u00106\u001a\u00020\u001f*\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "visitedAnnotationUsages", "", "Lcom/intellij/psi/PsiElement;", "addThreadAnnotations", "", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "result", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableAnnotations", "", "checkThreading", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "callerThreads", "calleeThreads", "describeThread", "describeThreads", "annotations", "any", "", "getThreadContext", "methodCall", "getThreadsFromExpressionContext", "lambdaCall", "Lorg/jetbrains/uast/UExpression;", "getThreadsFromMethod", "originalMethod", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isCompatibleThread", "caller", "callee", "callers", "visitAnnotationUsage", "usage", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "referenced", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "isThreadingAnnotation", "Companion", "android.sdktools.lint-checks"})
public final class ThreadDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PsiElement> visitedAnnotationUsages;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ThreadDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue THREAD;

    public ThreadDetector() {
        boolean bl2 = false;
        this.visitedAnnotationUsages = new LinkedHashSet();
    }

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetector.UI_THREAD_ANNOTATION.oldName(), AnnotationDetector.UI_THREAD_ANNOTATION.newName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.newName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.newName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.newName(), AnnotationDetector.ANY_THREAD_ANNOTATION.oldName(), AnnotationDetector.ANY_THREAD_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        AnnotationUsageType annotationUsageType = type;
        int n10 = WhenMappings.$EnumSwitchMapping$0[annotationUsageType.ordinal()];
        switch (n10) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.visitedAnnotationUsages.clear();
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method == null) {
            return;
        }
        Object object = usage.getSourcePsi();
        if (object == null) {
            return;
        }
        Object usagePsi = object;
        if (!this.visitedAnnotationUsages.add((PsiElement)usagePsi)) {
            return;
        }
        object = type;
        int n10 = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n10) {
            case 1: 
            case 2: {
                List<String> list2 = this.getThreadContext(context2, usage);
                if (list2 == null) {
                    return;
                }
                List<String> list3 = list2;
                list2 = this.getThreadsFromMethod(context2, method);
                if (list2 == null) {
                    return;
                }
                this.checkThreading(context2, usage, method, list3, list2);
                break;
            }
            case 3: 
            case 4: {
                Object object2;
                UCallableReferenceExpression uCallableReferenceExpression;
                UCallableReferenceExpression uCallableReferenceExpression2 = uCallableReferenceExpression = usage instanceof UCallableReferenceExpression ? (UCallableReferenceExpression)usage : null;
                if (uCallableReferenceExpression == null) {
                    return;
                }
                UCallableReferenceExpression reference = uCallableReferenceExpression;
                PsiElement psiElement = reference.resolve();
                PsiMethod psiMethod = object2 = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                if (object2 == null) {
                    return;
                }
                PsiMethod referencedMethod = object2;
                object2 = this.getThreadsFromExpressionContext(context2, (UExpression)reference);
                if (object2 == null) {
                    return;
                }
                Object object3 = object2;
                object2 = this.getThreadsFromMethod(context2, referencedMethod);
                if (object2 == null) {
                    return;
                }
                this.checkThreading(context2, usage, referencedMethod, (List<String>)object3, (List<String>)object2);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void checkThreading(JavaContext context2, UElement node, PsiMethod method, List<String> callerThreads, List<String> calleeThreads) {
        boolean bl2;
        block7: {
            Iterable $this$any$iv = calleeThreads;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl3 = false;
                    if (!this.isCompatibleThread(callerThreads, it2)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return;
        }
        String $i$f$any = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$any, (String)"method.name");
        String name = $i$f$any;
        if (StringsKt.startsWith$default((String)name, (String)"post", (boolean)false, (int)2, null) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
            return;
        }
        if (calleeThreads.containsAll((Collection)callerThreads)) {
            return;
        }
        if (calleeThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || calleeThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.newName())) {
            return;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread";
        Object[] objectArray = new Object[]{method.isConstructor() ? "Constructor" : "Method", method.getName(), this.describeThreads(calleeThreads, true), this.describeThreads(callerThreads, false)};
        boolean bl4 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        Location location = context2.getLocation(node);
        this.report(context2, THREAD, node, location, message2);
    }

    private final boolean isThreadingAnnotation(PsiAnnotation $this$isThreadingAnnotation) {
        String signature = $this$isThreadingAnnotation.getQualifiedName();
        return signature != null && StringsKt.endsWith$default((String)signature, (String)"Thread", (boolean)false, (int)2, null) && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(signature);
    }

    private final String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb2 = new StringBuilder();
        int n10 = 0;
        int n11 = annotations.size() + -1;
        if (n10 <= n11) {
            do {
                int i10;
                if ((i10 = n10++) > 0) {
                    if (i10 == annotations.size() - 1) {
                        if (any) {
                            sb2.append(" or ");
                        } else {
                            sb2.append(" and ");
                        }
                    } else {
                        sb2.append(", ");
                    }
                }
                sb2.append(this.describeThread(annotations.get(i10)));
            } while (n10 <= n11);
        }
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String describeThread(String annotation) {
        String string = annotation;
        return (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.newName())) ? "UI" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.newName())) ? "main" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.newName())) ? "binder" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.newName())) ? "worker" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.newName())) ? "any" : "other"))));
    }

    private final boolean isCompatibleThread(List<String> callers, String callee) {
        Collection collection = callers;
        boolean bl2 = false;
        boolean bl3 = !collection.isEmpty();
        bl2 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (String caller : callers) {
            if (this.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCompatibleThread(String caller, String callee) {
        if (Intrinsics.areEqual((Object)callee, (Object)caller)) {
            return true;
        }
        if (AnnotationDetector.ANY_THREAD_ANNOTATION.isEquals(callee)) {
            return true;
        }
        if (AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(callee) ? AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(caller) : AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(callee) && AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(caller)) {
            return true;
        }
        int callerNameIndex = StringsKt.lastIndexOf$default((CharSequence)caller, (char)'.', (int)0, (boolean)false, (int)6, null);
        int calleeNameIndex = StringsKt.lastIndexOf$default((CharSequence)callee, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (callerNameIndex != -1 && calleeNameIndex != -1) {
            return StringsKt.regionMatches((String)caller, (int)callerNameIndex, (String)callee, (int)calleeNameIndex, (int)(caller.length() - callerNameIndex), (boolean)false);
        }
        return false;
    }

    private final List<String> getThreadContext(JavaContext context2, UElement methodCall) {
        PsiMethod method;
        Class[] classArray = new Class[]{UAnonymousClass.class, ULambdaExpression.class};
        UElement uElement = UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])classArray);
        PsiMethod psiMethod = method = uElement instanceof PsiMethod ? (PsiMethod)uElement : null;
        if (method != null) {
            UClass containingClass = UastUtils.getContainingUClass((UElement)methodCall);
            if (containingClass instanceof UAnonymousClass) {
                Object object = new Class[]{UCallExpression.class};
                UObjectLiteralExpression anonClassCall = (UObjectLiteralExpression)UastUtils.getParentOfType((UElement)methodCall, UObjectLiteralExpression.class, (boolean)true, (Class[])object);
                return (object = this.getThreadsFromExpressionContext(context2, (UExpression)anonClassCall)) == null ? this.getThreadsFromMethod(context2, method) : object;
            }
            return this.getThreadsFromMethod(context2, method);
        }
        classArray = new Class[]{UAnonymousClass.class, ULambdaExpression.class};
        ULambdaExpression lambdaCall = (ULambdaExpression)UastUtils.getParentOfType((UElement)methodCall, ULambdaExpression.class, (boolean)true, (Class[])classArray);
        return this.getThreadsFromExpressionContext(context2, (UExpression)lambdaCall);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getThreadsFromExpressionContext(JavaContext context2, UExpression lambdaCall) {
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        UCallExpression uCallExpression;
        PsiAnnotation[] psiAnnotationArray = lambdaCall;
        UElement uElement = psiAnnotationArray == null ? null : psiAnnotationArray.getUastParent();
        UCallExpression uCallExpression2 = uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression lambdaCallExpression = uCallExpression;
        uElement = UastUtils.getParameterForArgument((UCallExpression)lambdaCallExpression, (UExpression)lambdaCall);
        if (uElement == null) {
            return null;
        }
        UElement lambdaArgument = uElement;
        psiAnnotationArray = context2.getEvaluator().getAllAnnotations((PsiModifierListOwner)lambdaArgument, false);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_11 = $this$filterTo$iv$iv;
        int n10 = ((void)var11_11).length;
        for (int i10 = 0; i10 < n10; ++i10) {
            void element$iv$iv;
            void it2 = element$iv$iv = var11_11[i10];
            boolean bl2 = false;
            if (!this.isThreadingAnnotation((PsiAnnotation)it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            PsiAnnotation it3 = (PsiAnnotation)element$iv$iv;
            boolean bl4 = false;
            if (it3.getQualifiedName() == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv$iv = string;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        $this$mapNotNull$iv = annotations;
        boolean bl8 = false;
        if (!$this$mapNotNull$iv.isEmpty()) {
            return annotations;
        }
        PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)lambdaArgument.getType());
        return this.getThreadsFromMethod(context2, functionalInterfaceMethod);
    }

    private final List<String> getThreadsFromMethod(JavaContext context2, PsiMethod originalMethod) {
        PsiMethod method = originalMethod;
        if (method != null) {
            PsiAnnotation[] annotations;
            JavaEvaluator evaluator = context2.getEvaluator();
            List<String> result2 = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, false)) {
                    result2 = this.addThreadAnnotations(annotation, result2);
                }
                if (result2 != null) {
                    return result2;
                }
                if (evaluator.isStatic((PsiModifierListOwner)method)) {
                    return null;
                }
                method = evaluator.getSuperMethod(method);
            }
            while (cls != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)) {
                    result2 = this.addThreadAnnotations(annotation, result2);
                }
                if (result2 != null) {
                    return result2;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private final List<String> addThreadAnnotations(PsiAnnotation annotation, List<String> result2) {
        List resultList = result2;
        String name = annotation.getQualifiedName();
        if (name != null && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(name) && StringsKt.endsWith$default((String)name, (String)"Thread", (boolean)false, (int)2, null)) {
            if (resultList == null) {
                resultList = new ArrayList(4);
            }
            String string = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SUPPORT_ANNOTATIONS_PREFIX.newName()");
            if (StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                String string2 = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName();
                String string3 = name;
                int n10 = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length();
                boolean bl2 = false;
                String string4 = string3.substring(n10);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String oldName = Intrinsics.stringPlus((String)string2, (Object)string4);
                resultList.add(oldName);
            } else {
                resultList.add(name);
            }
        }
        return resultList;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        THREAD = Issue.Companion.create$default(companion, "WrongThread", "Wrong Thread", "\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread.\n                ", implementation, "https://developer.android.com/guide/components/processes-and-threads.html#Threads", category, 6, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            nArray[AnnotationUsageType.METHOD_CALL_CLASS.ordinal()] = 2;
            nArray[AnnotationUsageType.METHOD_CALL_PARAMETER.ordinal()] = 3;
            nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

