/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.w3c.dom.Attr;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016Jb\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\u0012H\u0002J \u0010%\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\"\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001e\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010/\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\b03H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0016J&\u00105\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u0002062\u0006\u00107\u001a\u00020\u0006H\u0002J \u00108\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u0001032\u0006\u0010\u0016\u001a\u0002062\u0006\u00109\u001a\u00020#H\u0014J \u0010:\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010;\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u0010<\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020'2\u0006\u0010A\u001a\u00020BH\u0016R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "fileIdMap", "", "Lcom/android/ide/common/util/PathString;", "Lcom/google/common/collect/Multimap;", "", "idToViewTag", "Ljava/util/HashMap;", "", "addTags", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "map", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkCompatible", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "castType", "Lcom/intellij/psi/PsiClassType;", "castTypeClass", "tag", "tags", "", "node", "Lorg/jetbrains/uast/UElement;", "resourceReference", "Lorg/jetbrains/uast/UExpression;", "items", "Lcom/android/ide/common/resources/ResourceItem;", "findView", "checkMissingCast", "findViewByIdCall", "Lorg/jetbrains/uast/UCallExpression;", "surroundingCall", "createCastFix", "Lcom/android/tools/lint/detector/api/LintFix;", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "displayTag", "createSecondary", "Lcom/android/tools/lint/detector/api/Location;", "sampleLayout", "findViewForTag", "Lcom/intellij/psi/PsiClass;", "getApplicableAttributes", "", "getApplicableMethodNames", "getIdToTagsIn", "Lcom/android/tools/lint/detector/api/Context;", "file", "getViewTags", "item", "isCompatible", "castClass", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public class ViewTypeDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Object> idToViewTag = new HashMap(50);
    @Nullable
    private Map<PathString, Multimap<String, String>> fileIdMap;
    @JvmField
    @NotNull
    public static final Issue WRONG_VIEW_CAST;
    @JvmField
    @NotNull
    public static final Issue ADD_CAST;
    @NotNull
    public static final String FIND_VIEW_BY_ID = "findViewById";
    @NotNull
    public static final String REQUIRE_VIEW_BY_ID = "requireViewById";
    @NotNull
    public static final String FIND_FRAGMENT_BY_TAG = "findFragmentByTag";
    @NotNull
    private static final String TAG_NAME_PREFIX = ":tag:";

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"id", "tag"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        List list2;
        String string;
        boolean bl2;
        int n10;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String value = attribute.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n10 = "@id/".length();
            bl2 = false;
            String string3 = string2.substring(n10);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n10 = "@+id/".length();
            bl2 = false;
            String string4 = string2.substring(n10);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName())) {
            string = Intrinsics.stringPlus((String)TAG_NAME_PREFIX, (Object)value);
        } else {
            return;
        }
        String id2 = string;
        ViewTypeDetector viewTypeDetector = this;
        bl2 = false;
        boolean bl3 = false;
        ViewTypeDetector $this$visitAttribute_u24lambda_u2d0 = viewTypeDetector;
        boolean bl4 = false;
        String cls = attribute.getOwnerElement().getTagName();
        if (Intrinsics.areEqual((Object)cls, (Object)"view")) {
            cls = attribute.getOwnerElement().getAttribute("class");
        } else if (Intrinsics.areEqual((Object)cls, (Object)"fragment")) {
            if (!Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName())) {
                return;
            }
            cls = attribute.getOwnerElement().getAttribute("class");
        }
        CharSequence charSequence = cls;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"cls");
        cls = StringsKt.replace$default((String)charSequence, (char)'$', (char)'.', (boolean)false, (int)4, null);
        charSequence = cls;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"cls");
        charSequence = charSequence;
        boolean bl5 = false;
        if (charSequence.length() == 0) {
            return;
        }
        charSequence = cls;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"cls");
        CharSequence view = charSequence;
        Object existing = this.idToViewTag.get(id2);
        if (existing == null) {
            Map map = this.idToViewTag;
            bl3 = false;
            map.put(id2, view);
        } else if (existing instanceof String) {
            String existingString = (String)existing;
            if (!Intrinsics.areEqual((Object)existingString, (Object)view)) {
                ArrayList<Object> list3 = new ArrayList<Object>(2);
                list3.add(existing);
                list3.add(view);
                Map map = this.idToViewTag;
                boolean bl6 = false;
                map.put(id2, list3);
            }
        } else if (TypeIntrinsics.isMutableList((Object)existing) && !(list2 = TypeIntrinsics.asMutableList((Object)existing)).contains(view)) {
            list2.add(view);
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{FIND_VIEW_BY_ID, REQUIRE_VIEW_BY_ID, FIND_FRAGMENT_BY_TAG};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object variable;
        PsiClassType type;
        PsiClassType psiClassType;
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        LintClient client = context2.getClient();
        UElement uElement = Lint.skipParentheses((UElement)node);
        if (uElement == null) {
            return;
        }
        UElement current = uElement;
        UElement parent = current.getUastParent();
        UElement errorNode = null;
        PsiClassType castType = null;
        UElement uElement2 = parent;
        if (uElement2 instanceof UBinaryExpressionWithType) {
            UElement cast = parent;
            psiType = ((UBinaryExpressionWithType)cast).getType();
            PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = cast;
        } else if (uElement2 instanceof UExpression) {
            if (parent instanceof UCallExpression) {
                UElement c10 = parent;
                this.checkMissingCast(context2, node, (UCallExpression)c10);
                return;
            }
            if (parent instanceof UQualifiedReferenceExpression) {
                UElement ref = parent;
                if (((UQualifiedReferenceExpression)ref).getSelector() != current) {
                    return;
                }
                if (!((parent = ((UExpression)parent).getUastParent()) instanceof UBinaryExpressionWithType)) {
                    return;
                }
            }
            UExpression uExpression = type = (psiClassType = parent) instanceof UExpression ? (UExpression)psiClassType : null;
            if (type == null) {
                return;
            }
            variable = type;
            psiType = variable.getExpressionType();
            PsiClassType psiClassType3 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else if (uElement2 instanceof UVariable) {
            variable = parent;
            psiType = ((UVariable)variable).getType();
            PsiClassType psiClassType4 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else {
            return;
        }
        variable = castType.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)variable, (String)"castType.canonicalText");
        switch (variable) {
            case "android.app.Fragment": 
            case "kotlin.Unit": 
            case "android.support.v4.app.Fragment": 
            case "androidx.fragment.app.Fragment": 
            case "android.view.View": {
                return;
            }
        }
        String methodName = node.getMethodName();
        boolean findView = Intrinsics.areEqual((Object)FIND_VIEW_BY_ID, (Object)methodName) || Intrinsics.areEqual((Object)REQUIRE_VIEW_BY_ID, (Object)methodName);
        boolean findTag = !findView && Intrinsics.areEqual((Object)FIND_FRAGMENT_BY_TAG, (Object)methodName);
        List args = node.getValueArguments();
        if (args.size() == 1) {
            UExpression first = (UExpression)args.get(0);
            String tag = null;
            String id2 = null;
            if (findTag) {
                String string = ConstantEvaluator.evaluateString(context2, (UElement)first, false);
                if (string == null) {
                    return;
                }
                tag = string;
                tag = Intrinsics.stringPlus((String)TAG_NAME_PREFIX, (Object)tag);
            } else {
                ResourceUrl resourceUrl = ResourceEvaluator.getResource(context2.getEvaluator(), (UElement)first);
                if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.isFramework()) {
                    id2 = resourceUrl.name;
                }
            }
            if (id2 != null || tag != null) {
                Object castTypeClass;
                if (id2 != null) {
                    boolean full = context2.isGlobalAnalysis();
                    Project project = full ? context2.getMainProject() : context2.getProject();
                    ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                    List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, id2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)items, (String)"items");
                    Collection collection = items;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) {
                        HashSet<String> compatible = new HashSet<String>();
                        for (ResourceItem item : items) {
                            Context context3 = context2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"item");
                            Collection<String> tags = this.getViewTags(context3, item);
                            if (tags == null) continue;
                            compatible.addAll(tags);
                        }
                        Collection collection2 = compatible;
                        boolean bl3 = false;
                        if (!collection2.isEmpty()) {
                            ArrayList layoutTypes = new ArrayList(compatible);
                            this.checkCompatible(context2, castType, (String)castTypeClass, null, layoutTypes, errorNode, first, items, findView);
                        }
                    }
                } else {
                    Map project = this.idToViewTag;
                    String string = id2;
                    string = tag;
                    boolean bl4 = false;
                    Object types = project.get(string);
                    if (types instanceof String) {
                        this.checkCompatible(context2, castType, (String)castTypeClass, (String)types, null, errorNode, first, null, findView);
                    } else if (types instanceof List) {
                        List layoutTypes = (List)types;
                        this.checkCompatible(context2, castType, (String)castTypeClass, null, layoutTypes, errorNode, first, null, findView);
                    }
                }
            }
        }
    }

    private final void checkMissingCast(JavaContext context2, UCallExpression findViewByIdCall, UCallExpression surroundingCall) {
        PsiClassType psiClassType;
        PsiClassType psiClassType2;
        LanguageLevel languageLevel = Lint.getLanguageLevel((UElement)surroundingCall, LanguageLevel.JDK_1_7);
        if (languageLevel.isLessThan(LanguageLevel.JDK_1_8)) {
            return;
        }
        if (!(surroundingCall.getUastParent() instanceof UQualifiedReferenceExpression)) {
            return;
        }
        List valueArguments = surroundingCall.getValueArguments();
        int parameterIndex = -1;
        int i10 = 0;
        int n10 = valueArguments.size();
        while (i10 < n10) {
            if (Intrinsics.areEqual((Object)findViewByIdCall, valueArguments.get(i10))) {
                parameterIndex = i10;
            }
            int n11 = i10;
            i10 = n11 + 1;
        }
        if (parameterIndex == -1) {
            return;
        }
        PsiMethod psiMethod = surroundingCall.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod resolvedMethod = psiMethod;
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        if (parameterIndex >= parameters.length) {
            return;
        }
        PsiType psiType = parameters[parameterIndex].getType();
        PsiClassType psiClassType3 = psiClassType2 = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType2 == null) {
            return;
        }
        PsiClassType parameterType = psiClassType2;
        if (!(parameterType.resolve() instanceof PsiTypeParameter)) {
            return;
        }
        PsiType erasure2 = TypeConversionUtil.erasure((PsiType)((PsiType)parameterType));
        if (erasure2 == null || Intrinsics.areEqual((Object)erasure2.getCanonicalText(), (Object)"android.view.View")) {
            return;
        }
        Object object = resolvedMethod.getReturnType();
        PsiClassType psiClassType4 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType returnType = psiClassType;
        if (!(returnType.resolve() instanceof PsiTypeParameter)) {
            return;
        }
        object = findViewByIdCall.getMethodName();
        if (object == null) {
            return;
        }
        Object callName = object;
        LintFix fix = LintFix.Companion.create().replace().name("Add cast").text((String)callName).shortenNames().reformat(true).with(Intrinsics.stringPlus((String)"(android.view.View)", (Object)callName)).build();
        context2.report(ADD_CAST, (UElement)findViewByIdCall, context2.getLocation((UElement)findViewByIdCall), "Add explicit cast here; won't compile with Java language level 1.8 without it", fix);
    }

    @Nullable
    protected Collection<String> getViewTags(@NotNull Context context2, @NotNull ResourceItem item) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        PathString pathString = item.getSource();
        if (pathString == null) {
            return null;
        }
        PathString source = pathString;
        Multimap<String, String> multimap = this.getIdToTagsIn(context2, source);
        if (multimap == null) {
            return null;
        }
        Multimap<String, String> map = multimap;
        return map.get((Object)item.getName());
    }

    private final Multimap<String, String> getIdToTagsIn(Context context2, PathString file) {
        Map map;
        boolean bl2;
        Object object;
        if (!StringsKt.endsWith$default((String)file.getFileName(), (String)".xml", (boolean)false, (int)2, null)) {
            return null;
        }
        Map map2 = this.fileIdMap;
        if (map2 == null) {
            object = this;
            bl2 = false;
            boolean bl3 = false;
            ViewTypeDetector $this$getIdToTagsIn_u24lambda_u2d1 = object;
            boolean bl4 = false;
            HashMap list2 = new HashMap();
            $this$getIdToTagsIn_u24lambda_u2d1.fileIdMap = list2;
            map = list2;
        } else {
            map = map2;
        }
        Map fileIdMap = map;
        Multimap map3 = fileIdMap.get(file);
        if (map3 == null) {
            map3 = (Multimap)ArrayListMultimap.create();
            object = fileIdMap;
            bl2 = false;
            object.put(file, map3);
            try {
                XmlPullParser parser = context2.getClient().createXmlPullParser(file);
                if (parser != null) {
                    this.addTags(parser, (Multimap<String, String>)map3);
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map3;
    }

    private final void addTags(XmlPullParser parser, Multimap<String, String> map) {
        block14: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    String tag;
                    String id2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                    if (id2 == null) continue block14;
                    CharSequence charSequence = id2;
                    boolean bl2 = false;
                    if (!(charSequence.length() > 0)) continue block14;
                    id2 = Lint.stripIdPrefix(id2);
                    CharSequence charSequence2 = parser.getName();
                    if (charSequence2 == null) continue block14;
                    switch (charSequence2) {
                        case "view": 
                        case "fragment": {
                            charSequence2 = parser.getAttributeValue(null, "class");
                            if (charSequence2 == null) continue block14;
                            tag = charSequence2;
                            charSequence2 = tag;
                            boolean bl3 = false;
                            if (!(charSequence2.length() == 0)) break;
                            continue block14;
                        }
                        case "include": 
                        case "merge": {
                            continue block14;
                        }
                    }
                    if (map.containsEntry((Object)id2, (Object)(tag = StringsKt.replace$default((String)tag, (char)'$', (char)'.', (boolean)false, (int)4, null)))) continue block14;
                    map.put((Object)id2, (Object)tag);
                    continue block14;
                }
                case 1: {
                    return;
                }
            }
        }
    }

    private final void checkCompatible(JavaContext context2, PsiClassType castType, String castTypeClass, String tag, List<String> tags, UElement node, UExpression resourceReference, List<? extends ResourceItem> items, boolean findView) {
        String verb;
        String string;
        String t1022;
        boolean bl2 = tag == null || tags == null;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-ViewTypeDetector$checkCompatible$232 = false;
            String string2 = tag;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            List<String> list2 = tags;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            String $i$a$-assert-ViewTypeDetector$checkCompatible$232 = Intrinsics.stringPlus((String)string2, list2);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ViewTypeDetector$checkCompatible$232));
        }
        if (Intrinsics.areEqual((Object)castTypeClass, (Object)tag) || tags != null && tags.contains(castTypeClass)) {
            return;
        }
        PsiClass castClass = castType.resolve();
        boolean compatible = true;
        if (findView) {
            if (tag != null) {
                if (!Intrinsics.areEqual((Object)tag, (Object)castTypeClass) && !context2.getSdkInfo().isSubViewOf(castTypeClass, tag)) {
                    compatible = false;
                }
            } else if (tags != null) {
                compatible = false;
                for (String type : tags) {
                    if (!Intrinsics.areEqual((Object)type, (Object)castTypeClass) && !context2.getSdkInfo().isSubViewOf(castTypeClass, type)) continue;
                    compatible = true;
                    break;
                }
            }
        } else {
            boolean bl4 = compatible = castClass == null;
        }
        if (castClass != null && !compatible) {
            if (tag != null) {
                if (this.isCompatible(context2, castClass, tag)) {
                    return;
                }
            } else if (tags != null) {
                for (String t1022 : tags) {
                    if (!this.isCompatible(context2, castClass, t1022)) continue;
                    return;
                }
            }
        }
        if (compatible) {
            return;
        }
        t1022 = tag;
        if (t1022 == null) {
            Joiner joiner = Joiner.on((String)"|");
            List<String> list3 = tags;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            string = joiner.join((Iterable)list3);
        } else {
            string = t1022;
        }
        String displayTag = string;
        String sampleLayout = null;
        if (items != null && (tags == null || tags.size() == 1)) {
            for (ResourceItem resourceItem : items) {
                PathString source;
                Collection<String> t11 = this.getViewTags(context2, resourceItem);
                if (t11 == null || !t11.contains(displayTag) || (source = resourceItem.getSource()) == null) continue;
                String parentName = source.getParentFileName();
                sampleLayout = resourceItem.getConfiguration().isDefault() || parentName == null ? source.getFileName() : parentName + '/' + source.getFileName();
                break;
            }
        }
        String string3 = castTypeClass;
        int t11 = StringsKt.lastIndexOf$default((CharSequence)castTypeClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        boolean source = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(t11);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String incompatibleTag = string5;
        String string6 = findView ? "layout" : "fragment";
        String string7 = verb = findView ? "was" : "referenced";
        if (!(node instanceof UBinaryExpressionWithType)) {
            Location location = null;
            if (node instanceof UVariable && ((UVariable)node).getTypeReference() != null) {
                UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                if (uTypeReferenceExpression == null) {
                    Intrinsics.throwNpe();
                }
                location = context2.getLocation((UElement)uTypeReferenceExpression);
                Intrinsics.checkExpressionValueIsNotNull((Object)displayTag, (String)"displayTag");
                location.setSecondary(this.createSecondary(context2, displayTag, resourceReference, sampleLayout));
            } else {
                location = context2.getLocation(node);
            }
            String message2 = "Unexpected implicit cast to `" + incompatibleTag + "`: " + string6 + " tag " + verb + " `" + displayTag + '`';
            JavaContext.report$default(context2, WRONG_VIEW_CAST, node, location, message2, null, 16, null);
        } else {
            Location location = context2.getLocation(node);
            if (sampleLayout != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)displayTag, (String)"displayTag");
                location.setSecondary(this.createSecondary(context2, displayTag, resourceReference, sampleLayout));
            }
            String message2 = "Unexpected cast to `" + incompatibleTag + "`: " + string6 + " tag " + verb + " `" + displayTag + '`';
            UBinaryExpressionWithType uBinaryExpressionWithType = (UBinaryExpressionWithType)node;
            Intrinsics.checkExpressionValueIsNotNull((Object)displayTag, (String)"displayTag");
            LintFix fix = this.createCastFix(uBinaryExpressionWithType, displayTag, context2);
            context2.report(WRONG_VIEW_CAST, node, location, message2, fix);
        }
    }

    private final LintFix createCastFix(UBinaryExpressionWithType node, String displayTag, JavaContext context2) {
        String string;
        UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
        if (uTypeReferenceExpression == null) {
            return null;
        }
        UTypeReferenceExpression typeReference = uTypeReferenceExpression;
        if (StringsKt.contains$default((CharSequence)displayTag, (char)'.', (boolean)false, (int)2, null)) {
            string = StringsKt.replace$default((String)displayTag, (char)'$', (char)'.', (boolean)false, (int)4, null);
        } else {
            String string2;
            String string3;
            PsiClass psiClass = this.findViewForTag(displayTag, context2);
            String string4 = string3 = psiClass == null ? null : psiClass.getQualifiedName();
            if (string3 == null) {
                return null;
            }
            string = string2 = string3;
        }
        String className = string;
        return this.fix().replace().all().with(className).name(Intrinsics.stringPlus((String)"Cast to ", (Object)displayTag)).range(context2.getLocation((UElement)typeReference)).reformat(true).shortenNames().build();
    }

    private final Location createSecondary(JavaContext context2, String tag, UExpression resourceReference, String sampleLayout) {
        Location secondary = context2.getLocation((UElement)resourceReference);
        if (sampleLayout != null) {
            String article = StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1 && StringsKt.indexOf$default((CharSequence)tag, (char)'|', (int)0, (boolean)false, (int)6, null) == -1 && StringUtil.isVowel((char)Character.toLowerCase(tag.charAt(0))) ? "an" : "a";
            secondary.setMessage("Id bound to " + article + " `" + tag + "` in `" + sampleLayout + '`');
        }
        return secondary;
    }

    private final boolean isCompatible(JavaContext context2, PsiClass castClass, String tag) {
        boolean bl2;
        PsiClass psiClass = this.findViewForTag(tag, context2);
        return psiClass == null ? true : (bl2 = psiClass.isInheritor(castClass, true));
    }

    private final PsiClass findViewForTag(String tag, JavaContext context2) {
        PsiClass cls = null;
        if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            String[] stringArray = new String[]{"android.widget.", "android.view.", "android.webkit."};
            for (String prefix : stringArray) {
                cls = context2.getEvaluator().findClass(Intrinsics.stringPlus((String)prefix, (Object)tag));
                if (cls == null) continue;
                break;
            }
        } else {
            cls = context2.getEvaluator().findClass(tag);
        }
        return cls;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(ViewTypeDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES), enumSetArray);
        WRONG_VIEW_CAST = Issue.Companion.create$default(companion, "WrongViewCast", "Mismatched view type", "\n                Keeps track of the view types associated with ids and if it finds a usage \\\n                of the id in the Java code it ensures that it is treated as the same type.", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(ViewTypeDetector.class, Scope.JAVA_FILE_SCOPE);
        ADD_CAST = Issue.Companion.create$default(companion, "FindViewByIdCast", "Add Explicit Cast", "\n                In Android O, the `findViewById` signature switched to using generics, which \\\n                means that most of the time you can leave out explicit casts and just assign \\\n                the result of the `findViewById` call to variables of specific view classes.\n\n                However, due to language changes between Java 7 and 8, this change may cause \\\n                code to not compile without explicit casts. This lint check looks for these \\\n                scenarios and suggests casts to be added now such that the code will \\\n                continue to compile if the language level is updated to 1.8.", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector$Companion;", "", "()V", "ADD_CAST", "Lcom/android/tools/lint/detector/api/Issue;", "FIND_FRAGMENT_BY_TAG", "", "FIND_VIEW_BY_ID", "REQUIRE_VIEW_BY_ID", "TAG_NAME_PREFIX", "WRONG_VIEW_CAST", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

