/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApiKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "registry", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/client/api/Vendor;)V", "api", "", "getApi", "()I", "isUpToDate", "", "()Z", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "getJarFile", "()Ljava/io/File;", "timestamp", "", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "cacheable", "Factory", "android.sdktools.lint-api"})
public final class JarFileIssueRegistry
extends IssueRegistry {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final File jarFile;
    @NotNull
    private final Vendor vendor;
    @NotNull
    private final List<Issue> issues;
    private long timestamp;
    private final int api;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile(".*[/\\\\].gradle[/\\\\]caches[/\\\\]transforms-[0-9]+[/\\\\][0-9a-f]+[/\\\\]transformed[/\\\\](.+)[/\\\\]jars[/\\\\]lint\\.jar$");
    @NotNull
    private static final String SERVICE_KEY = "META-INF/services/com.android.tools.lint.client.api.IssueRegistry";
    @NotNull
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    @NotNull
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    @Nullable
    private static Map<File, SoftReference<JarFileIssueRegistry>> cache;

    private JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor) {
        this.jarFile = jarFile;
        this.vendor = vendor;
        this.issues = CollectionsKt.toList((Iterable)registry.getIssues());
        this.timestamp = this.jarFile.lastModified();
        ClassLoader loader = registry.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            JarFileIssueRegistry.Factory.loadAndCloseURLClassLoader(client, this.jarFile, (URLClassLoader)loader);
        }
        this.api = 10;
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @Override
    @NotNull
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    protected boolean cacheable() {
        return LintClient.Companion.isStudio();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    @Override
    public int getApi() {
        return this.api;
    }

    public /* synthetic */ JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor, DefaultConstructorMarker $constructor_marker) {
        this(client, jarFile, registry, vendor);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0002J,\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u001f\u0010!\u001a\u00020 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0#\"\u00020 \u00a2\u0006\u0002\u0010$J \u0010%\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J,\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010+\u001a\u00020,H\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry$Factory;", "", "()V", "ARTIFACT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MF_LINT_REGISTRY", "", "MF_LINT_REGISTRY_OLD", "SERVICE_KEY", "cache", "", "Ljava/io/File;", "Ljava/lang/ref/SoftReference;", "Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "clearCache", "", "findRegistries", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFiles", "", "get", "registryClassName", "jarFile", "currentProject", "Lcom/android/tools/lint/detector/api/Project;", "", "getVendor", "Lcom/android/tools/lint/client/api/Vendor;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "join", "registries", "", "([Lcom/android/tools/lint/client/api/IssueRegistry;)Lcom/android/tools/lint/client/api/IssueRegistry;", "loadAndCloseURLClassLoader", "file", "loader", "Ljava/net/URLClassLoader;", "loadIssueRegistry", "className", "logJarProblems", "", "verify", "android.sdktools.lint-api"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final List<JarFileIssueRegistry> get(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles, @Nullable Project currentProject) {
            Map<String, File> map;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(jarFiles, (String)"jarFiles");
            try {
                map = this.findRegistries(client, jarFiles);
            }
            catch (IOException e10) {
                if (this.logJarProblems()) {
                    client.log(e10, Intrinsics.stringPlus((String)"Could not load custom lint check jar files: ", (Object)e10.getMessage()), new Object[0]);
                }
                return CollectionsKt.emptyList();
            }
            Map<String, File> registryMap = map;
            if (registryMap.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int capacity = jarFiles.size() + 1;
            ArrayList<JarFileIssueRegistry> registries = new ArrayList<JarFileIssueRegistry>(capacity);
            Object object = registryMap;
            boolean bl2 = false;
            Iterator<Map.Entry<String, File>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl3 = false;
                String registryClass = (String)object2.getKey();
                Object object3 = object;
                boolean bl4 = false;
                File jarFile = (File)object3.getValue();
                try {
                    JarFileIssueRegistry jarFileIssueRegistry = this.get(client, registryClass, jarFile, currentProject);
                    if (jarFileIssueRegistry == null) continue;
                    JarFileIssueRegistry registry = jarFileIssueRegistry;
                    registries.add(registry);
                }
                catch (Throwable e11) {
                    if (!this.logJarProblems()) continue;
                    Object[] objectArray = new Object[]{jarFile};
                    client.log(e11, "Could not load custom lint check jar file %1$s", objectArray);
                }
            }
            return registries;
        }

        private final JarFileIssueRegistry get(LintClient client, String registryClassName, File jarFile, Project currentProject) {
            JarFileIssueRegistry jarFileIssueRegistry;
            if (cache == null) {
                cache = new HashMap();
            } else {
                JarFileIssueRegistry registry;
                SoftReference reference;
                Map map = cache;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if ((reference = (SoftReference)map.get(jarFile)) != null && (registry = (JarFileIssueRegistry)reference.get()) != null && registry.isUpToDate()) {
                    return registry;
                }
            }
            IssueRegistry.Companion.reset();
            IssueRegistry userRegistry = this.loadIssueRegistry(client, jarFile, registryClassName, currentProject);
            if (userRegistry != null) {
                Vendor vendor = this.getVendor(client, userRegistry, jarFile);
                JarFileIssueRegistry jarIssueRegistry = new JarFileIssueRegistry(client, jarFile, userRegistry, vendor, null);
                for (Issue issue : userRegistry.getIssues()) {
                    issue.setRegistry(jarIssueRegistry);
                    if (issue.getDefaultSeverity() != Severity.IGNORE) continue;
                    client.log(Severity.ERROR, null, "Issue " + issue.getId() + " has defaultSeverity=IGNORE; that's not valid. Use enabledByDefault=false instead.", new Object[0]);
                }
                Map map = cache;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                Map map2 = map;
                SoftReference<JarFileIssueRegistry> softReference = new SoftReference<JarFileIssueRegistry>(jarIssueRegistry);
                boolean bl2 = false;
                map2.put(jarFile, softReference);
                jarFileIssueRegistry = jarIssueRegistry;
            } else {
                jarFileIssueRegistry = null;
            }
            return jarFileIssueRegistry;
        }

        public final void clearCache() {
            Map map = cache;
            if (map != null) {
                map.clear();
            }
        }

        @NotNull
        public final IssueRegistry join(IssueRegistry ... registries) {
            Intrinsics.checkParameterIsNotNull((Object)registries, (String)"registries");
            return registries.length == 1 ? registries[0] : (IssueRegistry)new CompositeIssueRegistry(ArraysKt.toList((Object[])registries));
        }

        private final String verify(LintClient client, File jarFile) {
            block3: {
                LintJarVerifier verifier = new LintJarVerifier();
                try {
                    if (!verifier.isCompatible(jarFile)) {
                        return verifier.describeFirstIncompatibleReference();
                    }
                }
                catch (Throwable verifierBug) {
                    if (!this.logJarProblems()) break block3;
                    client.log(verifierBug, Intrinsics.stringPlus((String)"Error verifying bytecode in ", (Object)jarFile), new Object[0]);
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final IssueRegistry loadIssueRegistry(LintClient client, File jarFile, String className, Project currentProject) {
            IssueRegistry issueRegistry;
            URL url = SdkUtils.fileToUrl((File)jarFile);
            try {
                IssueRegistry registry;
                block22: {
                    List<Issue> list2;
                    Object object = new URL[1];
                    Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"url");
                    object[0] = url;
                    URL[] uRLArray = object;
                    object = JarFileIssueRegistry.class.getClassLoader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"JarFileIssueRegistry::class.java.classLoader");
                    ClassLoader loader = client.createUrlClassLoader(uRLArray, (ClassLoader)object);
                    Class<?> registryClass = Class.forName(className, true, loader);
                    Object obj = registryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.client.api.IssueRegistry");
                    }
                    registry = (IssueRegistry)obj;
                    try {
                        list2 = registry.getIssues();
                    }
                    catch (Throwable e10) {
                        StringBuilder stacktrace = new StringBuilder();
                        LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e10, stacktrace, 0, 0, 12, null);
                        String message2 = "Lint found one or more custom checks that could not be loaded. The most likely reason for this is that it is using an older, incompatible or unsupported API in lint. Make sure these lint checks are updated to the new APIs. The issue registry class is " + className + ". The class loading issue is " + e10.getMessage() + ": " + stacktrace;
                        LintClient.Companion.report(client, IssueRegistry.OBSOLETE_LINT_CHECK, message2, jarFile, currentProject);
                        return null;
                    }
                    List<Issue> issues = list2;
                    try {
                        if (registry.getMaxApi() < 10) {
                            return null;
                        }
                        Method apiField = registryClass.getDeclaredMethod("getApi", new Class[0]);
                        Object stacktrace = apiField.invoke((Object)registry, new Object[0]);
                        if (stacktrace == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int api = (Integer)stacktrace;
                        if (api < 10) {
                            String verifierError = this.verify(client, jarFile);
                            if (verifierError != null) {
                                String string = "\nLibrary lint checks out of date.\n\nLint found an issue registry (`" + className + "`)\nwhich was compiled against an older version of lint\nthan this one.\n\nThis often works just fine, but some basic verification\nshows that the lint check jar references (for example)\nthe following API which is no longer valid in this\nversion of lint:\n" + verifierError + "\n\nRecompile the checks against the latest version, or if\nthis is a check bundled with a third-party library, see\nif there is a more recent version available.\n\nVersion of Lint API this lint check is using is " + api + ".\nThe Lint API version currently running is 10 (" + ApiKt.describeApi(10) + ").\n";
                                boolean bl2 = false;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                String message3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                                LintClient.Companion.report(client, IssueRegistry.OBSOLETE_LINT_CHECK, message3, jarFile, currentProject);
                                return null;
                            }
                            break block22;
                        }
                        try {
                            String verifierError;
                            int minApi = registry.getMinApi();
                            if (minApi > 10) {
                                String message4 = "Lint found an issue registry (`" + className + "`) which requires a newer API level. That means that the custom lint checks are intended for a newer lint version; please upgrade.";
                                LintClient.Companion.report(client, IssueRegistry.OBSOLETE_LINT_CHECK, message4, jarFile, currentProject);
                                return null;
                            }
                            if (api >= 10 && (verifierError = this.verify(client, jarFile)) != null) {
                                String string = "\nRequires newer lint.\n\nLint found an issue registry (`" + className + "`)\nwhich was compiled against a newer version of lint\nthan this one.\n\nThis often works just fine, but some basic verification\nshows that the lint check jar references (for example)\nthe following API which is not valid in the version of\nlint which is running:\n" + verifierError + "\n\nTo use this lint check, upgrade to a more recent version\nof lint.\n\nVersion of Lint API this lint check is using is " + api + ".\nThe Lint API version currently running is 10 (" + ApiKt.describeApi(10) + ").\n";
                                boolean bl3 = false;
                                String string3 = string;
                                if (string3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                String message5 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                                LintClient.Companion.report(client, IssueRegistry.OBSOLETE_LINT_CHECK, message5, jarFile, currentProject);
                                return null;
                            }
                        }
                        catch (Throwable e11) {
                            if (this.logJarProblems()) {
                                client.log(e11, null, new Object[0]);
                            }
                        }
                    }
                    catch (Throwable e12) {
                        void $this$mapTo$iv$iv;
                        if (StringsKt.startsWith$default((String)className, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"android.", (boolean)false, (int)2, null)) {
                            return registry;
                        }
                        String message6 = "Lint found an issue registry (`" + className + "`)\nwhich did not specify the Lint API version it was compiled with.\n\n**This means that the lint checks are likely not compatible.**\n\nIf you are the author of this lint check, make your lint\n`IssueRegistry` class contain\n\u00a0\u00a0override val api: Int = com.android.tools.lint.detector.api.CURRENT_API\nor from Java,\n\u00a0\u00a0@Override public int getApi() { return com.android.tools.lint.detector.api.ApiKt.CURRENT_API; }";
                        Iterable $this$map$iv = issues;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            Issue issue = (Issue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            String string = it2.getId();
                            collection.add(string);
                        }
                        List issueIds = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        if (CollectionsKt.any((Iterable)issueIds)) {
                            message6 = Intrinsics.stringPlus((String)message6, (Object)StringsKt.replace$default((String)("\n\nIf you are just using lint checks from a third party library\nyou have no control over, you can disable these lint checks (if\nthey misbehave) like this:\n\n    android {\n        lintOptions {\n            disable " + CollectionsKt.joinToString$default((Iterable)issueIds, (CharSequence)",\n                    ", null, null, (int)0, null, (Function1)loadIssueRegistry.1.INSTANCE, (int)30, null) + "\n        }\n    }\n"), (String)"    ", (String)"\u00a0\u00a0\u00a0\u00a0", (boolean)false, (int)4, null));
                        }
                        LintClient.Companion.report(client, IssueRegistry.OBSOLETE_LINT_CHECK, message6, jarFile, currentProject);
                    }
                }
                issueRegistry = registry;
            }
            catch (Throwable e13) {
                if (this.logJarProblems()) {
                    Object[] objectArray = new Object[]{jarFile};
                    client.log(e13, "Could not load custom lint check jar file %1$s", objectArray);
                }
                issueRegistry = null;
            }
            return issueRegistry;
        }

        private final Vendor getVendor(LintClient client, IssueRegistry registry, File jarFile) {
            Vendor vendor;
            Vendor vendor2 = registry.getVendor();
            if (vendor2 == null) {
                Vendor inferredVendor;
                Vendor vendor3;
                Object object;
                String string;
                Factory factory = this;
                boolean bl2 = false;
                boolean bl3 = false;
                Factory $this$getVendor_u24lambda_u2d1 = factory;
                boolean bl4 = false;
                String registryClass = registry.getClass().getName();
                Matcher matcher = ARTIFACT_PATTERN.matcher(jarFile.getPath());
                if (matcher.matches()) {
                    string = matcher.group(1);
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)registryClass, (String)"registryClass");
                    String string2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)registryClass, (CharSequence)"IssueRegistry"), (CharSequence)"Registry"), (CharSequence)".My"), (CharSequence)".");
                    object = Locale.US;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"US");
                    boolean bl5 = false;
                    String string3 = string2;
                    boolean bl6 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toLowerCase((Locale)object);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                }
                String identifier = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)registryClass, (String)"registryClass");
                if (StringsKt.startsWith$default((String)registryClass, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)registryClass, (String)"android.", (boolean)false, (int)2, null)) {
                    object = "Android Open Source Project (" + identifier + ')';
                    vendor3 = new Vendor((String)object, identifier, "https://issuetracker.google.com/issues/new?component=192731", null, 8, null);
                } else {
                    vendor3 = inferredVendor = StringsKt.startsWith$default((String)registryClass, (String)"com.google.", (boolean)false, (int)2, null) ? new Vendor("Google (" + identifier + ')', identifier, null, null, 12, null) : (Vendor)null;
                }
                if (inferredVendor != null) {
                    vendor = inferredVendor;
                } else {
                    if ($this$getVendor_u24lambda_u2d1.logJarProblems()) {
                        client.log(Severity.WARNING, null, registryClass + " in " + jarFile + " does not specify a vendor; see IssueRegistry#vendor", new Object[0]);
                    }
                    vendor = new Vendor(null, identifier, null, null, 13, null);
                }
            } else {
                vendor = vendor2;
            }
            return vendor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Map<String, File> findRegistries(LintClient client, Collection<? extends File> jarFiles) {
            HashMap registryClassToJarFile = new HashMap();
            for (File file : jarFiles) {
                Closeable closeable = new JarFile(file);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    boolean bl4;
                    Object object;
                    Object[] objectArray;
                    JarFile file2 = (JarFile)closeable;
                    boolean bl5 = false;
                    Manifest manifest = file2.getManifest();
                    Attributes attrs = manifest.getMainAttributes();
                    Object attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY));
                    boolean isLegacy = false;
                    if (attribute == null && (attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY_OLD))) != null) {
                        isLegacy = true;
                    }
                    if (attribute instanceof String) {
                        Object className = attribute;
                        if (!isLegacy || registryClassToJarFile.get(className) == null) {
                            objectArray = registryClassToJarFile;
                            object = className;
                            bl4 = false;
                            objectArray.put(object, file);
                        }
                    } else {
                        JarEntry services = file2.getJarEntry(JarFileIssueRegistry.SERVICE_KEY);
                        if (services != null) {
                            objectArray = file2.getInputStream(services);
                            boolean bl6 = false;
                            bl4 = false;
                            Throwable throwable2 = null;
                            try {
                                InputStream it2 = (InputStream)objectArray;
                                boolean bl7 = false;
                                InputStreamReader reader = new InputStreamReader(it2, Charsets.UTF_8);
                                Reader $this$useLines$iv = reader;
                                boolean $i$f$useLines = false;
                                Closeable closeable2 = $this$useLines$iv;
                                int n10 = 8192;
                                boolean bl8 = false;
                                closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n10);
                                n10 = 0;
                                bl8 = false;
                                Throwable throwable3 = null;
                                try {
                                    BufferedReader it$iv = (BufferedReader)closeable2;
                                    boolean bl9 = false;
                                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                    boolean bl10 = false;
                                    for (String line : lines) {
                                        String string;
                                        int n11;
                                        Object object2;
                                        int comment = StringsKt.indexOf$default((CharSequence)line, (String)"#", (int)0, (boolean)false, (int)6, null);
                                        if (comment >= 0) {
                                            object2 = line;
                                            n11 = 0;
                                            boolean bl11 = false;
                                            String string2 = object2;
                                            if (string2 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                            }
                                            String string3 = string2.substring(n11, comment);
                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                            object2 = string3;
                                            n11 = 0;
                                            CharSequence charSequence = object2;
                                            if (charSequence == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                                        } else {
                                            object2 = line;
                                            n11 = 0;
                                            String string4 = object2;
                                            if (string4 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                                        }
                                        String className = string;
                                        object2 = className;
                                        n11 = 0;
                                        if (!(object2.length() > 0) || registryClassToJarFile.get(className) != null) continue;
                                        object2 = registryClassToJarFile;
                                        n11 = 0;
                                        object2.put(className, file);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)objectArray, (Throwable)throwable2);
                            }
                        }
                        if (Factory.logJarProblems()) {
                            objectArray = new Object[2];
                            object = file.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jarFile.path");
                            objectArray[0] = object;
                            objectArray[1] = JarFileIssueRegistry.MF_LINT_REGISTRY;
                            client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", objectArray);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return registryClassToJarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                return;
            }
            try {
                Closeable closeable = new JarFile(file);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)closeable;
                    boolean bl4 = false;
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        String path2 = entry.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                        if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path2, (char)'$', (int)0, (boolean)false, (int)6, null) != -1) continue;
                        String string = path2;
                        int n10 = 0;
                        int n11 = path2.length() - ".class".length();
                        boolean bl5 = false;
                        String string2 = string.substring(n10, n11);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String name = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
                        try {
                            Class<?> cls = Class.forName(name, true, loader);
                            if (cls.isAnnotation() || cls.isEnum() || cls.isInterface()) continue;
                            try {
                                Constructor<?> defaultConstructor = cls.getConstructor(new Class[0]);
                                defaultConstructor.setAccessible(true);
                                defaultConstructor.newInstance(new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                        }
                        catch (Throwable e10) {
                            if (!Factory.logJarProblems()) continue;
                            client.log(Severity.ERROR, e10, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    loader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private final boolean logJarProblems() {
            return !Intrinsics.areEqual((Object)System.getProperty("android.lint.log-jar-problems"), (Object)"false");
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

