/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,J2\u0010*\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00106\u001a\u00020\tJ\u0010\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\tH\u0002J\b\u00109\u001a\u00020)H\u0002J\u001d\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u001e\u0010@\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\tJ\u0016\u0010C\u001a\u00020)2\u0006\u00106\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012RN\u0010\u0018\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001b\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001c0\u001c \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R$\u0010%\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010 \"\u0004\b'\u0010\"\u00a8\u0006I"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "attributes", "", "", "entriesToWrite", "", "Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "getFile", "()Ljava/io/File;", "fixedCount", "", "getFixedCount", "()I", "<set-?>", "foundErrorCount", "getFoundErrorCount", "foundWarningCount", "getFoundWarningCount", "idToMessages", "Lcom/google/common/collect/ArrayListMultimap;", "kotlin.jvm.PlatformType", "messageToEntry", "Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "removeFixed", "", "getRemoveFixed", "()Z", "setRemoveFixed", "(Z)V", "totalCount", "getTotalCount", "writeOnClose", "getWriteOnClose", "setWriteOnClose", "close", "", "findAndMark", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "depth", "getAttribute", "name", "ignored", "id", "readBaselineFile", "reportBaselineIssues", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "reportBaselineIssues$android_sdktools_lint_api", "sameMessage", "new", "old", "setAttribute", "value", "Companion", "Entry", "LightLocation", "ReportedEntry", "android.sdktools.lint-api"})
public final class LintBaseline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final LintClient client;
    @NotNull
    private final File file;
    private int foundErrorCount;
    private int foundWarningCount;
    private int totalCount;
    private final ArrayListMultimap<String, Entry> messageToEntry;
    private final ArrayListMultimap<String, String> idToMessages;
    private boolean writeOnClose;
    private boolean removeFixed;
    @Nullable
    private List<ReportedEntry> entriesToWrite;
    @Nullable
    private Map<String, String> attributes;
    @NotNull
    public static final String VARIANT_ALL = "all";
    @NotNull
    public static final String VARIANT_FATAL = "fatal";

    public LintBaseline(@Nullable LintClient client, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.client = client;
        this.file = file;
        this.messageToEntry = ArrayListMultimap.create((int)100, (int)20);
        this.idToMessages = ArrayListMultimap.create((int)30, (int)20);
        this.readBaselineFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final int getFoundErrorCount() {
        return this.foundErrorCount;
    }

    public final int getFoundWarningCount() {
        return this.foundWarningCount;
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    public final boolean getWriteOnClose() {
        return this.writeOnClose;
    }

    public final void setWriteOnClose(boolean writeOnClose) {
        if (writeOnClose) {
            int count = this.totalCount > 0 ? this.totalCount + 10 : 30;
            this.entriesToWrite = new ArrayList(count);
        }
        this.writeOnClose = writeOnClose;
    }

    public final boolean getRemoveFixed() {
        return this.removeFixed;
    }

    public final void setRemoveFixed(boolean bl2) {
        this.removeFixed = bl2;
    }

    public final int getFixedCount() {
        return this.totalCount - this.foundErrorCount - this.foundWarningCount;
    }

    private final boolean ignored(String id2) {
        return IssueRegistry.Companion.isDeletedIssueId(id2) || Intrinsics.areEqual((Object)id2, (Object)"VectorDrawableCompat");
    }

    public final void reportBaselineIssues$android_sdktools_lint_api(@NotNull LintDriver driver, @NotNull Project project) {
        int fixedCount;
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.foundErrorCount > 0 || this.foundWarningCount > 0) {
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            String message2 = Companion.describeBaselineFilter(this.foundErrorCount, this.foundWarningCount, LintBaseline.Companion.getDisplayPath(client, project, baselineFile));
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, message2, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
        if (!((fixedCount = this.getFixedCount()) <= 0 || this.writeOnClose && this.removeFixed)) {
            boolean bl2;
            Object object;
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            HashMap ids = Maps.newHashMap();
            for (Entry entry : this.messageToEntry.values()) {
                String id2 = entry.getIssueId();
                if (this.ignored(id2)) continue;
                Integer count = (Integer)ids.get(id2);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)ids, (String)"ids");
                object = ids;
                bl2 = false;
                object.put(id2, count);
            }
            if (ids.isEmpty()) {
                return;
            }
            ArrayList sorted = Lists.newArrayList((Iterable)ids.keySet());
            Intrinsics.checkExpressionValueIsNotNull((Object)sorted, (String)"sorted");
            CollectionsKt.sort((List)sorted);
            StringBuilder issueTypes = new StringBuilder();
            for (String id3 : sorted) {
                object = issueTypes;
                bl2 = false;
                if (object.length() > 0) {
                    issueTypes.append(", ");
                }
                issueTypes.append(id3);
                Integer count = (Integer)ids.get(id3);
                if (count == null || count <= 1) continue;
                issueTypes.append(" (").append(count.toString()).append(")");
            }
            Object object2 = StringCompanionObject.INSTANCE;
            object = "%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?";
            Object[] objectArray = new Object[]{fixedCount, LintBaseline.Companion.getDisplayPath(client, project, baselineFile)};
            boolean bl3 = false;
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            String message3 = string;
            if (LintClient.Companion.isGradle() && project.getBuildModule() != null && ((object2 = project.getBuildModule()) == null ? false : ((object = object2.getLintOptions()) == null ? false : !object.getCheckDependencies()))) {
                message3 = Intrinsics.stringPlus((String)message3, (Object)" Another possible explanation is that lint recently stopped analyzing (and including results from) dependent projects by default. You can turn this back on with `android.lintOptions.checkDependencies=true`.");
            }
            message3 = message3 + " Unmatched issue types: " + issueTypes;
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, message3, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
    }

    public final boolean findAndMark(@NotNull Incident incident) {
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Issue issue = incident.getIssue();
        Location location = incident.getLocation();
        String message2 = incident.getMessage();
        Severity severity = incident.getSeverity();
        boolean found = this.findAndMark(issue, location, message2, severity, 0);
        if (this.writeOnClose && (!this.removeFixed || found) && this.entriesToWrite != null && !Intrinsics.areEqual((Object)issue.getId(), (Object)IssueRegistry.BASELINE.getId())) {
            Project project = incident.getProject();
            List<ReportedEntry> list2 = this.entriesToWrite;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(new ReportedEntry(issue, project, location, message2));
        }
        return found;
    }

    private final boolean findAndMark(Issue issue, Location location, String message2, Severity severity, int depth) {
        List entries = this.messageToEntry.get((Object)message2);
        if (entries == null || entries.isEmpty()) {
            List messages = this.idToMessages.get((Object)issue.getId());
            if (messages != null) {
                Collection collection = messages;
                boolean bl2 = false;
                if (!collection.isEmpty() && depth < 20) {
                    for (String oldMessage : messages) {
                        if (Intrinsics.areEqual((Object)message2, (Object)oldMessage)) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oldMessage, (String)"oldMessage");
                        if (!this.sameMessage(issue, message2, oldMessage)) continue;
                        return this.findAndMark(issue, location, oldMessage, severity, depth + 1);
                    }
                }
            }
            return false;
        }
        File file = location.getFile();
        String path2 = file.getPath();
        String issueId = issue.getId();
        for (Entry entry : entries) {
            Entry entry2 = entry;
            if (entry2 == null || !Intrinsics.areEqual((Object)entry.getIssueId(), (Object)issueId) && (!IssueRegistry.Companion.isDeletedIssueId(entry.getIssueId()) || !Intrinsics.areEqual((Object)IssueRegistry.Companion.getNewId(entry.getIssueId()), (Object)issueId))) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
            if (!Companion.isSamePathSuffix(path2, entry.getPath())) continue;
            Entry curr = entry;
            while (curr.getPrevious() != null) {
                curr = curr.getPrevious();
            }
            while (curr != null) {
                this.messageToEntry.remove((Object)curr.getMessage(), (Object)curr);
                this.idToMessages.remove((Object)issue, (Object)curr.getMessage());
                curr = curr.getNext();
            }
            Object object = severity;
            if ((object == null ? issue.getDefaultSeverity() : object).isError()) {
                object = this;
                int n10 = ((LintBaseline)object).foundErrorCount;
                ((LintBaseline)object).foundErrorCount = n10 + 1;
            } else {
                object = this;
                int n11 = ((LintBaseline)object).foundWarningCount;
                ((LintBaseline)object).foundWarningCount = n11 + 1;
            }
            return true;
        }
        return false;
    }

    public final boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"new");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        switch (issue.getId()) {
            case "InvalidPackage": {
                bl2 = LintBaseline.Companion.sameSuffixFrom("not included in", string, old);
                break;
            }
            case "IconDensities": {
                bl2 = true;
                break;
            }
            case "UselessLeaf": {
                bl2 = true;
                break;
            }
            case "ScopedStorage": {
                bl2 = LintBaseline.Companion.sameSuffixFrom("MANAGE_EXTERNAL_STORAGE", string, old);
                break;
            }
            case "SmallSp": {
                bl2 = LintBaseline.Companion.sameSuffixFrom("sp:", string, old);
                break;
            }
            case "BatteryLife": {
                String s10 = "Use of REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
                if (StringsKt.startsWith$default((String)old, (String)s10, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)string, (String)s10, (boolean)false, (int)2, null)) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                bl2 = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string, 0, 0, 12, null);
            }
        }
        return bl2;
    }

    @Nullable
    public final String getAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Map<String, String> map = this.attributes;
        return map == null ? null : map.get(name);
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Map attributes;
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map2 = this.attributes;
        if (map2 == null) {
            Map newMap2;
            LintBaseline lintBaseline = this;
            boolean bl2 = false;
            boolean bl3 = false;
            LintBaseline $this$setAttribute_u24lambda_u2d0 = lintBaseline;
            boolean bl4 = false;
            boolean bl5 = false;
            $this$setAttribute_u24lambda_u2d0.attributes = newMap2 = (Map)new LinkedHashMap();
            map = newMap2;
        } else {
            map = map2;
        }
        map2 = attributes = map;
        boolean bl6 = false;
        map2.put((String)name, (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void readBaselineFile() {
        if (!this.file.exists()) {
            return;
        }
        try {
            var1_1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
            var2_4 = false;
            var3_5 = false;
            var3_6 = null;
            try {
                reader = (BufferedReader)var1_1;
                $i$a$-use-LintBaseline$readBaselineFile$1 = false;
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput((Reader)reader);
                issue = null;
                message = null;
                path = null;
                currentEntry = null;
                while (parser.next() != 1) {
                    eventType = parser.getEventType();
                    if (eventType == 3) {
                        tag = parser.getName();
                        if (Intrinsics.areEqual((Object)tag, (Object)"location")) {
                            if (issue != null && message != null && path != null) {
                                entry = new Entry(issue, message, path);
                                if (currentEntry != null) {
                                    currentEntry.setNext(entry);
                                }
                                entry.setPrevious(currentEntry);
                                currentEntry = entry;
                                this.messageToEntry.put((Object)entry.getMessage(), (Object)entry);
                                this.idToMessages.put((Object)issue, (Object)message);
                            }
                        } else if (Intrinsics.areEqual((Object)tag, (Object)"issue")) {
                            if (issue != null && !this.ignored(issue)) {
                                entry = this;
                                var14_22 = entry.getTotalCount();
                                entry.totalCount = var14_22 + 1;
                            }
                            issue = null;
                            message = null;
                            path = null;
                            currentEntry = null;
                        }
                    } else if (eventType != 2) continue;
                    i = 0;
                    n = parser.getAttributeCount();
                    while (i < n) {
                        name = parser.getAttributeName(i);
                        value = parser.getAttributeValue(i);
                        var16_26 = name;
                        if (var16_26 == null) ** GOTO lbl-1000
                        tmp = -1;
                        switch (var16_26.hashCode()) {
                            case 3143036: {
                                if (var16_26.equals("file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 3159: {
                                if (var16_26.equals("by")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -1268779017: {
                                if (var16_26.equals("format")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 3355: {
                                if (var16_26.equals("id")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 954925063: {
                                if (var16_26.equals("message")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 3: {
                                issue = value;
                                break;
                            }
                            case 4: {
                                v0 = message = value;
                                if (v0 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (!StringsKt.startsWith$default((String)v0, (String)"[", (boolean)false, (int)2, null)) break;
                                if (StringsKt.startsWith$default((String)message, (String)"[I18N] ", (boolean)false, (int)2, null)) {
                                    var17_27 = message;
                                    var18_28 = "[I18N] ".length();
                                    var19_29 = false;
                                    v1 = var17_27.substring(var18_28);
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.String).substring(startIndex)");
                                    message = v1;
                                    break;
                                }
                                if (!StringsKt.startsWith$default((String)message, (String)"[Accessibility] ", (boolean)false, (int)2, null)) break;
                                var17_27 = message;
                                var18_28 = "[Accessibility] ".length();
                                var19_29 = false;
                                v2 = var17_27.substring(var18_28);
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
                                message = v2;
                                break;
                            }
                            case 1: {
                                path = value;
                                break;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (parser.getDepth() != 1) break;
                                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                this.setAttribute(name, value);
                            }
                            case 2: 
                        }
                        var16_25 = i;
                        i = var16_25 + 1;
                    }
                }
                var4_7 = Unit.INSTANCE;
            }
            catch (Throwable var4_8) {
                var3_6 = var4_8;
                throw var4_8;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var1_1, (Throwable)var3_6);
            }
        }
        catch (IOException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
            } else {
                e.printStackTrace();
            }
        }
        catch (XmlPullParserException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void close() {
        if (this.writeOnClose) {
            boolean mkdirs2;
            File parentFile = this.file.getParentFile();
            if (parentFile != null && !parentFile.exists() && !(mkdirs2 = parentFile.mkdirs())) {
                LintClient lintClient = this.client;
                if (lintClient == null) {
                    Intrinsics.throwNpe();
                }
                Object[] objectArray = new Object[]{parentFile};
                lintClient.log(null, "Couldn't create %1$s", objectArray);
                return;
            }
            try {
                Closeable mkdirs2 = new BufferedWriter(new FileWriter(this.file));
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    int n10;
                    String string;
                    Object object;
                    String revision;
                    BufferedWriter writer = (BufferedWriter)mkdirs2;
                    boolean bl4 = false;
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    writer.write("<");
                    writer.write("issues");
                    writer.write(" format=\"5\"");
                    LintClient lintClient = this.client;
                    if (lintClient == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((revision = lintClient.getClientDisplayRevision()) != null) {
                        object = StringCompanionObject.INSTANCE;
                        string = " by=\"lint %1$s\"";
                        Object[] objectArray = new Object[]{revision};
                        n10 = 0;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        writer.write(string2);
                    }
                    if ((object = this.attributes) != null) {
                        void $this$forEach$iv;
                        string = object;
                        boolean bl5 = false;
                        n10 = 0;
                        String map = string;
                        boolean bl6 = false;
                        Sequence $this$sortedBy$iv = MapsKt.asSequence((Map)((Object)map));
                        boolean $i$f$sortedBy = false;
                        boolean bl7 = false;
                        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a10, T b10) {
                                boolean bl2 = false;
                                Map.Entry it2 = (Map.Entry)a10;
                                boolean bl3 = false;
                                Comparable comparable = (Comparable)((Object)((String)it2.getKey()));
                                it2 = (Map.Entry)b10;
                                Comparable comparable2 = comparable;
                                bl3 = false;
                                String string = (String)it2.getKey();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry it2 = (Map.Entry)element$iv;
                            boolean bl8 = false;
                            writer.write(' ' + (String)it2.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it2.getValue())) + '\"');
                        }
                    }
                    writer.write(">\n");
                    this.totalCount = 0;
                    if (this.entriesToWrite != null) {
                        List<ReportedEntry> list2 = this.entriesToWrite;
                        if (list2 == null) {
                            Intrinsics.throwNpe();
                        }
                        CollectionsKt.sort(list2);
                        List<ReportedEntry> list3 = this.entriesToWrite;
                        if (list3 == null) {
                            Intrinsics.throwNpe();
                        }
                        for (ReportedEntry entry : list3) {
                            entry.write(writer, this.client);
                            LintBaseline lintBaseline = this;
                            n10 = lintBaseline.getTotalCount();
                            lintBaseline.totalCount = n10 + 1;
                        }
                    }
                    writer.write("\n</");
                    writer.write("issues");
                    writer.write(">\n");
                    writer.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)mkdirs2, (Throwable)throwable);
                }
            }
            catch (IOException ioe) {
                LintClient lintClient = this.client;
                if (lintClient == null) {
                    Intrinsics.throwNpe();
                }
                lintClient.log(ioe, null, new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "(Lcom/android/tools/lint/detector/api/Location;)V", "column", "", "getColumn", "()I", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "line", "getLine", "secondary", "getSecondary", "()Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "android.sdktools.lint-api"})
    private static final class LightLocation {
        @NotNull
        private final File file;
        private final int line;
        private final int column;
        @Nullable
        private final LightLocation secondary;

        /*
         * WARNING - void declaration
         */
        public LightLocation(@NotNull Location location) {
            LightLocation lightLocation;
            int n10;
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            this.file = location.getFile();
            Object object = location.getStart();
            this.line = object == null ? -1 : (n10 = ((Position)object).getLine());
            object = location.getStart();
            this.column = object == null ? -1 : (n10 = ((Position)object).getColumn());
            LightLocation lightLocation2 = this;
            object = location.getSecondary();
            if (object == null) {
                lightLocation = null;
            } else {
                void it2;
                Object object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Object object3 = object2;
                LightLocation lightLocation3 = lightLocation2;
                boolean bl4 = false;
                LightLocation lightLocation4 = new LightLocation((Location)it2);
                lightLocation2 = lightLocation3;
                lightLocation = lightLocation4;
            }
            lightLocation2.secondary = lightLocation;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        @Nullable
        public final LightLocation getSecondary() {
            return this.secondary;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "getLocation", "()Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "getMessage", "()Ljava/lang/String;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "compareTo", "", "other", "write", "", "writer", "Ljava/io/Writer;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "android.sdktools.lint-api"})
    private static final class ReportedEntry
    implements Comparable<ReportedEntry> {
        @NotNull
        private final Issue issue;
        @Nullable
        private final Project project;
        @NotNull
        private final String message;
        @NotNull
        private final LightLocation location;

        public ReportedEntry(@NotNull Issue issue, @Nullable Project project, @NotNull Location location, @NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.issue = issue;
            this.project = project;
            this.message = message2;
            this.location = new LightLocation(location);
        }

        @NotNull
        public final Issue getIssue() {
            return this.issue;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final LightLocation getLocation() {
            return this.location;
        }

        @Override
        public int compareTo(@NotNull ReportedEntry other) {
            File secondaryFile2;
            LightLocation secondary2;
            int otherLine;
            String id2;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
            if (categoryDelta != 0) {
                return categoryDelta;
            }
            int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
            if (priorityDelta != 0) {
                return priorityDelta;
            }
            String id1 = this.issue.getId();
            int idDelta = id1.compareTo(id2 = other.issue.getId());
            if (idDelta != 0) {
                return idDelta;
            }
            File file = this.location.getFile();
            File otherFile = other.location.getFile();
            String string = file.getName();
            String string2 = otherFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"otherFile.name");
            int fileDelta = string.compareTo(string2);
            if (fileDelta != 0) {
                return fileDelta;
            }
            int line = this.location.getLine();
            if (line != (otherLine = other.location.getLine())) {
                return line - otherLine;
            }
            int delta = this.message.compareTo(other.message);
            if (delta != 0) {
                return delta;
            }
            delta = file.compareTo(otherFile);
            if (delta != 0) {
                return delta;
            }
            LightLocation secondary1 = this.location.getSecondary();
            LightLocation lightLocation = secondary1;
            File secondaryFile1 = lightLocation == null ? null : lightLocation.getFile();
            LightLocation lightLocation2 = secondary2 = other.location.getSecondary();
            File file2 = secondaryFile2 = lightLocation2 == null ? null : lightLocation2.getFile();
            if (secondaryFile1 != null) {
                return secondaryFile2 != null ? secondaryFile1.compareTo(secondaryFile2) : -1;
            }
            if (secondaryFile2 != null) {
                return 1;
            }
            if (line != -1 && otherLine != -1 && (delta = this.location.getColumn() - other.location.getColumn()) != 0) {
                return delta;
            }
            return 0;
        }

        public final void write(@NotNull Writer writer, @NotNull LintClient client) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            try {
                writer.write("\n");
                Companion.indent(writer, 1);
                writer.write("<");
                writer.write("issue");
                Companion.writeAttribute(writer, 2, "id", this.issue.getId());
                Companion.writeAttribute(writer, 2, "message", this.message);
                writer.write(">\n");
                for (LightLocation currentLocation = this.location; currentLocation != null; currentLocation = currentLocation.getSecondary()) {
                    Companion.indent(writer, 2);
                    writer.write("<");
                    writer.write("location");
                    String path2 = Companion.getDisplayPath(client, this.project, currentLocation.getFile());
                    Companion.writeAttribute(writer, 3, "file", path2);
                    int line = currentLocation.getLine();
                    if (line >= 0) {
                        Companion.writeAttribute(writer, 3, "line", String.valueOf(line + 1));
                    }
                    writer.write("/>\n");
                }
                Companion.indent(writer, 1);
                writer.write("</");
                writer.write("issue");
                writer.write(">\n");
            }
            catch (IOException ioe) {
                client.log(ioe, null, new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "", "issueId", "", "message", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssueId", "()Ljava/lang/String;", "getMessage", "next", "getNext", "()Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "setNext", "(Lcom/android/tools/lint/client/api/LintBaseline$Entry;)V", "getPath", "previous", "getPrevious", "setPrevious", "android.sdktools.lint-api"})
    private static final class Entry {
        @NotNull
        private final String issueId;
        @NotNull
        private final String message;
        @NotNull
        private final String path;
        @Nullable
        private Entry next;
        @Nullable
        private Entry previous;

        public Entry(@NotNull String issueId, @NotNull String message2, @NotNull String path2) {
            Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
            this.issueId = issueId;
            this.message = message2;
            this.path = path2;
        }

        @NotNull
        public final String getIssueId() {
            return this.issueId;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @Nullable
        public final Entry getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Entry entry) {
            this.previous = entry;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J \u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J*\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020\bJ(\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Companion;", "", "()V", "VARIANT_ALL", "", "VARIANT_FATAL", "describeBaselineFilter", "errors", "", "warnings", "baselineDisplayPath", "getDisplayPath", "client", "Lcom/android/tools/lint/client/api/LintClient;", "project", "Lcom/android/tools/lint/detector/api/Project;", "file", "Ljava/io/File;", "indent", "", "writer", "Ljava/io/Writer;", "isFilteredMessage", "", "errorMessage", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "isFixedMessage", "isSamePathSuffix", "path", "suffix", "sameSuffixFrom", "target", "new", "old", "stringsEquivalent", "s1", "s2", "start1", "start2", "writeAttribute", "name", "value", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFilteredMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"filtered out because", (boolean)false, (int)2, null);
        }

        public final boolean isFixedMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"perhaps they have been fixed", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String describeBaselineFilter(int errors, int warnings, @NotNull String baselineDisplayPath) {
            Intrinsics.checkParameterIsNotNull((Object)baselineDisplayPath, (String)"baselineDisplayPath");
            String counts = Lint.describeCounts(errors, warnings, false, true);
            return errors + warnings == 1 ? counts + " was filtered out because it is listed in the baseline file, " + baselineDisplayPath + '\n' : counts + " were filtered out because they are listed in the baseline file, " + baselineDisplayPath + '\n';
        }

        public final boolean isSamePathSuffix(@NotNull String path2, @NotNull String suffix) {
            char c10;
            Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
            int i10 = path2.length() - 1;
            int j10 = suffix.length() - 1;
            int begin = 0;
            while (begin < j10 && ((c10 = suffix.charAt(begin)) == '.' || c10 == '/' || c10 == '\\')) {
                int n10 = begin;
                begin = n10 + 1;
            }
            if (j10 - begin > i10) {
                return false;
            }
            while (j10 > begin) {
                int c22;
                int c12 = path2.charAt(i10);
                if (c12 != (c22 = suffix.charAt(j10))) {
                    if (c12 == 92) {
                        c12 = 47;
                    }
                    if (c22 == 92) {
                        c22 = 47;
                    }
                    if (c12 != c22) {
                        return false;
                    }
                }
                int n11 = i10;
                i10 = n11 + -1;
                n11 = j10;
                j10 = n11 + -1;
            }
            return true;
        }

        private final String getDisplayPath(LintClient client, Project project, File file) {
            String path2 = file.getPath();
            if (project == null) {
                String string = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                return string;
            }
            String string = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            String string2 = string;
            string = project.getReferenceDir().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.referenceDir.path");
            if (StringsKt.startsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) {
                int chop = project.getReferenceDir().getPath().length();
                if (path2.length() > chop && path2.charAt(chop) == File.separatorChar) {
                    int n10 = chop;
                    chop = n10 + 1;
                }
                CharSequence charSequence = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"path");
                boolean bl2 = false;
                String string3 = ((String)charSequence).substring(chop);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                path2 = string3;
                charSequence = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"path");
                charSequence = charSequence;
                bl2 = false;
                if (charSequence.length() == 0) {
                    path2 = file.getName();
                }
            } else if (file.isAbsolute() && file.exists()) {
                string = client.getRelativePath(project.getReferenceDir(), file);
                path2 = string == null ? file.getPath() : string;
            }
            String string4 = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"path");
            return string4;
        }

        private final boolean sameSuffixFrom(String target2, String string, String old) {
            int i12 = StringsKt.indexOf$default((CharSequence)string, (String)target2, (int)0, (boolean)false, (int)6, null);
            int i22 = StringsKt.indexOf$default((CharSequence)old, (String)target2, (int)0, (boolean)false, (int)6, null);
            return i12 != -1 && i22 != -1 && this.stringsEquivalent(string, old, i12 + target2.length(), i22 + target2.length());
        }

        public final boolean stringsEquivalent(@NotNull String s12, @NotNull String s22, int start1, int start2) {
            Intrinsics.checkParameterIsNotNull((Object)s12, (String)"s1");
            Intrinsics.checkParameterIsNotNull((Object)s22, (String)"s2");
            int i12 = start1;
            int i22 = start2;
            int n12 = s12.length();
            int n22 = s22.length();
            if (start1 == n12 || start2 == n22) {
                return true;
            }
            while (true) {
                int n10;
                char c22;
                char c12;
                if ((c12 = s12.charAt(i12)) != (c22 = s22.charAt(i22))) {
                    while (i12 < n12 && s12.charAt(i12) == '`') {
                        n10 = i12;
                        i12 = n10 + 1;
                    }
                    while (i22 < n22 && s22.charAt(i22) == '`') {
                        n10 = i22;
                        i22 = n10 + 1;
                    }
                    if (i12 == n12 || i22 == n22) {
                        return true;
                    }
                    if (s12.charAt(i12) != s22.charAt(i22)) {
                        int http = StringsKt.lastIndexOf$default((CharSequence)s12, (String)"http", (int)i12, (boolean)false, (int)4, null);
                        if (http != -1) {
                            int blank1 = StringsKt.indexOf$default((CharSequence)s12, (char)' ', (int)http, (boolean)false, (int)4, null);
                            int blank2 = StringsKt.indexOf$default((CharSequence)s22, (char)' ', (int)http, (boolean)false, (int)4, null);
                            if (blank1 == -1 || blank2 == -1) {
                                return true;
                            }
                            if (i12 < blank1) {
                                i12 = blank1;
                                i22 = blank2;
                                continue;
                            }
                        }
                        return false;
                    }
                }
                n10 = i12;
                i12 = n10 + 1;
                n10 = i22;
                i22 = n10 + 1;
                if (i12 == n12 || i22 == n22) break;
            }
            return true;
        }

        public static /* synthetic */ boolean stringsEquivalent$default(Companion companion, String string, String string2, int n10, int n11, int n12, Object object) {
            if ((n12 & 4) != 0) {
                n10 = 0;
            }
            if ((n12 & 8) != 0) {
                n11 = 0;
            }
            return companion.stringsEquivalent(string, string2, n10, n11);
        }

        private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
            writer.write("\n");
            this.indent(writer, indent);
            writer.write(name);
            writer.write("=\"");
            writer.write(XmlUtils.toXmlAttributeValue((String)value));
            writer.write("\"");
        }

        private final void indent(Writer writer, int indent) throws IOException {
            int n10 = 0;
            if (n10 < indent) {
                do {
                    int level = n10++;
                    writer.write("    ");
                } while (n10 < indent);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

