/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightFieldForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightMethodForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightPsiLiteral;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryExpressionWithTypeKind;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinStringTemplateUPolyadicExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ConstantEvaluator {
    private static final int LARGEST_LITERAL_ARRAY = 12;
    private boolean allowUnknown;
    private boolean allowFieldInitializers;

    public ConstantEvaluator allowUnknowns() {
        this.allowUnknown = true;
        return this;
    }

    public ConstantEvaluator allowFieldInitializers() {
        this.allowFieldInitializers = true;
        return this;
    }

    public Object evaluate(UElement node) {
        Object evaluated;
        UIfExpression expression;
        if (node == null) {
            return null;
        }
        if (node instanceof ULiteralExpression) {
            return ((ULiteralExpression)node).getValue();
        }
        if (node instanceof UPrefixExpression) {
            UastPrefixOperator operator = ((UPrefixExpression)node).getOperator();
            Object operand = this.evaluate((UElement)((UPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == UastPrefixOperator.LOGICAL_NOT) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == UastPrefixOperator.UNARY_PLUS) {
                    return operand;
                }
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof UIfExpression && ((UIfExpression)node).getExpressionType() != null) {
            expression = (UIfExpression)node;
            Object known = this.evaluate((UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((UElement)expression.getElseExpression());
            }
        } else {
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression2 = parenthesizedExpression.getExpression();
                return this.evaluate((UElement)expression2);
            }
            if (node instanceof UPolyadicExpression) {
                UPolyadicExpression polyadicExpression = (UPolyadicExpression)node;
                UastBinaryOperator operator = polyadicExpression.getOperator();
                List operands = polyadicExpression.getOperands();
                if (operands.isEmpty() && node instanceof KotlinStringTemplateUPolyadicExpression) {
                    return "";
                }
                assert (!operands.isEmpty());
                Object result2 = this.evaluate((UElement)operands.get(0));
                int n10 = operands.size();
                for (int i10 = 1; i10 < n10; ++i10) {
                    Object rhs = this.evaluate((UElement)operands.get(i10));
                    result2 = this.evaluateBinary(operator, result2, rhs);
                }
                if (result2 != null) {
                    return result2;
                }
            } else {
                Object array;
                Object indexValue;
                List indices;
                UCallExpression call;
                if (node instanceof UBinaryExpressionWithType && ((UBinaryExpressionWithType)node).getOperationKind() == UastBinaryExpressionWithTypeKind.TYPE_CAST) {
                    UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
                    Object operandValue = this.evaluate((UElement)cast.getOperand());
                    if (operandValue instanceof Number) {
                        Number number = (Number)operandValue;
                        PsiType type = cast.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                    return operandValue;
                }
                if (node instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)node).resolve();
                    if (resolved instanceof PsiVariable) {
                        if (resolved instanceof PsiField) {
                            Object fieldValue;
                            PsiField field = (PsiField)resolved;
                            if ("length".equals(field.getName()) && node instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)node).getReceiver().getExpressionType() instanceof PsiArrayType) {
                                Object array2 = this.evaluate((UElement)((UQualifiedReferenceExpression)node).getReceiver());
                                int size = ConstantEvaluator.getArraySize(array2);
                                if (size != -1) {
                                    return size;
                                }
                                return null;
                            }
                            Object value = field.computeConstantValue();
                            if (value != null) {
                                return value;
                            }
                            if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                                if (ConstantEvaluator.surroundedByVariableCheck(node, (PsiVariable)field)) {
                                    return null;
                                }
                                return value;
                            }
                            if (field instanceof KtUltraLightFieldForSourceDeclaration && (fieldValue = this.evaluate((PsiElement)field)) != null) {
                                return fieldValue;
                            }
                            return null;
                        }
                        PsiVariable variable = (PsiVariable)resolved;
                        Object value = UastLintUtils.findLastValue(variable, node, this);
                        if (value == LastAssignmentFinder.LAST_ASSIGNMENT_VALUE_UNKNOWN) {
                            return null;
                        }
                        if (value != null) {
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return value;
                        }
                        if (variable.getInitializer() != null) {
                            Object initializedValue = this.evaluate((PsiElement)variable.getInitializer());
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return initializedValue;
                        }
                        return null;
                    }
                    if (node instanceof UQualifiedReferenceExpression) {
                        USimpleNameReferenceExpression name;
                        UQualifiedReferenceExpression expression3 = (UQualifiedReferenceExpression)node;
                        UExpression selector = expression3.getSelector();
                        UExpression receiver = expression3.getReceiver();
                        if (receiver instanceof USimpleNameReferenceExpression && (name = (USimpleNameReferenceExpression)receiver).getIdentifier().equals("kotlin")) {
                            return this.evaluate((UElement)selector);
                        }
                        if (selector instanceof USimpleNameReferenceExpression) {
                            UCallExpression receiverCall;
                            String name2;
                            UQualifiedReferenceExpression expression1;
                            USimpleNameReferenceExpression nameReferenceExpression = (USimpleNameReferenceExpression)selector;
                            String identifier = nameReferenceExpression.getIdentifier();
                            if (receiver instanceof UQualifiedReferenceExpression && (expression1 = (UQualifiedReferenceExpression)receiver).getReceiver() instanceof USimpleNameReferenceExpression && ((USimpleNameReferenceExpression)expression1.getReceiver()).getIdentifier().equals("kotlin")) {
                                receiver = expression1.getSelector();
                            }
                            if ("size".equals(identifier) && receiver instanceof UCallExpression && (name2 = Lint.getMethodName(receiverCall = (UCallExpression)receiver)) != null) {
                                int size;
                                if (name2.endsWith("Array") && (name2.equals("Array") || ConstantEvaluator.getKotlinPrimitiveArrayType(name2) != null)) {
                                    size = this.getKotlinArrayConstructionSize(receiverCall);
                                    if (size != -1) {
                                        return size;
                                    }
                                } else {
                                    if (name2.endsWith("rrayOf") && (name2.equals("arrayOf") || ConstantEvaluator.getKotlinPrimitiveArrayType(name2) != null)) {
                                        return receiverCall.getValueArgumentCount();
                                    }
                                    if ("arrayOfNulls".equals(name2) && (size = this.getKotlinArrayConstructionSize(receiverCall)) != -1) {
                                        return size;
                                    }
                                }
                            }
                        }
                        if (receiver != null && selector instanceof UCallExpression) {
                            List arguments;
                            Object s10;
                            UCallExpression call2 = (UCallExpression)selector;
                            String methodName = call2.getMethodName();
                            if ("trimIndent".equals(methodName)) {
                                s10 = this.evaluate((UElement)receiver);
                                if (s10 instanceof String) {
                                    return StringsKt.trimIndent((String)((String)s10));
                                }
                            } else if ("trimMargin".equals(methodName)) {
                                s10 = this.evaluate((UElement)receiver);
                                if (s10 instanceof String) {
                                    Object arg;
                                    String prefix = "|";
                                    List valueArguments = call2.getValueArguments();
                                    if (valueArguments.size() == 1 && (arg = this.evaluate((UElement)valueArguments.get(0))) != null) {
                                        prefix = arg.toString();
                                    }
                                    return StringsKt.trimMargin((String)((String)s10), (String)prefix);
                                }
                            } else if (this.allowUnknown && "format".equals(methodName) && (arguments = call2.getValueArguments()).size() >= 2) {
                                UExpression first = (UExpression)arguments.get(0);
                                UExpression second = (UExpression)arguments.get(1);
                                PsiType expressionType = first.getExpressionType();
                                if (expressionType != null && "java.util.Locale".equals(expressionType.getCanonicalText())) {
                                    return this.evaluate((UElement)second);
                                }
                                return this.evaluate((UElement)first);
                            }
                        }
                    }
                } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                    Object lengthObj;
                    PsiType type;
                    call = (UCallExpression)node;
                    PsiType arrayType = call.getExpressionType();
                    if (arrayType instanceof PsiArrayType && !((type = arrayType.getDeepComponentType()) instanceof PsiArrayType) && call.getValueArgumentCount() == 1 && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
                        int size = ((Number)lengthObj).intValue();
                        int dimensions = arrayType.getArrayDimensions();
                        return ConstantEvaluator.getArray(type, size, dimensions);
                    }
                } else if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                    Object array3 = this.createInitializedArray((UCallExpression)node);
                    if (array3 != null) {
                        return array3;
                    }
                } else if (node instanceof UCallExpression) {
                    call = (UCallExpression)node;
                    String name = Lint.getMethodName(call);
                    if (name != null) {
                        int size;
                        PsiType type;
                        if (name.endsWith("Array") && UastExpressionUtils.isConstructorCall((UElement)call)) {
                            int size2 = this.getKotlinArrayConstructionSize(call);
                            if (size2 != -1) {
                                if (name.equals("Array")) {
                                    PsiType type2 = call.getExpressionType();
                                    if (type2 instanceof PsiArrayType) {
                                        int dimensions = type2.getArrayDimensions();
                                        PsiType componentType = type2.getDeepComponentType();
                                        return ConstantEvaluator.getArray(componentType, size2, dimensions);
                                    }
                                } else {
                                    PsiType type3 = ConstantEvaluator.getKotlinPrimitiveArrayType(name);
                                    if (type3 != null) {
                                        int dimensions = 1;
                                        return ConstantEvaluator.getArray(type3, size2, dimensions);
                                    }
                                }
                            }
                        } else if ("arrayOf".equals(name) || name.endsWith("ArrayOf") && ConstantEvaluator.getKotlinPrimitiveArrayType(name) != null) {
                            Object array4 = this.createInitializedArray(call);
                            if (array4 != null) {
                                return array4;
                            }
                        } else if ("arrayOfNulls".equals(name) && (type = call.getExpressionType()) instanceof PsiArrayType && (size = this.getKotlinArrayConstructionSize(call)) != -1) {
                            int dimensions = type.getArrayDimensions();
                            PsiType componentType = type.getDeepComponentType();
                            return ConstantEvaluator.getArray(componentType, size, dimensions);
                        }
                    }
                } else if (node instanceof UArrayAccessExpression && (indices = (expression = (UArrayAccessExpression)node).getIndices()).size() == 1 && (indexValue = this.evaluate((UElement)indices.get(0))) instanceof Number && (array = this.evaluate((UElement)expression.getReceiver())) != null) {
                    int index = ((Number)indexValue).intValue();
                    if (array instanceof Object[]) {
                        Object[] objArray = (Object[])array;
                        if (index >= 0 && index < objArray.length) {
                            return objArray[index];
                        }
                    } else if (array instanceof int[]) {
                        int[] intArray = (int[])array;
                        if (index >= 0 && index < intArray.length) {
                            return intArray[index];
                        }
                    } else if (array instanceof boolean[]) {
                        boolean[] booleanArray = (boolean[])array;
                        if (index >= 0 && index < booleanArray.length) {
                            return booleanArray[index];
                        }
                    } else if (array instanceof char[]) {
                        char[] charArray = (char[])array;
                        if (index >= 0 && index < charArray.length) {
                            return Character.valueOf(charArray[index]);
                        }
                    } else if (array instanceof long[]) {
                        long[] longArray = (long[])array;
                        if (index >= 0 && index < longArray.length) {
                            return longArray[index];
                        }
                    } else if (array instanceof float[]) {
                        float[] floatArray = (float[])array;
                        if (index >= 0 && index < floatArray.length) {
                            return Float.valueOf(floatArray[index]);
                        }
                    } else if (array instanceof double[]) {
                        double[] doubleArray = (double[])array;
                        if (index >= 0 && index < doubleArray.length) {
                            return doubleArray[index];
                        }
                    } else if (array instanceof byte[]) {
                        byte[] byteArray = (byte[])array;
                        if (index >= 0 && index < byteArray.length) {
                            return byteArray[index];
                        }
                    } else if (array instanceof short[]) {
                        short[] shortArray = (short[])array;
                        if (index >= 0 && index < shortArray.length) {
                            return shortArray[index];
                        }
                    }
                }
            }
        }
        if (node instanceof UExpression && (evaluated = ((UExpression)node).evaluate()) != null) {
            return evaluated;
        }
        return null;
    }

    private Object createInitializedArray(UCallExpression call) {
        PsiType componentType;
        PsiType arrayType = call.getExpressionType();
        if (arrayType instanceof PsiArrayType && !((componentType = arrayType.getDeepComponentType()) instanceof PsiArrayType)) {
            Object[] arr;
            int length = call.getValueArgumentCount();
            ArrayList<Object> evaluatedArgs = new ArrayList<Object>(length);
            int count = 0;
            for (UExpression arg : call.getValueArguments()) {
                Object object = this.evaluate((UElement)arg);
                if (!this.allowUnknown && object == null) {
                    return null;
                }
                evaluatedArgs.add(object);
                if (++count != 40) continue;
                return ConstantEvaluator.getArray(componentType, length, 1);
            }
            if (componentType == PsiType.BOOLEAN) {
                arr = new boolean[length];
                for (int i10 = 0; i10 < length; ++i10) {
                    Object e10 = evaluatedArgs.get(i10);
                    if (!(e10 instanceof Boolean)) continue;
                    arr[i10] = (Boolean)e10;
                }
                return arr;
            }
            if (ConstantEvaluator.isObjectType(componentType)) {
                arr = new Object[length];
                for (int i11 = 0; i11 < length; ++i11) {
                    arr[i11] = evaluatedArgs.get(i11);
                }
                return arr;
            }
            if (componentType.equals(PsiType.CHAR)) {
                arr = new char[length];
                for (int i12 = 0; i12 < length; ++i12) {
                    Object e11 = evaluatedArgs.get(i12);
                    if (!(e11 instanceof Character)) continue;
                    arr[i12] = ((Character)e11).charValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.BYTE)) {
                arr = new byte[length];
                for (int i13 = 0; i13 < length; ++i13) {
                    Object e12 = evaluatedArgs.get(i13);
                    if (!(e12 instanceof Byte)) continue;
                    arr[i13] = (Byte)e12;
                }
                return arr;
            }
            if (componentType.equals(PsiType.DOUBLE)) {
                arr = new double[length];
                for (int i14 = 0; i14 < length; ++i14) {
                    Object e13 = evaluatedArgs.get(i14);
                    if (!(e13 instanceof Double)) continue;
                    arr[i14] = ((Double)e13).doubleValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.FLOAT)) {
                arr = new float[length];
                for (int i15 = 0; i15 < length; ++i15) {
                    Object e14 = evaluatedArgs.get(i15);
                    if (!(e14 instanceof Float)) continue;
                    arr[i15] = ((Float)e14).floatValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.INT)) {
                arr = new int[length];
                for (int i16 = 0; i16 < length; ++i16) {
                    Object e15 = evaluatedArgs.get(i16);
                    if (!(e15 instanceof Integer)) continue;
                    arr[i16] = (Integer)e15;
                }
                return arr;
            }
            if (componentType.equals(PsiType.SHORT)) {
                arr = new short[length];
                for (int i17 = 0; i17 < length; ++i17) {
                    Object e16 = evaluatedArgs.get(i17);
                    if (!(e16 instanceof Short)) continue;
                    arr[i17] = (Short)e16;
                }
                return arr;
            }
            if (componentType.equals(PsiType.LONG)) {
                arr = new long[length];
                for (int i18 = 0; i18 < length; ++i18) {
                    Object e17 = evaluatedArgs.get(i18);
                    if (!(e17 instanceof Long)) continue;
                    arr[i18] = ((Long)e17).longValue();
                }
                return arr;
            }
            if (ConstantEvaluator.isStringType(componentType)) {
                arr = new String[length];
                for (int i19 = 0; i19 < length; ++i19) {
                    Object e18 = evaluatedArgs.get(i19);
                    if (!(e18 instanceof String)) continue;
                    arr[i19] = (String)e18;
                }
                return arr;
            }
            if (!evaluatedArgs.isEmpty()) {
                Object first = evaluatedArgs.get(0);
                for (Object e19 : evaluatedArgs) {
                    if (e19.getClass() == first.getClass()) continue;
                    return null;
                }
                return evaluatedArgs.toArray((Object[])Array.newInstance(first.getClass(), 0));
            }
        }
        return null;
    }

    private static PsiType getKotlinPrimitiveArrayType(String constructorName) {
        switch (constructorName) {
            case "ByteArray": 
            case "byteArrayOf": {
                return PsiPrimitiveType.BYTE;
            }
            case "CharArray": 
            case "charArrayOf": {
                return PsiPrimitiveType.CHAR;
            }
            case "ShortArray": 
            case "shortArrayOf": {
                return PsiPrimitiveType.SHORT;
            }
            case "IntArray": 
            case "intArrayOf": {
                return PsiPrimitiveType.INT;
            }
            case "LongArray": 
            case "longArrayOf": {
                return PsiPrimitiveType.LONG;
            }
            case "FloatArray": 
            case "floatArrayOf": {
                return PsiPrimitiveType.FLOAT;
            }
            case "DoubleArray": 
            case "doubleArrayOf": {
                return PsiPrimitiveType.DOUBLE;
            }
            case "BooleanArray": 
            case "booleanArrayOf": {
                return PsiPrimitiveType.BOOLEAN;
            }
        }
        return null;
    }

    private int getKotlinArrayConstructionSize(UCallExpression call) {
        Object lengthObj;
        List valueArguments = call.getValueArguments();
        if (!valueArguments.isEmpty() && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
            return ((Number)lengthObj).intValue();
        }
        return -1;
    }

    public static int getArraySize(Object array) {
        if (array instanceof ArrayReference) {
            return ((ArrayReference)array).size;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        return -1;
    }

    private Object evaluateBinary(UastBinaryOperator operator, Object operandLeft, Object operandRight) {
        if (operandLeft == null || operandRight == null) {
            if (this.allowUnknown) {
                if (operandLeft == null) {
                    return operandRight;
                }
                return operandLeft;
            }
            return null;
        }
        if (operandLeft instanceof String && (operandRight instanceof String || operandRight instanceof Character) || operandRight instanceof String && operandLeft instanceof Character) {
            if (operator == UastBinaryOperator.PLUS) {
                return operandLeft + operandRight.toString();
            }
            return null;
        }
        if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
            boolean left = (Boolean)operandLeft;
            boolean right = (Boolean)operandRight;
            if (operator == UastBinaryOperator.LOGICAL_OR) {
                return left || right;
            }
            if (operator == UastBinaryOperator.LOGICAL_AND) {
                return left && right;
            }
            if (operator == UastBinaryOperator.BITWISE_OR) {
                return left | right;
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                return left ^ right;
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                return left & right;
            }
            if (operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.EQUALS) {
                return left == right;
            }
            if (operator == UastBinaryOperator.IDENTITY_NOT_EQUALS || operator == UastBinaryOperator.NOT_EQUALS) {
                return left != right;
            }
        } else if (operandLeft instanceof Number && operandRight instanceof Number) {
            boolean isWide;
            boolean isInteger;
            Number left = (Number)operandLeft;
            Number right = (Number)operandRight;
            boolean bl2 = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
            boolean bl3 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
            if (operator == UastBinaryOperator.BITWISE_OR) {
                if (isWide) {
                    return left.longValue() | right.longValue();
                }
                return left.intValue() | right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                if (isWide) {
                    return left.longValue() ^ right.longValue();
                }
                return left.intValue() ^ right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                if (isWide) {
                    return left.longValue() & right.longValue();
                }
                return left.intValue() & right.intValue();
            }
            if (operator == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.IDENTITY_EQUALS) {
                if (isInteger) {
                    return left.longValue() == right.longValue();
                }
                return left.doubleValue() == right.doubleValue();
            }
            if (operator == UastBinaryOperator.NOT_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                if (isInteger) {
                    return left.longValue() != right.longValue();
                }
                return left.doubleValue() != right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER) {
                if (isInteger) {
                    return left.longValue() > right.longValue();
                }
                return left.doubleValue() > right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() >= right.longValue();
                }
                return left.doubleValue() >= right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS) {
                if (isInteger) {
                    return left.longValue() < right.longValue();
                }
                return left.doubleValue() < right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() <= right.longValue();
                }
                return left.doubleValue() <= right.doubleValue();
            }
            if (operator == UastBinaryOperator.SHIFT_LEFT) {
                if (isWide) {
                    return left.longValue() << right.intValue();
                }
                return left.intValue() << right.intValue();
            }
            if (operator == UastBinaryOperator.SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >> right.intValue();
                }
                return left.intValue() >> right.intValue();
            }
            if (operator == UastBinaryOperator.UNSIGNED_SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >>> right.intValue();
                }
                return left.intValue() >>> right.intValue();
            }
            if (operator == UastBinaryOperator.PLUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() + right.longValue();
                    }
                    return left.intValue() + right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() + right.doubleValue();
                }
                return Float.valueOf(left.floatValue() + right.floatValue());
            }
            if (operator == UastBinaryOperator.MINUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() - right.longValue();
                    }
                    return left.intValue() - right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() - right.doubleValue();
                }
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            if (operator == UastBinaryOperator.MULTIPLY) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() * right.longValue();
                    }
                    return left.intValue() * right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() * right.doubleValue();
                }
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            if (operator == UastBinaryOperator.DIV) {
                if (isInteger) {
                    if (right.longValue() == 0L) {
                        return null;
                    }
                    if (isWide) {
                        return left.longValue() / right.longValue();
                    }
                    return left.intValue() / right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() / right.doubleValue();
                }
                return Float.valueOf(left.floatValue() / right.floatValue());
            }
            if (operator == UastBinaryOperator.MOD) {
                if (isInteger) {
                    if (right.longValue() == 0L) {
                        return null;
                    }
                    if (isWide) {
                        return left.longValue() % right.longValue();
                    }
                    return left.intValue() % right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() % right.doubleValue();
                }
                return Float.valueOf(left.floatValue() % right.floatValue());
            }
            return null;
        }
        return null;
    }

    private static boolean surroundedByVariableCheck(UElement node, PsiVariable variable) {
        if (node == null) {
            return false;
        }
        UIfExpression curr = (UIfExpression)UastUtils.getParentOfType((UElement)node, UIfExpression.class);
        while (curr != null) {
            UExpression condition;
            if (ConstantEvaluator.references(curr.getCondition(), variable) && !UastUtils.isUastChildOf((UElement)node, (UElement)(condition = curr.getCondition()), (boolean)false)) {
                return true;
            }
            curr = (UIfExpression)UastUtils.getParentOfType((UElement)curr, UIfExpression.class);
        }
        return false;
    }

    private static boolean isStringType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.String".equals(resolvedClass.getQualifiedName());
    }

    private static boolean isObjectType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }

    /*
     * WARNING - void declaration
     */
    public Object evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PsiLiteral) {
            KtExpression origin;
            UExpression uastExpression;
            Object value = ((PsiLiteral)node).getValue();
            if (value == null && node instanceof KtLightPsiLiteral && (uastExpression = (UExpression)UastFacade.INSTANCE.convertElement((PsiElement)(origin = ((KtLightPsiLiteral)node).getKotlinOrigin()), null, UExpression.class)) != null) {
                value = uastExpression.evaluate();
            }
            return value;
        }
        if (node instanceof PsiPrefixExpression) {
            IElementType operator = ((PsiPrefixExpression)node).getOperationTokenType();
            Object operand = this.evaluate((PsiElement)((PsiPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == JavaTokenType.EXCL) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == JavaTokenType.PLUS) {
                    return operand;
                }
                if (operator == JavaTokenType.TILDE) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == JavaTokenType.MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)node;
            Object known = this.evaluate((PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((PsiElement)expression.getElseExpression());
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return this.evaluate((PsiElement)expression);
            }
        } else if (node instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)node;
            IElementType operator = expression.getOperationTokenType();
            Object operandLeft = this.evaluate((PsiElement)expression.getLOperand());
            Object operandRight = this.evaluate((PsiElement)expression.getROperand());
            if (operandLeft == null || operandRight == null) {
                if (this.allowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && (operandRight instanceof String || operandRight instanceof Character) || operandRight instanceof String && operandLeft instanceof Character) {
                if (operator == JavaTokenType.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                if (operator == JavaTokenType.OROR) {
                    return left || right;
                }
                if (operator == JavaTokenType.ANDAND) {
                    return left && right;
                }
                if (operator == JavaTokenType.OR) {
                    return left | right;
                }
                if (operator == JavaTokenType.XOR) {
                    return left ^ right;
                }
                if (operator == JavaTokenType.AND) {
                    return left & right;
                }
                if (operator == JavaTokenType.EQEQ) {
                    return left == right;
                }
                if (operator == JavaTokenType.NE) {
                    return left != right;
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isWide;
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl2 = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean bl3 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        return left.longValue() | right.longValue();
                    }
                    return left.intValue() | right.intValue();
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        return left.longValue() ^ right.longValue();
                    }
                    return left.intValue() ^ right.intValue();
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        return left.longValue() & right.longValue();
                    }
                    return left.intValue() & right.intValue();
                }
                if (operator == JavaTokenType.EQEQ) {
                    if (isInteger) {
                        return left.longValue() == right.longValue();
                    }
                    return left.doubleValue() == right.doubleValue();
                }
                if (operator == JavaTokenType.NE) {
                    if (isInteger) {
                        return left.longValue() != right.longValue();
                    }
                    return left.doubleValue() != right.doubleValue();
                }
                if (operator == JavaTokenType.GT) {
                    if (isInteger) {
                        return left.longValue() > right.longValue();
                    }
                    return left.doubleValue() > right.doubleValue();
                }
                if (operator == JavaTokenType.GE) {
                    if (isInteger) {
                        return left.longValue() >= right.longValue();
                    }
                    return left.doubleValue() >= right.doubleValue();
                }
                if (operator == JavaTokenType.LT) {
                    if (isInteger) {
                        return left.longValue() < right.longValue();
                    }
                    return left.doubleValue() < right.doubleValue();
                }
                if (operator == JavaTokenType.LE) {
                    if (isInteger) {
                        return left.longValue() <= right.longValue();
                    }
                    return left.doubleValue() <= right.doubleValue();
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        return left.longValue() << right.intValue();
                    }
                    return left.intValue() << right.intValue();
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        return left.longValue() >> right.intValue();
                    }
                    return left.intValue() >> right.intValue();
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        return left.longValue() >>> right.intValue();
                    }
                    return left.intValue() >>> right.intValue();
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() + right.longValue();
                        }
                        return left.intValue() + right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() + right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() + right.floatValue());
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() - right.longValue();
                        }
                        return left.intValue() - right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() - right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() - right.floatValue());
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() * right.longValue();
                        }
                        return left.intValue() * right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() * right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() * right.floatValue());
                }
                if (operator == JavaTokenType.DIV) {
                    if (isInteger) {
                        if (right.longValue() == 0L) {
                            return null;
                        }
                        if (isWide) {
                            return left.longValue() / right.longValue();
                        }
                        return left.intValue() / right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() / right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() / right.floatValue());
                }
                if (operator == JavaTokenType.PERC) {
                    if (isInteger) {
                        if (right.longValue() == 0L) {
                            return null;
                        }
                        if (isWide) {
                            return left.longValue() % right.longValue();
                        }
                        return left.intValue() % right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() % right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() % right.floatValue());
                }
                return null;
            }
        } else if (node instanceof PsiPolyadicExpression) {
            int i10;
            Object value;
            void var13_142;
            PsiPolyadicExpression expression = (PsiPolyadicExpression)node;
            IElementType operator = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            ArrayList<Object> values = new ArrayList<Object>(operands.length);
            boolean hasString = false;
            boolean hasBoolean = false;
            boolean hasNumber = false;
            boolean isFloat = false;
            boolean isWide = false;
            PsiExpression[] psiExpressionArray = operands;
            int n10 = psiExpressionArray.length;
            boolean bl4 = false;
            while (var13_142 < n10) {
                PsiExpression operand = psiExpressionArray[var13_142];
                value = this.evaluate((PsiElement)operand);
                if (value != null) {
                    values.add(value);
                    if (value instanceof String) {
                        hasString = true;
                    } else if (value instanceof Boolean) {
                        hasBoolean = true;
                    } else if (value instanceof Number) {
                        if (value instanceof Float) {
                            isFloat = true;
                        } else if (value instanceof Double) {
                            isFloat = true;
                            isWide = true;
                        } else if (value instanceof Long) {
                            isWide = true;
                        }
                        hasNumber = true;
                    }
                }
                ++var13_142;
            }
            if (values.isEmpty()) {
                return null;
            }
            if (hasString) {
                if (operator == JavaTokenType.PLUS) {
                    StringBuilder sb2 = new StringBuilder();
                    for (Object e10 : values) {
                        sb2.append(e10.toString());
                    }
                    return sb2.toString();
                }
                return null;
            }
            if (!this.allowUnknown && operands.length != values.size()) {
                return null;
            }
            if (hasBoolean) {
                if (operator == JavaTokenType.OROR) {
                    boolean result2 = false;
                    for (Object e11 : values) {
                        if (!(e11 instanceof Boolean)) continue;
                        result2 = result2 || (Boolean)e11 != false;
                    }
                    return result2;
                }
                if (operator == JavaTokenType.ANDAND) {
                    boolean result3 = true;
                    for (Object e12 : values) {
                        if (!(e12 instanceof Boolean)) continue;
                        result3 = result3 && (Boolean)e12 != false;
                    }
                    return result3;
                }
                if (operator == JavaTokenType.OR) {
                    boolean result4 = false;
                    for (Object e13 : values) {
                        if (!(e13 instanceof Boolean)) continue;
                        result4 |= ((Boolean)e13).booleanValue();
                    }
                    return result4;
                }
                if (operator == JavaTokenType.XOR) {
                    boolean result5 = false;
                    for (Object e14 : values) {
                        if (!(e14 instanceof Boolean)) continue;
                        result5 ^= ((Boolean)e14).booleanValue();
                    }
                    return result5;
                }
                if (operator == JavaTokenType.AND) {
                    boolean result6 = true;
                    for (Object e15 : values) {
                        if (!(e15 instanceof Boolean)) continue;
                        result6 &= ((Boolean)e15).booleanValue();
                    }
                    return result6;
                }
                if (operator == JavaTokenType.EQEQ) {
                    boolean result7 = false;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e16 = values.get(i10);
                        if (!(e16 instanceof Boolean)) continue;
                        boolean b10 = (Boolean)e16;
                        result7 = i10 == 0 ? b10 : result7 == b10;
                    }
                    return result7;
                }
                if (operator == JavaTokenType.NE) {
                    boolean result8 = false;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e17 = values.get(i10);
                        if (!(e17 instanceof Boolean)) continue;
                        boolean b11 = (Boolean)e17;
                        result8 = i10 == 0 ? b11 : result8 != b11;
                    }
                    return result8;
                }
                return null;
            }
            if (hasNumber) {
                int prev;
                Object value2;
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        void var13_152;
                        long result9 = 0L;
                        boolean bl5 = false;
                        while (var13_152 < values.size()) {
                            Object value10 = values.get((int)var13_152);
                            if (value10 instanceof Number) {
                                long l10 = ((Number)value10).longValue();
                                result9 = var13_152 == false ? l10 : (result9 |= l10);
                            }
                            ++var13_152;
                        }
                        return result9;
                    }
                    int result10 = 0;
                    for (int i102 = 0; i102 < values.size(); ++i102) {
                        Object e18 = values.get(i102);
                        if (!(e18 instanceof Number)) continue;
                        int l11 = ((Number)e18).intValue();
                        if (i102 == 0) {
                            result10 = l11;
                            continue;
                        }
                        result10 |= l11;
                    }
                    return result10;
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        void var13_155;
                        long result11 = 0L;
                        boolean bl6 = false;
                        while (var13_155 < values.size()) {
                            value2 = values.get((int)var13_155);
                            if (value2 instanceof Number) {
                                long l12 = ((Number)value2).longValue();
                                result11 = var13_155 == false ? l12 : (result11 ^= l12);
                            }
                            ++var13_155;
                        }
                        return result11;
                    }
                    int result12 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e19 = values.get(i10);
                        if (!(e19 instanceof Number)) continue;
                        int l13 = ((Number)e19).intValue();
                        if (i10 == 0) {
                            result12 = l13;
                            continue;
                        }
                        result12 ^= l13;
                    }
                    return result12;
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        void var13_158;
                        long result13 = 0L;
                        boolean bl7 = false;
                        while (var13_158 < values.size()) {
                            value2 = values.get((int)var13_158);
                            if (value2 instanceof Number) {
                                long l14 = ((Number)value2).longValue();
                                result13 = var13_158 == false ? l14 : (result13 &= l14);
                            }
                            ++var13_158;
                        }
                        return result13;
                    }
                    int result14 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e20 = values.get(i10);
                        if (!(e20 instanceof Number)) continue;
                        int l15 = ((Number)e20).intValue();
                        if (i10 == 0) {
                            result14 = l15;
                            continue;
                        }
                        result14 &= l15;
                    }
                    return result14;
                }
                if (operator == JavaTokenType.EQEQ) {
                    void var13_161;
                    if (isWide) {
                        boolean result15 = false;
                        long prev2 = 0L;
                        for (int i12 = 0; i12 < values.size(); ++i12) {
                            value = values.get(i12);
                            if (!(value instanceof Number)) continue;
                            long l16 = ((Number)value).longValue();
                            if (i12 != 0) {
                                result15 = prev2 == l16;
                            }
                            prev2 = l16;
                        }
                        return result15;
                    }
                    boolean result16 = false;
                    prev = 0;
                    boolean bl8 = false;
                    while (var13_161 < values.size()) {
                        value2 = values.get((int)var13_161);
                        if (value2 instanceof Number) {
                            int l17 = ((Number)value2).intValue();
                            if (var13_161 != false) {
                                result16 = prev == l17;
                            }
                            prev = l17;
                        }
                        ++var13_161;
                    }
                    return result16;
                }
                if (operator == JavaTokenType.NE) {
                    void var13_163;
                    if (isWide) {
                        boolean result17 = false;
                        long prev3 = 0L;
                        for (int i13 = 0; i13 < values.size(); ++i13) {
                            value = values.get(i13);
                            if (!(value instanceof Number)) continue;
                            long l18 = ((Number)value).longValue();
                            if (i13 != 0) {
                                result17 = prev3 != l18;
                            }
                            prev3 = l18;
                        }
                        return result17;
                    }
                    boolean result18 = false;
                    prev = 0;
                    boolean bl9 = false;
                    while (var13_163 < values.size()) {
                        value2 = values.get((int)var13_163);
                        if (value2 instanceof Number) {
                            int l19 = ((Number)value2).intValue();
                            if (var13_163 != false) {
                                result18 = prev != l19;
                            }
                            prev = l19;
                        }
                        ++var13_163;
                    }
                    return result18;
                }
                if (operator == JavaTokenType.GT) {
                    void var13_165;
                    if (isWide) {
                        boolean result19 = false;
                        long prev4 = 0L;
                        for (int i14 = 0; i14 < values.size(); ++i14) {
                            value = values.get(i14);
                            if (!(value instanceof Number)) continue;
                            long l20 = ((Number)value).longValue();
                            if (i14 != 0) {
                                result19 = prev4 > l20;
                            }
                            prev4 = l20;
                        }
                        return result19;
                    }
                    boolean result20 = false;
                    prev = 0;
                    boolean bl10 = false;
                    while (var13_165 < values.size()) {
                        value2 = values.get((int)var13_165);
                        if (value2 instanceof Number) {
                            int l21 = ((Number)value2).intValue();
                            if (var13_165 != false) {
                                result20 = prev > l21;
                            }
                            prev = l21;
                        }
                        ++var13_165;
                    }
                    return result20;
                }
                if (operator == JavaTokenType.GE) {
                    void var13_167;
                    if (isWide) {
                        boolean result21 = false;
                        long prev5 = 0L;
                        for (int i15 = 0; i15 < values.size(); ++i15) {
                            value = values.get(i15);
                            if (!(value instanceof Number)) continue;
                            long l22 = ((Number)value).longValue();
                            if (i15 != 0) {
                                result21 = prev5 >= l22;
                            }
                            prev5 = l22;
                        }
                        return result21;
                    }
                    boolean result22 = false;
                    prev = 0;
                    boolean bl11 = false;
                    while (var13_167 < values.size()) {
                        value2 = values.get((int)var13_167);
                        if (value2 instanceof Number) {
                            int l23 = ((Number)value2).intValue();
                            if (var13_167 != false) {
                                result22 = prev >= l23;
                            }
                            prev = l23;
                        }
                        ++var13_167;
                    }
                    return result22;
                }
                if (operator == JavaTokenType.LT) {
                    void var13_169;
                    if (isWide) {
                        boolean result23 = false;
                        long prev6 = 0L;
                        for (int i16 = 0; i16 < values.size(); ++i16) {
                            value = values.get(i16);
                            if (!(value instanceof Number)) continue;
                            long l24 = ((Number)value).longValue();
                            if (i16 != 0) {
                                result23 = prev6 < l24;
                            }
                            prev6 = l24;
                        }
                        return result23;
                    }
                    boolean result24 = false;
                    prev = 0;
                    boolean bl12 = false;
                    while (var13_169 < values.size()) {
                        value2 = values.get((int)var13_169);
                        if (value2 instanceof Number) {
                            int l25 = ((Number)value2).intValue();
                            if (var13_169 != false) {
                                result24 = prev < l25;
                            }
                            prev = l25;
                        }
                        ++var13_169;
                    }
                    return result24;
                }
                if (operator == JavaTokenType.LE) {
                    void var13_171;
                    if (isWide) {
                        boolean result25 = false;
                        long prev7 = 0L;
                        for (int i17 = 0; i17 < values.size(); ++i17) {
                            value = values.get(i17);
                            if (!(value instanceof Number)) continue;
                            long l26 = ((Number)value).longValue();
                            if (i17 != 0) {
                                result25 = prev7 <= l26;
                            }
                            prev7 = l26;
                        }
                        return result25;
                    }
                    boolean result26 = false;
                    prev = 0;
                    boolean bl13 = false;
                    while (var13_171 < values.size()) {
                        value2 = values.get((int)var13_171);
                        if (value2 instanceof Number) {
                            int l27 = ((Number)value2).intValue();
                            if (var13_171 != false) {
                                result26 = prev <= l27;
                            }
                            prev = l27;
                        }
                        ++var13_171;
                    }
                    return result26;
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        void var13_173;
                        long result27 = 0L;
                        boolean bl14 = false;
                        while (var13_173 < values.size()) {
                            value2 = values.get((int)var13_173);
                            if (value2 instanceof Number) {
                                long l28 = ((Number)value2).longValue();
                                result27 = var13_173 == false ? l28 : (result27 <<= (int)l28);
                            }
                            ++var13_173;
                        }
                        return result27;
                    }
                    int result28 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e21 = values.get(i10);
                        if (!(e21 instanceof Number)) continue;
                        int l29 = ((Number)e21).intValue();
                        if (i10 == 0) {
                            result28 = l29;
                            continue;
                        }
                        result28 <<= l29;
                    }
                    return result28;
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        void var13_176;
                        long result29 = 0L;
                        boolean bl15 = false;
                        while (var13_176 < values.size()) {
                            value2 = values.get((int)var13_176);
                            if (value2 instanceof Number) {
                                long l30 = ((Number)value2).longValue();
                                result29 = var13_176 == false ? l30 : (result29 >>= (int)l30);
                            }
                            ++var13_176;
                        }
                        return result29;
                    }
                    int result30 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e22 = values.get(i10);
                        if (!(e22 instanceof Number)) continue;
                        int l31 = ((Number)e22).intValue();
                        if (i10 == 0) {
                            result30 = l31;
                            continue;
                        }
                        result30 >>= l31;
                    }
                    return result30;
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        void var13_179;
                        long result31 = 0L;
                        boolean bl16 = false;
                        while (var13_179 < values.size()) {
                            value2 = values.get((int)var13_179);
                            if (value2 instanceof Number) {
                                long l32 = ((Number)value2).longValue();
                                result31 = var13_179 == false ? l32 : (result31 >>>= (int)l32);
                            }
                            ++var13_179;
                        }
                        return result31;
                    }
                    int result32 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e23 = values.get(i10);
                        if (!(e23 instanceof Number)) continue;
                        int l33 = ((Number)e23).intValue();
                        if (i10 == 0) {
                            result32 = l33;
                            continue;
                        }
                        result32 >>>= l33;
                    }
                    return result32;
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_182;
                            double result33 = 0.0;
                            boolean bl17 = false;
                            while (var13_182 < values.size()) {
                                value2 = values.get((int)var13_182);
                                if (value2 instanceof Number) {
                                    double l34 = ((Number)value2).doubleValue();
                                    result33 = var13_182 == false ? l34 : (result33 += l34);
                                }
                                ++var13_182;
                            }
                            return result33;
                        }
                        float result34 = 0.0f;
                        for (i10 = 0; i10 < values.size(); ++i10) {
                            Object e24 = values.get(i10);
                            if (!(e24 instanceof Number)) continue;
                            float l35 = ((Number)e24).floatValue();
                            if (i10 == 0) {
                                result34 = l35;
                                continue;
                            }
                            result34 += l35;
                        }
                        return Float.valueOf(result34);
                    }
                    if (isWide) {
                        void var13_185;
                        long result35 = 0L;
                        boolean bl18 = false;
                        while (var13_185 < values.size()) {
                            value2 = values.get((int)var13_185);
                            if (value2 instanceof Number) {
                                long l36 = ((Number)value2).longValue();
                                result35 = var13_185 == false ? l36 : (result35 += l36);
                            }
                            ++var13_185;
                        }
                        return result35;
                    }
                    int result36 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e25 = values.get(i10);
                        if (!(e25 instanceof Number)) continue;
                        int l37 = ((Number)e25).intValue();
                        if (i10 == 0) {
                            result36 = l37;
                            continue;
                        }
                        result36 += l37;
                    }
                    return result36;
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_188;
                            double result37 = 0.0;
                            boolean bl19 = false;
                            while (var13_188 < values.size()) {
                                value2 = values.get((int)var13_188);
                                if (value2 instanceof Number) {
                                    double l38 = ((Number)value2).doubleValue();
                                    result37 = var13_188 == false ? l38 : (result37 -= l38);
                                }
                                ++var13_188;
                            }
                            return result37;
                        }
                        float result38 = 0.0f;
                        for (i10 = 0; i10 < values.size(); ++i10) {
                            Object e26 = values.get(i10);
                            if (!(e26 instanceof Number)) continue;
                            float l39 = ((Number)e26).floatValue();
                            if (i10 == 0) {
                                result38 = l39;
                                continue;
                            }
                            result38 -= l39;
                        }
                        return Float.valueOf(result38);
                    }
                    if (isWide) {
                        void var13_191;
                        long result39 = 0L;
                        boolean bl20 = false;
                        while (var13_191 < values.size()) {
                            value2 = values.get((int)var13_191);
                            if (value2 instanceof Number) {
                                long l40 = ((Number)value2).longValue();
                                result39 = var13_191 == false ? l40 : (result39 -= l40);
                            }
                            ++var13_191;
                        }
                        return result39;
                    }
                    int result40 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e27 = values.get(i10);
                        if (!(e27 instanceof Number)) continue;
                        int l41 = ((Number)e27).intValue();
                        if (i10 == 0) {
                            result40 = l41;
                            continue;
                        }
                        result40 -= l41;
                    }
                    return result40;
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_194;
                            double result41 = 0.0;
                            boolean bl21 = false;
                            while (var13_194 < values.size()) {
                                value2 = values.get((int)var13_194);
                                if (value2 instanceof Number) {
                                    double l42 = ((Number)value2).doubleValue();
                                    result41 = var13_194 == false ? l42 : (result41 *= l42);
                                }
                                ++var13_194;
                            }
                            return result41;
                        }
                        float result42 = 0.0f;
                        for (i10 = 0; i10 < values.size(); ++i10) {
                            Object e28 = values.get(i10);
                            if (!(e28 instanceof Number)) continue;
                            float l43 = ((Number)e28).floatValue();
                            if (i10 == 0) {
                                result42 = l43;
                                continue;
                            }
                            result42 *= l43;
                        }
                        return Float.valueOf(result42);
                    }
                    if (isWide) {
                        void var13_197;
                        long result43 = 0L;
                        boolean bl22 = false;
                        while (var13_197 < values.size()) {
                            value2 = values.get((int)var13_197);
                            if (value2 instanceof Number) {
                                long l44 = ((Number)value2).longValue();
                                result43 = var13_197 == false ? l44 : (result43 *= l44);
                            }
                            ++var13_197;
                        }
                        return result43;
                    }
                    int result44 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e29 = values.get(i10);
                        if (!(e29 instanceof Number)) continue;
                        int l45 = ((Number)e29).intValue();
                        if (i10 == 0) {
                            result44 = l45;
                            continue;
                        }
                        result44 *= l45;
                    }
                    return result44;
                }
                if (operator == JavaTokenType.DIV) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_200;
                            double result45 = 0.0;
                            boolean bl23 = false;
                            while (var13_200 < values.size()) {
                                value2 = values.get((int)var13_200);
                                if (value2 instanceof Number) {
                                    double l46 = ((Number)value2).doubleValue();
                                    result45 = var13_200 == false ? l46 : (result45 /= l46);
                                }
                                ++var13_200;
                            }
                            return result45;
                        }
                        float result46 = 0.0f;
                        for (i10 = 0; i10 < values.size(); ++i10) {
                            Object e30 = values.get(i10);
                            if (!(e30 instanceof Number)) continue;
                            float l47 = ((Number)e30).floatValue();
                            if (i10 == 0) {
                                result46 = l47;
                                continue;
                            }
                            result46 /= l47;
                        }
                        return Float.valueOf(result46);
                    }
                    if (isWide) {
                        void var13_203;
                        long result47 = 0L;
                        boolean bl24 = false;
                        while (var13_203 < values.size()) {
                            value2 = values.get((int)var13_203);
                            if (value2 instanceof Number) {
                                long l48 = ((Number)value2).longValue();
                                if (var13_203 == false) {
                                    result47 = l48;
                                } else {
                                    if (l48 == 0L) {
                                        return null;
                                    }
                                    result47 /= l48;
                                }
                            }
                            ++var13_203;
                        }
                        return result47;
                    }
                    int result48 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e31 = values.get(i10);
                        if (!(e31 instanceof Number)) continue;
                        int l49 = ((Number)e31).intValue();
                        if (i10 == 0) {
                            result48 = l49;
                            continue;
                        }
                        if (l49 == 0) {
                            return null;
                        }
                        result48 /= l49;
                    }
                    return result48;
                }
                if (operator == JavaTokenType.PERC) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_206;
                            double result49 = 0.0;
                            boolean bl25 = false;
                            while (var13_206 < values.size()) {
                                value2 = values.get((int)var13_206);
                                if (value2 instanceof Number) {
                                    double l50 = ((Number)value2).doubleValue();
                                    result49 = var13_206 == false ? l50 : (result49 %= l50);
                                }
                                ++var13_206;
                            }
                            return result49;
                        }
                        float result50 = 0.0f;
                        for (i10 = 0; i10 < values.size(); ++i10) {
                            Object e32 = values.get(i10);
                            if (!(e32 instanceof Number)) continue;
                            float l51 = ((Number)e32).floatValue();
                            if (i10 == 0) {
                                result50 = l51;
                                continue;
                            }
                            result50 %= l51;
                        }
                        return Float.valueOf(result50);
                    }
                    if (isWide) {
                        void var13_209;
                        long result51 = 0L;
                        boolean bl26 = false;
                        while (var13_209 < values.size()) {
                            value2 = values.get((int)var13_209);
                            if (value2 instanceof Number) {
                                long l52 = ((Number)value2).longValue();
                                if (var13_209 == false) {
                                    result51 = l52;
                                } else {
                                    if (l52 == 0L) {
                                        return null;
                                    }
                                    result51 %= l52;
                                }
                            }
                            ++var13_209;
                        }
                        return result51;
                    }
                    int result52 = 0;
                    for (i10 = 0; i10 < values.size(); ++i10) {
                        Object e33 = values.get(i10);
                        if (!(e33 instanceof Number)) continue;
                        int l53 = ((Number)e33).intValue();
                        if (i10 == 0) {
                            result52 = l53;
                            continue;
                        }
                        if (l53 == 0) {
                            return null;
                        }
                        result52 %= l53;
                    }
                    return result52;
                }
                return null;
            }
        } else {
            if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                Object operandValue = this.evaluate((PsiElement)cast.getOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    PsiTypeElement typeElement = cast.getCastType();
                    if (typeElement != null) {
                        PsiType type = typeElement.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                }
                return operandValue;
            }
            if (node instanceof PsiReference) {
                PsiLocalVariable variable;
                PsiExpression last;
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiField) {
                    PsiExpression expression;
                    PsiField field = (PsiField)resolved;
                    if ("length".equals(field.getName()) && node instanceof PsiReferenceExpression && (expression = ((PsiReferenceExpression)node).getQualifierExpression()) != null && expression.getType() instanceof PsiArrayType) {
                        Object array = this.evaluate((PsiElement)expression);
                        int size = ConstantEvaluator.getArraySize(array);
                        if (size != -1) {
                            return size;
                        }
                        return null;
                    }
                    Object value = field.computeConstantValue();
                    if (value != null) {
                        return value;
                    }
                    if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                        PsiIfStatement curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiIfStatement.class);
                        while (curr != null) {
                            PsiExpression condition;
                            if (curr.getCondition() != null && ConstantEvaluator.references(curr.getCondition(), (PsiVariable)field) && !PsiTreeUtil.isAncestor((PsiElement)(condition = curr.getCondition()), (PsiElement)node, (boolean)true)) {
                                return value;
                            }
                            curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)curr, PsiIfStatement.class, (boolean)true);
                        }
                        return value;
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                    return this.evaluate((PsiElement)last);
                }
            } else if (node instanceof PsiNewExpression) {
                PsiNewExpression creation = (PsiNewExpression)node;
                PsiArrayInitializerExpression initializer = creation.getArrayInitializer();
                PsiType type = creation.getType();
                if (type instanceof PsiArrayType) {
                    Object fixedSize;
                    if (initializer != null) {
                        int i11;
                        Object[] array;
                        PsiExpression[] initializers = initializer.getInitializers();
                        Class<?> commonType = null;
                        ArrayList values = Lists.newArrayListWithExpectedSize((int)initializers.length);
                        int count = 0;
                        for (PsiExpression expression : initializers) {
                            Object object = this.evaluate((PsiElement)expression);
                            if (object != null) {
                                values.add(object);
                                if (commonType == null) {
                                    commonType = object.getClass();
                                } else {
                                    while (!commonType.isAssignableFrom(object.getClass())) {
                                        commonType = commonType.getSuperclass();
                                    }
                                }
                            } else if (!this.allowUnknown) {
                                return null;
                            }
                            if (++count != 40) continue;
                            return ConstantEvaluator.getArray(type.getDeepComponentType(), initializers.length, 1);
                        }
                        if ((type = type.getDeepComponentType()) == PsiType.INT) {
                            if (!values.isEmpty()) {
                                array = new int[values.size()];
                                for (int i18 = 0; i18 < values.size(); ++i18) {
                                    Object o10 = values.get(i18);
                                    if (!(o10 instanceof Integer)) continue;
                                    array[i18] = (Integer)o10;
                                }
                                return array;
                            }
                            return new int[0];
                        }
                        if (type == PsiType.BOOLEAN) {
                            if (!values.isEmpty()) {
                                array = new boolean[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o11 = values.get(i11);
                                    if (!(o11 instanceof Boolean)) continue;
                                    array[i11] = ((Boolean)o11).booleanValue() ? 1 : 0;
                                }
                                return array;
                            }
                            return new boolean[0];
                        }
                        if (type == PsiType.DOUBLE) {
                            if (!values.isEmpty()) {
                                array = new double[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o12 = values.get(i11);
                                    if (!(o12 instanceof Double)) continue;
                                    array[i11] = (int)((Double)o12).doubleValue();
                                }
                                return array;
                            }
                            return new double[0];
                        }
                        if (type == PsiType.LONG) {
                            if (!values.isEmpty()) {
                                array = new long[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o13 = values.get(i11);
                                    if (!(o13 instanceof Long)) continue;
                                    array[i11] = (int)((Long)o13).longValue();
                                }
                                return array;
                            }
                            return new long[0];
                        }
                        if (type == PsiType.FLOAT) {
                            if (!values.isEmpty()) {
                                array = new float[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o14 = values.get(i11);
                                    if (!(o14 instanceof Float)) continue;
                                    array[i11] = (int)((Float)o14).floatValue();
                                }
                                return array;
                            }
                            return new float[0];
                        }
                        if (type == PsiType.CHAR) {
                            if (!values.isEmpty()) {
                                array = new char[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o15 = values.get(i11);
                                    if (!(o15 instanceof Character)) continue;
                                    array[i11] = ((Character)o15).charValue();
                                }
                                return array;
                            }
                            return new char[0];
                        }
                        if (type == PsiType.BYTE) {
                            if (!values.isEmpty()) {
                                array = new byte[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o16 = values.get(i11);
                                    if (!(o16 instanceof Byte)) continue;
                                    array[i11] = ((Byte)o16).byteValue();
                                }
                                return array;
                            }
                            return new byte[0];
                        }
                        if (type == PsiType.SHORT) {
                            if (!values.isEmpty()) {
                                array = new short[values.size()];
                                for (i11 = 0; i11 < values.size(); ++i11) {
                                    Object o17 = values.get(i11);
                                    if (!(o17 instanceof Short)) continue;
                                    array[i11] = ((Short)o17).shortValue();
                                }
                                return array;
                            }
                            return new short[0];
                        }
                        if (!values.isEmpty()) {
                            Object o18 = Array.newInstance(commonType, values.size());
                            return values.toArray((Object[])o18);
                        }
                        return null;
                    }
                    PsiExpression[] arrayDimensions = creation.getArrayDimensions();
                    int size = 0;
                    if (arrayDimensions.length > 0 && (fixedSize = this.evaluate((PsiElement)arrayDimensions[0])) instanceof Number) {
                        size = ((Number)fixedSize).intValue();
                    }
                    int dimensions = type.getArrayDimensions();
                    type = type.getDeepComponentType();
                    return ConstantEvaluator.getArray(type, size, dimensions);
                }
            } else {
                if (node instanceof KtLiteralStringTemplateEntry) {
                    return node.getText();
                }
                if (node instanceof KtStringTemplateExpression) {
                    KtStringTemplateExpression template = (KtStringTemplateExpression)node;
                    StringBuilder sb3 = new StringBuilder();
                    boolean parts = false;
                    for (KtStringTemplateEntry entry : template.getEntries()) {
                        if (entry instanceof KtLiteralStringTemplateEntry) {
                            sb3.append(entry.getText());
                            parts = true;
                            continue;
                        }
                        KtExpression expression = entry.getExpression();
                        Object part = this.evaluate((PsiElement)expression);
                        if (!(part instanceof String)) continue;
                        sb3.append(part);
                        parts = true;
                    }
                    if (parts) {
                        return sb3.toString();
                    }
                } else {
                    if (node instanceof KtUltraLightMethodForSourceDeclaration) {
                        return this.valueFromProperty(((KtUltraLightMethodForSourceDeclaration)node).getKotlinOrigin());
                    }
                    if (node instanceof KtUltraLightFieldForSourceDeclaration) {
                        return this.valueFromProperty((KtDeclaration)((KtUltraLightFieldForSourceDeclaration)node).getKotlinOrigin());
                    }
                }
            }
        }
        return null;
    }

    private Object valueFromProperty(KtDeclaration origin) {
        if (origin instanceof KtProperty) {
            KtExpression initializer;
            KtProperty property = (KtProperty)origin;
            if (this.allowFieldInitializers) {
                KtExpression initializer2 = property.getInitializer();
                if (initializer2 != null) {
                    return this.evaluate((PsiElement)initializer2);
                }
            } else if (!property.isVar() && property.getGetter() == null && property.getSetter() == null && (initializer = property.getInitializer()) != null) {
                return this.evaluate((PsiElement)initializer);
            }
        }
        return null;
    }

    private static Object getArray(PsiType type, int size, int dimensions) {
        if (type instanceof PsiPrimitiveType) {
            if (size <= 12) {
                if (PsiType.BYTE.equals((Object)type)) {
                    return new byte[size];
                }
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    return new boolean[size];
                }
                if (PsiType.INT.equals((Object)type)) {
                    return new int[size];
                }
                if (PsiType.LONG.equals((Object)type)) {
                    return new long[size];
                }
                if (PsiType.CHAR.equals((Object)type)) {
                    return new char[size];
                }
                if (PsiType.FLOAT.equals((Object)type)) {
                    return new float[size];
                }
                if (PsiType.DOUBLE.equals((Object)type)) {
                    return new double[size];
                }
                if (PsiType.SHORT.equals((Object)type)) {
                    return new short[size];
                }
            } else {
                if (PsiType.BYTE.equals((Object)type)) {
                    return new ArrayReference(Byte.TYPE, size, dimensions);
                }
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    return new ArrayReference(Boolean.TYPE, size, dimensions);
                }
                if (PsiType.INT.equals((Object)type)) {
                    return new ArrayReference(Integer.TYPE, size, dimensions);
                }
                if (PsiType.LONG.equals((Object)type)) {
                    return new ArrayReference(Long.TYPE, size, dimensions);
                }
                if (PsiType.CHAR.equals((Object)type)) {
                    return new ArrayReference(Character.TYPE, size, dimensions);
                }
                if (PsiType.FLOAT.equals((Object)type)) {
                    return new ArrayReference(Float.TYPE, size, dimensions);
                }
                if (PsiType.DOUBLE.equals((Object)type)) {
                    return new ArrayReference(Double.TYPE, size, dimensions);
                }
                if (PsiType.SHORT.equals((Object)type)) {
                    return new ArrayReference(Short.TYPE, size, dimensions);
                }
            }
        } else if (type instanceof PsiClassType) {
            String className = type.getCanonicalText();
            if ("java.lang.String".equals(className)) {
                if (size < 12) {
                    return new String[size];
                }
                return new ArrayReference(String.class, size, dimensions);
            }
            if ("java.lang.Object".equals(className)) {
                if (size < 12) {
                    return new Object[size];
                }
                return new ArrayReference(Object.class, size, dimensions);
            }
            return new ArrayReference(className, size, dimensions);
        }
        return null;
    }

    private static boolean references(PsiExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement refersTo = reference.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                super.visitReferenceElement(reference);
            }
        });
        return found.get();
    }

    private static boolean references(UExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                PsiElement refersTo = node.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                return super.visitSimpleNameReferenceExpression(node);
            }

            public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                return super.visitQualifiedReferenceExpression(node);
            }
        });
        return found.get();
    }

    public static boolean isArrayLiteral(PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand;
        if (node instanceof PsiReference) {
            PsiLocalVariable variable;
            PsiExpression last;
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return ConstantEvaluator.isArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)last);
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type = creation.getType();
            if (type instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)expression);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return ConstantEvaluator.isArrayLiteral((PsiElement)operand);
        }
        return false;
    }

    public static boolean isArrayLiteral(UElement node) {
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return ConstantEvaluator.isArrayLiteral((UElement)lastAssignment);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression = parenthesizedExpression.getExpression();
                return ConstantEvaluator.isArrayLiteral((UElement)expression);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand = castExpression.getOperand();
                return ConstantEvaluator.isArrayLiteral((UElement)operand);
            }
        }
        return false;
    }

    public static Object evaluate(JavaContext context2, PsiElement node) {
        Object evaluate = new ConstantEvaluator().evaluate(node);
        return evaluate;
    }

    public static Object evaluate(JavaContext context2, UElement element) {
        if (element instanceof ULiteralExpression) {
            return ((ULiteralExpression)element).getValue();
        }
        return new ConstantEvaluator().evaluate(element);
    }

    public static String evaluateString(JavaContext context2, PsiElement node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }

    public static PsiExpression findLastAssignment(PsiElement usage, PsiVariable variable) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)usage, PsiStatement.class, (boolean)false);
        if (statement != null) {
            PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            String targetName = variable.getName();
            if (targetName == null) {
                return null;
            }
            while (prev != null) {
                PsiReferenceExpression reference;
                PsiAssignmentExpression assign;
                PsiExpression lhs;
                PsiExpression expression;
                if (prev instanceof PsiDeclarationStatement) {
                    for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                        if (!variable.equals(element)) continue;
                        return variable.getInitializer();
                    }
                } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                    return assign.getRExpression();
                }
                prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
            }
        }
        return null;
    }

    public static String evaluateString(JavaContext context2, UElement element, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(element)) instanceof String ? (String)value : null;
    }

    public static class ArrayReference {
        public final Class<?> type;
        public final String className;
        public final int size;
        public final int dimensions;

        public ArrayReference(Class<?> type, int size, int dimensions) {
            this.type = type;
            this.className = null;
            this.size = size;
            this.dimensions = dimensions;
        }

        public ArrayReference(String className, int size, int dimensions) {
            this.className = className;
            this.type = null;
            this.size = size;
            this.dimensions = dimensions;
        }

        public boolean equals(Object o10) {
            if (this == o10) {
                return true;
            }
            if (o10 == null || this.getClass() != o10.getClass()) {
                return false;
            }
            ArrayReference that = (ArrayReference)o10;
            return this.size == that.size && this.dimensions == that.dimensions && Objects.equals(this.type, that.type) && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.className, this.size, this.dimensions);
        }

        public String toString() {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("Array Reference: ");
            if (this.type != null) {
                sb2.append(this.type.toString());
            } else if (this.className != null) {
                sb2.append(this.className);
            }
            for (int i10 = 0; i10 < this.dimensions - 1; ++i10) {
                sb2.append("[]");
            }
            sb2.append("[");
            sb2.append(Integer.toString(this.size));
            sb2.append("]");
            return sb2.toString();
        }
    }

    public static class LastAssignmentFinder
    extends AbstractUastVisitor {
        public static final Object LAST_ASSIGNMENT_VALUE_UNKNOWN = new String("<unknown>");
        private final PsiVariable mVariable;
        private final UElement mEndAt;
        private final ConstantEvaluator mConstantEvaluator;
        private boolean mDone = false;
        private int mCurrentLevel = 0;
        private int mVariableLevel = -1;
        private Object mCurrentValue;
        private UElement mLastAssignment;

        public LastAssignmentFinder(PsiVariable variable, UElement endAt, ConstantEvaluator constantEvaluator, int variableLevel) {
            this.mVariable = variable;
            this.mEndAt = endAt;
            UExpression initializer = UastFacade.INSTANCE.getInitializerBody(variable);
            this.mLastAssignment = initializer;
            this.mConstantEvaluator = constantEvaluator;
            if (initializer != null && constantEvaluator != null) {
                this.mCurrentValue = constantEvaluator.evaluate((UElement)initializer);
            }
            this.mVariableLevel = variableLevel;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public UElement getLastAssignment() {
            return this.mLastAssignment;
        }

        public boolean visitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                ++this.mCurrentLevel;
            }
            if (node.equals(this.mEndAt)) {
                this.mDone = true;
            }
            return this.mDone || super.visitElement(node);
        }

        public boolean visitVariable(UVariable node) {
            if (this.mVariableLevel < 0 && node.getPsi().isEquivalentTo((PsiElement)this.mVariable)) {
                this.mVariableLevel = this.mCurrentLevel;
            }
            return super.visitVariable(node);
        }

        public void afterVisitBinaryExpression(UBinaryExpression node) {
            if (!this.mDone && node.getOperator() instanceof UastBinaryOperator.AssignOperator && this.mVariableLevel >= 0) {
                UExpression leftOperand = node.getLeftOperand();
                UastBinaryOperator operator = node.getOperator();
                if (!(operator instanceof UastBinaryOperator.AssignOperator) || !(leftOperand instanceof UResolvable)) {
                    return;
                }
                PsiElement resolved = ((UResolvable)leftOperand).resolve();
                if (!this.mVariable.equals(resolved)) {
                    return;
                }
                if (this.mCurrentLevel > this.mVariableLevel + 1) {
                    this.mLastAssignment = null;
                    this.mCurrentValue = null;
                    return;
                }
                UExpression rightOperand = node.getRightOperand();
                ConstantEvaluator constantEvaluator = this.mConstantEvaluator;
                this.mCurrentValue = constantEvaluator != null ? constantEvaluator.evaluate((UElement)rightOperand) : null;
                this.mLastAssignment = rightOperand;
            }
            super.afterVisitBinaryExpression(node);
        }

        public void afterVisitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                --this.mCurrentLevel;
            }
            super.afterVisitElement(node);
        }

        private static boolean elementHasLevel(UElement node) {
            return !(node instanceof UBlockExpression) && !(node instanceof UDeclarationsExpression);
        }
    }
}

