/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.HprofBitmapProvider;
import com.android.tools.perflib.heap.memoryanalyzer.Printer;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Base64;
import javax.imageio.ImageIO;

public final class HtmlPrinter
implements Printer {
    private final PrintStream mOutStream;
    private final Escaper mEscaper;
    private static final int MAX_PREVIEW_STRING_LENGTH = 100;

    public HtmlPrinter(Path path2) throws FileNotFoundException {
        this(new PrintStream(path2.toFile()));
    }

    public HtmlPrinter(PrintStream outStream) {
        this.mOutStream = outStream;
        this.mEscaper = HtmlEscapers.htmlEscaper();
    }

    @Override
    public void addHeading(int level, String content) {
        this.mOutStream.printf("<h%d>%s</h%1$d>\n", level, this.mEscaper.escape(content));
    }

    @Override
    public void addParagraph(String content) {
        this.mOutStream.printf("<p>%s</p>\n", this.mEscaper.escape(content));
    }

    @Override
    public void startTable(String ... columnHeadings) {
        this.mOutStream.printf("<table>\n", new Object[0]);
        if (columnHeadings.length > 0) {
            this.mOutStream.printf("<tr style='border: 1px solid black;'>\n", new Object[0]);
            for (String column : columnHeadings) {
                this.mOutStream.printf("<th style='border: 1px solid black;'>%s</th>\n", this.mEscaper.escape(column));
            }
            this.mOutStream.printf("</tr>\n", new Object[0]);
        }
    }

    @Override
    public void addRow(String ... values) {
        this.mOutStream.printf("<tr>\n", new Object[0]);
        for (String value : values) {
            this.mOutStream.printf("<td>%s</td>\n", this.mEscaper.escape(value));
        }
        this.mOutStream.printf("</tr>\n", new Object[0]);
    }

    @Override
    public void endTable() {
        this.mOutStream.printf("</table>\n", new Object[0]);
    }

    @Override
    public void addImage(Instance instance) {
        if (!HprofBitmapProvider.canGetBitmapFromInstance(instance)) {
            return;
        }
        try {
            int[] converted;
            HprofBitmapProvider bitmapProvider = new HprofBitmapProvider(instance);
            String configName = bitmapProvider.getBitmapConfigName();
            int width = bitmapProvider.getDimension().width;
            int height = bitmapProvider.getDimension().height;
            byte[] raw = bitmapProvider.getPixelBytes(new Dimension());
            if ("\"ARGB_8888\"".equals(configName)) {
                converted = new int[width * height];
                for (int i10 = 0; i10 < converted.length; ++i10) {
                    converted[i10] = ((raw[i10 * 4 + 3] & 0xFF) << 24) + ((raw[i10 * 4 + 0] & 0xFF) << 16) + ((raw[i10 * 4 + 1] & 0xFF) << 8) + (raw[i10 * 4 + 2] & 0xFF);
                }
            } else {
                throw new Exception("RGB_565/ALPHA_8 conversion not implemented");
            }
            int imageType = -1;
            switch (configName) {
                case "\"ARGB_8888\"": {
                    imageType = 6;
                    break;
                }
                case "\"RGB_565\"": {
                    imageType = 8;
                    break;
                }
                case "\"ALPHA_8\"": {
                    imageType = 10;
                }
            }
            BufferedImage image = new BufferedImage(width, height, imageType);
            image.setRGB(0, 0, width, height, converted, 0, width);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteOutputStream);
            byteOutputStream.flush();
            String imageDataString = Base64.getEncoder().encodeToString(byteOutputStream.toByteArray());
            byteOutputStream.close();
            this.mOutStream.printf("<img src='data:image/png;base64,%s' \\>\n", imageDataString);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return;
        }
    }

    @Override
    public String formatInstance(Instance instance) {
        return instance.toString();
    }

    private String bitmapAsBase64String(BufferedImage image) {
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteOutputStream);
            byteOutputStream.flush();
            String imageDataString = Base64.getEncoder().encodeToString(byteOutputStream.toByteArray());
            byteOutputStream.close();
            return imageDataString;
        }
        catch (IOException e10) {
            return null;
        }
    }
}

