/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Ints;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class LargeFileSource
extends Source {
    private final Path transferSrc;
    private final int compressionLevel;
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    public LargeFileSource(Path src, Path tmpStorage, String name, int compressionLevel) throws IOException {
        super(name);
        this.compressionLevel = compressionLevel;
        if (tmpStorage == null && compressionLevel != 0) {
            String msg = "Compression without a provided tmp Path is not supported";
            throw new IllegalStateException(msg);
        }
        try (CheckedInputStream in2 = new CheckedInputStream(Files.newInputStream(src, new OpenOption[0]), new CRC32());){
            if (compressionLevel == 0) {
                this.buildStored(in2);
                this.transferSrc = src;
            } else {
                this.buildCompressed(in2, compressionLevel, tmpStorage);
                this.transferSrc = tmpStorage;
            }
            this.crc = Ints.longToUint(in2.getChecksum().getValue());
        }
    }

    public LargeFileSource(Path src, String name, int compressionLevel) throws IOException {
        this(src, LargeFileSource.getTmpStoragePath(src.getFileName().toString()), name, compressionLevel);
    }

    public static Path getTmpStoragePath(String entryName) {
        StringBuilder filename = new StringBuilder();
        filename.append(Integer.toHexString(entryName.hashCode()));
        filename.append("-");
        filename.append(Thread.currentThread().getId());
        filename.append("-");
        filename.append(System.nanoTime());
        filename.append(".tmp");
        Path tmp = Paths.get(TMP_DIR, filename.toString());
        if (Files.exists(tmp, new LinkOption[0])) {
            String msg = String.format(Locale.US, "Cannot use path '%s' (exists)", tmp);
            throw new IllegalStateException(msg);
        }
        return tmp;
    }

    private void buildStored(InputStream in2) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        long inputSize = 0L;
        while ((read = in2.read(buffer)) != -1) {
            inputSize += (long)read;
        }
        this.uncompressedSize = this.compressedSize = inputSize;
        this.compressionFlag = 0;
    }

    private void buildCompressed(InputStream in2, int compressionLevel, Path tmp) throws IOException {
        if (Files.exists(tmp, new LinkOption[0])) {
            String msg = String.format("Tmp storage '%s' already exists", tmp.toAbsolutePath());
            throw new IllegalStateException(msg);
        }
        Deflater deflater = Compressor.getDeflater(compressionLevel);
        try (DeflaterOutputStream out = new DeflaterOutputStream(Files.newOutputStream(tmp, StandardOpenOption.CREATE_NEW), deflater);){
            int read;
            tmp.toFile().deleteOnExit();
            byte[] buffer = new byte[4096];
            while ((read = in2.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        this.compressedSize = deflater.getBytesWritten();
        this.uncompressedSize = deflater.getBytesRead();
        this.compressionFlag = (short)8;
    }

    @Override
    public void prepare() throws IOException {
    }

    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        try {
            long l10;
            block10: {
                FileChannel src = FileChannel.open(this.transferSrc, StandardOpenOption.READ);
                try {
                    writer.transferFrom(src, 0L, this.compressedSize);
                    l10 = this.compressedSize;
                    if (src == null) break block10;
                }
                catch (Throwable throwable) {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                src.close();
            }
            return l10;
        }
        finally {
            if (this.compressionLevel != 0) {
                Files.delete(this.transferSrc);
            }
        }
    }
}

