/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MatchingOutputStream;
import com.google.archivepatcher.generator.MinimalZipArchive;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.MismatchException;
import com.google.archivepatcher.shared.JreDeflateParameters;
import com.google.archivepatcher.shared.MultiViewInputStreamFactory;
import com.google.archivepatcher.shared.RandomAccessFileInputStreamFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class DefaultDeflateCompressionDiviner {
    private final Map<Integer, List<Integer>> levelsByStrategy = this.getLevelsByStrategy();

    public List<DivinationResult> divineDeflateParameters(File archiveFile) throws IOException {
        ArrayList<DivinationResult> results = new ArrayList<DivinationResult>();
        for (MinimalZipEntry minimalZipEntry : MinimalZipArchive.listEntries(archiveFile)) {
            JreDeflateParameters divinedParameters = null;
            if (minimalZipEntry.isDeflateCompressed()) {
                RandomAccessFileInputStreamFactory rafisFactory = new RandomAccessFileInputStreamFactory(archiveFile, minimalZipEntry.getFileOffsetOfCompressedData(), minimalZipEntry.getCompressedSize());
                divinedParameters = this.divineDeflateParameters(rafisFactory);
            }
            results.add(new DivinationResult(minimalZipEntry, divinedParameters));
        }
        return results;
    }

    protected Map<Integer, List<Integer>> getLevelsByStrategy() {
        HashMap<Integer, List<Integer>> levelsByStrategy = new HashMap<Integer, List<Integer>>();
        levelsByStrategy.put(0, Collections.unmodifiableList(Arrays.asList(6, 9, 1, 4, 2, 3, 5, 7, 8)));
        levelsByStrategy.put(1, Collections.unmodifiableList(Arrays.asList(6, 9, 4, 5, 7, 8)));
        levelsByStrategy.put(2, Collections.singletonList(1));
        return Collections.unmodifiableMap(levelsByStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JreDeflateParameters divineDeflateParameters(MultiViewInputStreamFactory<?> compressedDataInputStreamFactory) throws IOException {
        Object compressedDataIn = compressedDataInputStreamFactory.newStream();
        if (!((InputStream)compressedDataIn).markSupported()) {
            try {
                ((InputStream)compressedDataIn).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalArgumentException("input stream must support mark(int)");
        }
        ((InputStream)compressedDataIn).mark(0);
        Object matchingCompressedDataIn = compressedDataInputStreamFactory.newStream();
        ((InputStream)matchingCompressedDataIn).mark(0);
        byte[] copyBuffer = new byte[32768];
        try {
            for (boolean nowrap : new boolean[]{true, false}) {
                Inflater inflater = new Inflater(nowrap);
                Deflater deflater = new Deflater(0, nowrap);
                for (int strategy : new int[]{0, 1, 2}) {
                    deflater.setStrategy(strategy);
                    List<Integer> levelsToSearch = this.levelsByStrategy.get(strategy);
                    for (int levelIndex = 0; levelIndex < levelsToSearch.size(); ++levelIndex) {
                        int level = levelsToSearch.get(levelIndex);
                        deflater.setLevel(level);
                        inflater.reset();
                        deflater.reset();
                        ((InputStream)compressedDataIn).reset();
                        ((InputStream)matchingCompressedDataIn).reset();
                        try {
                            if (!this.matches((InputStream)compressedDataIn, inflater, deflater, (InputStream)matchingCompressedDataIn, copyBuffer)) continue;
                            JreDeflateParameters jreDeflateParameters = JreDeflateParameters.of(level, strategy, nowrap);
                            return jreDeflateParameters;
                        }
                        catch (ZipException e10) {
                            levelIndex = levelsToSearch.size();
                            strategy = 2;
                        }
                    }
                }
            }
        }
        finally {
            try {
                ((InputStream)compressedDataIn).close();
            }
            catch (Exception exception) {}
            try {
                ((InputStream)matchingCompressedDataIn).close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(InputStream compressedDataIn, Inflater inflater, Deflater deflater, InputStream matchingStreamInput, byte[] copyBuffer) throws IOException {
        MatchingOutputStream matcher = new MatchingOutputStream(matchingStreamInput, 32768);
        InflaterInputStream inflaterIn = new InflaterInputStream(compressedDataIn, inflater, 32768);
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)matcher, deflater, 32768);
        int numRead = 0;
        try {
            while ((numRead = inflaterIn.read(copyBuffer)) >= 0) {
                out.write(copyBuffer, 0, numRead);
            }
            out.finish();
            out.flush();
            matcher.expectEof();
            boolean bl2 = true;
            return bl2;
        }
        catch (MismatchException mismatchException) {
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static class DivinationResult {
        public final MinimalZipEntry minimalZipEntry;
        public final JreDeflateParameters divinedParameters;

        public DivinationResult(MinimalZipEntry minimalZipEntry, JreDeflateParameters divinedParameters) {
            if (minimalZipEntry == null) {
                throw new IllegalArgumentException("minimalZipEntry cannot be null");
            }
            this.minimalZipEntry = minimalZipEntry;
            this.divinedParameters = divinedParameters;
        }
    }
}

