/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MatchingOutputStream
extends OutputStream {
    private final InputStream expectedBytesStream;
    private final byte[] buffer;

    public MatchingOutputStream(InputStream expectedBytesStream, int matchBufferSize) {
        if (matchBufferSize < 1) {
            throw new IllegalArgumentException("buffer size must be >= 1");
        }
        this.expectedBytesStream = expectedBytesStream;
        this.buffer = new byte[matchBufferSize];
    }

    @Override
    public void write(int b10) throws IOException {
        int expected = this.expectedBytesStream.read();
        if (expected == -1) {
            throw new MismatchException("EOF reached in expectedBytesStream");
        }
        if (expected != b10) {
            throw new MismatchException("Data does not match");
        }
    }

    @Override
    public void write(byte[] b10) throws IOException {
        this.write(b10, 0, b10.length);
    }

    @Override
    public void write(byte[] dataToWrite, int offset, int length) throws IOException {
        int numReadThisLoop;
        for (int numReadSoFar = 0; numReadSoFar < length; numReadSoFar += numReadThisLoop) {
            int maxToRead = Math.min(this.buffer.length, length - numReadSoFar);
            numReadThisLoop = this.expectedBytesStream.read(this.buffer, 0, maxToRead);
            if (numReadThisLoop == -1) {
                throw new MismatchException("EOF reached in expectedBytesStream");
            }
            for (int matchCount = 0; matchCount < numReadThisLoop; ++matchCount) {
                if (this.buffer[matchCount] == dataToWrite[offset + numReadSoFar + matchCount]) continue;
                throw new MismatchException("Data does not match");
            }
        }
    }

    public void expectEof() throws IOException {
        if (this.expectedBytesStream.read() != -1) {
            throw new MismatchException("EOF not reached in expectedBytesStream");
        }
    }
}

