/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.BsDiff;
import com.google.archivepatcher.generator.bsdiff.Matcher;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import java.io.IOException;

class BsDiffMatcher
implements Matcher {
    private final RandomAccessObject mOldData;
    private final RandomAccessObject mNewData;
    private final RandomAccessObject mGroupArray;
    private int mOldPos;
    private int mNewPos;
    private final int mMinimumMatchLength;
    private final long mTotalMatchLenBudget = 0x4000000L;
    private int mMatchLen;

    BsDiffMatcher(RandomAccessObject oldData, RandomAccessObject newData, RandomAccessObject groupArray, int minimumMatchLength) {
        this.mOldData = oldData;
        this.mNewData = newData;
        this.mGroupArray = groupArray;
        this.mOldPos = 0;
        this.mMinimumMatchLength = minimumMatchLength;
    }

    @Override
    public Matcher.NextMatch next() throws IOException, InterruptedException {
        RandomAccessObject oldData = this.mOldData;
        RandomAccessObject newData = this.mNewData;
        int previousOldOffset = this.mOldPos - this.mNewPos;
        this.mNewPos += this.mMatchLen;
        int numMatches = 0;
        int matchesCacheSize = 0;
        long totalMatchLen = 0L;
        while ((long)this.mNewPos < newData.length()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            BsDiff.Match match2 = BsDiff.searchForMatch(this.mGroupArray, oldData, newData, this.mNewPos, 0, (int)oldData.length());
            this.mOldPos = match2.start;
            this.mMatchLen = match2.length;
            totalMatchLen += (long)this.mMatchLen;
            while (matchesCacheSize < this.mMatchLen) {
                int oldIndex = this.mNewPos + previousOldOffset + matchesCacheSize;
                int newIndex = this.mNewPos + matchesCacheSize;
                if ((long)oldIndex < oldData.length()) {
                    oldData.seek(oldIndex);
                    newData.seek(newIndex);
                    if (oldData.readByte() == newData.readByte()) {
                        ++numMatches;
                    }
                }
                ++matchesCacheSize;
            }
            if (this.mMatchLen > numMatches + this.mMinimumMatchLength || totalMatchLen >= 0x4000000L) {
                return Matcher.NextMatch.of(true, this.mOldPos, this.mNewPos);
            }
            if (this.mMatchLen == 0) {
                ++this.mNewPos;
                continue;
            }
            if (this.mMatchLen == numMatches) {
                this.mNewPos += numMatches;
                numMatches = 0;
                matchesCacheSize = 0;
                continue;
            }
            if ((long)(this.mNewPos + previousOldOffset) < oldData.length()) {
                oldData.seek(this.mNewPos + previousOldOffset);
                newData.seek(this.mNewPos);
                if (oldData.readByte() == newData.readByte()) {
                    --numMatches;
                }
            }
            ++this.mNewPos;
            --matchesCacheSize;
        }
        return Matcher.NextMatch.of(false, 0, 0);
    }
}

