/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class BsUtil {
    private static final long NEGATIVE_MASK = Long.MIN_VALUE;

    BsUtil() {
    }

    static void writeFormattedLong(long value, OutputStream outputStream) throws IOException {
        long y10 = value;
        if (y10 < 0L) {
            y10 = -y10 | Long.MIN_VALUE;
        }
        for (int i10 = 0; i10 < 8; ++i10) {
            outputStream.write((byte)(y10 & 0xFFL));
            y10 >>>= 8;
        }
    }

    static long readFormattedLong(InputStream inputStream) throws IOException {
        long result2 = 0L;
        for (int bitshift = 0; bitshift < 64; bitshift += 8) {
            result2 |= (long)inputStream.read() << bitshift;
        }
        if (result2 - Long.MIN_VALUE > 0L) {
            result2 = (result2 & Long.MAX_VALUE) * -1L;
        }
        return result2;
    }

    static int lexicographicalCompare(RandomAccessObject data1, int start1, int length1, RandomAccessObject data2, int start2, int length2) throws IOException {
        int bytesLeft = Math.min(length1, length2);
        data1.seek(start1);
        data2.seek(start2);
        while (bytesLeft-- > 0) {
            int i22;
            int i12 = data1.readUnsignedByte();
            if (i12 == (i22 = data2.readUnsignedByte())) continue;
            return i12 - i22;
        }
        return length1 - length2;
    }
}

