/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.Utf8;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class Utf8Old
extends Utf8 {
    private static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(() -> new Cache());

    @Override
    public int encodedLength(CharSequence in2) {
        Cache cache = CACHE.get();
        int estimated = (int)((float)in2.length() * cache.encoder.maxBytesPerChar());
        if (cache.lastOutput == null || cache.lastOutput.capacity() < estimated) {
            cache.lastOutput = ByteBuffer.allocate(Math.max(128, estimated));
        }
        cache.lastOutput.clear();
        cache.lastInput = in2;
        CharBuffer wrap = in2 instanceof CharBuffer ? (CharBuffer)in2 : CharBuffer.wrap(in2);
        CoderResult result2 = cache.encoder.encode(wrap, cache.lastOutput, true);
        if (result2.isError()) {
            try {
                result2.throwException();
            }
            catch (CharacterCodingException e10) {
                throw new IllegalArgumentException("bad character encoding", e10);
            }
        }
        cache.lastOutput.flip();
        return cache.lastOutput.remaining();
    }

    @Override
    public void encodeUtf8(CharSequence in2, ByteBuffer out) {
        Cache cache = CACHE.get();
        if (cache.lastInput != in2) {
            this.encodedLength(in2);
        }
        out.put(cache.lastOutput);
    }

    @Override
    public String decodeUtf8(ByteBuffer buffer, int offset, int length) {
        CharsetDecoder decoder = Utf8Old.CACHE.get().decoder;
        decoder.reset();
        buffer = buffer.duplicate();
        buffer.position(offset);
        buffer.limit(offset + length);
        try {
            CharBuffer result2 = decoder.decode(buffer);
            return result2.toString();
        }
        catch (CharacterCodingException e10) {
            throw new IllegalArgumentException("Bad encoding", e10);
        }
    }

    private static class Cache {
        final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharSequence lastInput = null;
        ByteBuffer lastOutput = null;

        Cache() {
        }
    }
}

