/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.stacktrace;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CodeLocation {
    public static final int INVALID_LINE_NUMBER = -1;
    @Nullable
    private final String myClassName;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myMethodName;
    @Nullable
    private final String mySignature;
    @Nullable
    private final List<String> myMethodParameters;
    private final int myLineNumber;
    private final boolean myNativeCode;
    private final long myNativeVAddress;
    @Nullable
    private final String myNativeModuleName;
    private final int myHashcode;

    private CodeLocation(@NotNull Builder builder) {
        if (builder == null) {
            CodeLocation.$$$reportNull$$$0(0);
        }
        this.myClassName = builder.myClassName;
        this.myFileName = builder.myFileName;
        this.myMethodName = builder.myMethodName;
        this.mySignature = builder.mySignature;
        this.myMethodParameters = builder.myMethodParameters;
        this.myLineNumber = builder.myLineNumber;
        this.myNativeCode = builder.myNativeCode;
        this.myNativeVAddress = builder.myNativeVAddress;
        this.myNativeModuleName = builder.myNativeModuleName;
        this.myHashcode = Arrays.hashCode(new int[]{this.myClassName == null ? 0 : this.myClassName.hashCode(), this.myFileName == null ? 0 : this.myFileName.hashCode(), this.myMethodName == null ? 0 : this.myMethodName.hashCode(), this.mySignature == null ? 0 : this.mySignature.hashCode(), this.myNativeModuleName == null ? 0 : this.myNativeModuleName.hashCode(), Integer.hashCode(this.myLineNumber)});
    }

    @TestOnly
    @NotNull
    public static CodeLocation stub() {
        CodeLocation codeLocation = new Builder("").build();
        if (codeLocation == null) {
            CodeLocation.$$$reportNull$$$0(1);
        }
        return codeLocation;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public String getOuterClassName() {
        if (this.myClassName == null) {
            return null;
        }
        int innerCharIndex = this.myClassName.indexOf(36);
        if (innerCharIndex < 0) {
            innerCharIndex = this.myClassName.length();
        }
        return this.myClassName.substring(0, innerCharIndex);
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    @Nullable
    public List<String> getMethodParameters() {
        return this.myMethodParameters;
    }

    public boolean isNativeCode() {
        return this.myNativeCode;
    }

    public long getNativeVAddress() {
        return this.myNativeVAddress;
    }

    @Nullable
    public String getNativeModuleName() {
        return this.myNativeModuleName;
    }

    public int hashCode() {
        return this.myHashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeLocation)) {
            return false;
        }
        CodeLocation other = (CodeLocation)obj;
        return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myFileName, (CharSequence)other.myFileName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName) && StringUtil.equals((CharSequence)this.mySignature, (CharSequence)other.mySignature) && StringUtil.equals((CharSequence)this.myNativeModuleName, (CharSequence)other.myNativeModuleName) && this.myLineNumber == other.myLineNumber && this.myNativeCode == other.myNativeCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/api/stacktrace/CodeLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/api/stacktrace/CodeLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        @Nullable
        private final String myClassName;
        @Nullable
        String myFileName;
        @Nullable
        String myMethodName;
        @Nullable
        String mySignature;
        @Nullable
        List<String> myMethodParameters;
        int myLineNumber;
        boolean myNativeCode;
        long myNativeVAddress;
        @Nullable
        String myNativeModuleName;

        public Builder(@Nullable String className) {
            this.myLineNumber = -1;
            this.myNativeVAddress = -1L;
            this.myClassName = className;
        }

        public Builder(@NotNull CodeLocation rhs) {
            if (rhs == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myLineNumber = -1;
            this.myNativeVAddress = -1L;
            this.myClassName = rhs.getClassName();
            this.myFileName = rhs.getFileName();
            this.myMethodName = rhs.getMethodName();
            this.mySignature = rhs.getSignature();
            this.myMethodParameters = rhs.getMethodParameters();
            this.myLineNumber = rhs.getLineNumber();
            this.myNativeCode = rhs.myNativeCode;
            this.myNativeVAddress = rhs.myNativeVAddress;
            this.myNativeModuleName = rhs.myNativeModuleName;
        }

        @NotNull
        public Builder setFileName(@Nullable String fileName) {
            this.myFileName = StringUtil.nullize((String)fileName);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setMethodName(@Nullable String methodName) {
            this.myMethodName = StringUtil.nullize((String)methodName);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setMethodSignature(@NotNull String signature) {
            if (signature == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.mySignature = signature;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setMethodParameters(@NotNull List<String> methodParameters) {
            if (methodParameters == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myMethodParameters = methodParameters;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setLineNumber(int lineNumber) {
            this.myLineNumber = lineNumber;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        public Builder setNativeCode(boolean nativeCode) {
            this.myNativeCode = nativeCode;
            return this;
        }

        public Builder setNativeVAddress(long nativeVAddress) {
            this.myNativeVAddress = nativeVAddress;
            return this;
        }

        public Builder setNativeModuleName(String name) {
            this.myNativeModuleName = name;
            return this;
        }

        @NotNull
        public CodeLocation build() {
            return new CodeLocation(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rhs";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/inspectors/common/api/stacktrace/CodeLocation$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/inspectors/common/api/stacktrace/CodeLocation$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFileName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethodName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethodSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethodParameters";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLineNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setMethodSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setMethodParameters";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

