/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.features;

import com.intellij.filePrediction.features.history.FileHistoryManagerWrapper;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereClassOrFileFeaturesProvider;
import com.intellij.ide.actions.searcheverywhere.ml.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.ide.actions.searcheverywhere.ml.features.statistician.SearchEverywhereStatisticianStats;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereClassOrFileFeaturesProvider;", "()V", "getElementFeatures", "", "", "", "element", "Lcom/intellij/psi/PsiElement;", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "currentTime", "", "searchQuery", "elementPriority", "", "cache", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereClassOrFileFeaturesProvider$Cache;", "getModificationTimeStats", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "getPredictionScore", "", "getRecentFilesIndex", "getStatisticianStats", "isFavorite", "", "isOpened", "matchesFileTypeInQuery", "(Lcom/intellij/psi/PsiFileSystemItem;Ljava/lang/String;)Ljava/lang/Boolean;", "Companion", "intellij.searchEverywhereMl"})
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereClassOrFileFeaturesProvider {
    @NotNull
    public static final String IS_DIRECTORY_DATA_KEY = "isDirectory";
    @NotNull
    public static final String FILETYPE_DATA_KEY = "fileType";
    @NotNull
    public static final String IS_FAVORITE_DATA_KEY = "isFavorite";
    @NotNull
    public static final String IS_OPENED_DATA_KEY = "isOpened";
    @NotNull
    public static final String RECENT_INDEX_DATA_KEY = "recentFilesIndex";
    @NotNull
    public static final String PREDICTION_SCORE_DATA_KEY = "predictionScore";
    @NotNull
    public static final String PRIORITY_DATA_KEY = "priority";
    @NotNull
    public static final String IS_EXACT_MATCH_DATA_KEY = "isExactMatch";
    @NotNull
    public static final String FILETYPE_MATCHES_QUERY_DATA_KEY = "fileTypeMatchesQuery";
    @NotNull
    public static final String STATISTICIAN_USE_COUNT_DATA_KEY = "statUseCount";
    @NotNull
    public static final String STATISTICIAN_IS_MOST_POPULAR_DATA_KEY = "statIsMostPopular";
    @NotNull
    public static final String STATISTICIAN_RECENCY_DATA_KEY = "statRecency";
    @NotNull
    public static final String STATISTICIAN_IS_MOST_RECENT_DATA_KEY = "statIsMostRecent";
    @NotNull
    public static final String TIME_SINCE_LAST_MODIFICATION_DATA_KEY = "timeSinceLastModification";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY = "wasModifiedInLastMinute";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY = "wasModifiedInLastHour";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_DAY_DATA_KEY = "wasModifiedInLastDay";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY = "wasModifiedInLastMonth";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Map<String, Object> getElementFeatures(@NotNull PsiElement element, @Nullable TargetPresentation presentation, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable SearchEverywhereClassOrFileFeaturesProvider.Cache cache) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiFileSystemItem)) {
            psiElement = null;
        }
        PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)psiElement;
        if (psiFileSystemItem == null) {
            return MapsKt.emptyMap();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        HashMap data = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)IS_FAVORITE_DATA_KEY, (Object)this.isFavorite(item)), TuplesKt.to((Object)IS_DIRECTORY_DATA_KEY, (Object)item.isDirectory()), TuplesKt.to((Object)PRIORITY_DATA_KEY, (Object)elementPriority), TuplesKt.to((Object)IS_EXACT_MATCH_DATA_KEY, (Object)(elementPriority == 5000 ? 1 : 0)), TuplesKt.to((Object)"totalSymbolsAmount", (Object)searchQuery.length())});
        data.putAll(this.getStatisticianStats(item));
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        String string = virtualFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.virtualFile.nameWithoutExtension");
        String nameOfItem = string;
        String string2 = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)searchQuery));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getNameWithoutE\u2026getFileName(searchQuery))");
        String fileNameFromQuery = string2;
        data.putAll(this.getNameMatchingFeatures(nameOfItem, fileNameFromQuery));
        if (item.isDirectory()) {
            return data;
        }
        ((Map)data).put(IS_OPENED_DATA_KEY, this.isOpened(item));
        Map map = data;
        VirtualFile virtualFile2 = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"item.virtualFile");
        FileType fileType = virtualFile2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"item.virtualFile.fileType");
        String string3 = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.virtualFile.fileType.name");
        map.put(FILETYPE_DATA_KEY, string3);
        this.putIfValueNotNull(data, FILETYPE_MATCHES_QUERY_DATA_KEY, this.matchesFileTypeInQuery(item, searchQuery));
        ((Map)data).put(RECENT_INDEX_DATA_KEY, this.getRecentFilesIndex(item));
        ((Map)data).put(PREDICTION_SCORE_DATA_KEY, this.getPredictionScore(item));
        data.putAll(this.getModificationTimeStats(item, currentTime));
        return data;
    }

    private final boolean isFavorite(PsiFileSystemItem item) {
        FavoritesManager favoritesManager = FavoritesManager.getInstance((Project)item.getProject());
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(favoritesManager, item){
            final /* synthetic */ FavoritesManager $favoritesManager;
            final /* synthetic */ PsiFileSystemItem $item;

            public final Boolean compute() {
                return this.$favoritesManager.getFavoriteListName(null, this.$item.getVirtualFile()) != null;
            }
            {
                this.$favoritesManager = favoritesManager;
                this.$item = psiFileSystemItem;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Boole\u2026em.virtualFile) != null }");
        return (Boolean)object;
    }

    private final Map<String, Object> getStatisticianStats(PsiFileSystemItem item) {
        Object object;
        block3: {
            block2: {
                SearchEverywhereStatisticianStats searchEverywhereStatisticianStats;
                Project project2 = item.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"item.project");
                SearchEverywhereStatisticianService statisticianService = SearchEverywhereStatisticianService.Companion.getInstance(project2);
                object = statisticianService.getCombinedStats(item);
                if (object == null) break block2;
                SearchEverywhereStatisticianStats stats = searchEverywhereStatisticianStats = object;
                boolean bl = false;
                object = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)STATISTICIAN_USE_COUNT_DATA_KEY, (Object)stats.getUseCount()), TuplesKt.to((Object)STATISTICIAN_IS_MOST_POPULAR_DATA_KEY, (Object)stats.isMostPopular()), TuplesKt.to((Object)STATISTICIAN_RECENCY_DATA_KEY, (Object)stats.getRecency()), TuplesKt.to((Object)STATISTICIAN_IS_MOST_RECENT_DATA_KEY, (Object)stats.isMostRecent())});
                if (object != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final boolean isOpened(PsiFileSystemItem item) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(item.project)");
        Object[] openedFiles = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)openedFiles, (String)"openedFiles");
        return ArraysKt.contains((Object[])openedFiles, (Object)item.getVirtualFile());
    }

    private final Boolean matchesFileTypeInQuery(PsiFileSystemItem item, String searchQuery) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        String fileExtension = virtualFile.getExtension();
        String extensionInQuery = StringsKt.substringAfterLast((String)searchQuery, (char)'.', (String)"");
        CharSequence charSequence = extensionInQuery;
        if (charSequence.length() == 0 || fileExtension == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionInQuery, (Object)fileExtension);
    }

    private final int getRecentFilesIndex(PsiFileSystemItem item) {
        EditorHistoryManager historyManager;
        EditorHistoryManager editorHistoryManager = historyManager = EditorHistoryManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)editorHistoryManager, (String)"historyManager");
        List list = editorHistoryManager.getFileList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"historyManager.fileList");
        List recentFilesList = list;
        int fileIndex = recentFilesList.indexOf(item.getVirtualFile());
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    private final Map<String, Object> getModificationTimeStats(PsiFileSystemItem item, long currentTime) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        long timeSinceLastMod = currentTime - virtualFile.getTimeStamp();
        return MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)TIME_SINCE_LAST_MODIFICATION_DATA_KEY, (Object)timeSinceLastMod), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY, (Object)(timeSinceLastMod <= (long)60000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY, (Object)(timeSinceLastMod <= (long)3600000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_DAY_DATA_KEY, (Object)(timeSinceLastMod <= (long)86400000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY, (Object)(timeSinceLastMod <= 2419200000L ? 1 : 0))});
    }

    private final double getPredictionScore(PsiFileSystemItem item) {
        Project project2 = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"item.project");
        FileHistoryManagerWrapper historyManagerWrapper = FileHistoryManagerWrapper.Companion.getInstance(project2);
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        double probability = historyManagerWrapper.calcNextFileProbability(virtualFile);
        return this.roundDouble$intellij_searchEverywhereMl(probability);
    }

    public SearchEverywhereFileFeaturesProvider() {
        super(FileSearchEverywhereContributor.class, RecentFilesSEContributor.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider$Companion;", "", "()V", "FILETYPE_DATA_KEY", "", "FILETYPE_MATCHES_QUERY_DATA_KEY", "IS_DIRECTORY_DATA_KEY", "IS_EXACT_MATCH_DATA_KEY", "IS_FAVORITE_DATA_KEY", "IS_OPENED_DATA_KEY", "PREDICTION_SCORE_DATA_KEY", "PRIORITY_DATA_KEY", "RECENT_INDEX_DATA_KEY", "STATISTICIAN_IS_MOST_POPULAR_DATA_KEY", "STATISTICIAN_IS_MOST_RECENT_DATA_KEY", "STATISTICIAN_RECENCY_DATA_KEY", "STATISTICIAN_USE_COUNT_DATA_KEY", "TIME_SINCE_LAST_MODIFICATION_DATA_KEY", "WAS_MODIFIED_IN_LAST_DAY_DATA_KEY", "WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY", "WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY", "WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

