/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.features;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereVcsFileFeaturesProvider;", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereElementFeaturesProvider;", "()V", "getElementFeatures", "", "", "", "element", "currentTime", "", "searchQuery", "elementPriority", "", "cache", "getFileFeatures", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "Companion", "intellij.searchEverywhereMl"})
public final class SearchEverywhereVcsFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    private static final String IS_IGNORED_DATA_KEY = "isIgnored";
    private static final String IS_CHANGED_DATA_KEY = "isChanged";
    private static final String FILE_STATUS_DATA_KEY = "fileStatus";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Map<String, Object> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable Object cache) {
        PsiFileSystemItem psiFileSystemItem;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Object object = element;
        if (object instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            PsiElement psiElement = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)element).getItem();
            if (!(psiElement instanceof PsiFileSystemItem)) {
                psiElement = null;
            }
            if ((psiFileSystemItem = (PsiFileSystemItem)psiElement) == null) {
                return MapsKt.emptyMap();
            }
        } else if (object instanceof PsiFileSystemItem) {
            psiFileSystemItem = (PsiFileSystemItem)element;
        } else {
            return MapsKt.emptyMap();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        return this.getFileFeatures(item);
    }

    private final Map<String, Object> getFileFeatures(PsiFileSystemItem item) {
        if (item.isDirectory()) {
            return MapsKt.emptyMap();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(item.project)");
        ChangeListManager changeListManager2 = changeListManager;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)IS_CHANGED_DATA_KEY, (Object)changeListManager2.isFileAffected(item.getVirtualFile()));
        pairArray[1] = TuplesKt.to((Object)IS_IGNORED_DATA_KEY, (Object)changeListManager2.isIgnoredFile(item.getVirtualFile()));
        FileStatus fileStatus = changeListManager2.getStatus(item.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"changeListManager.getStatus(item.virtualFile)");
        pairArray[2] = TuplesKt.to((Object)FILE_STATUS_DATA_KEY, (Object)fileStatus.getId());
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    public SearchEverywhereVcsFileFeaturesProvider() {
        super(FileSearchEverywhereContributor.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereVcsFileFeaturesProvider$Companion;", "", "()V", "FILE_STATUS_DATA_KEY", "", "IS_CHANGED_DATA_KEY", "IS_IGNORED_DATA_KEY", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

