/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.model;

import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereTabWithMl;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeaturesInfo;
import com.intellij.internal.ml.ModelMetadataReader;
import com.intellij.internal.ml.models.local.LocalRandomForestModel;
import com.intellij.internal.ml.models.local.ZipModelMetadataReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.io.Closeable;
import java.util.Locale;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0015\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/model/LocalRankingModelProviderUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLocalModel", "Lcom/intellij/internal/ml/DecisionFunction;", "contributorId", "", "getPath", "tab", "Lcom/intellij/ide/actions/searcheverywhere/ml/SearchEverywhereTabWithMl;", "getRegistryKey", "isPathToLocalModelSpecified", "", "tabId", "loadLocalModelFromZip", "path", "intellij.searchEverywhereMl"})
public final class LocalRankingModelProviderUtil {
    private static final Logger LOG;
    @NotNull
    public static final LocalRankingModelProviderUtil INSTANCE;

    @Nullable
    public final DecisionFunction getLocalModel(@NotNull String contributorId) {
        Intrinsics.checkNotNullParameter((Object)contributorId, (String)"contributorId");
        SearchEverywhereTabWithMl searchEverywhereTabWithMl = SearchEverywhereTabWithMl.Companion.findById(contributorId);
        if (searchEverywhereTabWithMl == null) {
            return null;
        }
        SearchEverywhereTabWithMl tab = searchEverywhereTabWithMl;
        if (!this.isPathToLocalModelSpecified(tab)) {
            return null;
        }
        String path = this.getPath(tab);
        return this.loadLocalModelFromZip(path);
    }

    public final boolean isPathToLocalModelSpecified(@NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        SearchEverywhereTabWithMl searchEverywhereTabWithMl = SearchEverywhereTabWithMl.Companion.findById(tabId);
        if (searchEverywhereTabWithMl == null) {
            return false;
        }
        SearchEverywhereTabWithMl tab = searchEverywhereTabWithMl;
        return this.isPathToLocalModelSpecified(tab);
    }

    private final boolean isPathToLocalModelSpecified(SearchEverywhereTabWithMl tab) {
        RegistryValue registryValue = Registry.get((String)this.getRegistryKey(tab));
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(getRegistryKey(tab))");
        return registryValue.isChangedFromDefault();
    }

    private final String getRegistryKey(SearchEverywhereTabWithMl tab) {
        String string = tab.name();
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return "search.everywhere.ml." + string2 + ".model.path";
    }

    private final String getPath(SearchEverywhereTabWithMl tab) {
        String string = Registry.stringValue((String)this.getRegistryKey(tab));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Registry.stringValue(getRegistryKey(tab))");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DecisionFunction loadLocalModelFromZip(String path) {
        try {
            Closeable closeable = new ZipFile(path);
            Throwable throwable = null;
            try {
                ZipFile file = (ZipFile)closeable;
                boolean bl = false;
                ZipModelMetadataReader metadataReader = new ZipModelMetadataReader(file);
                FeaturesInfo metadata = FeaturesInfo.Companion.buildInfo((ModelMetadataReader)metadataReader);
                String modelText = metadataReader.resourceContent("model.txt");
                DecisionFunction decisionFunction = LocalRandomForestModel.Companion.loadModel(modelText, metadata);
                return decisionFunction;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            return null;
        }
    }

    private LocalRankingModelProviderUtil() {
    }

    static {
        LocalRankingModelProviderUtil localRankingModelProviderUtil;
        INSTANCE = localRankingModelProviderUtil = new LocalRankingModelProviderUtil();
        Logger logger = Logger.getInstance(localRankingModelProviderUtil.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this.javaClass)");
        LOG = logger;
    }
}

