/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.gradle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.BuildSystemType;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ModuleTransformer;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleModuleTransformer;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleModuleTransformerKt;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleProjectModuleType;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J*\u0010\u001a\u001a\u00020\u001b*\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010!\u001a\u00020\u0011*\u00020\u000fH\u0002\u00a8\u0006#"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/GradleModuleTransformer;", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ModuleTransformer;", "()V", "createNavigatableDependencyCallback", "Lkotlin/Function3;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findExternalProjectOrNull", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "module", "Lcom/intellij/openapi/module/Module;", "recursiveSearch", "", "getAllSubmodules", "", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;", "rootModule", "isKotlinDsl", "buildVirtualFile", "transformModules", "nativeModules", "addChildrenToListRecursive", "", "modules", "", "currentModule", "findProjectWithId", "externalProjectId", "isNotGradleSourceSetModule", "Companion", "intellij.packageSearch.gradle"})
public final class GradleModuleTransformer
implements ModuleTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProjectModule> transformModules(@NotNull Project project, @NotNull List<? extends Module> nativeModules) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(nativeModules, (String)"nativeModules");
        Iterable $this$filter$iv = nativeModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Module)element$iv$iv;
            boolean bl = false;
            if (!this.isNotGradleSourceSetModule((Module)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ProjectModule projectModule;
            ProjectModule projectModule2;
            ExternalProject externalProject;
            ProjectModule projectModule3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Module nativeModule = (Module)element$iv$iv;
            boolean bl2 = false;
            if (this.findExternalProjectOrNull(project, nativeModule, false) == null) {
                projectModule3 = null;
            } else if (externalProject.getBuildFile() == null) {
                projectModule3 = null;
            } else {
                File buildFile;
                Intrinsics.checkNotNullExpressionValue((Object)buildFile, (String)"externalProject.buildFil\u2026?: return@mapNotNull null");
                if (LocalFileSystem.getInstance().findFileByPath(buildFile.getAbsolutePath()) == null) {
                    projectModule3 = null;
                } else {
                    VirtualFile buildVirtualFile;
                    Intrinsics.checkNotNullExpressionValue((Object)buildVirtualFile, (String)"LocalFileSystem.getInsta\u2026?: return@mapNotNull null");
                    BuildSystemType buildSystemType = this.isKotlinDsl(project, buildVirtualFile) ? BuildSystemType.Companion.getGRADLE_KOTLIN() : BuildSystemType.Companion.getGRADLE_GROOVY();
                    Object object = GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(nativeModule);
                    if (object == null || (object = ((GradleExtensionsSettings.GradleExtensionsData)object).configurations) == null || (object = object.keySet()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    Object scopes = object;
                    String string = externalProject.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalProject.name");
                    projectModule3 = projectModule2 = new ProjectModule(string, nativeModule, null, buildVirtualFile, buildSystemType, GradleProjectModuleType.INSTANCE, this.createNavigatableDependencyCallback(project, buildVirtualFile), (List<String>)scopes);
                }
            }
            if (projectModule2 == null) continue;
            ProjectModule it$iv$iv = projectModule = projectModule2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ProjectModule)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAllSubmodules(project, (ProjectModule)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<VirtualFile> set$iv = new HashSet<VirtualFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ProjectModule it2 = (ProjectModule)e$iv;
            boolean bl = false;
            VirtualFile key$iv = it2.getBuildFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private final boolean isKotlinDsl(Project project, VirtualFile buildVirtualFile) {
        Object object;
        GradleModuleTransformer gradleModuleTransformer = this;
        try {
            object = Result.Companion;
            GradleModuleTransformer $this$runCatching = gradleModuleTransformer;
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(buildVirtualFile);
            object = Result.constructor-impl((Object)psiFile);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        gradleModuleTransformer = object;
        Object object2 = (PsiFile)(Result.isFailure-impl((Object)gradleModuleTransformer) ? null : gradleModuleTransformer);
        return object2 != null && (object2 = object2.getLanguage()) != null && (object2 = object2.getDisplayName()) != null && StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"kotlin", (boolean)true);
    }

    private final boolean isNotGradleSourceSetModule(Module $this$isNotGradleSourceSetModule) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)$this$isNotGradleSourceSetModule)) {
            return false;
        }
        return Intrinsics.areEqual((Object)ExternalSystemApiUtil.getExternalModuleType((Module)$this$isNotGradleSourceSetModule), (Object)"sourceSet") ^ true;
    }

    private final List<ProjectModule> getAllSubmodules(Project project, ProjectModule rootModule) {
        ExternalProject externalProject = GradleModuleTransformer.findExternalProjectOrNull$default(this, project, rootModule.getNativeModule(), false, 4, null);
        if (externalProject == null) {
            return CollectionsKt.emptyList();
        }
        ExternalProject externalRootProject = externalProject;
        List modules = CollectionsKt.mutableListOf((Object[])new ProjectModule[]{rootModule});
        this.addChildrenToListRecursive(externalRootProject, modules, rootModule, project);
        return modules;
    }

    private final ExternalProject findExternalProjectOrNull(Project project, Module module, boolean recursiveSearch) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;

                @NotNull
                public final String invoke() {
                    return "Module has no external project ID, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
                {
                    this.$project = project;
                    this.$module = module;
                    super(0);
                }
            }));
            return null;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;

                @NotNull
                public final String invoke() {
                    return "Root external project was not yet imported, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
                {
                    this.$project = project;
                    this.$module = module;
                    super(0);
                }
            }));
            return null;
        }
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance((Project)project);
        ExternalProject externalProject = externalProjectDataCache.getRootExternalProject(rootProjectPath);
        if (externalProject == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;

                @NotNull
                public final String invoke() {
                    return "External project is not yet cached, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
                {
                    this.$project = project;
                    this.$module = module;
                    super(0);
                }
            }));
            return null;
        }
        return this.findProjectWithId(externalProject, externalProjectId, recursiveSearch);
    }

    static /* synthetic */ ExternalProject findExternalProjectOrNull$default(GradleModuleTransformer gradleModuleTransformer, Project project, Module module, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return gradleModuleTransformer.findExternalProjectOrNull(project, module, bl);
    }

    private final ExternalProject findProjectWithId(ExternalProject $this$findProjectWithId, String externalProjectId, boolean recursiveSearch) {
        if (Intrinsics.areEqual((Object)externalProjectId, (Object)$this$findProjectWithId.getId())) {
            return $this$findProjectWithId;
        }
        if (!recursiveSearch) {
            return null;
        }
        Collection childExternalProjects = $this$findProjectWithId.getChildProjects().values();
        if (childExternalProjects.isEmpty()) {
            return null;
        }
        Iterator iterator = childExternalProjects.iterator();
        while (iterator.hasNext()) {
            ExternalProject childExternalProject;
            ExternalProject externalProject = childExternalProject = (ExternalProject)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)externalProject, (String)"childExternalProject");
            if (Intrinsics.areEqual((Object)externalProject.getId(), (Object)externalProjectId)) {
                return childExternalProject;
            }
            ExternalProject recursiveExternalProject = this.findProjectWithId(childExternalProject, externalProjectId, recursiveSearch);
            if (recursiveExternalProject == null) continue;
            return recursiveExternalProject;
        }
        return null;
    }

    private final void addChildrenToListRecursive(ExternalProject $this$addChildrenToListRecursive, List<ProjectModule> modules, ProjectModule currentModule, Project project) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Iterator iterator = $this$addChildrenToListRecursive.getChildProjects().values().iterator();
        while (iterator.hasNext()) {
            Module nativeModule;
            Object object;
            ExternalProject externalProject;
            ExternalProject externalProject2 = externalProject = (ExternalProject)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)externalProject2, (String)"externalProject");
            Object object2 = externalProject2.getBuildFile();
            if (object2 == null || (object2 = ((File)object2).getAbsolutePath()) == null) continue;
            Object p1 = object = object2;
            boolean bl = false;
            object2 = localFileSystem.findFileByPath((String)p1);
            if (object2 == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"externalProject.buildFil\u2026              ?: continue");
            Object projectBuildFile = object2;
            if (ModuleUtilCore.findModuleForFile((VirtualFile)projectBuildFile, (Project)project) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)nativeModule, (String)"ModuleUtilCore.findModul\u2026              ?: continue");
            String string = externalProject.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalProject.name");
            ProjectModule projectModule = new ProjectModule(string, nativeModule, currentModule, (VirtualFile)projectBuildFile, BuildSystemType.Companion.getGRADLE_GROOVY(), GradleProjectModuleType.INSTANCE, this.createNavigatableDependencyCallback(project, (VirtualFile)projectBuildFile), CollectionsKt.emptyList());
            Collection collection = modules;
            collection.add(projectModule);
            this.addChildrenToListRecursive(externalProject, modules, projectModule, project);
        }
    }

    private final Function3<String, String, PackageVersion, Navigatable> createNavigatableDependencyCallback(Project project, VirtualFile file) {
        return (Function3)new Function3<String, String, PackageVersion, Navigatable>(project, file){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            @Nullable
            public final Navigatable invoke(@NotNull String groupId, @NotNull String artifactId, @NotNull PackageVersion $noName_2) {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"<anonymous parameter 2>");
                boolean $i$f$runReadAction = false;
                return (Navigatable)ApplicationManager.getApplication().runReadAction(new Computable(this, groupId, artifactId){
                    final /* synthetic */ createNavigatableDependencyCallback.1 this$0;
                    final /* synthetic */ String $groupId$inlined;
                    final /* synthetic */ String $artifactId$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$groupId$inlined = string;
                        this.$artifactId$inlined = string2;
                    }

                    public final T compute() {
                        Navigatable navigatable;
                        boolean bl = false;
                        PsiFile psiFile = PsiManager.getInstance((Project)this.this$0.$project).findFile(this.this$0.$file);
                        if (psiFile != null) {
                            PsiFile psiFile2;
                            PsiFile psiFile3 = psiFile2 = psiFile;
                            boolean bl2 = false;
                            PsiFile psiFile4 = psiFile3;
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"psiFile");
                            PsiElement psiElement = GradleModuleTransformer.Companion.findDependencyElement(psiFile4, this.$groupId$inlined, this.$artifactId$inlined);
                            if (psiElement == null) {
                                navigatable = null;
                            } else {
                                PsiElement dependencyElement;
                                PsiElement psiElement2 = dependencyElement = psiElement;
                                if (psiElement2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.pom.Navigatable");
                                }
                                navigatable = (Navigatable)psiElement2;
                            }
                        } else {
                            navigatable = null;
                        }
                        return (T)navigatable;
                    }
                });
            }
            {
                this.$project = project;
                this.$file = virtualFile;
                super(3);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/GradleModuleTransformer$Companion;", "", "()V", "findDependencyElement", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "groupId", "", "artifactId", "intellij.packageSearch.gradle"})
    public static final class Companion {
        @Nullable
        public final PsiElement findDependencyElement(@NotNull PsiFile file, @NotNull String groupId, @NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            boolean isKotlinDependencyInKts = Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(file.getLanguage().getClass()).getQualifiedName(), (Object)"org.jetbrains.kotlin.idea.KotlinLanguage") && Intrinsics.areEqual((Object)groupId, (Object)"org.jetbrains.kotlin") && StringsKt.startsWith$default((String)artifactId, (String)"kotlin-", (boolean)false, (int)2, null);
            String textToSearchFor = isKotlinDependencyInKts ? "kotlin(\"" + StringsKt.removePrefix((String)artifactId, (CharSequence)"kotlin-") + "\")" : groupId + ":" + artifactId;
            return GradleModuleTransformerKt.access$firstElementContainingExactly(file, textToSearchFor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

