/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MergingLogRewriter
implements MessageReceiver {
    private final MessageReceiver mMessageReceiver;
    private final Function<SourceFilePosition, SourceFilePosition> mGetOriginalPosition;

    public MergingLogRewriter(Function<SourceFilePosition, SourceFilePosition> mergingLogLookup, MessageReceiver messageReceiver) {
        this.mMessageReceiver = messageReceiver;
        this.mGetOriginalPosition = mergingLogLookup;
    }

    @Override
    public void receiveMessage(Message message) {
        List originalPositions = message.getSourceFilePositions();
        Iterable positions = originalPositions.stream().map(this.mGetOriginalPosition).collect(Collectors.toList());
        this.mMessageReceiver.receiveMessage(new Message(message.getKind(), message.getText(), message.getRawMessage(), message.getToolName(), ImmutableList.copyOf((Iterable)positions)));
    }

    public static Function<SourceFilePosition, SourceFilePosition> rewriteDir(File from, File to) {
        return input -> {
            File file = input.getFile().getSourceFile();
            if (file != null && file.toPath().startsWith(from.toPath())) {
                return new SourceFilePosition(new SourceFile(to.toPath().resolve(from.toPath().relativize(file.toPath())).toFile()), input.getPosition());
            }
            return input;
        };
    }
}

