/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.util.ReplacementUtil;

public abstract class AbstractCall
implements LocationInfoProvider {
    protected int typeArguments;
    protected String expression;
    protected List<String> arguments;
    protected LocationInfo locationInfo;
    protected StatementCoverageType coverage = StatementCoverageType.NONE;

    private static boolean equalsIgnoringExtraParenthesis(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        String parenthesizedS1 = "(" + s1 + ")";
        if (parenthesizedS1.equals(s2)) {
            return true;
        }
        String parenthesizedS2 = "(" + s2 + ")";
        return parenthesizedS2.equals(s1);
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public StatementCoverageType getCoverage() {
        return this.coverage;
    }

    public abstract boolean identicalName(AbstractCall var1);

    public abstract String getName();

    public abstract double normalizedNameDistance(AbstractCall var1);

    public abstract AbstractCall update(String var1, String var2);

    public String actualString() {
        StringBuilder sb = new StringBuilder();
        if (this.expression != null) {
            sb.append(this.expression).append(".");
        }
        sb.append(this.getName());
        sb.append("(");
        int size = this.arguments.size();
        if (size > 0) {
            for (int i = 0; i < size - 1; ++i) {
                sb.append(this.arguments.get(i)).append(",");
            }
            sb.append(this.arguments.get(size - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean expressionIsNullOrThis() {
        if (this.expression == null) {
            return true;
        }
        return this.expression.equals("this");
    }

    public boolean identicalExpression(AbstractCall call, Set<Replacement> replacements) {
        return this.identicalExpression(call) || this.identicalExpressionAfterTypeReplacements(call, replacements);
    }

    public boolean identicalExpression(AbstractCall call) {
        return this.getExpression() != null && call.getExpression() != null && this.getExpression().equals(call.getExpression()) || this.getExpression() == null && call.getExpression() == null;
    }

    private boolean identicalExpressionAfterTypeReplacements(AbstractCall call, Set<Replacement> replacements) {
        if (this.getExpression() != null && call.getExpression() != null) {
            String expression1 = this.getExpression();
            String expression2 = call.getExpression();
            String expression1AfterReplacements = expression1;
            for (Replacement replacement : replacements) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) continue;
                expression1AfterReplacements = ReplacementUtil.performReplacement(expression1AfterReplacements, expression2, replacement.getBefore(), replacement.getAfter());
            }
            return expression1AfterReplacements.equals(expression2);
        }
        return false;
    }

    public boolean identicalWithMergedArguments(AbstractCall call, Set<Replacement> replacements) {
        if (this.onlyArgumentsChanged(call, replacements)) {
            ArrayList<String> updatedArguments1 = new ArrayList<String>(this.arguments);
            LinkedHashMap commonVariableReplacementMap = new LinkedHashMap();
            for (Replacement replacement : replacements) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                String key = replacement.getAfter();
                if (commonVariableReplacementMap.containsKey(key)) {
                    ((Set)commonVariableReplacementMap.get(key)).add(replacement);
                    int index = updatedArguments1.indexOf(replacement.getBefore());
                    if (index == -1) continue;
                    updatedArguments1.remove(index);
                    continue;
                }
                LinkedHashSet<Replacement> r = new LinkedHashSet<Replacement>();
                r.add(replacement);
                commonVariableReplacementMap.put(key, r);
                int index = updatedArguments1.indexOf(replacement.getBefore());
                if (index == -1) continue;
                updatedArguments1.remove(index);
                updatedArguments1.add(index, key);
            }
            if (updatedArguments1.equals(call.arguments)) {
                for (String key : commonVariableReplacementMap.keySet()) {
                    Set r = (Set)commonVariableReplacementMap.get(key);
                    if (r.size() <= 1) continue;
                    replacements.removeAll(r);
                }
                return true;
            }
        }
        return false;
    }

    public boolean identicalOrWrappedArguments(AbstractCall call) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument2;
            boolean argumentWrapped;
            String argument1 = arguments1.get(i);
            boolean bl = argumentWrapped = argument1.contains("(" + (argument2 = arguments2.get(i)) + ")") || argument2.contains("(" + argument1 + ")");
            if (argument1.equals(argument2) || argumentWrapped) continue;
            return false;
        }
        return true;
    }

    public boolean equalArguments(AbstractCall call) {
        return this.getArguments().equals(call.getArguments());
    }

    public boolean identicalOrReplacedArguments(AbstractCall call, Set<Replacement> replacements, List<UMLOperationBodyMapper> lambdaMappers) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentReplacement = false;
            for (Replacement replacement : replacements) {
                if (!replacement.getBefore().equals(argument1) || !replacement.getAfter().equals(argument2)) continue;
                argumentReplacement = true;
                break;
            }
            boolean lambdaReplacement = false;
            if (argument1.contains("->") && argument2.contains("->")) {
                for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                    if (lambdaMapper.nonMappedElementsT1() != 0 || lambdaMapper.nonMappedElementsT2() != 0) continue;
                    lambdaReplacement = true;
                    break;
                }
            }
            if (argument1.equals(argument2) || argumentReplacement || lambdaReplacement) continue;
            return false;
        }
        return true;
    }

    public boolean identicalOrConcatenatedArguments(AbstractCall call) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentConcatenated = false;
            if ((argument1.contains("+") || argument2.contains("+")) && !argument1.contains("++") && !argument2.contains("++")) {
                LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(argument1.split("(\\s)*(\\+)(\\s)*")));
                LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(argument2.split("(\\s)*(\\+)(\\s)*")));
                LinkedHashSet<String> intersection = new LinkedHashSet<String>(tokens1);
                intersection.retainAll(tokens2);
                int size = intersection.size();
                int threshold = Math.max(tokens1.size(), tokens2.size()) - size;
                if (size > 0 && size >= threshold) {
                    argumentConcatenated = true;
                }
            }
            if (argument1.equals(argument2) || argumentConcatenated) continue;
            return false;
        }
        return true;
    }

    public boolean allArgumentsReplaced(AbstractCall call, Set<Replacement> replacements) {
        int replacedArguments = 0;
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() == arguments2.size()) {
            block0: for (int i = 0; i < arguments1.size(); ++i) {
                String argument1 = arguments1.get(i);
                String argument2 = arguments2.get(i);
                for (Replacement replacement : replacements) {
                    if (!replacement.getBefore().equals(argument1) || !replacement.getAfter().equals(argument2)) continue;
                    ++replacedArguments;
                    continue block0;
                }
            }
        }
        return replacedArguments > 0 && replacedArguments == arguments1.size();
    }

    public boolean renamedWithIdenticalExpressionAndArguments(AbstractCall call, Set<Replacement> replacements, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean identicalOrReplacedArguments = this.identicalOrReplacedArguments(call, replacements, lambdaMappers);
        boolean allArgumentsReplaced = this.allArgumentsReplaced(call, replacements);
        return this.getExpression() != null && call.getExpression() != null && this.identicalExpression(call, replacements) && !this.identicalName(call) && (this.equalArguments(call) || allArgumentsReplaced && this.normalizedNameDistance(call) <= distance || identicalOrReplacedArguments && !allArgumentsReplaced);
    }

    public boolean renamedWithDifferentExpressionAndIdenticalArguments(AbstractCall call) {
        return (this.getName().contains(call.getName()) || call.getName().contains(this.getName())) && this.equalArguments(call) && this.arguments.size() > 0 && (this.getExpression() == null && call.getExpression() != null || call.getExpression() == null && this.getExpression() != null);
    }

    public boolean renamedWithIdenticalArgumentsAndNoExpression(AbstractCall call, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (UMLClassBaseDiff.allMappingsAreExactMatches(lambdaMapper)) continue;
            allExactLambdaMappers = false;
            break;
        }
        return this.getExpression() == null && call.getExpression() == null && !this.identicalName(call) && (this.normalizedNameDistance(call) <= distance || allExactLambdaMappers) && this.equalArguments(call);
    }

    public boolean renamedWithIdenticalExpressionAndDifferentNumberOfArguments(AbstractCall call, Set<Replacement> replacements, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (UMLClassBaseDiff.allMappingsAreExactMatches(lambdaMapper)) continue;
            allExactLambdaMappers = false;
            break;
        }
        return this.getExpression() != null && call.getExpression() != null && this.identicalExpression(call, replacements) && (this.normalizedNameDistance(call) <= distance || allExactLambdaMappers) && !this.equalArguments(call) && this.getArguments().size() != call.getArguments().size();
    }

    private boolean onlyArgumentsChanged(AbstractCall call, Set<Replacement> replacements) {
        return this.identicalExpression(call, replacements) && this.identicalName(call) && !this.equalArguments(call) && this.getArguments().size() != call.getArguments().size();
    }

    public boolean identicalWithDifferentNumberOfArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        if (this.onlyArgumentsChanged(call, replacements)) {
            int argumentIntersectionSize = this.argumentIntersectionSize(call, parameterToArgumentMap);
            return argumentIntersectionSize > 0 || this.getArguments().size() == 0 || call.getArguments().size() == 0;
        }
        return false;
    }

    public boolean identical(AbstractCall call, Set<Replacement> replacements, List<UMLOperationBodyMapper> lambdaMappers) {
        return this.identicalExpression(call, replacements) && this.identicalName(call) && (this.equalArguments(call) || this.onlyLambdaArgumentsDiffer(call, lambdaMappers));
    }

    private boolean onlyLambdaArgumentsDiffer(AbstractCall call, List<UMLOperationBodyMapper> lambdaMappers) {
        if (lambdaMappers.size() > 0) {
            List<String> arguments1 = this.getArguments();
            List<String> arguments2 = call.getArguments();
            if (arguments1.size() == arguments2.size()) {
                for (int i = 0; i < arguments1.size(); ++i) {
                    String argument1 = arguments1.get(i);
                    String argument2 = arguments2.get(i);
                    if (argument1.contains("->") && argument2.contains("->")) {
                        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                            if (lambdaMapper.nonMappedElementsT1() == 0 && lambdaMapper.nonMappedElementsT2() == 0) continue;
                            return false;
                        }
                        continue;
                    }
                    if (argument1.equals(argument2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Set<String> argumentIntersection(AbstractCall call) {
        List<String> args1 = this.preprocessArguments(this.getArguments());
        List<String> args2 = this.preprocessArguments(call.getArguments());
        LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(args1);
        argumentIntersection.retainAll(args2);
        return argumentIntersection;
    }

    private List<String> preprocessArguments(List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : arguments) {
            if (arg.contains("\n")) {
                args.add(arg.substring(0, arg.indexOf("\n")));
                continue;
            }
            args.add(arg);
        }
        return args;
    }

    private int argumentIntersectionSize(AbstractCall call, Map<String, String> parameterToArgumentMap) {
        Set<String> argumentIntersection = this.argumentIntersection(call);
        int argumentIntersectionSize = argumentIntersection.size();
        for (String parameter : parameterToArgumentMap.keySet()) {
            String argument = parameterToArgumentMap.get(parameter);
            if (!this.getArguments().contains(argument) || !call.getArguments().contains(parameter)) continue;
            ++argumentIntersectionSize;
        }
        return argumentIntersectionSize;
    }

    private boolean argumentIsEqual(String statement) {
        return statement.endsWith("\n") && this.getArguments().size() == 1 && AbstractCall.equalsIgnoringExtraParenthesis(this.getArguments().get(0), statement.substring(0, statement.length() - 1));
    }

    private boolean argumentIsReturned(String statement) {
        return statement.startsWith("return ") && this.getArguments().size() == 1 && AbstractCall.equalsIgnoringExtraParenthesis(this.getArguments().get(0), statement.substring(7, statement.length() - 1));
    }

    public Replacement makeReplacementForReturnedArgument(String statement) {
        if (this.argumentIsReturned(statement)) {
            return new Replacement(this.getArguments().get(0), statement.substring(7, statement.length() - 1), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        if (this.argumentIsEqual(statement)) {
            return new Replacement(this.getArguments().get(0), statement.substring(0, statement.length() - 1), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        return null;
    }

    public Replacement makeReplacementForWrappedCall(String statement) {
        if (this.argumentIsReturned(statement)) {
            return new Replacement(statement.substring(7, statement.length() - 1), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        if (this.argumentIsEqual(statement)) {
            return new Replacement(statement.substring(0, statement.length() - 1), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        return null;
    }

    private boolean argumentIsAssigned(String statement) {
        return this.getArguments().size() == 1 && statement.contains("=") && statement.endsWith("\n") && AbstractCall.equalsIgnoringExtraParenthesis(this.getArguments().get(0), statement.substring(statement.indexOf("=") + 1, statement.length() - 1));
    }

    public Replacement makeReplacementForAssignedArgument(String statement) {
        if (this.argumentIsAssigned(statement)) {
            return new Replacement(statement.substring(statement.indexOf("=") + 1, statement.length() - 1), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION);
        }
        return null;
    }

    protected void update(AbstractCall newCall, String oldExpression, String newExpression) {
        newCall.typeArguments = this.typeArguments;
        newCall.expression = this.expression != null && this.expression.equals(oldExpression) ? newExpression : this.expression;
        newCall.arguments = new ArrayList<String>();
        for (String argument : this.arguments) {
            newCall.arguments.add(ReplacementUtil.performReplacement(argument, oldExpression, newExpression));
        }
    }

    @Override
    public CodeRange codeRange() {
        return this.getLocationInfo().codeRange();
    }

    public static enum StatementCoverageType {
        NONE,
        ONLY_CALL,
        RETURN_CALL,
        THROW_CALL,
        CAST_CALL,
        VARIABLE_DECLARATION_INITIALIZER_CALL;

    }
}

