/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LeafMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.ObjectCreationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.VariableReplacementWithMethodInvocation;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.InlineVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.util.ReplacementUtil;

public abstract class AbstractCodeMapping {
    private final AbstractCodeFragment fragment1;
    private final AbstractCodeFragment fragment2;
    private final UMLOperation operation1;
    private final UMLOperation operation2;
    private final Set<Replacement> replacements;
    private boolean identicalWithExtractedVariable;
    private boolean identicalWithInlinedVariable;

    public AbstractCodeMapping(AbstractCodeFragment fragment1, AbstractCodeFragment fragment2, UMLOperation operation1, UMLOperation operation2) {
        this.fragment1 = fragment1;
        this.fragment2 = fragment2;
        this.operation1 = operation1;
        this.operation2 = operation2;
        this.replacements = new LinkedHashSet<Replacement>();
    }

    public AbstractCodeFragment getFragment1() {
        return this.fragment1;
    }

    public AbstractCodeFragment getFragment2() {
        return this.fragment2;
    }

    public UMLOperation getOperation1() {
        return this.operation1;
    }

    public UMLOperation getOperation2() {
        return this.operation2;
    }

    public boolean isIdenticalWithExtractedVariable() {
        return this.identicalWithExtractedVariable;
    }

    public boolean isIdenticalWithInlinedVariable() {
        return this.identicalWithInlinedVariable;
    }

    public boolean isExact() {
        return (this.fragment1.getArgumentizedString().equals(this.fragment2.getArgumentizedString()) || this.fragment1.getString().equals(this.fragment2.getString()) || this.containsIdenticalOrCompositeReplacement()) && !this.isKeyword();
    }

    private boolean isKeyword() {
        return this.fragment1.getString().startsWith("return") || this.fragment1.getString().startsWith("break") || this.fragment1.getString().startsWith("continue");
    }

    private boolean containsIdenticalOrCompositeReplacement() {
        for (Replacement r : this.replacements) {
            if (r.getType().equals((Object)Replacement.ReplacementType.ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS) && r.getBefore().equals(r.getAfter())) {
                return true;
            }
            if (!r.getType().equals((Object)Replacement.ReplacementType.COMPOSITE)) continue;
            return true;
        }
        return false;
    }

    public void addReplacement(Replacement replacement) {
        this.replacements.add(replacement);
    }

    public void addReplacements(Set<Replacement> replacements) {
        this.replacements.addAll(replacements);
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public boolean containsReplacement(Replacement.ReplacementType type) {
        for (Replacement replacement : this.replacements) {
            if (!replacement.getType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public Set<Replacement.ReplacementType> getReplacementTypes() {
        LinkedHashSet<Replacement.ReplacementType> types = new LinkedHashSet<Replacement.ReplacementType>();
        for (Replacement replacement : this.replacements) {
            types.add(replacement.getType());
        }
        return types;
    }

    public void temporaryVariableAssignment(Set<Refactoring> refactorings) {
        if (this instanceof LeafMapping && this.getFragment1() instanceof AbstractExpression && this.getFragment2() instanceof StatementObject) {
            StatementObject statement = (StatementObject)this.getFragment2();
            List<VariableDeclaration> variableDeclarations = statement.getVariableDeclarations();
            boolean validReplacements = true;
            for (Replacement replacement : this.getReplacements()) {
                if (!(replacement instanceof MethodInvocationReplacement) && !(replacement instanceof ObjectCreationReplacement)) continue;
                validReplacements = false;
                break;
            }
            if (variableDeclarations.size() == 1 && validReplacements) {
                VariableDeclaration variableDeclaration = variableDeclarations.get(0);
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(variableDeclaration, this.operation1, this.operation2);
                this.processExtractVariableRefactoring(ref, refactorings);
                this.identicalWithExtractedVariable = true;
            }
        }
    }

    private boolean containsVariableNameReplacement(String variableName) {
        for (Replacement replacement : this.getReplacements()) {
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !replacement.getBefore().equals(variableName) && !replacement.getAfter().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    public void temporaryVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, Set<Refactoring> refactorings, UMLClassBaseDiff classDiff) {
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            OperationInvocation invocation;
            String variableName = declaration.getVariableName();
            AbstractExpression initializer = declaration.getInitializer();
            for (Replacement replacement : this.getReplacements()) {
                if (replacement.getAfter().startsWith(variableName + ".")) {
                    String suffixAfter = replacement.getAfter().substring(variableName.length());
                    if (replacement.getBefore().endsWith(suffixAfter)) {
                        String prefixBefore = replacement.getBefore().substring(0, replacement.getBefore().indexOf(suffixAfter));
                        if (initializer != null && (initializer.toString().equals(prefixBefore) || this.overlappingExtractVariable(initializer, prefixBefore, nonMappedLeavesT2, refactorings))) {
                            ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2);
                            this.processExtractVariableRefactoring(ref, refactorings);
                            if (this.getReplacements().size() == 1) {
                                this.identicalWithExtractedVariable = true;
                            }
                        }
                    }
                }
                if (!variableName.equals(replacement.getAfter()) || initializer == null || !initializer.toString().equals(replacement.getBefore()) && (!initializer.toString().equals("(" + declaration.getType() + ")" + replacement.getBefore()) || this.containsVariableNameReplacement(variableName)) && !this.reservedTokenMatch(initializer, replacement, replacement.getBefore()) && !this.overlappingExtractVariable(initializer, replacement.getBefore(), nonMappedLeavesT2, refactorings)) continue;
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2);
                this.processExtractVariableRefactoring(ref, refactorings);
                if (this.getReplacements().size() != 1) continue;
                this.identicalWithExtractedVariable = true;
            }
            if (classDiff == null || initializer == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
            for (Refactoring refactoring : classDiff.getRefactoringsBeforePostProcessing()) {
                if (!(refactoring instanceof RenameOperationRefactoring)) continue;
                RenameOperationRefactoring rename = (RenameOperationRefactoring)refactoring;
                if (!invocation.getMethodName().equals(rename.getRenamedOperation().getName())) continue;
                String initializerBeforeRename = initializer.getString().replace(rename.getRenamedOperation().getName(), rename.getOriginalOperation().getName());
                if (!this.getFragment1().getString().contains(initializerBeforeRename) || !this.getFragment2().getString().contains(variableName)) continue;
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2);
                this.processExtractVariableRefactoring(ref, refactorings);
            }
        }
        String argumentizedString = statement.getArgumentizedString();
        if (argumentizedString.contains("=")) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = argumentizedString.endsWith("\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1);
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getAfter()) || !initializer.equals(replacement.getBefore())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation2.getVariableDeclarationsInScope(this.fragment2.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2);
                    this.processExtractVariableRefactoring(ref, refactorings);
                    if (this.getReplacements().size() != 1) continue;
                    this.identicalWithExtractedVariable = true;
                }
            }
        }
    }

    private boolean reservedTokenMatch(AbstractExpression initializer, Replacement replacement, String replacedExpression) {
        OperationInvocation initializerInvocation = initializer.invocationCoveringEntireFragment();
        OperationInvocation replacementInvocation = replacement instanceof VariableReplacementWithMethodInvocation ? ((VariableReplacementWithMethodInvocation)replacement).getInvokedOperation() : null;
        boolean methodInvocationMatch = true;
        if (initializerInvocation != null && replacementInvocation != null) {
            if (!initializerInvocation.getName().equals(replacementInvocation.getName())) {
                methodInvocationMatch = false;
            }
        } else if (initializerInvocation != null) {
            methodInvocationMatch = false;
        } else if (replacementInvocation != null) {
            methodInvocationMatch = false;
        }
        String initializerReservedTokens = ReplacementUtil.keepReservedTokens(initializer.toString());
        String replacementReservedTokens = ReplacementUtil.keepReservedTokens(replacedExpression);
        return methodInvocationMatch && !initializerReservedTokens.isEmpty() && !initializerReservedTokens.equals(".()") && !initializerReservedTokens.equals(" ()") && initializerReservedTokens.equals(replacementReservedTokens);
    }

    private boolean overlappingExtractVariable(AbstractExpression initializer, String input, List<? extends AbstractCodeFragment> nonMappedLeavesT2, Set<Refactoring> refactorings) {
        String prefix2;
        String prefix1;
        String output = input;
        for (Refactoring ref : refactorings) {
            ExtractVariableRefactoring extractVariable;
            VariableDeclaration declaration;
            if (!(ref instanceof ExtractVariableRefactoring) || (declaration = (extractVariable = (ExtractVariableRefactoring)ref).getVariableDeclaration()).getInitializer() == null || !input.contains(declaration.getInitializer().toString())) continue;
            output = output.replace(declaration.getInitializer().toString(), declaration.getVariableName());
        }
        if (initializer.toString().equals(output)) {
            return true;
        }
        String longestCommonSuffix = PrefixSuffixUtils.longestCommonSuffix(initializer.toString(), input);
        if (!longestCommonSuffix.isEmpty() && longestCommonSuffix.startsWith(".") && ((prefix1 = initializer.toString().substring(0, initializer.toString().indexOf(longestCommonSuffix))).equals(prefix2 = input.substring(0, input.indexOf(longestCommonSuffix))) || !prefix1.toUpperCase().equals(prefix1) && !prefix2.toUpperCase().equals(prefix2))) {
            return true;
        }
        String longestCommonPrefix = PrefixSuffixUtils.longestCommonPrefix(initializer.toString(), input);
        if (!(longestCommonSuffix.isEmpty() || longestCommonPrefix.isEmpty() || longestCommonPrefix.equals(initializer.toString()) || longestCommonPrefix.equals(input) || longestCommonSuffix.equals(initializer.toString()) || longestCommonSuffix.equals(input) || longestCommonPrefix.length() + longestCommonSuffix.length() >= input.length() || longestCommonPrefix.length() + longestCommonSuffix.length() >= initializer.toString().length())) {
            String s1 = input.substring(longestCommonPrefix.length(), input.lastIndexOf(longestCommonSuffix));
            String s2 = initializer.toString().substring(longestCommonPrefix.length(), initializer.toString().lastIndexOf(longestCommonSuffix));
            for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
                VariableDeclaration variable = abstractCodeFragment.getVariableDeclaration(s2);
                if (variable == null || variable.getInitializer() == null || !variable.getInitializer().toString().equals(s1)) continue;
                return true;
            }
        }
        return false;
    }

    private void processExtractVariableRefactoring(ExtractVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                ((ExtractVariableRefactoring)refactoring).addReference(this);
                break;
            }
        }
    }

    public void inlinedVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, Set<Refactoring> refactorings) {
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            for (Replacement replacement : this.getReplacements()) {
                String variableName = declaration.getVariableName();
                AbstractExpression initializer = declaration.getInitializer();
                if (replacement.getBefore().startsWith(variableName + ".")) {
                    String suffixBefore = replacement.getBefore().substring(variableName.length());
                    if (replacement.getAfter().endsWith(suffixBefore)) {
                        String prefixAfter = replacement.getAfter().substring(0, replacement.getAfter().indexOf(suffixBefore));
                        if (initializer != null && (initializer.toString().equals(prefixAfter) || this.overlappingExtractVariable(initializer, prefixAfter, nonMappedLeavesT2, refactorings))) {
                            InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2);
                            this.processInlineVariableRefactoring(ref, refactorings);
                            if (this.getReplacements().size() == 1) {
                                this.identicalWithInlinedVariable = true;
                            }
                        }
                    }
                }
                if (!variableName.equals(replacement.getBefore()) || initializer == null || !initializer.toString().equals(replacement.getAfter()) && (!initializer.toString().equals("(" + declaration.getType() + ")" + replacement.getAfter()) || this.containsVariableNameReplacement(variableName)) && !this.reservedTokenMatch(initializer, replacement, replacement.getAfter()) && !this.overlappingExtractVariable(initializer, replacement.getAfter(), nonMappedLeavesT2, refactorings)) continue;
                InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2);
                this.processInlineVariableRefactoring(ref, refactorings);
                if (this.getReplacements().size() != 1) continue;
                this.identicalWithInlinedVariable = true;
            }
        }
        String argumentizedString = statement.getArgumentizedString();
        if (argumentizedString.contains("=")) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = null;
            initializer = argumentizedString.endsWith("\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1);
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getBefore()) || !initializer.equals(replacement.getAfter())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation1.getVariableDeclarationsInScope(this.fragment1.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2);
                    this.processInlineVariableRefactoring(ref, refactorings);
                    if (this.getReplacements().size() != 1) continue;
                    this.identicalWithInlinedVariable = true;
                }
            }
        }
    }

    private void processInlineVariableRefactoring(InlineVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                ((InlineVariableRefactoring)refactoring).addReference(this);
                break;
            }
        }
    }

    public String toString() {
        return this.fragment1.toString() + this.fragment2.toString();
    }

    public Set<Replacement> commonReplacements(AbstractCodeMapping other) {
        LinkedHashSet<Replacement> intersection = new LinkedHashSet<Replacement>(this.replacements);
        intersection.retainAll(other.replacements);
        return intersection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragment1 == null ? 0 : this.fragment1.hashCode());
        result = 31 * result + (this.fragment2 == null ? 0 : this.fragment2.hashCode());
        result = 31 * result + (this.operation1 == null ? 0 : this.operation1.hashCode());
        result = 31 * result + (this.operation2 == null ? 0 : this.operation2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCodeMapping other = (AbstractCodeMapping)obj;
        if (this.fragment1 == null ? other.fragment1 != null : !this.fragment1.equals(other.fragment1)) {
            return false;
        }
        if (this.fragment2 == null ? other.fragment2 != null : !this.fragment2.equals(other.fragment2)) {
            return false;
        }
        if (this.operation1 == null ? other.operation1 != null : !this.operation1.equals(other.operation1)) {
            return false;
        }
        if (this.operation2 == null) {
            return other.operation2 == null;
        }
        return this.operation2.equals(other.operation2);
    }
}

