/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;

public class TryStatementObject
extends CompositeStatementObject {
    private final List<CompositeStatementObject> catchClauses = new ArrayList<CompositeStatementObject>();
    private CompositeStatementObject finallyClause;

    public TryStatementObject(KtFile cu, String filePath, KtTryExpression statement, int depth) {
        super(cu, filePath, (KtElement)statement, depth, CodeElementType.TRY_STATEMENT);
    }

    public void addCatchClause(CompositeStatementObject catchClause) {
        this.catchClauses.add(catchClause);
    }

    public List<CompositeStatementObject> getCatchClauses() {
        return this.catchClauses;
    }

    public void setFinallyClause(CompositeStatementObject finallyClause) {
        this.finallyClause = finallyClause;
    }

    public CompositeStatementObject getFinallyClause() {
        return this.finallyClause;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>(super.getVariableDeclarations());
        for (CompositeStatementObject catchClause : this.catchClauses) {
            variableDeclarations.addAll(catchClause.getVariableDeclarations());
        }
        return variableDeclarations;
    }
}

