/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableReferenceExtractor;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeVariableTypeRefactoring;

public class TypeReplacementAnalysis {
    private final Set<AbstractCodeMapping> mappings;
    private final Set<ChangeVariableTypeRefactoring> changedTypes = new LinkedHashSet<ChangeVariableTypeRefactoring>();

    public TypeReplacementAnalysis(Set<AbstractCodeMapping> mappings) {
        this.mappings = mappings;
        this.findTypeChanges();
    }

    public Set<ChangeVariableTypeRefactoring> getChangedTypes() {
        return this.changedTypes;
    }

    private void findTypeChanges() {
        for (AbstractCodeMapping mapping : this.mappings) {
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            for (Replacement replacement : mapping.getReplacements()) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) continue;
                List<VariableDeclaration> declarations1 = fragment1.getVariableDeclarations();
                List<VariableDeclaration> declarations2 = fragment2.getVariableDeclarations();
                block2: for (VariableDeclaration declaration1 : declarations1) {
                    for (VariableDeclaration declaration2 : declarations2) {
                        if (!declaration1.getVariableName().equals(declaration2.getVariableName()) || declaration1.getType().equals(declaration2.getType()) && declaration1.getType().equalsQualified(declaration2.getType()) || this.containsVariableDeclarationWithSameNameAndType(declaration1, declarations2)) continue;
                        ChangeVariableTypeRefactoring ref = new ChangeVariableTypeRefactoring(declaration1, declaration2, mapping.getOperation1(), mapping.getOperation2(), VariableReferenceExtractor.findReferences(declaration1, declaration2, this.mappings));
                        this.changedTypes.add(ref);
                        continue block2;
                    }
                }
            }
        }
    }

    private boolean containsVariableDeclarationWithSameNameAndType(VariableDeclaration declaration, List<VariableDeclaration> declarations) {
        for (VariableDeclaration d : declarations) {
            if (!d.getVariableName().equals(declaration.getVariableName()) || !d.getType().equals(declaration.getType()) || !d.getType().equalsQualified(declaration.getType())) continue;
            return true;
        }
        return false;
    }
}

