/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.common.replacement.AddVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.replacement.IntersectionReplacement;
import org.jetbrains.research.kotlinrminer.common.replacement.MergeVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.common.replacement.SplitVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCall;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractStatement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AnonymousClassDeclarationObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObjectMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LeafMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationBody;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.TypeReplacementAnalysis;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableReplacementAnalysis;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.ClassInstanceCreationWithMethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.CompositeReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationWithClassInstanceCreationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.ObjectCreationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.VariableReplacementWithMethodInvocation;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLFileDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLParameterDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateMergeVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateSplitVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.kotlinrminer.ide.util.ReplacementUtil;

public class UMLOperationBodyMapper
implements Comparable<UMLOperationBodyMapper> {
    private final UMLOperation operation1;
    private final UMLOperation operation2;
    private final Set<AbstractCodeMapping> mappings;
    private final List<StatementObject> nonMappedLeavesT1;
    private final List<StatementObject> nonMappedLeavesT2;
    private final List<CompositeStatementObject> nonMappedInnerNodesT1;
    private final List<CompositeStatementObject> nonMappedInnerNodesT2;
    private final Set<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
    private final Set<CandidateAttributeRefactoring> candidateAttributeRenames = new LinkedHashSet<CandidateAttributeRefactoring>();
    private final Set<CandidateMergeVariableRefactoring> candidateAttributeMerges = new LinkedHashSet<CandidateMergeVariableRefactoring>();
    private final Set<CandidateSplitVariableRefactoring> candidateAttributeSplits = new LinkedHashSet<CandidateSplitVariableRefactoring>();
    private final List<UMLOperationBodyMapper> childMappers = new ArrayList<UMLOperationBodyMapper>();
    private UMLOperationBodyMapper parentMapper;
    private static final Pattern SPLIT_CONDITIONAL_PATTERN = Pattern.compile("(\\|\\|)|(&&)|(\\?)|(:)");
    public static final String SPLIT_CONCAT_STRING_PATTERN = "(\\s)*(\\+)(\\s)*";
    private static final Pattern DOUBLE_QUOTES = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private final UMLClassBaseDiff classDiff;
    private UMLFileDiff fileDiff;
    private UMLModelDiff modelDiff;
    private UMLOperation callSiteOperation;
    private final Map<AbstractCodeFragment, UMLOperation> codeFragmentOperationMap1 = new LinkedHashMap<AbstractCodeFragment, UMLOperation>();
    private final Map<AbstractCodeFragment, UMLOperation> codeFragmentOperationMap2 = new LinkedHashMap<AbstractCodeFragment, UMLOperation>();

    public UMLOperationBodyMapper(UMLOperation operation1, UMLOperation operation2, UMLClassBaseDiff classDiff) throws RefactoringMinerTimedOutException {
        this.classDiff = classDiff;
        this.fileDiff = null;
        if (classDiff != null) {
            this.modelDiff = classDiff.getModelDiff();
        }
        this.operation1 = operation1;
        this.operation2 = operation2;
        this.mappings = new LinkedHashSet<AbstractCodeMapping>();
        this.nonMappedLeavesT1 = new ArrayList<StatementObject>();
        this.nonMappedLeavesT2 = new ArrayList<StatementObject>();
        this.nonMappedInnerNodesT1 = new ArrayList<CompositeStatementObject>();
        this.nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>();
        OperationBody body1 = operation1.getBody();
        OperationBody body2 = operation2.getBody();
        if (body1 != null && body2 != null) {
            Iterator<StatementObject> removedParameter;
            List<UMLParameter> removedParameters;
            UMLParameter addedParameter;
            CompositeStatementObject composite1 = body1.getCompositeStatement();
            CompositeStatementObject composite2 = body2.getCompositeStatement();
            List<StatementObject> leaves1 = composite1.getLeaves();
            List<StatementObject> leaves2 = composite2.getLeaves();
            UMLOperationDiff operationDiff = new UMLOperationDiff(operation1, operation2);
            LinkedHashMap<String, String> parameterToArgumentMap1 = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> parameterToArgumentMap2 = new LinkedHashMap<String, String>();
            List<UMLParameter> addedParameters = operationDiff.getAddedParameters();
            if (addedParameters.size() == 1 && UMLModelDiff.looksLikeSameType((addedParameter = addedParameters.get(0)).getType().getClassType(), operation1.getClassName())) {
                parameterToArgumentMap1.put("this.", "");
                parameterToArgumentMap2.put(addedParameter.getName() + ".", "");
            }
            if ((removedParameters = operationDiff.getRemovedParameters()).size() == 1 && UMLModelDiff.looksLikeSameType(((UMLParameter)((Object)(removedParameter = removedParameters.get(0)))).getType().getClassType(), operation2.getClassName())) {
                parameterToArgumentMap1.put(((UMLParameter)((Object)removedParameter)).getName() + ".", "");
                parameterToArgumentMap2.put("this.", "");
            }
            this.resetNodes(leaves1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (StatementObject leave1 : leaves1) {
                    leave1.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(leaves2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (StatementObject leave2 : leaves2) {
                    leave2.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processLeaves(leaves1, leaves2, new LinkedHashMap<String, String>());
            List<CompositeStatementObject> innerNodes1 = composite1.getInnerNodes();
            innerNodes1.remove(composite1);
            List<CompositeStatementObject> innerNodes2 = composite2.getInnerNodes();
            innerNodes2.remove(composite2);
            this.resetNodes(innerNodes1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (CompositeStatementObject innerNode1 : innerNodes1) {
                    innerNode1.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(innerNodes2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (CompositeStatementObject innerNode2 : innerNodes2) {
                    innerNode2.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processInnerNodes(innerNodes1, innerNodes2, new LinkedHashMap<String, String>());
            this.nonMappedLeavesT1.addAll(leaves1);
            this.nonMappedLeavesT2.addAll(leaves2);
            this.nonMappedInnerNodesT1.addAll(innerNodes1);
            this.nonMappedInnerNodesT2.addAll(innerNodes2);
            for (StatementObject statement : this.getNonMappedLeavesT2()) {
                this.temporaryVariableAssignment(statement, this.nonMappedLeavesT2);
            }
            for (StatementObject statement : this.getNonMappedLeavesT1()) {
                this.inlinedVariableAssignment(statement, this.nonMappedLeavesT2);
            }
        }
    }

    private UMLOperationBodyMapper(LambdaExpressionObject lambda1, LambdaExpressionObject lambda2, UMLOperationBodyMapper parentMapper) throws RefactoringMinerTimedOutException {
        this.classDiff = parentMapper.classDiff;
        this.fileDiff = null;
        if (this.classDiff != null) {
            this.modelDiff = this.classDiff.getModelDiff();
        }
        this.operation1 = parentMapper.operation1;
        this.operation2 = parentMapper.operation2;
        this.mappings = new LinkedHashSet<AbstractCodeMapping>();
        this.nonMappedLeavesT1 = new ArrayList<StatementObject>();
        this.nonMappedLeavesT2 = new ArrayList<StatementObject>();
        this.nonMappedInnerNodesT1 = new ArrayList<CompositeStatementObject>();
        this.nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>();
        if (lambda1.getExpression() != null && lambda2.getExpression() != null) {
            ArrayList<AbstractExpression> leaves1 = new ArrayList<AbstractExpression>();
            leaves1.add(lambda1.getExpression());
            ArrayList<AbstractExpression> leaves2 = new ArrayList<AbstractExpression>();
            leaves2.add(lambda2.getExpression());
            this.processLeaves(leaves1, leaves2, new LinkedHashMap<String, String>());
        } else if (lambda1.getBody() != null && lambda2.getBody() != null) {
            CompositeStatementObject composite1 = lambda1.getBody().getCompositeStatement();
            CompositeStatementObject composite2 = lambda2.getBody().getCompositeStatement();
            List<StatementObject> leaves1 = composite1.getLeaves();
            List<StatementObject> leaves2 = composite2.getLeaves();
            this.processLeaves(leaves1, leaves2, new LinkedHashMap<String, String>());
            List<CompositeStatementObject> innerNodes1 = composite1.getInnerNodes();
            List<CompositeStatementObject> innerNodes2 = composite2.getInnerNodes();
            this.processInnerNodes(innerNodes1, innerNodes2, new LinkedHashMap<String, String>());
            this.nonMappedLeavesT1.addAll(leaves1);
            this.nonMappedLeavesT2.addAll(leaves2);
            this.nonMappedInnerNodesT1.addAll(innerNodes1);
            this.nonMappedInnerNodesT2.addAll(innerNodes2);
            for (StatementObject statement : this.getNonMappedLeavesT2()) {
                this.temporaryVariableAssignment(statement, this.nonMappedLeavesT2);
            }
            for (StatementObject statement : this.getNonMappedLeavesT1()) {
                this.inlinedVariableAssignment(statement, this.nonMappedLeavesT2);
            }
        }
    }

    public UMLOperationBodyMapper(UMLFileDiff fileDiff, UMLOperation operation1, UMLOperation operation2) throws RefactoringMinerTimedOutException {
        this.classDiff = null;
        this.fileDiff = fileDiff;
        if (fileDiff != null) {
            this.modelDiff = fileDiff.getModelDiff();
        }
        this.operation1 = operation1;
        this.operation2 = operation2;
        this.mappings = new LinkedHashSet<AbstractCodeMapping>();
        this.nonMappedLeavesT1 = new ArrayList<StatementObject>();
        this.nonMappedLeavesT2 = new ArrayList<StatementObject>();
        this.nonMappedInnerNodesT1 = new ArrayList<CompositeStatementObject>();
        this.nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>();
        OperationBody body1 = operation1.getBody();
        OperationBody body2 = operation2.getBody();
        if (body1 != null && body2 != null) {
            Iterator<StatementObject> removedParameter;
            List<UMLParameter> removedParameters;
            UMLParameter addedParameter;
            CompositeStatementObject composite1 = body1.getCompositeStatement();
            CompositeStatementObject composite2 = body2.getCompositeStatement();
            List<StatementObject> leaves1 = composite1.getLeaves();
            List<StatementObject> leaves2 = composite2.getLeaves();
            UMLOperationDiff operationDiff = new UMLOperationDiff(operation1, operation2);
            LinkedHashMap<String, String> parameterToArgumentMap1 = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> parameterToArgumentMap2 = new LinkedHashMap<String, String>();
            List<UMLParameter> addedParameters = operationDiff.getAddedParameters();
            if (addedParameters.size() == 1 && UMLModelDiff.looksLikeSameType((addedParameter = addedParameters.get(0)).getType().getClassType(), operation1.getClassName())) {
                parameterToArgumentMap1.put("this.", "");
                parameterToArgumentMap2.put(addedParameter.getName() + ".", "");
            }
            if ((removedParameters = operationDiff.getRemovedParameters()).size() == 1 && UMLModelDiff.looksLikeSameType(((UMLParameter)((Object)(removedParameter = removedParameters.get(0)))).getType().getClassType(), operation2.getClassName())) {
                parameterToArgumentMap1.put(((UMLParameter)((Object)removedParameter)).getName() + ".", "");
                parameterToArgumentMap2.put("this.", "");
            }
            this.resetNodes(leaves1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (StatementObject leave1 : leaves1) {
                    leave1.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(leaves2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (StatementObject leave2 : leaves2) {
                    leave2.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processLeaves(leaves1, leaves2, new LinkedHashMap<String, String>());
            List<CompositeStatementObject> innerNodes1 = composite1.getInnerNodes();
            innerNodes1.remove(composite1);
            List<CompositeStatementObject> innerNodes2 = composite2.getInnerNodes();
            innerNodes2.remove(composite2);
            this.resetNodes(innerNodes1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (CompositeStatementObject innerNode1 : innerNodes1) {
                    innerNode1.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(innerNodes2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (CompositeStatementObject innerNode2 : innerNodes2) {
                    innerNode2.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processInnerNodes(innerNodes1, innerNodes2, new LinkedHashMap<String, String>());
            this.nonMappedLeavesT1.addAll(leaves1);
            this.nonMappedLeavesT2.addAll(leaves2);
            this.nonMappedInnerNodesT1.addAll(innerNodes1);
            this.nonMappedInnerNodesT2.addAll(innerNodes2);
            for (StatementObject statement : this.getNonMappedLeavesT2()) {
                this.temporaryVariableAssignment(statement, this.nonMappedLeavesT2);
            }
            for (StatementObject statement : this.getNonMappedLeavesT1()) {
                this.inlinedVariableAssignment(statement, this.nonMappedLeavesT2);
            }
        }
    }

    public UMLOperationBodyMapper(UMLOperationBodyMapper operationBodyMapper, UMLOperation addedOperation, Map<String, String> parameterToArgumentMap1, Map<String, String> parameterToArgumentMap2, UMLClassBaseDiff classDiff) throws RefactoringMinerTimedOutException {
        this.parentMapper = operationBodyMapper;
        this.operation1 = operationBodyMapper.operation1;
        this.callSiteOperation = operationBodyMapper.operation2;
        this.operation2 = addedOperation;
        this.classDiff = classDiff;
        this.mappings = new LinkedHashSet<AbstractCodeMapping>();
        this.nonMappedLeavesT1 = new ArrayList<StatementObject>();
        this.nonMappedLeavesT2 = new ArrayList<StatementObject>();
        this.nonMappedInnerNodesT1 = new ArrayList<CompositeStatementObject>();
        this.nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>();
        OperationBody addedOperationBody = addedOperation.getBody();
        if (addedOperationBody != null) {
            CompositeStatementObject composite2 = addedOperationBody.getCompositeStatement();
            List<StatementObject> leaves1 = operationBodyMapper.getNonMappedLeavesT1();
            List<CompositeStatementObject> innerNodes1 = operationBodyMapper.getNonMappedInnerNodesT1();
            LinkedHashSet addedLeaves1 = new LinkedHashSet();
            LinkedHashSet<CompositeStatementObject> addedInnerNodes1 = new LinkedHashSet<CompositeStatementObject>();
            for (StatementObject statementObject : new ArrayList<StatementObject>(operationBodyMapper.getNonMappedLeavesT1())) {
            }
            for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                if (this.returnWithVariableReplacement(mapping) || this.nullLiteralReplacements(mapping) || mapping.getReplacements().isEmpty() && mapping.getFragment1().equalFragment(mapping.getFragment2())) continue;
                AbstractCodeFragment abstractCodeFragment = mapping.getFragment1();
            }
            List<StatementObject> leaves2 = composite2.getLeaves();
            List<CompositeStatementObject> innerNodes2 = composite2.getInnerNodes();
            LinkedHashSet<StatementObject> addedLeaves2 = new LinkedHashSet<StatementObject>();
            LinkedHashSet<CompositeStatementObject> addedInnerNodes2 = new LinkedHashSet<CompositeStatementObject>();
            for (StatementObject statementObject : leaves2) {
                if (statementObject.getLambdas().isEmpty()) continue;
                for (LambdaExpressionObject lambda2 : statementObject.getLambdas()) {
                    if (lambda2.getBody() == null) continue;
                    List<StatementObject> lambdaLeaves = lambda2.getBody().getCompositeStatement().getLeaves();
                    for (StatementObject lambdaLeaf : lambdaLeaves) {
                        if (leaves2.contains(lambdaLeaf)) continue;
                        addedLeaves2.add(lambdaLeaf);
                        this.codeFragmentOperationMap2.put(lambdaLeaf, this.operation2);
                    }
                    List<CompositeStatementObject> lambdaInnerNodes = lambda2.getBody().getCompositeStatement().getInnerNodes();
                    for (CompositeStatementObject lambdaInnerNode : lambdaInnerNodes) {
                        if (innerNodes2.contains(lambdaInnerNode)) continue;
                        addedInnerNodes2.add(lambdaInnerNode);
                        this.codeFragmentOperationMap2.put(lambdaInnerNode, this.operation2);
                    }
                }
            }
            leaves2.addAll(addedLeaves2);
            this.resetNodes(leaves1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (StatementObject statementObject : leaves1) {
                    statementObject.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(leaves2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (StatementObject statementObject : leaves2) {
                    statementObject.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processLeaves(leaves1, leaves2, parameterToArgumentMap2);
            for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
                Object statement;
                AbstractCodeFragment fragment;
                if (abstractCodeMapping.getReplacements().isEmpty() && abstractCodeMapping.getFragment1().equalFragment(abstractCodeMapping.getFragment2()) || !((fragment = abstractCodeMapping.getFragment1()) instanceof CompositeStatementObject) || innerNodes1.contains(statement = (CompositeStatementObject)fragment)) continue;
                innerNodes1.add((CompositeStatementObject)statement);
                addedInnerNodes1.add((CompositeStatementObject)statement);
            }
            innerNodes2.remove(composite2);
            innerNodes2.addAll(addedInnerNodes2);
            this.resetNodes(innerNodes1);
            if (!parameterToArgumentMap1.isEmpty()) {
                for (CompositeStatementObject compositeStatementObject : innerNodes1) {
                    compositeStatementObject.replaceParametersWithArguments(parameterToArgumentMap1);
                }
            }
            this.resetNodes(innerNodes2);
            if (!parameterToArgumentMap2.isEmpty()) {
                for (CompositeStatementObject compositeStatementObject : innerNodes2) {
                    compositeStatementObject.replaceParametersWithArguments(parameterToArgumentMap2);
                }
            }
            this.processInnerNodes(innerNodes1, innerNodes2, parameterToArgumentMap2);
            ArrayList<AbstractExpression> expressionsT1 = new ArrayList<AbstractExpression>();
            for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT1()) {
                for (AbstractExpression expression : composite.getExpressions()) {
                    expression.replaceParametersWithArguments(parameterToArgumentMap1);
                    expressionsT1.add(expression);
                }
            }
            int n = this.mappings.size();
            this.processLeaves(expressionsT1, leaves2, parameterToArgumentMap2);
            ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>(this.mappings);
            for (int i = n; i < mappings.size(); ++i) {
                ((AbstractCodeMapping)mappings.get(i)).temporaryVariableAssignment(this.refactorings);
            }
            leaves1.removeAll(addedLeaves1);
            leaves2.removeAll(addedLeaves2);
            innerNodes1.removeAll(addedInnerNodes1);
            innerNodes2.removeAll(addedInnerNodes2);
            this.nonMappedLeavesT1.addAll(leaves1);
            this.nonMappedLeavesT2.addAll(leaves2);
            this.nonMappedInnerNodesT1.addAll(innerNodes1);
            this.nonMappedInnerNodesT2.addAll(innerNodes2);
            for (StatementObject statement : this.getNonMappedLeavesT2()) {
                this.temporaryVariableAssignment(statement, this.nonMappedLeavesT2);
            }
            for (StatementObject statement : this.getNonMappedLeavesT1()) {
                this.inlinedVariableAssignment(statement, this.nonMappedLeavesT2);
            }
        }
    }

    public UMLOperationBodyMapper(UMLOperation removedOperation, UMLOperationBodyMapper operationBodyMapper, Map<String, String> parameterToArgumentMap, UMLClassBaseDiff classDiff) throws RefactoringMinerTimedOutException {
        this.parentMapper = operationBodyMapper;
        this.operation1 = removedOperation;
        this.operation2 = operationBodyMapper.operation2;
        this.callSiteOperation = operationBodyMapper.operation1;
        this.classDiff = classDiff;
        this.fileDiff = null;
        this.mappings = new LinkedHashSet<AbstractCodeMapping>();
        this.nonMappedLeavesT1 = new ArrayList<StatementObject>();
        this.nonMappedLeavesT2 = new ArrayList<StatementObject>();
        this.nonMappedInnerNodesT1 = new ArrayList<CompositeStatementObject>();
        this.nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>();
        OperationBody removedOperationBody = removedOperation.getBody();
        if (removedOperationBody != null) {
            CompositeStatementObject composite1 = removedOperationBody.getCompositeStatement();
            List<StatementObject> leaves1 = composite1.getLeaves();
            List<StatementObject> leaves2 = operationBodyMapper.getNonMappedLeavesT2();
            LinkedHashSet<Iterator<AbstractCodeMapping>> addedLeaves2 = new LinkedHashSet<Iterator<AbstractCodeMapping>>();
            for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                Iterator<Object> statement;
                AbstractCodeFragment fragment;
                if (this.returnWithVariableReplacement(mapping) || this.nullLiteralReplacements(mapping) || mapping.getReplacements().isEmpty() && mapping.getFragment1().equalFragment(mapping.getFragment2()) || !((fragment = mapping.getFragment2()) instanceof StatementObject) || leaves2.contains(statement = (StatementObject)fragment)) continue;
                leaves2.add((StatementObject)((Object)statement));
                addedLeaves2.add(statement);
            }
            this.resetNodes(leaves1);
            if (!parameterToArgumentMap.isEmpty()) {
                for (StatementObject leave2 : leaves2) {
                    List<VariableDeclaration> variableDeclarations = leave2.getVariableDeclarations();
                    for (VariableDeclaration variableDeclaration : variableDeclarations) {
                        for (String parameter : parameterToArgumentMap.keySet()) {
                            String argument = parameterToArgumentMap.get(parameter);
                            if (variableDeclaration.getInitializer() == null || !argument.equals(variableDeclaration.getInitializer().toString())) continue;
                            parameterToArgumentMap.put(parameter, variableDeclaration.getVariableName());
                        }
                    }
                }
                for (StatementObject leave1 : leaves1) {
                    leave1.replaceParametersWithArguments(parameterToArgumentMap);
                }
            }
            this.processLeaves(leaves1, leaves2, parameterToArgumentMap);
            List<CompositeStatementObject> innerNodes1 = composite1.getInnerNodes();
            innerNodes1.remove(composite1);
            List<CompositeStatementObject> innerNodes2 = operationBodyMapper.getNonMappedInnerNodesT2();
            LinkedHashSet<CompositeStatementObject> addedInnerNodes2 = new LinkedHashSet<CompositeStatementObject>();
            for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                CompositeStatementObject statement;
                AbstractCodeFragment fragment;
                if (mapping.getReplacements().isEmpty() && mapping.getFragment1().equalFragment(mapping.getFragment2()) || !((fragment = mapping.getFragment2()) instanceof CompositeStatementObject) || innerNodes2.contains(statement = (CompositeStatementObject)fragment)) continue;
                innerNodes2.add(statement);
                addedInnerNodes2.add(statement);
            }
            this.resetNodes(innerNodes1);
            if (!parameterToArgumentMap.isEmpty()) {
                for (CompositeStatementObject innerNode1 : innerNodes1) {
                    innerNode1.replaceParametersWithArguments(parameterToArgumentMap);
                }
            }
            this.processInnerNodes(innerNodes1, innerNodes2, parameterToArgumentMap);
            ArrayList<AbstractExpression> expressionsT2 = new ArrayList<AbstractExpression>();
            for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT2()) {
                expressionsT2.addAll(composite.getExpressions());
            }
            this.processLeaves(leaves1, expressionsT2, parameterToArgumentMap);
            leaves2.removeAll(addedLeaves2);
            innerNodes2.removeAll(addedInnerNodes2);
            this.nonMappedLeavesT1.addAll(leaves1);
            this.nonMappedLeavesT2.addAll(leaves2);
            this.nonMappedInnerNodesT1.addAll(innerNodes1);
            this.nonMappedInnerNodesT2.addAll(innerNodes2);
            for (StatementObject statement : this.getNonMappedLeavesT2()) {
                this.temporaryVariableAssignment(statement, this.nonMappedLeavesT2);
            }
            for (StatementObject statement : this.getNonMappedLeavesT1()) {
                this.inlinedVariableAssignment(statement, this.nonMappedLeavesT2);
            }
        }
    }

    private boolean returnWithVariableReplacement(AbstractCodeMapping mapping) {
        Replacement r;
        if (mapping.getReplacements().size() == 1 && (r = mapping.getReplacements().iterator().next()).getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) {
            String fragment1 = mapping.getFragment1().getString();
            String fragment2 = mapping.getFragment2().getString();
            return fragment1.equals("return " + r.getBefore() + "\n") && fragment2.equals("return " + r.getAfter() + "\n");
        }
        return false;
    }

    private boolean nullLiteralReplacements(AbstractCodeMapping mapping) {
        int numberOfReplacements = mapping.getReplacements().size();
        int nullLiteralReplacements = 0;
        int methodInvocationReplacementsToIgnore = 0;
        int variableNameReplacementsToIgnore = 0;
        for (Replacement replacement : mapping.getReplacements()) {
            if (replacement.getType().equals((Object)Replacement.ReplacementType.NULL_LITERAL_REPLACED_WITH_CONDITIONAL_EXPRESSION) || replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_NULL_LITERAL) || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_VARIABLE) && (replacement.getBefore().equals("Null") || replacement.getAfter().equals("Null"))) {
                ++nullLiteralReplacements;
                continue;
            }
            if (replacement instanceof MethodInvocationReplacement) {
                MethodInvocationReplacement invocationReplacement = (MethodInvocationReplacement)replacement;
                OperationInvocation invokedOperationBefore = invocationReplacement.getInvokedOperationBefore();
                OperationInvocation invokedOperationAfter = invocationReplacement.getInvokedOperationAfter();
                if (!invokedOperationBefore.getName().equals(invokedOperationAfter.getName()) || invokedOperationBefore.getArguments().size() != invokedOperationAfter.getArguments().size()) continue;
                ++methodInvocationReplacementsToIgnore;
                continue;
            }
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
            ++variableNameReplacementsToIgnore;
        }
        return nullLiteralReplacements > 0 && numberOfReplacements == nullLiteralReplacements + methodInvocationReplacementsToIgnore + variableNameReplacementsToIgnore;
    }

    private void resetNodes(List<? extends AbstractCodeFragment> nodes) {
        for (AbstractCodeFragment abstractCodeFragment : nodes) {
            abstractCodeFragment.resetArgumentization();
        }
    }

    public void processLeaves(List<? extends AbstractCodeFragment> leaves1, List<? extends AbstractCodeFragment> leaves2, Map<String, String> parameterToArgumentMap) throws RefactoringMinerTimedOutException {
        LeafMapping minStatementMapping;
        Iterator switchParentEntry;
        UMLClassBaseDiff classDiff;
        AbstractCodeFragment leaf;
        Iterator<Object> iterator;
        Set<Replacement> replacements;
        ReplacementInfo replacementInfo;
        LeafMapping minStatementMapping2;
        LeafMapping mapping;
        String argumentizedString2;
        String argumentizedString1;
        TreeSet<LeafMapping> mappingSet;
        ArrayList<TreeSet<LeafMapping>> postponedMappingSets = new ArrayList<TreeSet<LeafMapping>>();
        if (leaves1.size() <= leaves2.size()) {
            AbstractCodeFragment leaf2;
            ListIterator<? extends AbstractCodeFragment> leafIterator2;
            ListIterator<? extends AbstractCodeFragment> leafIterator1 = leaves1.listIterator();
            while (leafIterator1.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator1.next();
                mappingSet = new TreeSet<LeafMapping>();
                leafIterator2 = leaves2.listIterator();
                while (leafIterator2.hasNext()) {
                    leaf2 = leafIterator2.next();
                    argumentizedString1 = this.preprocessInput1(abstractCodeFragment, leaf2);
                    argumentizedString2 = this.preprocessInput2(abstractCodeFragment, leaf2);
                    if (!abstractCodeFragment.getString().equals(leaf2.getString()) && !argumentizedString1.equals(argumentizedString2) || abstractCodeFragment.getDepth() != leaf2.getDepth()) continue;
                    mapping = this.createLeafMapping(abstractCodeFragment, leaf2, parameterToArgumentMap);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                LeafMapping minStatementMapping22 = (LeafMapping)mappingSet.first();
                this.mappings.add(minStatementMapping22);
                leaves2.remove(minStatementMapping22.getFragment2());
                leafIterator1.remove();
            }
            leafIterator1 = leaves1.listIterator();
            while (leafIterator1.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator1.next();
                mappingSet = new TreeSet();
                leafIterator2 = leaves2.listIterator();
                while (leafIterator2.hasNext()) {
                    leaf2 = leafIterator2.next();
                    argumentizedString1 = this.preprocessInput1(abstractCodeFragment, leaf2);
                    argumentizedString2 = this.preprocessInput2(abstractCodeFragment, leaf2);
                    if (!abstractCodeFragment.getString().equals(leaf2.getString()) && !argumentizedString1.equals(argumentizedString2)) continue;
                    mapping = this.createLeafMapping(abstractCodeFragment, leaf2, parameterToArgumentMap);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                minStatementMapping2 = (LeafMapping)mappingSet.first();
                this.mappings.add(minStatementMapping2);
                leaves2.remove(minStatementMapping2.getFragment2());
                leafIterator1.remove();
            }
            leafIterator1 = leaves1.listIterator();
            while (leafIterator1.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator1.next();
                mappingSet = new TreeSet();
                leafIterator2 = leaves2.listIterator();
                while (leafIterator2.hasNext()) {
                    leaf2 = leafIterator2.next();
                    replacements = this.findReplacementsWithExactMatching(abstractCodeFragment, leaf2, parameterToArgumentMap, replacementInfo = this.initializeReplacementInfo(abstractCodeFragment, leaf2, leaves1, leaves2));
                    if (replacements == null) continue;
                    mapping = this.createLeafMapping(abstractCodeFragment, leaf2, parameterToArgumentMap);
                    mapping.addReplacements(replacements);
                    iterator = leaves2.iterator();
                    while (iterator.hasNext() && !(leaf = (AbstractCodeFragment)iterator.next()).equals(leaf2)) {
                        classDiff = this.classDiff != null ? this.classDiff : (this.parentMapper != null ? this.parentMapper.classDiff : null);
                        mapping.temporaryVariableAssignment(leaf, leaves2, this.refactorings, classDiff);
                        if (!mapping.isIdenticalWithExtractedVariable()) continue;
                        break;
                    }
                    iterator = leaves1.iterator();
                    while (iterator.hasNext() && !(leaf = (AbstractCodeFragment)iterator.next()).equals(abstractCodeFragment)) {
                        mapping.inlinedVariableAssignment(leaf, leaves2, this.refactorings);
                        if (!mapping.isIdenticalWithInlinedVariable()) continue;
                        break;
                    }
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                switchParentEntry = null;
                if (this.variableDeclarationMappingsWithSameReplacementTypes(mappingSet)) {
                    postponedMappingSets.add(mappingSet);
                    continue;
                }
                minStatementMapping = mappingSet.first();
                this.mappings.add(minStatementMapping);
                leaves2.remove(minStatementMapping.getFragment2());
                leafIterator1.remove();
            }
        } else {
            AbstractCodeFragment leaf1;
            ListIterator<? extends AbstractCodeFragment> leafIterator1;
            ListIterator<? extends AbstractCodeFragment> leafIterator2 = leaves2.listIterator();
            while (leafIterator2.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator2.next();
                mappingSet = new TreeSet();
                leafIterator1 = leaves1.listIterator();
                while (leafIterator1.hasNext()) {
                    leaf1 = leafIterator1.next();
                    argumentizedString1 = this.preprocessInput1(leaf1, abstractCodeFragment);
                    argumentizedString2 = this.preprocessInput2(leaf1, abstractCodeFragment);
                    if (!leaf1.getString().equals(abstractCodeFragment.getString()) && !argumentizedString1.equals(argumentizedString2) || leaf1.getDepth() != abstractCodeFragment.getDepth()) continue;
                    mapping = this.createLeafMapping(leaf1, abstractCodeFragment, parameterToArgumentMap);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                minStatementMapping2 = (LeafMapping)mappingSet.first();
                this.mappings.add(minStatementMapping2);
                leaves1.remove(minStatementMapping2.getFragment1());
                leafIterator2.remove();
            }
            leafIterator2 = leaves2.listIterator();
            while (leafIterator2.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator2.next();
                mappingSet = new TreeSet();
                leafIterator1 = leaves1.listIterator();
                while (leafIterator1.hasNext()) {
                    leaf1 = leafIterator1.next();
                    argumentizedString1 = this.preprocessInput1(leaf1, abstractCodeFragment);
                    argumentizedString2 = this.preprocessInput2(leaf1, abstractCodeFragment);
                    if (!leaf1.getString().equals(abstractCodeFragment.getString()) && !argumentizedString1.equals(argumentizedString2)) continue;
                    mapping = this.createLeafMapping(leaf1, abstractCodeFragment, parameterToArgumentMap);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                minStatementMapping2 = (LeafMapping)mappingSet.first();
                this.mappings.add(minStatementMapping2);
                leaves1.remove(minStatementMapping2.getFragment1());
                leafIterator2.remove();
            }
            leafIterator2 = leaves2.listIterator();
            while (leafIterator2.hasNext()) {
                AbstractCodeFragment abstractCodeFragment = leafIterator2.next();
                mappingSet = new TreeSet();
                leafIterator1 = leaves1.listIterator();
                while (leafIterator1.hasNext()) {
                    leaf1 = leafIterator1.next();
                    replacements = this.findReplacementsWithExactMatching(leaf1, abstractCodeFragment, parameterToArgumentMap, replacementInfo = this.initializeReplacementInfo(leaf1, abstractCodeFragment, leaves1, leaves2));
                    if (replacements == null) continue;
                    mapping = this.createLeafMapping(leaf1, abstractCodeFragment, parameterToArgumentMap);
                    mapping.addReplacements(replacements);
                    iterator = leaves2.iterator();
                    while (iterator.hasNext() && !(leaf = (AbstractCodeFragment)iterator.next()).equals(abstractCodeFragment)) {
                        classDiff = this.classDiff != null ? this.classDiff : (this.parentMapper != null ? this.parentMapper.classDiff : null);
                        mapping.temporaryVariableAssignment(leaf, leaves2, this.refactorings, classDiff);
                        if (!mapping.isIdenticalWithExtractedVariable()) continue;
                        break;
                    }
                    iterator = leaves1.iterator();
                    while (iterator.hasNext() && !(leaf = (AbstractCodeFragment)iterator.next()).equals(leaf1)) {
                        mapping.inlinedVariableAssignment(leaf, leaves2, this.refactorings);
                        if (!mapping.isIdenticalWithInlinedVariable()) continue;
                        break;
                    }
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                switchParentEntry = null;
                if (this.variableDeclarationMappingsWithSameReplacementTypes(mappingSet)) {
                    postponedMappingSets.add(mappingSet);
                    continue;
                }
                minStatementMapping = mappingSet.first();
                this.mappings.add(minStatementMapping);
                leaves1.remove(minStatementMapping.getFragment1());
                leafIterator2.remove();
            }
        }
        for (TreeSet treeSet : postponedMappingSets) {
            LinkedHashSet<LeafMapping> mappingsToBeAdded = new LinkedHashSet<LeafMapping>();
            for (LeafMapping variableDeclarationMapping : treeSet) {
                for (AbstractCodeMapping previousMapping : this.mappings) {
                    Set<Replacement> intersection = variableDeclarationMapping.commonReplacements(previousMapping);
                    if (intersection.isEmpty()) continue;
                    for (Replacement commonReplacement : intersection) {
                        if (!commonReplacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || variableDeclarationMapping.getFragment1().getVariableDeclaration(commonReplacement.getBefore()) == null || variableDeclarationMapping.getFragment2().getVariableDeclaration(commonReplacement.getAfter()) == null) continue;
                        mappingsToBeAdded.add(variableDeclarationMapping);
                    }
                }
            }
            if (mappingsToBeAdded.size() == 1) {
                minStatementMapping2 = (LeafMapping)mappingsToBeAdded.iterator().next();
                this.mappings.add(minStatementMapping2);
                leaves1.remove(minStatementMapping2.getFragment1());
                leaves2.remove(minStatementMapping2.getFragment2());
                continue;
            }
            minStatementMapping2 = (LeafMapping)treeSet.first();
            this.mappings.add(minStatementMapping2);
            leaves1.remove(minStatementMapping2.getFragment1());
            leaves2.remove(minStatementMapping2.getFragment2());
        }
    }

    public UMLOperation getOperation1() {
        return this.operation1;
    }

    public UMLOperation getOperation2() {
        return this.operation2;
    }

    public List<UMLOperationBodyMapper> getChildMappers() {
        return this.childMappers;
    }

    public UMLOperationBodyMapper getParentMapper() {
        return this.parentMapper;
    }

    public UMLOperation getCallSiteOperation() {
        return this.callSiteOperation;
    }

    private boolean variableDeclarationMappingsWithSameReplacementTypes(Set<LeafMapping> mappingSet) {
        if (mappingSet.size() > 1) {
            LinkedHashSet<LeafMapping> variableDeclarationMappings = new LinkedHashSet<LeafMapping>();
            for (LeafMapping mapping : mappingSet) {
                if (mapping.getFragment1().getVariableDeclarations().size() <= 0 || mapping.getFragment2().getVariableDeclarations().size() <= 0) continue;
                variableDeclarationMappings.add(mapping);
            }
            if (variableDeclarationMappings.size() == mappingSet.size()) {
                Set<Replacement.ReplacementType> replacementTypes = null;
                LinkedHashSet<LeafMapping> mappingsWithSameReplacementTypes = new LinkedHashSet<LeafMapping>();
                block1: for (LeafMapping mapping : variableDeclarationMappings) {
                    if (replacementTypes == null) {
                        replacementTypes = mapping.getReplacementTypes();
                        mappingsWithSameReplacementTypes.add(mapping);
                        continue;
                    }
                    if (mapping.getReplacementTypes().equals(replacementTypes)) {
                        mappingsWithSameReplacementTypes.add(mapping);
                        continue;
                    }
                    if (!mapping.getReplacementTypes().containsAll(replacementTypes) && !replacementTypes.containsAll(mapping.getReplacementTypes())) continue;
                    OperationInvocation invocation1 = mapping.getFragment1().invocationCoveringEntireFragment();
                    OperationInvocation invocation2 = mapping.getFragment2().invocationCoveringEntireFragment();
                    if (invocation1 == null || invocation2 == null) continue;
                    for (Replacement replacement : mapping.getReplacements()) {
                        if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !invocation1.getName().equals(replacement.getBefore()) || !invocation2.getName().equals(replacement.getAfter())) continue;
                        mappingsWithSameReplacementTypes.add(mapping);
                        continue block1;
                    }
                }
                return mappingsWithSameReplacementTypes.size() == mappingSet.size();
            }
        }
        return false;
    }

    private LeafMapping createLeafMapping(AbstractCodeFragment leaf1, AbstractCodeFragment leaf2, Map<String, String> parameterToArgumentMap) {
        UMLOperation operation1 = this.codeFragmentOperationMap1.getOrDefault(leaf1, this.operation1);
        UMLOperation operation2 = this.codeFragmentOperationMap2.getOrDefault(leaf2, this.operation2);
        LeafMapping mapping = new LeafMapping(leaf1, leaf2, operation1, operation2);
        for (String key : parameterToArgumentMap.keySet()) {
            String value;
            if (key.equals(value = parameterToArgumentMap.get(key)) || !ReplacementUtil.contains(leaf2.getString(), key) || !ReplacementUtil.contains(leaf1.getString(), value)) continue;
            mapping.addReplacement(new Replacement(value, key, Replacement.ReplacementType.VARIABLE_NAME));
        }
        return mapping;
    }

    private ReplacementInfo initializeReplacementInfo(AbstractCodeFragment leaf1, AbstractCodeFragment leaf2, List<? extends AbstractCodeFragment> leaves1, List<? extends AbstractCodeFragment> leaves2) {
        ArrayList<? extends AbstractCodeFragment> l1 = new ArrayList<AbstractCodeFragment>(leaves1);
        l1.remove(leaf1);
        ArrayList<? extends AbstractCodeFragment> l2 = new ArrayList<AbstractCodeFragment>(leaves2);
        l2.remove(leaf2);
        return new ReplacementInfo(this.preprocessInput1(leaf1, leaf2), this.preprocessInput2(leaf1, leaf2), l1, l2);
    }

    public void processInnerNodes(List<CompositeStatementObject> innerNodes1, List<CompositeStatementObject> innerNodes2, Map<String, String> parameterToArgumentMap) throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> addedOperations;
        ArrayList<UMLOperation> removedOperations = this.classDiff != null ? this.classDiff.getRemovedOperations() : new ArrayList();
        List<Object> list = addedOperations = this.classDiff != null ? this.classDiff.getAddedOperations() : new ArrayList();
        if (innerNodes1.size() <= innerNodes2.size()) {
            Object minStatementMapping;
            TreeSet<CompositeStatementObjectMapping> mappingSet;
            CompositeStatementObject statement12;
            ListIterator<CompositeStatementObject> innerNodeIterator1 = innerNodes1.listIterator();
            while (innerNodeIterator1.hasNext()) {
                statement12 = innerNodeIterator1.next();
                mappingSet = new TreeSet<CompositeStatementObjectMapping>();
                innerNodes2.forEach(statement2 -> {
                    double score = this.computeScore(statement12, (CompositeStatementObject)statement2, (List<UMLOperation>)removedOperations, (List<UMLOperation>)addedOperations);
                    if ((statement12.getString().equals(statement2.getString()) || statement12.getArgumentizedString().equals(statement2.getArgumentizedString())) && statement12.getDepth() == statement2.getDepth() && (score > 0.0 || Math.max(statement12.getStatements().size(), statement2.getStatements().size()) == 0)) {
                        CompositeStatementObjectMapping mapping = this.createCompositeMapping(statement12, (CompositeStatementObject)statement2, parameterToArgumentMap, score);
                        mappingSet.add(mapping);
                    }
                });
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes2.remove(((AbstractCodeMapping)minStatementMapping).getFragment2());
                innerNodeIterator1.remove();
            }
            innerNodeIterator1 = innerNodes1.listIterator();
            while (innerNodeIterator1.hasNext()) {
                statement12 = innerNodeIterator1.next();
                mappingSet = new TreeSet();
                innerNodes2.forEach(statement2 -> {
                    double score = this.computeScore(statement12, (CompositeStatementObject)statement2, (List<UMLOperation>)removedOperations, (List<UMLOperation>)addedOperations);
                    if ((statement12.getString().equals(statement2.getString()) || statement12.getArgumentizedString().equals(statement2.getArgumentizedString())) && (score > 0.0 || Math.max(statement12.getStatements().size(), statement2.getStatements().size()) == 0)) {
                        CompositeStatementObjectMapping mapping = this.createCompositeMapping(statement12, (CompositeStatementObject)statement2, parameterToArgumentMap, score);
                        mappingSet.add(mapping);
                    }
                });
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes2.remove(((AbstractCodeMapping)minStatementMapping).getFragment2());
                innerNodeIterator1.remove();
            }
            innerNodeIterator1 = innerNodes1.listIterator();
            while (innerNodeIterator1.hasNext()) {
                statement12 = innerNodeIterator1.next();
                mappingSet = new TreeSet();
                for (CompositeStatementObject statement22 : innerNodes2) {
                    ReplacementInfo replacementInfo = this.initializeReplacementInfo(statement12, statement22, innerNodes1, innerNodes2);
                    Set<Replacement> replacements = this.findReplacementsWithExactMatching(statement12, statement22, parameterToArgumentMap, replacementInfo);
                    double score = this.computeScore(statement12, statement22, removedOperations, addedOperations);
                    if (score == 0.0 && replacements != null && replacements.size() == 1 && (replacements.iterator().next().getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR) || replacements.iterator().next().getType().equals((Object)Replacement.ReplacementType.INVERT_CONDITIONAL))) {
                        score = 1.0;
                    }
                    if (replacements == null || !(score > 0.0) && Math.max(statement12.getStatements().size(), statement22.getStatements().size()) != 0) continue;
                    CompositeStatementObjectMapping mapping = this.createCompositeMapping(statement12, statement22, parameterToArgumentMap, score);
                    mapping.addReplacements(replacements);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes2.remove(((AbstractCodeMapping)minStatementMapping).getFragment2());
                innerNodeIterator1.remove();
            }
        } else {
            Object minStatementMapping;
            TreeSet<CompositeStatementObjectMapping> mappingSet;
            CompositeStatementObject statement23;
            ListIterator<CompositeStatementObject> innerNodeIterator2 = innerNodes2.listIterator();
            while (innerNodeIterator2.hasNext()) {
                statement23 = innerNodeIterator2.next();
                mappingSet = new TreeSet<CompositeStatementObjectMapping>();
                innerNodes1.forEach(statement1 -> {
                    double score = this.computeScore((CompositeStatementObject)statement1, statement23, (List<UMLOperation>)removedOperations, (List<UMLOperation>)addedOperations);
                    if ((statement1.getString().equals(statement23.getString()) || statement1.getArgumentizedString().equals(statement23.getArgumentizedString())) && statement1.getDepth() == statement23.getDepth() && (score > 0.0 || Math.max(statement1.getStatements().size(), statement23.getStatements().size()) == 0)) {
                        CompositeStatementObjectMapping mapping = this.createCompositeMapping((CompositeStatementObject)statement1, statement23, parameterToArgumentMap, score);
                        mappingSet.add(mapping);
                    }
                });
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes1.remove(((AbstractCodeMapping)minStatementMapping).getFragment1());
                innerNodeIterator2.remove();
            }
            innerNodeIterator2 = innerNodes2.listIterator();
            while (innerNodeIterator2.hasNext()) {
                statement23 = innerNodeIterator2.next();
                mappingSet = new TreeSet();
                innerNodes1.forEach(statement1 -> {
                    double score = this.computeScore((CompositeStatementObject)statement1, statement23, (List<UMLOperation>)removedOperations, (List<UMLOperation>)addedOperations);
                    if ((statement1.getString().equals(statement23.getString()) || statement1.getArgumentizedString().equals(statement23.getArgumentizedString())) && (score > 0.0 || Math.max(statement1.getStatements().size(), statement23.getStatements().size()) == 0)) {
                        CompositeStatementObjectMapping mapping = this.createCompositeMapping((CompositeStatementObject)statement1, statement23, parameterToArgumentMap, score);
                        mappingSet.add(mapping);
                    }
                });
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes1.remove(((AbstractCodeMapping)minStatementMapping).getFragment1());
                innerNodeIterator2.remove();
            }
            innerNodeIterator2 = innerNodes2.listIterator();
            while (innerNodeIterator2.hasNext()) {
                statement23 = innerNodeIterator2.next();
                mappingSet = new TreeSet();
                for (CompositeStatementObject statement13 : innerNodes1) {
                    ReplacementInfo replacementInfo = this.initializeReplacementInfo(statement13, statement23, innerNodes1, innerNodes2);
                    Set<Replacement> replacements = this.findReplacementsWithExactMatching(statement13, statement23, parameterToArgumentMap, replacementInfo);
                    double score = this.computeScore(statement13, statement23, removedOperations, addedOperations);
                    if (score == 0.0 && replacements != null && replacements.size() == 1 && (replacements.iterator().next().getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR) || replacements.iterator().next().getType().equals((Object)Replacement.ReplacementType.INVERT_CONDITIONAL))) {
                        score = 1.0;
                    }
                    if (replacements == null || !(score > 0.0) && Math.max(statement13.getStatements().size(), statement23.getStatements().size()) != 0) continue;
                    CompositeStatementObjectMapping mapping = this.createCompositeMapping(statement13, statement23, parameterToArgumentMap, score);
                    mapping.addReplacements(replacements);
                    mappingSet.add(mapping);
                }
                if (mappingSet.isEmpty()) continue;
                minStatementMapping = (CompositeStatementObjectMapping)mappingSet.first();
                this.mappings.add((AbstractCodeMapping)minStatementMapping);
                innerNodes1.remove(((AbstractCodeMapping)minStatementMapping).getFragment1());
                innerNodeIterator2.remove();
            }
        }
    }

    private CompositeStatementObjectMapping createCompositeMapping(CompositeStatementObject statement1, CompositeStatementObject statement2, Map<String, String> parameterToArgumentMap, double score) {
        UMLOperation operation1 = this.codeFragmentOperationMap1.getOrDefault(statement1, this.operation1);
        UMLOperation operation2 = this.codeFragmentOperationMap2.getOrDefault(statement2, this.operation2);
        CompositeStatementObjectMapping mapping = new CompositeStatementObjectMapping(statement1, statement2, operation1, operation2, score);
        for (String key : parameterToArgumentMap.keySet()) {
            String value;
            if (key.equals(value = parameterToArgumentMap.get(key)) || !ReplacementUtil.contains(statement2.getString(), key) || !ReplacementUtil.contains(statement1.getString(), value)) continue;
            mapping.addReplacement(new Replacement(value, key, Replacement.ReplacementType.VARIABLE_NAME));
        }
        return mapping;
    }

    private double computeScore(CompositeStatementObject statement1, CompositeStatementObject statement2, List<UMLOperation> removedOperations, List<UMLOperation> addedOperations) {
        return this.compositeChildMatchingScore(statement1, statement2, this.mappings, removedOperations, addedOperations);
    }

    private boolean matchesOperation(OperationInvocation invocation, List<UMLOperation> operations, Map<String, UMLType> variableTypeMap) {
        for (UMLOperation operation : operations) {
            if (!invocation.matchesOperation(operation, variableTypeMap, this.modelDiff)) continue;
            return true;
        }
        return false;
    }

    private double compositeChildMatchingScore(CompositeStatementObject comp1, CompositeStatementObject comp2, Set<AbstractCodeMapping> mappings, List<UMLOperation> removedOperations, List<UMLOperation> addedOperations) {
        List<AbstractStatement> compStatements1 = comp1.getStatements();
        List<AbstractStatement> compStatements2 = comp2.getStatements();
        int childrenSize1 = compStatements1.size();
        int childrenSize2 = compStatements2.size();
        if (this.parentMapper != null && comp1.getLocationInfo().getCodeElementType().equals((Object)comp2.getLocationInfo().getCodeElementType()) && childrenSize1 == 1 && childrenSize2 == 1 && !comp1.getString().equals("{") && !comp2.getString().equals("{")) {
            CompositeStatementObject block;
            if (compStatements1.get(0).getString().equals("{") && !compStatements2.get(0).getString().equals("{")) {
                block = (CompositeStatementObject)compStatements1.get(0);
                compStatements1.addAll(block.getStatements());
            }
            if (!compStatements1.get(0).getString().equals("{") && compStatements2.get(0).getString().equals("{")) {
                block = (CompositeStatementObject)compStatements2.get(0);
                compStatements2.addAll(block.getStatements());
            }
        }
        int mappedChildrenSize = 0;
        for (AbstractCodeMapping mapping : mappings) {
            if (!compStatements1.contains(mapping.getFragment1()) || !compStatements2.contains(mapping.getFragment2())) continue;
            ++mappedChildrenSize;
        }
        if (mappedChildrenSize == 0) {
            int max;
            List<StatementObject> leaves1 = comp1.getLeaves();
            List<StatementObject> leaves2 = comp2.getLeaves();
            int leaveSize1 = leaves1.size();
            int leaveSize2 = leaves2.size();
            int mappedLeavesSize = 0;
            for (AbstractCodeMapping mapping : mappings) {
                if (!leaves1.contains(mapping.getFragment1()) || !leaves2.contains(mapping.getFragment2())) continue;
                ++mappedLeavesSize;
            }
            if (mappedLeavesSize == 0) {
                if (leaveSize2 <= 2) {
                    for (StatementObject leaf2 : leaves2) {
                        OperationInvocation invocation = leaf2.invocationCoveringEntireFragment();
                        if (invocation == null || !this.matchesOperation(invocation, addedOperations, this.operation2.variableTypeMap())) continue;
                        ++mappedLeavesSize;
                    }
                } else if (leaveSize1 <= 2) {
                    for (StatementObject leaf1 : leaves1) {
                        OperationInvocation invocation = leaf1.invocationCoveringEntireFragment();
                        if (invocation == null || !this.matchesOperation(invocation, removedOperations, this.operation1.variableTypeMap())) continue;
                        ++mappedLeavesSize;
                    }
                }
                if (leaveSize1 == 1 && leaveSize2 == 1 && leaves1.get(0).getString().equals("continue;\n") && leaves2.get(0).getString().equals("return null\n")) {
                    ++mappedLeavesSize;
                }
            }
            if ((max = Math.max(leaveSize1, leaveSize2)) == 0) {
                return 0.0;
            }
            return (double)mappedLeavesSize / (double)max;
        }
        int max = Math.max(childrenSize1, childrenSize2);
        if (max == 0) {
            return 0.0;
        }
        return (double)mappedChildrenSize / (double)max;
    }

    private void temporaryVariableAssignment(StatementObject statement, List<StatementObject> nonMappedLeavesT2) {
        for (AbstractCodeMapping mapping : this.getMappings()) {
            UMLClassBaseDiff classDiff = this.classDiff != null ? this.classDiff : (this.parentMapper != null ? this.parentMapper.classDiff : null);
            mapping.temporaryVariableAssignment(statement, nonMappedLeavesT2, this.refactorings, classDiff);
        }
    }

    private VariableDeclaration declarationWithArrayInitializer(List<VariableDeclaration> declarations) {
        for (VariableDeclaration declaration : declarations) {
            AbstractExpression initializer = declaration.getInitializer();
            if (initializer == null || !initializer.getString().startsWith("{") || !initializer.getString().endsWith("}")) continue;
            return declaration;
        }
        return null;
    }

    private boolean nonMatchedStatementUsesVariableInArgument(List<? extends AbstractCodeFragment> statements, String variable, String otherArgument) {
        for (AbstractCodeFragment abstractCodeFragment : statements) {
            OperationInvocation invocation = abstractCodeFragment.invocationCoveringEntireFragment();
            if (invocation == null) continue;
            for (String argument : invocation.getArguments()) {
                String argumentNoWhiteSpace = argument.replaceAll("\\s", "");
                if (!argument.contains(variable) || argument.equals(variable) || argumentNoWhiteSpace.contains("+" + variable + "+") || argumentNoWhiteSpace.contains(variable + "+") || argumentNoWhiteSpace.contains("+" + variable) || argument.equals(otherArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private void replaceVariablesWithArguments(Set<String> variables, Map<String, String> parameterToArgumentMap) {
        for (String parameter : parameterToArgumentMap.keySet()) {
            String arguments;
            String argument = parameterToArgumentMap.get(parameter);
            if (!variables.contains(parameter)) continue;
            variables.add(argument);
            if (!argument.contains("(") || !argument.contains(")")) continue;
            int indexOfOpeningParenthesis = argument.indexOf("(");
            int indexOfClosingParenthesis = argument.lastIndexOf(")");
            boolean openingParenthesisInsideSingleQuotes = UMLOperationBodyMapper.isInsideSingleQuotes(argument, indexOfOpeningParenthesis);
            boolean closingParenthesisInsideSingleQuotes = UMLOperationBodyMapper.isInsideSingleQuotes(argument, indexOfClosingParenthesis);
            boolean openingParenthesisInsideDoubleQuotes = UMLOperationBodyMapper.isInsideDoubleQuotes(argument, indexOfOpeningParenthesis);
            boolean closingParenthesisIndideDoubleQuotes = UMLOperationBodyMapper.isInsideDoubleQuotes(argument, indexOfClosingParenthesis);
            if (indexOfOpeningParenthesis >= indexOfClosingParenthesis || openingParenthesisInsideSingleQuotes || closingParenthesisInsideSingleQuotes || openingParenthesisInsideDoubleQuotes || closingParenthesisIndideDoubleQuotes || (arguments = argument.substring(indexOfOpeningParenthesis + 1, indexOfClosingParenthesis)).isEmpty() || arguments.contains(",") || arguments.contains("(") || arguments.contains(")")) continue;
            variables.add(arguments);
        }
    }

    private static boolean isInsideSingleQuotes(String argument, int indexOfChar) {
        if (indexOfChar > 0 && indexOfChar < argument.length() - 1) {
            return argument.charAt(indexOfChar - 1) == '\'' && argument.charAt(indexOfChar + 1) == '\'';
        }
        return false;
    }

    private static boolean isInsideDoubleQuotes(String argument, int indexOfChar) {
        Matcher m = DOUBLE_QUOTES.matcher(argument);
        while (m.find()) {
            if (m.group(1) == null || indexOfChar <= m.start() || indexOfChar >= m.end()) continue;
            return true;
        }
        return false;
    }

    private void removeCommonElements(Set<String> strings1, Set<String> strings2) {
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(strings1);
        intersection.retainAll(strings2);
        strings1.removeAll(intersection);
        strings2.removeAll(intersection);
    }

    private boolean argumentsWithIdenticalMethodCalls(Set<String> arguments1, Set<String> arguments2, Set<String> variables1, Set<String> variables2) {
        int identicalMethodCalls = 0;
        if (arguments1.size() == arguments2.size()) {
            Iterator<String> it1 = arguments1.iterator();
            Iterator<String> it2 = arguments2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                String s2;
                String s1;
                String arg1 = it1.next();
                String arg2 = it2.next();
                if (!arg1.contains("(") || !arg2.contains("(") || !arg1.contains(")") || !arg2.contains(")")) continue;
                int indexOfOpeningParenthesis1 = arg1.indexOf("(");
                int indexOfClosingParenthesis1 = arg1.indexOf(")");
                boolean openingParenthesisInsideSingleQuotes1 = UMLOperationBodyMapper.isInsideSingleQuotes(arg1, indexOfOpeningParenthesis1);
                boolean openingParenthesisInsideDoubleQuotes1 = UMLOperationBodyMapper.isInsideDoubleQuotes(arg1, indexOfOpeningParenthesis1);
                boolean closingParenthesisInsideSingleQuotes1 = UMLOperationBodyMapper.isInsideSingleQuotes(arg1, indexOfClosingParenthesis1);
                boolean closingParenthesisInsideDoubleQuotes1 = UMLOperationBodyMapper.isInsideDoubleQuotes(arg1, indexOfClosingParenthesis1);
                int indexOfOpeningParenthesis2 = arg2.indexOf("(");
                int indexOfClosingParenthesis2 = arg2.indexOf(")");
                boolean openingParenthesisInsideSingleQuotes2 = UMLOperationBodyMapper.isInsideSingleQuotes(arg2, indexOfOpeningParenthesis2);
                boolean openingParenthesisInsideDoubleQuotes2 = UMLOperationBodyMapper.isInsideDoubleQuotes(arg2, indexOfOpeningParenthesis2);
                boolean closingParenthesisInsideSingleQuotes2 = UMLOperationBodyMapper.isInsideSingleQuotes(arg2, indexOfClosingParenthesis2);
                boolean closingParenthesisInsideDoubleQuotes2 = UMLOperationBodyMapper.isInsideDoubleQuotes(arg2, indexOfClosingParenthesis2);
                if (openingParenthesisInsideSingleQuotes1 || closingParenthesisInsideSingleQuotes1 || openingParenthesisInsideDoubleQuotes1 || closingParenthesisInsideDoubleQuotes1 || openingParenthesisInsideSingleQuotes2 || closingParenthesisInsideSingleQuotes2 || openingParenthesisInsideDoubleQuotes2 || closingParenthesisInsideDoubleQuotes2 || !(s1 = arg1.substring(0, indexOfOpeningParenthesis1)).equals(s2 = arg2.substring(0, indexOfOpeningParenthesis2)) || s1.length() <= 0) continue;
                String args1 = arg1.substring(indexOfOpeningParenthesis1 + 1, indexOfClosingParenthesis1);
                String args2 = arg2.substring(indexOfOpeningParenthesis2 + 1, indexOfClosingParenthesis2);
                if (!variables1.contains(args1) || !variables2.contains(args2)) continue;
                ++identicalMethodCalls;
            }
        }
        return identicalMethodCalls == arguments1.size() && arguments1.size() > 0;
    }

    private void removeCommonTypes(Set<String> strings1, Set<String> strings2, List<String> types1, List<String> types2) {
        if (types1.size() == types2.size()) {
            LinkedHashSet<String> removeFromIntersection = new LinkedHashSet<String>();
            for (int i = 0; i < types1.size(); ++i) {
                String type2;
                String type1 = types1.get(i);
                if (type1.equals(type2 = types2.get(i))) continue;
                removeFromIntersection.add(type1);
                removeFromIntersection.add(type2);
            }
            LinkedHashSet<String> intersection = new LinkedHashSet<String>(strings1);
            intersection.retainAll(strings2);
            intersection.removeAll(removeFromIntersection);
            strings1.removeAll(intersection);
            strings2.removeAll(intersection);
        } else {
            this.removeCommonElements(strings1, strings2);
        }
    }

    private LinkedHashSet<String> getVariablesToBeRemovedFromTheIntersection(AbstractCodeFragment statement1, AbstractCodeFragment statement2, Set<String> variableIntersection, Set<String> variables1, Set<String> variables2, ReplacementInfo replacementInfo) {
        LinkedHashSet<String> variablesToBeRemovedFromTheIntersection = new LinkedHashSet<String>();
        OperationInvocation invocationCoveringTheEntireStatement1 = statement1.invocationCoveringEntireFragment();
        OperationInvocation invocationCoveringTheEntireStatement2 = statement2.invocationCoveringEntireFragment();
        for (String variable : variableIntersection) {
            if (!variable.startsWith("this.") && !variableIntersection.contains("this." + variable) && (variables1.contains("this." + variable) || variables2.contains("this." + variable))) {
                variablesToBeRemovedFromTheIntersection.add(variable);
            }
            if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2)) {
                String argumentNoWhiteSpace;
                if (!invocationCoveringTheEntireStatement1.getArguments().contains(variable) && invocationCoveringTheEntireStatement2.getArguments().contains(variable)) {
                    for (String argument : invocationCoveringTheEntireStatement1.getArguments()) {
                        argumentNoWhiteSpace = argument.replaceAll("\\s", "");
                        if (!argument.contains(variable) || argument.equals(variable) || argumentNoWhiteSpace.contains("+" + variable + "+") || argumentNoWhiteSpace.contains(variable + "+") || argumentNoWhiteSpace.contains("+" + variable) || this.nonMatchedStatementUsesVariableInArgument(replacementInfo.statements1, variable, argument)) continue;
                        variablesToBeRemovedFromTheIntersection.add(variable);
                    }
                } else if (invocationCoveringTheEntireStatement1.getArguments().contains(variable) && !invocationCoveringTheEntireStatement2.getArguments().contains(variable)) {
                    for (String argument : invocationCoveringTheEntireStatement2.getArguments()) {
                        argumentNoWhiteSpace = argument.replaceAll("\\s", "");
                        if (!argument.contains(variable) || argument.equals(variable) || argumentNoWhiteSpace.contains("+" + variable + "+") || argumentNoWhiteSpace.contains(variable + "+") || argumentNoWhiteSpace.contains("+" + variable) || this.nonMatchedStatementUsesVariableInArgument(replacementInfo.statements2, variable, argument)) continue;
                        variablesToBeRemovedFromTheIntersection.add(variable);
                    }
                }
            }
            if (!variable.toUpperCase().equals(variable) || ReplacementUtil.sameCharsBeforeAfter(statement1.getString(), statement2.getString(), variable)) continue;
            variablesToBeRemovedFromTheIntersection.add(variable);
        }
        return variablesToBeRemovedFromTheIntersection;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Replacement> findReplacementsWithExactMatching(AbstractCodeFragment statement1, AbstractCodeFragment statement2, Map<String, String> parameterToArgumentMap, ReplacementInfo replacementInfo) throws RefactoringMinerTimedOutException {
        String string;
        String string2;
        String args2;
        String string3;
        Object replacement;
        Object replacement2;
        Replacement r;
        Replacement r2;
        Replacement replacement3;
        OperationInvocation assignmentInvocationCoveringTheEntireStatement1;
        Object anonymousClassDeclaration2;
        OperationInvocation invokedOperationAfter;
        ArrayList<VariableDeclaration> variableDeclarations1 = new ArrayList<VariableDeclaration>(statement1.getVariableDeclarations());
        ArrayList<VariableDeclaration> variableDeclarations2 = new ArrayList<VariableDeclaration>(statement2.getVariableDeclarations());
        VariableDeclaration variableDeclarationWithArrayInitializer1 = this.declarationWithArrayInitializer(variableDeclarations1);
        VariableDeclaration variableDeclarationWithArrayInitializer2 = this.declarationWithArrayInitializer(variableDeclarations2);
        OperationInvocation invocationCoveringTheEntireStatement1 = statement1.invocationCoveringEntireFragment();
        OperationInvocation invocationCoveringTheEntireStatement2 = statement2.invocationCoveringEntireFragment();
        LinkedHashSet<String> variables1 = new LinkedHashSet<String>(statement1.getVariables());
        LinkedHashSet<String> variables2 = new LinkedHashSet<String>(statement2.getVariables());
        LinkedHashSet<String> variableIntersection = new LinkedHashSet<String>(variables1);
        variableIntersection.retainAll(variables2);
        LinkedHashSet<String> variablesToBeRemovedFromTheIntersection = new LinkedHashSet<String>();
        for (String variable : variableIntersection) {
            if (!variable.startsWith("this.") && !variableIntersection.contains("this." + variable) && (variables1.contains("this." + variable) || variables2.contains("this." + variable))) {
                variablesToBeRemovedFromTheIntersection.add(variable);
            }
            if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2)) {
                String argumentNoWhiteSpace;
                if (!invocationCoveringTheEntireStatement1.getArguments().contains(variable) && invocationCoveringTheEntireStatement2.getArguments().contains(variable)) {
                    for (String argument : invocationCoveringTheEntireStatement1.getArguments()) {
                        argumentNoWhiteSpace = argument.replaceAll("\\s", "");
                        if (!argument.contains(variable) || argument.equals(variable) || argumentNoWhiteSpace.contains("+" + variable + "+") || argumentNoWhiteSpace.contains(variable + "+") || argumentNoWhiteSpace.contains("+" + variable) || this.nonMatchedStatementUsesVariableInArgument(replacementInfo.statements1, variable, argument)) continue;
                        variablesToBeRemovedFromTheIntersection.add(variable);
                    }
                } else if (invocationCoveringTheEntireStatement1.getArguments().contains(variable) && !invocationCoveringTheEntireStatement2.getArguments().contains(variable)) {
                    for (String argument : invocationCoveringTheEntireStatement2.getArguments()) {
                        argumentNoWhiteSpace = argument.replaceAll("\\s", "");
                        if (!argument.contains(variable) || argument.equals(variable) || argumentNoWhiteSpace.contains("+" + variable + "+") || argumentNoWhiteSpace.contains(variable + "+") || argumentNoWhiteSpace.contains("+" + variable) || this.nonMatchedStatementUsesVariableInArgument(replacementInfo.statements2, variable, argument)) continue;
                        variablesToBeRemovedFromTheIntersection.add(variable);
                    }
                }
            }
            if (!variable.toUpperCase().equals(variable) || ReplacementUtil.sameCharsBeforeAfter(statement1.getString(), statement2.getString(), variable)) continue;
            variablesToBeRemovedFromTheIntersection.add(variable);
        }
        variableIntersection.removeAll(variablesToBeRemovedFromTheIntersection);
        variables1.removeAll(variableIntersection);
        variables2.removeAll(variableIntersection);
        this.replaceVariablesWithArguments(variables1, parameterToArgumentMap);
        this.replaceVariablesWithArguments(variables2, parameterToArgumentMap);
        LinkedHashMap<String, List<? extends AbstractCall>> methodInvocationMap1 = new LinkedHashMap<String, List<? extends AbstractCall>>(statement1.getMethodInvocationMap());
        LinkedHashMap<String, List<? extends AbstractCall>> methodInvocationMap2 = new LinkedHashMap<String, List<? extends AbstractCall>>(statement2.getMethodInvocationMap());
        LinkedHashSet<String> methodInvocations1 = new LinkedHashSet<String>(methodInvocationMap1.keySet());
        LinkedHashSet<String> methodInvocations2 = new LinkedHashSet<String>(methodInvocationMap2.keySet());
        LinkedHashMap<String, List<? extends AbstractCall>> creationMap1 = new LinkedHashMap<String, List<? extends AbstractCall>>(statement1.getCreationMap());
        LinkedHashMap<String, List<? extends AbstractCall>> creationMap2 = new LinkedHashMap<String, List<? extends AbstractCall>>(statement2.getCreationMap());
        LinkedHashSet<String> creations1 = new LinkedHashSet<String>(creationMap1.keySet());
        LinkedHashSet<String> creations2 = new LinkedHashSet<String>(creationMap2.keySet());
        LinkedHashSet<String> arguments1 = new LinkedHashSet<String>(statement1.getArguments());
        LinkedHashSet<String> arguments2 = new LinkedHashSet<String>(statement2.getArguments());
        this.removeCommonElements(arguments1, arguments2);
        if (!this.argumentsWithIdenticalMethodCalls(arguments1, arguments2, variables1, variables2)) {
            this.findReplacements(arguments1, variables2, replacementInfo, Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_VARIABLE);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        LinkedHashSet<Replacement> replacementsToBeRemoved = new LinkedHashSet<Replacement>();
        LinkedHashSet<Replacement> replacementsToBeAdded = new LinkedHashSet<Replacement>();
        for (Replacement r3 : replacementInfo.getReplacements()) {
            map.put(r3.getBefore(), r3.getAfter());
            if (!methodInvocationMap1.containsKey(r3.getBefore())) continue;
            Iterator replacement5 = new VariableReplacementWithMethodInvocation(r3.getBefore(), r3.getAfter(), (OperationInvocation)((List)methodInvocationMap1.get(r3.getBefore())).get(0), VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
            replacementsToBeAdded.add((Replacement)((Object)replacement5));
            replacementsToBeRemoved.add(r3);
        }
        replacementInfo.getReplacements().removeAll(replacementsToBeRemoved);
        replacementInfo.getReplacements().addAll(replacementsToBeAdded);
        this.replaceVariablesWithArguments(methodInvocationMap1, methodInvocations1, parameterToArgumentMap);
        this.replaceVariablesWithArguments(methodInvocationMap2, methodInvocations2, parameterToArgumentMap);
        this.replaceVariablesWithArguments(methodInvocationMap1, methodInvocations1, map);
        if (invocationCoveringTheEntireStatement1 != null) {
            for (String methodInvocation1 : methodInvocationMap1.keySet()) {
                for (AbstractCall call : (List)methodInvocationMap1.get(methodInvocation1)) {
                    if (!invocationCoveringTheEntireStatement1.getLocationInfo().equals(call.getLocationInfo())) continue;
                    methodInvocations1.remove(methodInvocation1);
                }
            }
        }
        if (invocationCoveringTheEntireStatement2 != null) {
            for (String methodInvocation2 : methodInvocationMap2.keySet()) {
                for (AbstractCall call : (List)methodInvocationMap2.get(methodInvocation2)) {
                    if (!invocationCoveringTheEntireStatement2.getLocationInfo().equals(call.getLocationInfo())) continue;
                    methodInvocations2.remove(methodInvocation2);
                }
            }
        }
        LinkedHashSet<String> methodInvocationIntersection = new LinkedHashSet<String>(methodInvocations1);
        methodInvocationIntersection.retainAll(methodInvocations2);
        LinkedHashSet<String> methodInvocationsToBeRemovedFromTheIntersection = new LinkedHashSet<String>();
        for (String methodInvocation : methodInvocationIntersection) {
            if (invocationCoveringTheEntireStatement1 == null || invocationCoveringTheEntireStatement2 == null || !invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2)) continue;
            if (!invocationCoveringTheEntireStatement1.getArguments().contains(methodInvocation) && invocationCoveringTheEntireStatement2.getArguments().contains(methodInvocation)) {
                methodInvocationsToBeRemovedFromTheIntersection.add(methodInvocation);
                continue;
            }
            if (!invocationCoveringTheEntireStatement1.getArguments().contains(methodInvocation) || invocationCoveringTheEntireStatement2.getArguments().contains(methodInvocation)) continue;
            methodInvocationsToBeRemovedFromTheIntersection.add(methodInvocation);
        }
        methodInvocationIntersection.removeAll(methodInvocationsToBeRemovedFromTheIntersection);
        methodInvocations1.removeAll(methodInvocationIntersection);
        methodInvocations2.removeAll(methodInvocationIntersection);
        LinkedHashSet<String> variablesAndMethodInvocations1 = new LinkedHashSet<String>();
        LinkedHashSet<String> variablesAndMethodInvocations2 = new LinkedHashSet<String>();
        variablesAndMethodInvocations2.addAll(methodInvocations2);
        variablesAndMethodInvocations2.addAll(variables2);
        LinkedHashSet<String> types1 = new LinkedHashSet<String>(statement1.getTypes());
        LinkedHashSet<String> types2 = new LinkedHashSet<String>(statement2.getTypes());
        this.removeCommonTypes(types1, types2, statement1.getTypes(), statement2.getTypes());
        this.replaceVariablesWithArguments(creationMap1, creations1, parameterToArgumentMap);
        this.replaceVariablesWithArguments(creationMap2, creations2, parameterToArgumentMap);
        this.replaceVariablesWithArguments(creationMap1, creations1, map);
        ObjectCreation creationCoveringTheEntireStatement1 = statement1.creationCoveringEntireFragment();
        ObjectCreation creationCoveringTheEntireStatement2 = statement2.creationCoveringEntireFragment();
        for (String objectCreation1 : creationMap1.keySet()) {
            for (AbstractCall creation1 : (List)creationMap1.get(objectCreation1)) {
                if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement1.getLocationInfo().equals(creation1.getLocationInfo())) {
                    creations1.remove(objectCreation1);
                }
                if (((ObjectCreation)creation1).getAnonymousClassDeclaration() == null) continue;
                creations1.remove(objectCreation1);
            }
        }
        for (String objectCreation2 : creationMap2.keySet()) {
            for (AbstractCall creation2 : (List)creationMap2.get(objectCreation2)) {
                if (creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement2.getLocationInfo().equals(creation2.getLocationInfo())) {
                    creations2.remove(objectCreation2);
                }
                if (((ObjectCreation)creation2).getAnonymousClassDeclaration() == null) continue;
                creations2.remove(objectCreation2);
            }
        }
        LinkedHashSet<String> creationIntersection = new LinkedHashSet<String>(creations1);
        creationIntersection.retainAll(creations2);
        creations1.removeAll(creationIntersection);
        creations2.removeAll(creationIntersection);
        LinkedHashSet<String> stringLiterals1 = new LinkedHashSet<String>(statement1.getStringLiterals());
        LinkedHashSet<String> stringLiterals2 = new LinkedHashSet<String>(statement2.getStringLiterals());
        this.removeCommonElements(stringLiterals1, stringLiterals2);
        LinkedHashSet<String> numberLiterals1 = new LinkedHashSet<String>(statement1.getNumberLiterals());
        LinkedHashSet<String> numberLiterals2 = new LinkedHashSet<String>(statement2.getNumberLiterals());
        this.removeCommonElements(numberLiterals1, numberLiterals2);
        LinkedHashSet<String> booleanLiterals1 = new LinkedHashSet<String>(statement1.getBooleanLiterals());
        LinkedHashSet<String> booleanLiterals2 = new LinkedHashSet<String>(statement2.getBooleanLiterals());
        this.removeCommonElements(booleanLiterals1, booleanLiterals2);
        LinkedHashSet<String> infixOperators1 = new LinkedHashSet<String>(statement1.getInfixOperators());
        LinkedHashSet<String> infixOperators2 = new LinkedHashSet<String>(statement2.getInfixOperators());
        this.removeCommonElements(infixOperators1, infixOperators2);
        LinkedHashSet<String> arrayAccesses1 = new LinkedHashSet<String>(statement1.getArrayAccesses());
        LinkedHashSet<String> arrayAccesses2 = new LinkedHashSet<String>(statement2.getArrayAccesses());
        this.removeCommonElements(arrayAccesses1, arrayAccesses2);
        LinkedHashSet<String> prefixExpressions1 = new LinkedHashSet<String>(statement1.getPrefixExpressions());
        LinkedHashSet<String> prefixExpressions2 = new LinkedHashSet<String>(statement2.getPrefixExpressions());
        this.removeCommonElements(prefixExpressions1, prefixExpressions2);
        this.findReplacements(types1, types2, replacementInfo, Replacement.ReplacementType.TYPE);
        this.findReplacements(infixOperators1, infixOperators2, replacementInfo, Replacement.ReplacementType.INFIX_OPERATOR);
        Iterator iterator = methodInvocations1.iterator();
        while (iterator.hasNext()) {
            String methodInvocation1;
            String temp = methodInvocation1 = (String)iterator.next();
            for (Replacement replacement4 : replacementInfo.getReplacements()) {
                temp = ReplacementUtil.performReplacement(temp, replacement4.getBefore(), replacement4.getAfter());
            }
            if (temp.equals(methodInvocation1)) continue;
            variablesAndMethodInvocations1.add(temp);
            methodInvocationMap1.put(temp, (List)methodInvocationMap1.get(methodInvocation1));
        }
        methodInvocations1.addAll(variablesAndMethodInvocations1);
        variablesAndMethodInvocations1.addAll(methodInvocations1);
        variablesAndMethodInvocations1.addAll(variables1);
        if (replacementInfo.getRawDistance() > 0) {
            for (String s1 : variablesAndMethodInvocations1) {
                TreeMap<Double, void> replacementMap = new TreeMap<Double, void>();
                int minDistance = replacementInfo.getRawDistance();
                for (String s2 : variablesAndMethodInvocations2) {
                    void var59_102;
                    boolean multipleInstanceRule;
                    boolean multipleInstances;
                    if (Thread.interrupted()) {
                        throw new RefactoringMinerTimedOutException();
                    }
                    String temp = ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), s1, s2);
                    int distanceRaw = StringDistance.editDistance(temp, replacementInfo.getArgumentizedString2(), minDistance);
                    boolean bl = multipleInstances = ReplacementUtil.countInstances(temp, s2) > 1;
                    if (distanceRaw == -1 && multipleInstances) {
                        distanceRaw = StringDistance.editDistance(temp, replacementInfo.getArgumentizedString2());
                    }
                    boolean bl2 = multipleInstanceRule = multipleInstances && Math.abs(s1.length() - s2.length()) == Math.abs(distanceRaw - minDistance) && !s1.equals(s2);
                    if (distanceRaw < 0 || distanceRaw >= replacementInfo.getRawDistance() && !multipleInstanceRule) continue;
                    minDistance = distanceRaw;
                    Object var59_103 = null;
                    if (variables1.contains(s1) && variables2.contains(s2) && this.variablesStartWithSameCase(s1, s2, parameterToArgumentMap)) {
                        VariableDeclaration v2;
                        VariableDeclaration v1;
                        String prefix2;
                        String prefix12;
                        Replacement replacement5 = new Replacement(s1, s2, Replacement.ReplacementType.VARIABLE_NAME);
                        if (s1.startsWith("(") && s2.startsWith("(") && s1.contains(")") && s2.contains(")") && (prefix12 = s1.substring(0, s1.indexOf(")") + 1)).equals(prefix2 = s2.substring(0, s2.indexOf(")") + 1))) {
                            String suffix1 = s1.substring(prefix12.length());
                            String suffix2 = s2.substring(prefix2.length());
                            Replacement replacement6 = new Replacement(suffix1, suffix2, Replacement.ReplacementType.VARIABLE_NAME);
                        }
                        if (this.inconsistentVariableMappingCount(statement1, statement2, v1 = statement1.searchVariableDeclaration(s1), v2 = statement2.searchVariableDeclaration(s2)) > 1 && this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) == null) {
                            Object var59_107 = null;
                        }
                    } else if (variables1.contains(s1) && methodInvocations2.contains(s2)) {
                        OperationInvocation invokedOperationAfter2 = (OperationInvocation)((List)methodInvocationMap2.get(s2)).get(0);
                        VariableReplacementWithMethodInvocation variableReplacementWithMethodInvocation = new VariableReplacementWithMethodInvocation(s1, s2, invokedOperationAfter2, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    } else if (methodInvocations1.contains(s1) && methodInvocations2.contains(s2)) {
                        OperationInvocation invokedOperationBefore = (OperationInvocation)((List)methodInvocationMap1.get(s1)).get(0);
                        if (invokedOperationBefore.compatibleExpression(invokedOperationAfter = (OperationInvocation)((List)methodInvocationMap2.get(s2)).get(0))) {
                            MethodInvocationReplacement methodInvocationReplacement = new MethodInvocationReplacement(s1, s2, invokedOperationBefore, invokedOperationAfter, Replacement.ReplacementType.METHOD_INVOCATION);
                        }
                    } else if (methodInvocations1.contains(s1) && variables2.contains(s2)) {
                        OperationInvocation invokedOperationBefore = (OperationInvocation)((List)methodInvocationMap1.get(s1)).get(0);
                        VariableReplacementWithMethodInvocation variableReplacementWithMethodInvocation = new VariableReplacementWithMethodInvocation(s1, s2, invokedOperationBefore, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    }
                    if (var59_102 != null) {
                        double distancenormalized = (double)distanceRaw / (double)Math.max(temp.length(), replacementInfo.getArgumentizedString2().length());
                        replacementMap.put(distancenormalized, var59_102);
                    }
                    if (distanceRaw != 0 || replacementInfo.getReplacements().isEmpty()) continue;
                    break;
                }
                if (replacementMap.isEmpty()) continue;
                Replacement replacement7 = (Replacement)replacementMap.firstEntry().getValue();
                replacementInfo.addReplacement(replacement7);
                replacementInfo.setArgumentizedString1(ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), replacement7.getBefore(), replacement7.getAfter()));
                if ((Double)replacementMap.firstEntry().getKey() != 0.0) continue;
                break;
            }
        }
        this.findReplacements(creations1, creations2, replacementInfo, Replacement.ReplacementType.CLASS_INSTANCE_CREATION);
        this.findReplacements(stringLiterals1, stringLiterals2, replacementInfo, Replacement.ReplacementType.STRING_LITERAL);
        this.findReplacements(numberLiterals1, numberLiterals2, replacementInfo, Replacement.ReplacementType.NUMBER_LITERAL);
        if (!(statement1.containsInitializerOfVariableDeclaration(numberLiterals1) || statement2.containsInitializerOfVariableDeclaration(variables2) || statement1.getString().endsWith("=0\n"))) {
            this.findReplacements(numberLiterals1, variables2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_NUMBER_LITERAL);
        }
        this.findReplacements(variables1, arrayAccesses2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS);
        this.findReplacements(arrayAccesses1, variables2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS);
        this.findReplacements(methodInvocations1, arrayAccesses2, replacementInfo, Replacement.ReplacementType.ARRAY_ACCESS_REPLACED_WITH_METHOD_INVOCATION);
        this.findReplacements(arrayAccesses1, methodInvocations2, replacementInfo, Replacement.ReplacementType.ARRAY_ACCESS_REPLACED_WITH_METHOD_INVOCATION);
        this.findReplacements(variables1, prefixExpressions2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION);
        this.findReplacements(prefixExpressions1, variables2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION);
        this.findReplacements(stringLiterals1, variables2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_STRING_LITERAL);
        if (statement1.getNullLiterals().isEmpty() && !statement2.getNullLiterals().isEmpty()) {
            LinkedHashSet<String> nullLiterals2 = new LinkedHashSet<String>();
            nullLiterals2.add("Null");
            this.findReplacements(variables1, nullLiterals2, replacementInfo, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_NULL_LITERAL);
        }
        if (!statement1.getString().endsWith("=True\n") && !statement1.getString().endsWith("=False\n")) {
            this.findReplacements(booleanLiterals1, variables2, replacementInfo, Replacement.ReplacementType.BOOLEAN_REPLACED_WITH_VARIABLE);
        }
        if (!statement2.getString().endsWith("=True\n") && !statement2.getString().endsWith("=False\n")) {
            this.findReplacements(arguments1, booleanLiterals2, replacementInfo, Replacement.ReplacementType.BOOLEAN_REPLACED_WITH_ARGUMENT);
        }
        String s1 = this.preprocessInput1(statement1, statement2);
        String s2 = this.preprocessInput2(statement1, statement2);
        replacementsToBeRemoved = new LinkedHashSet();
        replacementsToBeAdded = new LinkedHashSet();
        for (Replacement replacement7 : replacementInfo.getReplacements()) {
            Object r22;
            Replacement r4;
            s1 = ReplacementUtil.performReplacement(s1, s2, replacement7.getBefore(), replacement7.getAfter());
            Set<Replacement> set = this.replacementsWithinMethodInvocations(replacement7.getBefore(), replacement7.getAfter(), variables1, methodInvocations2, methodInvocationMap2, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
            set.addAll(this.replacementsWithinMethodInvocations(replacement7.getBefore(), replacement7.getAfter(), methodInvocations1, variables2, methodInvocationMap1, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE));
            if (!set.isEmpty()) {
                replacementsToBeRemoved.add(replacement7);
                replacementsToBeAdded.addAll(set);
            }
            if ((r4 = this.variableReplacementWithinMethodInvocations(replacement7.getBefore(), replacement7.getAfter(), variables1, variables2)) != null) {
                replacementsToBeRemoved.add(replacement7);
                replacementsToBeAdded.add(r4);
            }
            if ((r22 = this.variableReplacementWithinMethodInvocations(replacement7.getBefore(), replacement7.getAfter(), stringLiterals1, variables2)) == null) continue;
            replacementsToBeRemoved.add(replacement7);
            replacementsToBeAdded.add((Replacement)r22);
        }
        replacementInfo.removeReplacements(replacementsToBeRemoved);
        replacementInfo.addReplacements(replacementsToBeAdded);
        boolean isEqualWithReplacement = s1.equals(s2) || replacementInfo.argumentizedString1.equals(replacementInfo.argumentizedString2) || this.differOnlyInCastExpressionOrPrefixOperator(s1, s2, replacementInfo) || this.oneIsVariableDeclarationTheOtherIsVariableAssignment(s1, s2, replacementInfo) || this.identicalVariableDeclarationsWithDifferentNames(s1, s2, variableDeclarations1, variableDeclarations2, replacementInfo) || this.oneIsVariableDeclarationTheOtherIsReturnStatement(s1, s2) || this.oneIsVariableDeclarationTheOtherIsReturnStatement(statement1.getString(), statement2.getString()) || this.containsValidOperatorReplacements(replacementInfo) && (this.equalAfterInfixExpressionExpansion(s1, s2, replacementInfo, statement1.getInfixExpressions()) || this.commonConditional(s1, s2, replacementInfo)) || this.equalAfterArgumentMerge(s1, s2, replacementInfo) || this.equalAfterNewArgumentAdditions(s1, s2, replacementInfo) || this.validStatementForConcatComparison(statement1, statement2) && this.commonConcat(s1, s2, replacementInfo);
        List<AnonymousClassDeclarationObject> anonymousClassDeclarations1 = statement1.getAnonymousClassDeclarations();
        List<AnonymousClassDeclarationObject> list = statement2.getAnonymousClassDeclarations();
        if (isEqualWithReplacement) {
            List<Replacement> typeReplacements = replacementInfo.getReplacements(Replacement.ReplacementType.TYPE);
            if (typeReplacements.size() > 0 && invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null) {
                for (Replacement typeReplacement : typeReplacements) {
                    if (!invocationCoveringTheEntireStatement1.getMethodName().contains(typeReplacement.getBefore()) || !invocationCoveringTheEntireStatement2.getMethodName().contains(typeReplacement.getAfter())) continue;
                    if (invocationCoveringTheEntireStatement1.identicalExpression(invocationCoveringTheEntireStatement2) && invocationCoveringTheEntireStatement1.equalArguments(invocationCoveringTheEntireStatement2)) {
                        MethodInvocationReplacement replacement8 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.getName(), invocationCoveringTheEntireStatement2.getName(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_NAME);
                        replacementInfo.addReplacement(replacement8);
                        break;
                    }
                    MethodInvocationReplacement replacement9 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION);
                    replacementInfo.addReplacement(replacement9);
                    break;
                }
            }
            if (this.variableDeclarationsWithEverythingReplaced(variableDeclarations1, variableDeclarations2, replacementInfo) && !statement1.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT) && !statement2.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT)) {
                return null;
            }
            if (this.variableAssignmentWithEverythingReplaced(statement1, statement2, replacementInfo)) {
                return null;
            }
            if (this.classInstanceCreationWithEverythingReplaced(statement1, statement2, replacementInfo, parameterToArgumentMap)) {
                return null;
            }
            if (!anonymousClassDeclarations1.isEmpty() && !list.isEmpty()) {
                LinkedHashSet<Replacement> replacementsInsideAnonymous = new LinkedHashSet<Replacement>();
                block19: for (Replacement replacement10 : replacementInfo.getReplacements()) {
                    if (!(replacement10 instanceof MethodInvocationReplacement)) continue;
                    for (int i = 0; i < anonymousClassDeclarations1.size(); ++i) {
                        void var59_114;
                        boolean bl = false;
                        while (var59_114 < list.size()) {
                            AnonymousClassDeclarationObject anonymousClassDeclaration1 = anonymousClassDeclarations1.get(i);
                            anonymousClassDeclaration2 = list.get((int)var59_114);
                            if (anonymousClassDeclaration1.getMethodInvocationMap().containsKey(replacement10.getBefore()) && ((AnonymousClassDeclarationObject)anonymousClassDeclaration2).getMethodInvocationMap().containsKey(replacement10.getAfter())) {
                                replacementsInsideAnonymous.add(replacement10);
                                break;
                            }
                            ++var59_114;
                        }
                        if (replacementsInsideAnonymous.contains(replacement10)) continue block19;
                    }
                }
                for (Replacement replacement11 : replacementsInsideAnonymous) {
                    this.equalAfterNewArgumentAdditions(replacement11.getBefore(), replacement11.getAfter(), replacementInfo);
                }
            }
            return replacementInfo.getReplacements();
        }
        List<LambdaExpressionObject> lambdas1 = statement1.getLambdas();
        List<LambdaExpressionObject> lambdas2 = statement2.getLambdas();
        ArrayList<UMLOperationBodyMapper> lambdaMappers = new ArrayList<UMLOperationBodyMapper>();
        if (!lambdas1.isEmpty() && !lambdas2.isEmpty()) {
            for (int i = 0; i < lambdas1.size(); ++i) {
                for (int j = 0; j < lambdas2.size(); ++j) {
                    LambdaExpressionObject lambda2;
                    LambdaExpressionObject lambdaExpressionObject = lambdas1.get(i);
                    UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(lambdaExpressionObject, lambda2 = lambdas2.get(j), this);
                    int mappings = mapper.mappingsWithoutBlocks();
                    if (mappings <= 0) continue;
                    int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                    int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                    if (mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) continue;
                    this.mappings.addAll(mapper.mappings);
                    this.nonMappedInnerNodesT1.addAll(mapper.nonMappedInnerNodesT1);
                    this.nonMappedInnerNodesT2.addAll(mapper.nonMappedInnerNodesT2);
                    this.nonMappedLeavesT1.addAll(mapper.nonMappedLeavesT1);
                    this.nonMappedLeavesT2.addAll(mapper.nonMappedLeavesT2);
                    this.refactorings.addAll(mapper.getRefactorings());
                    lambdaMappers.add(mapper);
                }
            }
        }
        OperationInvocation operationInvocation = assignmentInvocationCoveringTheEntireStatement1 = invocationCoveringTheEntireStatement1 == null ? statement1.assignmentInvocationCoveringEntireStatement() : invocationCoveringTheEntireStatement1;
        if (assignmentInvocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null) {
            for (String string4 : methodInvocationMap1.keySet()) {
                for (AbstractCall invocation1 : (List)methodInvocationMap1.get(string4)) {
                    if (invocation1.identical(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), lambdaMappers) && !assignmentInvocationCoveringTheEntireStatement1.getArguments().contains(string4)) {
                        String expression1 = assignmentInvocationCoveringTheEntireStatement1.getExpression();
                        if (expression1 != null && expression1.contains(string4)) continue;
                        return replacementInfo.getReplacements();
                    }
                    if (!invocation1.identicalName(invocationCoveringTheEntireStatement2) || !invocation1.equalArguments(invocationCoveringTheEntireStatement2) || assignmentInvocationCoveringTheEntireStatement1.getArguments().contains(string4) || invocationCoveringTheEntireStatement2.getExpression() == null) continue;
                    boolean expressionMatched = false;
                    LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements2 = new LinkedHashSet<AbstractCodeFragment>();
                    for (AbstractCodeFragment abstractCodeFragment : replacementInfo.statements2) {
                        VariableDeclaration variableDeclaration = abstractCodeFragment.getVariableDeclaration(invocationCoveringTheEntireStatement2.getExpression());
                        OperationInvocation invocationCoveringEntireCodeFragment = abstractCodeFragment.invocationCoveringEntireFragment();
                        if (variableDeclaration != null && variableDeclaration.getInitializer() != null && invocation1.getExpression() != null && invocation1.getExpression().equals(variableDeclaration.getInitializer().getString())) {
                            Replacement r5 = new Replacement(invocation1.getExpression(), variableDeclaration.getVariableName(), Replacement.ReplacementType.VARIABLE_REPLACED_WITH_EXPRESSION_OF_METHOD_INVOCATION);
                            replacementInfo.getReplacements().add(r5);
                            additionallyMatchedStatements2.add(abstractCodeFragment);
                            expressionMatched = true;
                        }
                        if (invocationCoveringEntireCodeFragment == null || !assignmentInvocationCoveringTheEntireStatement1.identicalName(invocationCoveringEntireCodeFragment) || !assignmentInvocationCoveringTheEntireStatement1.equalArguments(invocationCoveringEntireCodeFragment)) continue;
                        additionallyMatchedStatements2.add(abstractCodeFragment);
                    }
                    if (!expressionMatched) continue;
                    if (additionallyMatchedStatements2.size() > 0) {
                        CompositeReplacement r6 = new CompositeReplacement(statement1.getString(), statement2.getString(), new LinkedHashSet<AbstractCodeFragment>(), additionallyMatchedStatements2);
                        replacementInfo.getReplacements().add(r6);
                    }
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalWithExpressionCallChainDifference(invocationCoveringTheEntireStatement2)) {
            List invokedOperationsBefore = (List)methodInvocationMap1.get(invocationCoveringTheEntireStatement1.getExpression());
            List list2 = (List)methodInvocationMap2.get(invocationCoveringTheEntireStatement2.getExpression());
            if (invokedOperationsBefore != null && invokedOperationsBefore.size() > 0 && list2 != null && list2.size() > 0) {
                OperationInvocation invokedOperationBefore = (OperationInvocation)invokedOperationsBefore.get(0);
                invokedOperationAfter = (OperationInvocation)list2.get(0);
                MethodInvocationReplacement replacement32 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.getExpression(), invocationCoveringTheEntireStatement2.getExpression(), invokedOperationBefore, invokedOperationAfter, Replacement.ReplacementType.METHOD_INVOCATION_EXPRESSION);
                replacementInfo.addReplacement(replacement32);
                return replacementInfo.getReplacements();
            }
            if (invokedOperationsBefore != null && invokedOperationsBefore.size() > 0) {
                OperationInvocation invokedOperationBefore = (OperationInvocation)invokedOperationsBefore.get(0);
                VariableReplacementWithMethodInvocation replacement12 = new VariableReplacementWithMethodInvocation(invocationCoveringTheEntireStatement1.getExpression(), invocationCoveringTheEntireStatement2.getExpression(), invokedOperationBefore, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                replacementInfo.addReplacement(replacement12);
                return replacementInfo.getReplacements();
            }
            if (list2 != null && list2.size() > 0) {
                OperationInvocation invokedOperationAfter3 = (OperationInvocation)list2.get(0);
                VariableReplacementWithMethodInvocation replacement8 = new VariableReplacementWithMethodInvocation(invocationCoveringTheEntireStatement1.getExpression(), invocationCoveringTheEntireStatement2.getExpression(), invokedOperationAfter3, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                replacementInfo.addReplacement(replacement8);
                return replacementInfo.getReplacements();
            }
            if (invocationCoveringTheEntireStatement1.numberOfSubExpressions() == invocationCoveringTheEntireStatement2.numberOfSubExpressions() && invocationCoveringTheEntireStatement1.getExpression().contains(".") == invocationCoveringTheEntireStatement2.getExpression().contains(".")) {
                return replacementInfo.getReplacements();
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalExpression(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements()) && invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2)) {
            for (String string5 : methodInvocationMap2.keySet()) {
                for (AbstractCall invocation2 : (List)methodInvocationMap2.get(string5)) {
                    if (!invocationCoveringTheEntireStatement1.identicalOrReplacedArguments(invocation2, replacementInfo.getReplacements(), lambdaMappers)) continue;
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalExpression(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements()) && invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2)) {
            for (String string6 : methodInvocationMap2.keySet()) {
                for (AbstractCall invocation2 : (List)methodInvocationMap2.get(string6)) {
                    if (invocationCoveringTheEntireStatement1.identicalOrWrappedArguments(invocation2)) {
                        replacement3 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT_WRAPPED);
                        replacementInfo.addReplacement(replacement3);
                        return replacementInfo.getReplacements();
                    }
                    if (!invocationCoveringTheEntireStatement1.identicalOrConcatenatedArguments(invocation2)) continue;
                    replacement3 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT_CONCATENATED);
                    replacementInfo.addReplacement(replacement3);
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.renamedWithIdenticalExpressionAndArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), 0.4, lambdaMappers)) {
            MethodInvocationReplacement replacement13 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.getName(), invocationCoveringTheEntireStatement2.getName(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_NAME);
            replacementInfo.addReplacement(replacement13);
            return replacementInfo.getReplacements();
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.renamedWithIdenticalArgumentsAndNoExpression(invocationCoveringTheEntireStatement2, 0.4, lambdaMappers)) {
            MethodInvocationReplacement replacement14 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.getName(), invocationCoveringTheEntireStatement2.getName(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_NAME);
            replacementInfo.addReplacement(replacement14);
            return replacementInfo.getReplacements();
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.renamedWithDifferentExpressionAndIdenticalArguments(invocationCoveringTheEntireStatement2)) {
            MethodInvocationReplacement replacement15 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_NAME_AND_EXPRESSION);
            replacementInfo.addReplacement(replacement15);
            return replacementInfo.getReplacements();
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.renamedWithIdenticalExpressionAndDifferentNumberOfArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), 0.4, lambdaMappers)) {
            Replacement.ReplacementType type = invocationCoveringTheEntireStatement1.getName().equals(invocationCoveringTheEntireStatement2.getName()) ? Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT : Replacement.ReplacementType.METHOD_INVOCATION_NAME_AND_ARGUMENT;
            MethodInvocationReplacement methodInvocationReplacement = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, type);
            replacementInfo.addReplacement(methodInvocationReplacement);
            return replacementInfo.getReplacements();
        }
        if (!methodInvocations1.isEmpty() && invocationCoveringTheEntireStatement2 != null) {
            for (String string7 : methodInvocations1) {
                for (Object operationInvocation1 : (List)methodInvocationMap1.get(string7)) {
                    if (!((AbstractCall)operationInvocation1).renamedWithIdenticalExpressionAndDifferentNumberOfArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), 0.4, lambdaMappers) || this.isExpressionOfAnotherMethodInvocation((AbstractCall)operationInvocation1, (Map<String, List<? extends AbstractCall>>)methodInvocationMap1)) continue;
                    Replacement.ReplacementType type = ((AbstractCall)operationInvocation1).getName().equals(invocationCoveringTheEntireStatement2.getName()) ? Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT : Replacement.ReplacementType.METHOD_INVOCATION_NAME_AND_ARGUMENT;
                    MethodInvocationReplacement replacement22 = new MethodInvocationReplacement(((AbstractCall)operationInvocation1).actualString(), invocationCoveringTheEntireStatement2.actualString(), (OperationInvocation)operationInvocation1, invocationCoveringTheEntireStatement2, type);
                    replacementInfo.addReplacement(replacement22);
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null) {
            if (invocationCoveringTheEntireStatement1.identicalWithMergedArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements())) {
                return replacementInfo.getReplacements();
            }
            if (invocationCoveringTheEntireStatement1.identicalWithDifferentNumberOfArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), parameterToArgumentMap)) {
                MethodInvocationReplacement replacement16 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), invocationCoveringTheEntireStatement2.actualString(), invocationCoveringTheEntireStatement1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT);
                replacementInfo.addReplacement(replacement16);
                return replacementInfo.getReplacements();
            }
        }
        if (!methodInvocations1.isEmpty() && invocationCoveringTheEntireStatement2 != null) {
            for (String string8 : methodInvocations1) {
                for (Object operationInvocation1 : (List)methodInvocationMap1.get(string8)) {
                    if (((AbstractCall)operationInvocation1).identicalWithMergedArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements())) {
                        return replacementInfo.getReplacements();
                    }
                    if (!((AbstractCall)operationInvocation1).identicalWithDifferentNumberOfArguments(invocationCoveringTheEntireStatement2, replacementInfo.getReplacements(), parameterToArgumentMap)) continue;
                    replacement3 = new MethodInvocationReplacement(((AbstractCall)operationInvocation1).actualString(), invocationCoveringTheEntireStatement2.actualString(), (OperationInvocation)operationInvocation1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT);
                    replacementInfo.addReplacement(replacement3);
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && (r2 = invocationCoveringTheEntireStatement1.makeReplacementForReturnedArgument(replacementInfo.getArgumentizedString2())) != null) {
            replacementInfo.addReplacement(r2);
            return replacementInfo.getReplacements();
        }
        for (String methodInvocation1 : methodInvocations1) {
            for (AbstractCall operationInvocation1 : (List)methodInvocationMap1.get(methodInvocation1)) {
                Replacement r3;
                if (!statement1.getString().endsWith(methodInvocation1 + ";\n") || (r3 = operationInvocation1.makeReplacementForReturnedArgument(replacementInfo.getArgumentizedString2())) == null || operationInvocation1.makeReplacementForReturnedArgument(statement2.getString()) == null) continue;
                replacementInfo.addReplacement(r3);
                return replacementInfo.getReplacements();
            }
        }
        if (invocationCoveringTheEntireStatement2 != null && (r = invocationCoveringTheEntireStatement2.makeReplacementForWrappedCall(replacementInfo.getArgumentizedString1())) != null) {
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        for (String methodInvocation2 : methodInvocations2) {
            for (AbstractCall operationInvocation2 : (List)methodInvocationMap2.get(methodInvocation2)) {
                if (!statement2.getString().endsWith(methodInvocation2 + ";\n") || (r = operationInvocation2.makeReplacementForWrappedCall(replacementInfo.getArgumentizedString1())) == null || operationInvocation2.makeReplacementForWrappedCall(statement1.getString()) == null) continue;
                replacementInfo.addReplacement(r);
                return replacementInfo.getReplacements();
            }
        }
        if (invocationCoveringTheEntireStatement2 != null && (r = invocationCoveringTheEntireStatement2.makeReplacementForAssignedArgument(replacementInfo.getArgumentizedString1())) != null && methodInvocationMap1.containsKey(invocationCoveringTheEntireStatement2.getArguments().get(0))) {
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        if (invocationCoveringTheEntireStatement2 != null) {
            for (String key1 : methodInvocationMap1.keySet()) {
                for (AbstractCall invocation1 : (List)methodInvocationMap1.get(key1)) {
                    if (!statement1.getString().endsWith(key1 + ";\n")) continue;
                    if (methodInvocationMap2.containsKey(invocation1.getExpression())) {
                        replacement2 = new MethodInvocationReplacement(invocation1.actualString(), invocationCoveringTheEntireStatement2.actualString(), (OperationInvocation)invocation1, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION);
                        replacementInfo.addReplacement((Replacement)replacement2);
                        return replacementInfo.getReplacements();
                    }
                    if (!(invocation1 instanceof OperationInvocation)) continue;
                    for (String subExpression1 : ((OperationInvocation)invocation1).getSubExpressions()) {
                        void var65_194;
                        if (!methodInvocationMap2.containsKey(subExpression1)) continue;
                        Object var65_192 = null;
                        for (String key : methodInvocationMap1.keySet()) {
                            if (!key.endsWith(subExpression1)) continue;
                            AbstractCall abstractCall = (AbstractCall)((List)methodInvocationMap1.get(key)).get(0);
                            break;
                        }
                        replacement = new MethodInvocationReplacement(subExpression1, invocationCoveringTheEntireStatement2.actualString(), (OperationInvocation)var65_194, invocationCoveringTheEntireStatement2, Replacement.ReplacementType.METHOD_INVOCATION);
                        replacementInfo.addReplacement((Replacement)replacement);
                        return replacementInfo.getReplacements();
                    }
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null) {
            for (String key2 : methodInvocationMap2.keySet()) {
                for (Object invocation2 : (List)methodInvocationMap2.get(key2)) {
                    if (!statement2.getString().endsWith(key2 + ";\n")) continue;
                    if (methodInvocationMap1.containsKey(((AbstractCall)invocation2).getExpression())) {
                        replacement2 = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), ((AbstractCall)invocation2).actualString(), invocationCoveringTheEntireStatement1, (OperationInvocation)invocation2, Replacement.ReplacementType.METHOD_INVOCATION);
                        replacementInfo.addReplacement((Replacement)replacement2);
                        return replacementInfo.getReplacements();
                    }
                    if (!(invocation2 instanceof OperationInvocation)) continue;
                    for (String subExpression2 : ((OperationInvocation)invocation2).getSubExpressions()) {
                        void var65_197;
                        if (!methodInvocationMap1.containsKey(subExpression2)) continue;
                        Object var65_195 = null;
                        for (String key : methodInvocationMap2.keySet()) {
                            if (!key.endsWith(subExpression2)) continue;
                            AbstractCall abstractCall = (AbstractCall)((List)methodInvocationMap2.get(key)).get(0);
                            break;
                        }
                        replacement = new MethodInvocationReplacement(invocationCoveringTheEntireStatement1.actualString(), subExpression2, invocationCoveringTheEntireStatement1, (OperationInvocation)var65_197, Replacement.ReplacementType.METHOD_INVOCATION);
                        replacementInfo.addReplacement((Replacement)replacement);
                        return replacementInfo.getReplacements();
                    }
                }
            }
        }
        if (creationCoveringTheEntireStatement1 != null) {
            for (String key2 : methodInvocationMap2.keySet()) {
                for (Object invocation2 : (List)methodInvocationMap2.get(key2)) {
                    if (!statement2.getString().endsWith(key2 + ";\n") || !creationCoveringTheEntireStatement1.getArguments().contains(((AbstractCall)invocation2).getExpression())) continue;
                    replacement2 = new ClassInstanceCreationWithMethodInvocationReplacement(creationCoveringTheEntireStatement1.getName(), ((AbstractCall)invocation2).getName(), Replacement.ReplacementType.CLASS_INSTANCE_CREATION_REPLACED_WITH_METHOD_INVOCATION, creationCoveringTheEntireStatement1, (OperationInvocation)invocation2);
                    replacementInfo.addReplacement((Replacement)replacement2);
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (invocationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.getName().equals("build")) {
            void var59_139;
            boolean bl = false;
            for (String key1 : methodInvocationMap1.keySet()) {
                if (!invocationCoveringTheEntireStatement1.actualString().startsWith(key1)) continue;
                for (AbstractCall invocation1 : (List)methodInvocationMap1.get(key1)) {
                    Set<String> argumentIntersection = invocation1.argumentIntersection(creationCoveringTheEntireStatement2);
                    var59_139 += argumentIntersection.size();
                }
            }
            if (var59_139 > 0) {
                MethodInvocationWithClassInstanceCreationReplacement replacement17 = new MethodInvocationWithClassInstanceCreationReplacement(invocationCoveringTheEntireStatement1.getName(), creationCoveringTheEntireStatement2.getName(), Replacement.ReplacementType.BUILDER_REPLACED_WITH_CLASS_INSTANCE_CREATION, invocationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2);
                replacementInfo.addReplacement(replacement17);
                return replacementInfo.getReplacements();
            }
        }
        if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement1.identical(creationCoveringTheEntireStatement2, replacementInfo.getReplacements(), lambdaMappers)) {
            boolean bl;
            boolean bl3 = true;
            if (creationCoveringTheEntireStatement1.isArray() && creationCoveringTheEntireStatement2.isArray()) {
                bl = creationCoveringTheEntireStatement1.identicalArrayInitializer(creationCoveringTheEntireStatement2);
            }
            if (bl) {
                String anonymousClassDeclaration1 = creationCoveringTheEntireStatement1.getAnonymousClassDeclaration();
                anonymousClassDeclaration2 = creationCoveringTheEntireStatement2.getAnonymousClassDeclaration();
                if (anonymousClassDeclaration1 != null && anonymousClassDeclaration2 != null && !anonymousClassDeclaration1.equals(anonymousClassDeclaration2)) {
                    replacement3 = new Replacement(anonymousClassDeclaration1, (String)anonymousClassDeclaration2, Replacement.ReplacementType.ANONYMOUS_CLASS_DECLARATION);
                    replacementInfo.addReplacement(replacement3);
                }
                return replacementInfo.getReplacements();
            }
        }
        if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement1.getArguments().size() > 0 && creationCoveringTheEntireStatement1.equalArguments(creationCoveringTheEntireStatement2)) {
            ObjectCreationReplacement objectCreationReplacement = new ObjectCreationReplacement(creationCoveringTheEntireStatement1.getName(), creationCoveringTheEntireStatement2.getName(), creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.CLASS_INSTANCE_CREATION);
            replacementInfo.addReplacement(objectCreationReplacement);
            return replacementInfo.getReplacements();
        }
        if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null) {
            if (creationCoveringTheEntireStatement1.identicalWithMergedArguments(creationCoveringTheEntireStatement2, replacementInfo.getReplacements())) {
                return replacementInfo.getReplacements();
            }
            if (creationCoveringTheEntireStatement1.identicalWithDifferentNumberOfArguments(creationCoveringTheEntireStatement2, replacementInfo.getReplacements(), parameterToArgumentMap)) {
                ObjectCreationReplacement objectCreationReplacement = new ObjectCreationReplacement(creationCoveringTheEntireStatement1.getName(), creationCoveringTheEntireStatement2.getName(), creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.CLASS_INSTANCE_CREATION_ARGUMENT);
                replacementInfo.addReplacement(objectCreationReplacement);
                return replacementInfo.getReplacements();
            }
        }
        if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement1.identicalName(creationCoveringTheEntireStatement2) && creationCoveringTheEntireStatement1.identicalExpression(creationCoveringTheEntireStatement2, replacementInfo.getReplacements())) {
            if (creationCoveringTheEntireStatement1.isArray() && creationCoveringTheEntireStatement2.isArray() && s1.contains("[") && s2.contains("[") && s1.substring(s1.indexOf("[") + 1, s1.lastIndexOf("]")).equals(s2.substring(s2.indexOf("[") + 1, s2.lastIndexOf("]"))) && s1.substring(s1.indexOf("[") + 1, s1.lastIndexOf("]")).length() > 0) {
                return replacementInfo.getReplacements();
            }
            if (!creationCoveringTheEntireStatement1.isArray() && !creationCoveringTheEntireStatement2.isArray() && s1.contains("(") && s2.contains("(") && s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")")).equals(s2.substring(s2.indexOf("(") + 1, s2.lastIndexOf(")"))) && s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")")).length() > 0) {
                return replacementInfo.getReplacements();
            }
        }
        if (creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement2 != null && variableDeclarations1.size() == 1 && variableDeclarations2.size() == 1) {
            String initializer2;
            VariableDeclaration variableDeclaration = (VariableDeclaration)variableDeclarations1.get(0);
            VariableDeclaration v2 = (VariableDeclaration)variableDeclarations2.get(0);
            Iterator initializer1 = variableDeclaration.getInitializer() != null ? variableDeclaration.getInitializer().getString() : null;
            String string9 = initializer2 = v2.getInitializer() != null ? v2.getInitializer().getString() : null;
            if (variableDeclaration.getType().getArrayDimension() == 1 && v2.getType().containsTypeArgument(variableDeclaration.getType().getClassType()) && creationCoveringTheEntireStatement1.isArray() && !creationCoveringTheEntireStatement2.isArray() && initializer1 != null && initializer2 != null && ((String)((Object)initializer1)).substring(((String)((Object)initializer1)).indexOf("[") + 1, ((String)((Object)initializer1)).lastIndexOf("]")).equals(initializer2.substring(initializer2.indexOf("(") + 1, initializer2.lastIndexOf(")")))) {
                ObjectCreationReplacement r7 = new ObjectCreationReplacement((String)((Object)initializer1), initializer2, creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION);
                replacementInfo.addReplacement(r7);
                return replacementInfo.getReplacements();
            }
            if (v2.getType().getArrayDimension() == 1 && variableDeclaration.getType().containsTypeArgument(v2.getType().getClassType()) && !creationCoveringTheEntireStatement1.isArray() && creationCoveringTheEntireStatement2.isArray() && initializer1 != null && initializer2 != null && ((String)((Object)initializer1)).substring(((String)((Object)initializer1)).indexOf("(") + 1, ((String)((Object)initializer1)).lastIndexOf(")")).equals(initializer2.substring(initializer2.indexOf("[") + 1, initializer2.lastIndexOf("]")))) {
                ObjectCreationReplacement r8 = new ObjectCreationReplacement((String)((Object)initializer1), initializer2, creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION);
                replacementInfo.addReplacement(r8);
                return replacementInfo.getReplacements();
            }
        }
        if (!creations1.isEmpty() && creationCoveringTheEntireStatement2 != null) {
            for (String creation1 : creations1) {
                for (AbstractCall objectCreation1 : (List)creationMap1.get(creation1)) {
                    if (objectCreation1.identicalWithMergedArguments(creationCoveringTheEntireStatement2, replacementInfo.getReplacements())) {
                        return replacementInfo.getReplacements();
                    }
                    if (objectCreation1.identicalWithDifferentNumberOfArguments(creationCoveringTheEntireStatement2, replacementInfo.getReplacements(), parameterToArgumentMap)) {
                        replacement2 = new ObjectCreationReplacement(objectCreation1.getName(), creationCoveringTheEntireStatement2.getName(), (ObjectCreation)objectCreation1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.CLASS_INSTANCE_CREATION_ARGUMENT);
                        replacementInfo.addReplacement((Replacement)replacement2);
                        return replacementInfo.getReplacements();
                    }
                    if (!objectCreation1.identicalName(creationCoveringTheEntireStatement2) || !objectCreation1.identicalExpression(creationCoveringTheEntireStatement2, replacementInfo.getReplacements())) continue;
                    if (((ObjectCreation)objectCreation1).isArray() && creationCoveringTheEntireStatement2.isArray() && s1.contains("[") && s2.contains("[") && s1.substring(s1.indexOf("[") + 1, s1.lastIndexOf("]")).equals(s2.substring(s2.indexOf("[") + 1, s2.lastIndexOf("]"))) && s1.substring(s1.indexOf("[") + 1, s1.lastIndexOf("]")).length() > 0) {
                        return replacementInfo.getReplacements();
                    }
                    if (((ObjectCreation)objectCreation1).isArray() || creationCoveringTheEntireStatement2.isArray() || !s1.contains("(") || !s2.contains("(") || !s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")")).equals(s2.substring(s2.indexOf("(") + 1, s2.lastIndexOf(")"))) || s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")")).length() <= 0) continue;
                    return replacementInfo.getReplacements();
                }
            }
        }
        if (creationCoveringTheEntireStatement1 != null && (r = creationCoveringTheEntireStatement1.makeReplacementForReturnedArgument(replacementInfo.getArgumentizedString2())) != null) {
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        for (String creation1 : creations1) {
            for (AbstractCall objectCreation1 : (List)creationMap1.get(creation1)) {
                if (!statement1.getString().endsWith(creation1 + ";\n") || (r = objectCreation1.makeReplacementForReturnedArgument(replacementInfo.getArgumentizedString2())) == null) continue;
                replacementInfo.addReplacement(r);
                return replacementInfo.getReplacements();
            }
        }
        if (variableDeclarationWithArrayInitializer1 != null && invocationCoveringTheEntireStatement2 != null && variableDeclarations2.isEmpty() && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(statement1.getString()) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(statement2.getString()) && (string3 = s1.substring(s1.indexOf("{") + 1, s1.lastIndexOf("}"))).equals(args2 = s2.substring(s2.indexOf("(") + 1, s2.lastIndexOf(")")))) {
            r = new Replacement(string3, args2, Replacement.ReplacementType.ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS);
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        if (variableDeclarationWithArrayInitializer2 != null && invocationCoveringTheEntireStatement1 != null && variableDeclarations1.isEmpty() && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(statement1.getString()) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(statement2.getString()) && (string2 = s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")"))).equals(args2 = s2.substring(s2.indexOf("{") + 1, s2.lastIndexOf("}")))) {
            r = new Replacement(string2, args2, Replacement.ReplacementType.ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS);
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        if (invocationCoveringTheEntireStatement2 != null && statement2.getString().equals(invocationCoveringTheEntireStatement2.actualString() + "\n") && invocationCoveringTheEntireStatement2.getArguments().size() == 1 && statement1.getString().endsWith("=" + invocationCoveringTheEntireStatement2.getArguments().get(0) + "\n") && invocationCoveringTheEntireStatement2.expressionIsNullOrThis() && invocationCoveringTheEntireStatement2.getName().startsWith("set") && variables1.contains(string = statement1.getString().substring(0, statement1.getString().lastIndexOf("=")))) {
            String before = string + "=" + invocationCoveringTheEntireStatement2.getArguments().get(0);
            String after = invocationCoveringTheEntireStatement2.actualString();
            r = new Replacement(before, after, Replacement.ReplacementType.FIELD_ASSIGNMENT_REPLACED_WITH_SETTER_METHOD_INVOCATION);
            replacementInfo.addReplacement(r);
            return replacementInfo.getReplacements();
        }
        return null;
    }

    private Replacement getReplacementFromArrayCreation(List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, ObjectCreation creationCoveringTheEntireStatement1, ObjectCreation creationCoveringTheEntireStatement2) {
        String initializer2;
        ObjectCreationReplacement r = null;
        VariableDeclaration v1 = variableDeclarations1.get(0);
        VariableDeclaration v2 = variableDeclarations2.get(0);
        String initializer1 = v1.getInitializer() != null ? v1.getInitializer().getString() : null;
        String string = initializer2 = v2.getInitializer() != null ? v2.getInitializer().getString() : null;
        if (v1.getType().getArrayDimension() == 1 && v2.getType().containsTypeArgument(v1.getType().getClassType()) && creationCoveringTheEntireStatement1.isArray() && !creationCoveringTheEntireStatement2.isArray() && initializer1 != null && initializer2 != null && initializer1.substring(initializer1.indexOf("[") + 1, initializer1.lastIndexOf("]")).equals(initializer2.substring(initializer2.indexOf("(") + 1, initializer2.lastIndexOf(")")))) {
            r = new ObjectCreationReplacement(initializer1, initializer2, creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION);
        }
        if (v2.getType().getArrayDimension() == 1 && v1.getType().containsTypeArgument(v2.getType().getClassType()) && !creationCoveringTheEntireStatement1.isArray() && creationCoveringTheEntireStatement2.isArray() && initializer1 != null && initializer2 != null && initializer1.substring(initializer1.indexOf("(") + 1, initializer1.lastIndexOf(")")).equals(initializer2.substring(initializer2.indexOf("[") + 1, initializer2.lastIndexOf("]")))) {
            r = new ObjectCreationReplacement(initializer1, initializer2, creationCoveringTheEntireStatement1, creationCoveringTheEntireStatement2, Replacement.ReplacementType.ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION);
        }
        return r;
    }

    private List<UMLOperationBodyMapper> getLambdaMappers(List<LambdaExpressionObject> lambdas1, List<LambdaExpressionObject> lambdas2) throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperationBodyMapper> lambdaMappers = new ArrayList<UMLOperationBodyMapper>();
        if (!lambdas1.isEmpty() && !lambdas2.isEmpty()) {
            for (LambdaExpressionObject lambdaExpressionObject : lambdas1) {
                for (LambdaExpressionObject expressionObject : lambdas2) {
                    UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(lambdaExpressionObject, expressionObject, this);
                    int mappings = mapper.mappingsWithoutBlocks();
                    if (mappings <= 0) continue;
                    int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                    int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                    if (mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) continue;
                    this.mappings.addAll(mapper.mappings);
                    this.nonMappedInnerNodesT1.addAll(mapper.nonMappedInnerNodesT1);
                    this.nonMappedInnerNodesT2.addAll(mapper.nonMappedInnerNodesT2);
                    this.nonMappedLeavesT1.addAll(mapper.nonMappedLeavesT1);
                    this.nonMappedLeavesT2.addAll(mapper.nonMappedLeavesT2);
                    this.refactorings.addAll(mapper.getRefactorings());
                    lambdaMappers.add(mapper);
                }
            }
        }
        return lambdaMappers;
    }

    private boolean cast(String diff1, String diff2) {
        return diff1.isEmpty() && diff2.startsWith("(") && diff2.endsWith(")") || diff2.equals("(" + diff1 + ")");
    }

    private boolean differOnlyInCastExpressionOrPrefixOperator(String s1, String s2, ReplacementInfo info) {
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(s1, s2);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
            String diff2;
            int endIndexS1;
            int beginIndexS1 = s1.indexOf(commonPrefix) + commonPrefix.length();
            String diff1 = beginIndexS1 > (endIndexS1 = s1.lastIndexOf(commonSuffix)) ? "" : s1.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = s2.lastIndexOf(commonSuffix);
            String string = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (this.cast(diff1, diff2)) {
                return true;
            }
            if (this.cast(diff2, diff1)) {
                return true;
            }
            if (diff1.isEmpty() && (diff2.equals("!") || diff2.equals("~"))) {
                Replacement r = new Replacement(s1, s2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                info.addReplacement(r);
                return true;
            }
            if (diff2.isEmpty() && (diff1.equals("!") || diff1.equals("~"))) {
                Replacement r = new Replacement(s1, s2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                info.addReplacement(r);
                return true;
            }
        }
        return false;
    }

    private boolean equalAfterInfixExpressionExpansion(String s1, String s2, ReplacementInfo replacementInfo, List<String> infixExpressions1) {
        LinkedHashSet<Replacement> replacementsToBeRemoved = new LinkedHashSet<Replacement>();
        LinkedHashSet<Replacement> replacementsToBeAdded = new LinkedHashSet<Replacement>();
        String originalArgumentizedString1 = replacementInfo.getArgumentizedString1();
        for (Replacement replacement : replacementInfo.getReplacements()) {
            String before = replacement.getBefore();
            for (String infixExpression1 : infixExpressions1) {
                String temp;
                int distanceRaw;
                if (!infixExpression1.startsWith(before)) continue;
                String suffix = infixExpression1.substring(before.length());
                String after = replacement.getAfter();
                if (!s1.contains(after + suffix) || (distanceRaw = StringDistance.editDistance(temp = ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), after + suffix, after), replacementInfo.getArgumentizedString2())) < 0 || distanceRaw >= replacementInfo.getRawDistance()) continue;
                replacementsToBeRemoved.add(replacement);
                Replacement newReplacement = new Replacement(infixExpression1, after, Replacement.ReplacementType.INFIX_EXPRESSION);
                replacementsToBeAdded.add(newReplacement);
                replacementInfo.setArgumentizedString1(temp);
            }
        }
        if (replacementInfo.getRawDistance() == 0) {
            replacementInfo.removeReplacements(replacementsToBeRemoved);
            replacementInfo.addReplacements(replacementsToBeAdded);
            return true;
        }
        replacementInfo.setArgumentizedString1(originalArgumentizedString1);
        return false;
    }

    private String prepareConditional(String s) {
        int indexOfEquals;
        String conditional = s;
        if (s.startsWith("if (") && s.endsWith(")")) {
            conditional = s.substring(3, s.length() - 1);
        }
        if (s.startsWith("while (") && s.endsWith(")")) {
            conditional = s.substring(6, s.length() - 1);
        }
        if (s.startsWith("return ") && s.endsWith(";\n")) {
            conditional = s.substring(7, s.length() - 2);
        }
        if ((indexOfEquals = s.indexOf("=")) > -1 && s.charAt(indexOfEquals + 1) != '=' && s.charAt(indexOfEquals - 1) != '!' && s.endsWith(";\n")) {
            conditional = s.substring(indexOfEquals + 1, s.length() - 2);
        }
        return conditional;
    }

    private boolean commonConditional(String s1, String s2, ReplacementInfo info) {
        if (!UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s1) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s2)) {
            Replacement r;
            if (s1.contains("||") || s1.contains("&&") || s2.contains("||") || s2.contains("&&")) {
                String conditional1 = this.prepareConditional(s1);
                String conditional2 = this.prepareConditional(s2);
                String[] subConditions1 = SPLIT_CONDITIONAL_PATTERN.split(conditional1);
                String[] subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2);
                ArrayList<String> subConditionsAsList1 = new ArrayList<String>();
                for (String s : subConditions1) {
                    subConditionsAsList1.add(s.trim());
                }
                ArrayList<String> subConditionsAsList2 = new ArrayList<String>();
                for (String s : subConditions2) {
                    subConditionsAsList2.add(s.trim());
                }
                LinkedHashSet<String> intersection = new LinkedHashSet<String>(subConditionsAsList1);
                intersection.retainAll(subConditionsAsList2);
                int matches = 0;
                if (!intersection.isEmpty()) {
                    for (String element : intersection) {
                        boolean replacementFound = false;
                        for (Replacement r2 : info.getReplacements()) {
                            if (element.equals(r2.getAfter()) || element.equals("(" + r2.getAfter()) || element.equals(r2.getAfter() + ")")) {
                                replacementFound = true;
                                break;
                            }
                            if (element.equals("!" + r2.getAfter())) {
                                replacementFound = true;
                                break;
                            }
                            if (r2.getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR) && element.contains(r2.getAfter())) {
                                replacementFound = true;
                                break;
                            }
                            if (!ReplacementUtil.contains(element, r2.getAfter()) || !element.startsWith(r2.getAfter()) || !element.endsWith(" != Null") && !element.endsWith(" == Null")) continue;
                            replacementFound = true;
                            break;
                        }
                        if (replacementFound) continue;
                        ++matches;
                    }
                }
                if (matches > 0) {
                    IntersectionReplacement r3 = new IntersectionReplacement(s1, s2, intersection, Replacement.ReplacementType.CONDITIONAL);
                    info.addReplacement(r3);
                }
                boolean invertConditionalFound = false;
                for (String subCondition1 : subConditionsAsList1) {
                    for (String subCondition2 : subConditionsAsList2) {
                        Replacement r4;
                        if (subCondition1.equals("!" + subCondition2)) {
                            r4 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                            info.addReplacement(r4);
                            invertConditionalFound = true;
                        }
                        if (!subCondition2.equals("!" + subCondition1)) continue;
                        r4 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                        info.addReplacement(r4);
                        invertConditionalFound = true;
                    }
                }
                if (invertConditionalFound || matches > 0) {
                    return true;
                }
            }
            if (s1.contains(" >= ") && s2.contains(" <= ") && (r = this.invertConditionalDirection(s1, s2, " >= ", " <= ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" <= ") && s2.contains(" >= ") && (r = this.invertConditionalDirection(s1, s2, " <= ", " >= ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" > ") && s2.contains(" < ") && (r = this.invertConditionalDirection(s1, s2, " > ", " < ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" < ") && s2.contains(" > ") && (r = this.invertConditionalDirection(s1, s2, " < ", " > ")) != null) {
                info.addReplacement(r);
                return true;
            }
        }
        return false;
    }

    private Replacement invertConditionalDirection(String s1, String s2, String operator1, String operator2) {
        int j;
        int indexS1 = s1.indexOf(operator1);
        int indexS2 = s2.indexOf(operator2);
        int i = indexS1 + operator1.length();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (j = indexS2 - 1; i < s1.length() && j >= 0; ++i, --j) {
            sb1.append(s1.charAt(i));
            sb2.insert(0, s2.charAt(j));
            if (!sb1.toString().equals(sb2.toString())) continue;
            String subCondition1 = operator1 + sb1;
            String subCondition2 = sb2 + operator2;
            return new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
        }
        i = indexS1 - 1;
        sb1 = new StringBuilder();
        sb2 = new StringBuilder();
        for (j = indexS2 + operator2.length(); i >= 0 && j < s2.length(); --i, ++j) {
            sb1.insert(0, s1.charAt(i));
            sb2.append(s2.charAt(j));
            if (!sb1.toString().equals(sb2.toString())) continue;
            String subCondition1 = sb1 + operator1;
            String subCondition2 = operator2 + sb2;
            return new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
        }
        return null;
    }

    private boolean oneIsVariableDeclarationTheOtherIsVariableAssignment(String s1, String s2, ReplacementInfo replacementInfo) {
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (s1.contains("=") && s2.contains("=") && (s1.equals(commonSuffix) || s2.equals(commonSuffix))) {
            if (replacementInfo.getReplacements().size() == 2) {
                StringBuilder sb = new StringBuilder();
                int counter = 0;
                for (Replacement r : replacementInfo.getReplacements()) {
                    sb.append(r.getAfter());
                    if (counter == 0) {
                        sb.append("=");
                    } else if (counter == 1) {
                        sb.append(";\n");
                    }
                    ++counter;
                }
                return !commonSuffix.equals(sb.toString());
            }
            return true;
        }
        return false;
    }

    private boolean oneIsVariableDeclarationTheOtherIsReturnStatement(String s1, String s2) {
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!(commonSuffix.equals("Null\n") || commonSuffix.equals("True\n") || commonSuffix.equals("False\n") || commonSuffix.equals("0\n"))) {
            if (s1.startsWith("return ") && s1.substring(7).equals(commonSuffix) && s2.contains("=") && s2.substring(s2.indexOf("=") + 1).equals(commonSuffix)) {
                return true;
            }
            return s2.startsWith("return ") && s2.substring(7).equals(commonSuffix) && s1.contains("=") && s1.substring(s1.indexOf("=") + 1).equals(commonSuffix);
        }
        return false;
    }

    private boolean identicalVariableDeclarationsWithDifferentNames(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, ReplacementInfo replacementInfo) {
        if (variableDeclarations1.size() == variableDeclarations2.size() && variableDeclarations1.size() == 1) {
            VariableDeclaration declaration1 = variableDeclarations1.get(0);
            VariableDeclaration declaration2 = variableDeclarations2.get(0);
            if (!declaration1.getVariableName().equals(declaration2.getVariableName())) {
                String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
                String composedString1 = declaration1.getType() + " " + declaration1.getVariableName() + commonSuffix;
                String composedString2 = declaration2.getType() + " " + declaration2.getVariableName() + commonSuffix;
                if (s1.equals(composedString1) && s2.equals(composedString2)) {
                    Replacement replacement = new Replacement(declaration1.getVariableName(), declaration2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
                    replacementInfo.addReplacement(replacement);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsValidOperatorReplacements(ReplacementInfo replacementInfo) {
        List<Replacement> operatorReplacements = replacementInfo.getReplacements(Replacement.ReplacementType.INFIX_OPERATOR);
        for (Replacement replacement : operatorReplacements) {
            if (replacement.getBefore().equals("==") && !replacement.getAfter().equals("!=")) {
                return false;
            }
            if (replacement.getBefore().equals("!=") && !replacement.getAfter().equals("==")) {
                return false;
            }
            if (replacement.getBefore().equals("&&") && !replacement.getAfter().equals("||")) {
                return false;
            }
            if (!replacement.getBefore().equals("||") || replacement.getAfter().equals("&&")) continue;
            return false;
        }
        return true;
    }

    private Replacement getReplacement(AbstractCodeFragment statement1, AbstractCodeFragment statement2, Map<String, String> parameterToArgumentMap, Set<String> variables1, Set<String> variables2, Map<String, List<? extends AbstractCall>> methodInvocationMap1, Map<String, List<? extends AbstractCall>> methodInvocationMap2, Set<String> methodInvocations1, Set<String> methodInvocations2, String s1, String s2) {
        Replacement replacement = null;
        if (variables1.contains(s1) && variables2.contains(s2) && this.variablesStartWithSameCase(s1, s2, parameterToArgumentMap)) {
            VariableDeclaration v2;
            VariableDeclaration v1;
            String prefix2;
            String prefix1;
            replacement = new Replacement(s1, s2, Replacement.ReplacementType.VARIABLE_NAME);
            if (s1.startsWith("(") && s2.startsWith("(") && s1.contains(")") && s2.contains(")") && (prefix1 = s1.substring(0, s1.indexOf(")") + 1)).equals(prefix2 = s2.substring(0, s2.indexOf(")") + 1))) {
                String suffix1 = s1.substring(prefix1.length());
                String suffix2 = s2.substring(prefix2.length());
                replacement = new Replacement(suffix1, suffix2, Replacement.ReplacementType.VARIABLE_NAME);
            }
            if (this.inconsistentVariableMappingCount(statement1, statement2, v1 = statement1.searchVariableDeclaration(s1), v2 = statement2.searchVariableDeclaration(s2)) > 1 && this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) == null) {
                replacement = null;
            }
        } else if (variables1.contains(s1) && methodInvocations2.contains(s2)) {
            OperationInvocation invokedOperationAfter = (OperationInvocation)methodInvocationMap2.get(s2).get(0);
            replacement = new VariableReplacementWithMethodInvocation(s1, s2, invokedOperationAfter, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
        } else if (methodInvocations1.contains(s1) && methodInvocations2.contains(s2)) {
            OperationInvocation invokedOperationAfter;
            OperationInvocation invokedOperationBefore = (OperationInvocation)methodInvocationMap1.get(s1).get(0);
            if (invokedOperationBefore.compatibleExpression(invokedOperationAfter = (OperationInvocation)methodInvocationMap2.get(s2).get(0))) {
                replacement = new MethodInvocationReplacement(s1, s2, invokedOperationBefore, invokedOperationAfter, Replacement.ReplacementType.METHOD_INVOCATION);
            }
        } else if (methodInvocations1.contains(s1) && variables2.contains(s2)) {
            OperationInvocation invokedOperationBefore = (OperationInvocation)methodInvocationMap1.get(s1).get(0);
            replacement = new VariableReplacementWithMethodInvocation(s1, s2, invokedOperationBefore, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
        }
        return replacement;
    }

    private int getCommonArgumentsCount(OperationInvocation invocationCoveringTheEntireStatement1, Map<String, List<? extends AbstractCall>> methodInvocationMap1, ObjectCreation creationCoveringTheEntireStatement2) {
        int commonArguments = 0;
        for (String key1 : methodInvocationMap1.keySet()) {
            if (!invocationCoveringTheEntireStatement1.actualString().startsWith(key1)) continue;
            for (AbstractCall abstractCall : methodInvocationMap1.get(key1)) {
                Set<String> argumentIntersection = abstractCall.argumentIntersection(creationCoveringTheEntireStatement2);
                commonArguments += argumentIntersection.size();
            }
        }
        return commonArguments;
    }

    private boolean commonConcat(String s1, String s2, ReplacementInfo info) {
        if (s1.contains("+") && s2.contains("+") && !s1.contains("++") && !s2.contains("++") && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s1) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s2)) {
            LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(s1.split(SPLIT_CONCAT_STRING_PATTERN)));
            LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(s2.split(SPLIT_CONCAT_STRING_PATTERN)));
            LinkedHashSet<String> intersection = new LinkedHashSet<String>(tokens1);
            intersection.retainAll(tokens2);
            LinkedHashSet<String> filteredIntersection = new LinkedHashSet<String>();
            for (String common : intersection) {
                boolean foundInReplacements = false;
                for (Replacement r : info.replacements) {
                    if (!r.getBefore().contains(common) && !r.getAfter().contains(common)) continue;
                    foundInReplacements = true;
                    break;
                }
                if (foundInReplacements) continue;
                filteredIntersection.add(common);
            }
            int size = filteredIntersection.size();
            int threshold = Math.max(tokens1.size(), tokens2.size()) - size;
            if (size > 0 && size > threshold || size > 1 && size >= threshold) {
                IntersectionReplacement r = new IntersectionReplacement(s1, s2, intersection, Replacement.ReplacementType.CONCATENATION);
                info.getReplacements().add(r);
                return true;
            }
        }
        return false;
    }

    private boolean validStatementForConcatComparison(AbstractCodeFragment statement1, AbstractCodeFragment statement2) {
        List<VariableDeclaration> variableDeclarations1 = statement1.getVariableDeclarations();
        List<VariableDeclaration> variableDeclarations2 = statement2.getVariableDeclarations();
        if (variableDeclarations1.size() == variableDeclarations2.size()) {
            return true;
        }
        if (variableDeclarations1.size() > 0 && variableDeclarations2.size() == 0 && statement2.getString().startsWith("return ")) {
            return true;
        }
        return variableDeclarations1.size() == 0 && variableDeclarations2.size() > 0 && statement1.getString().startsWith("return ");
    }

    private boolean equalAfterNewArgumentAdditions(String s1, String s2, ReplacementInfo replacementInfo) {
        UMLOperationDiff operationDiff;
        UMLOperationDiff uMLOperationDiff = operationDiff = this.classDiff != null ? this.classDiff.getOperationDiff(this.operation1, this.operation2) : null;
        if (operationDiff == null) {
            operationDiff = new UMLOperationDiff(this.operation1, this.operation2);
        }
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(s1, s2);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!(commonPrefix.isEmpty() || commonSuffix.isEmpty() || commonPrefix.equals("return "))) {
            String characterAfterCommonPrefix;
            Object diff2;
            int endIndexS1;
            int beginIndexS1 = s1.indexOf(commonPrefix) + commonPrefix.length();
            Object diff1 = beginIndexS1 > (endIndexS1 = s1.lastIndexOf(commonSuffix)) ? "" : s1.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = s2.lastIndexOf(commonSuffix);
            Object object = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (beginIndexS1 > endIndexS1 && ((String)(diff2 = (String)diff2 + commonSuffix.substring(0, beginIndexS1 - endIndexS1))).charAt(((String)diff2).length() - 1) == ',') {
                diff2 = ((String)diff2).substring(0, ((String)diff2).length() - 1);
            }
            String string = characterAfterCommonPrefix = s1.equals(commonPrefix) ? "" : Character.toString(s1.charAt(commonPrefix.length()));
            if (commonPrefix.contains(",") && commonPrefix.lastIndexOf(",") < commonPrefix.length() - 1 && !characterAfterCommonPrefix.equals(",") && !characterAfterCommonPrefix.equals(")")) {
                String prepend = commonPrefix.substring(commonPrefix.lastIndexOf(",") + 1);
                diff1 = prepend + (String)diff1;
                diff2 = prepend + (String)diff2;
            }
            if (((String)diff1).isEmpty() || this.operation1.getParameterNameList().contains(diff1) && !this.operation2.getParameterNameList().contains(diff1) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass((String)diff2) || this.classDiff != null && this.classDiff.getOriginalClass().containsAttributeWithName((String)diff1) && !this.classDiff.getNextClass().containsAttributeWithName((String)diff1) && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass((String)diff2)) {
                Object matchingReplacement;
                ArrayList<UMLParameter> matchingAddedParameters = new ArrayList<UMLParameter>();
                for (UMLParameter addedParameter : operationDiff.getAddedParameters()) {
                    if (!((String)diff2).contains(addedParameter.getName())) continue;
                    matchingAddedParameters.add(addedParameter);
                }
                if (matchingAddedParameters.size() > 0) {
                    Object split;
                    int counter;
                    Replacement matchingReplacement2 = this.getMatchingReplacement(replacementInfo, operationDiff);
                    if (matchingReplacement2 != null) {
                        LinkedHashSet<String> splitVariables2 = new LinkedHashSet<String>();
                        splitVariables2.add(matchingReplacement2.getAfter());
                        StringBuilder stringBuilder = new StringBuilder();
                        counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            splitVariables2.add(uMLParameter.getName());
                            stringBuilder.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                stringBuilder.append(",");
                            }
                            ++counter;
                        }
                        split = new SplitVariableReplacement(matchingReplacement2.getBefore(), splitVariables2);
                        if (!((SplitVariableReplacement)split).getSplitVariables().contains(((Replacement)split).getBefore()) && stringBuilder.toString().equals(diff2)) {
                            replacementInfo.getReplacements().remove(matchingReplacement2);
                            replacementInfo.getReplacements().add((Replacement)split);
                            return true;
                        }
                    } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                        LinkedHashSet<String> addedVariables2 = new LinkedHashSet<String>();
                        StringBuilder stringBuilder = new StringBuilder();
                        counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            addedVariables2.add(uMLParameter.getName());
                            stringBuilder.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                stringBuilder.append(",");
                            }
                            ++counter;
                        }
                        if (stringBuilder.toString().equals(diff2)) {
                            AddVariableReplacement r = new AddVariableReplacement(addedVariables2);
                            replacementInfo.getReplacements().add(r);
                            return true;
                        }
                    }
                    if (this.operation1.getParameterNameList().contains(diff1)) {
                        LinkedHashSet splitVariables = new LinkedHashSet();
                        StringBuilder stringBuilder = new StringBuilder();
                        counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            splitVariables.add(uMLParameter.getName());
                            stringBuilder.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                stringBuilder.append(",");
                            }
                            ++counter;
                        }
                        split = new SplitVariableReplacement((String)diff1, splitVariables);
                        if (!((SplitVariableReplacement)split).getSplitVariables().contains(((Replacement)split).getBefore()) && stringBuilder.toString().equals(diff2)) {
                            replacementInfo.getReplacements().add((Replacement)split);
                            return true;
                        }
                    }
                }
                if (this.classDiff != null) {
                    ArrayList<UMLAttribute> matchingAttributes = new ArrayList<UMLAttribute>();
                    for (UMLAttribute uMLAttribute : this.classDiff.getNextClass().getAttributes()) {
                        if (!((String)diff2).contains(uMLAttribute.getName())) continue;
                        matchingAttributes.add(uMLAttribute);
                    }
                    if (matchingAttributes.size() > 0) {
                        matchingReplacement = null;
                        for (Replacement replacement : replacementInfo.getReplacements()) {
                            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !this.classDiff.getOriginalClass().containsAttributeWithName(replacement.getBefore()) || !this.classDiff.getNextClass().containsAttributeWithName(replacement.getAfter())) continue;
                            matchingReplacement = replacement;
                            break;
                        }
                        if (matchingReplacement != null) {
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                            linkedHashSet.add(((Replacement)matchingReplacement).getAfter());
                            StringBuilder concat = new StringBuilder();
                            int counter = 0;
                            for (UMLAttribute uMLAttribute : matchingAttributes) {
                                linkedHashSet.add(uMLAttribute.getName());
                                concat.append(uMLAttribute.getName());
                                if (counter < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++counter;
                            }
                            SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement(((Replacement)matchingReplacement).getBefore(), linkedHashSet);
                            if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                                replacementInfo.getReplacements().remove(matchingReplacement);
                                replacementInfo.getReplacements().add(splitVariableReplacement);
                                return true;
                            }
                        } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                            StringBuilder concat = new StringBuilder();
                            int counter = 0;
                            for (UMLAttribute uMLAttribute : matchingAttributes) {
                                linkedHashSet.add(uMLAttribute.getName());
                                concat.append(uMLAttribute.getName());
                                if (counter < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++counter;
                            }
                            if (concat.toString().equals(diff2)) {
                                AddVariableReplacement addVariableReplacement = new AddVariableReplacement(linkedHashSet);
                                replacementInfo.getReplacements().add(addVariableReplacement);
                                return true;
                            }
                        }
                        if (this.classDiff.getOriginalClass().containsAttributeWithName((String)diff1)) {
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                            StringBuilder concat = new StringBuilder();
                            int counter = 0;
                            for (UMLAttribute uMLAttribute : matchingAttributes) {
                                linkedHashSet.add(uMLAttribute.getName());
                                concat.append(uMLAttribute.getName());
                                if (counter < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++counter;
                            }
                            SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement((String)diff1, linkedHashSet);
                            if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                                replacementInfo.getReplacements().add(splitVariableReplacement);
                                return true;
                            }
                        }
                    }
                }
                ArrayList<VariableDeclaration> matchingVariableDeclarations = new ArrayList<VariableDeclaration>();
                for (VariableDeclaration variableDeclaration : this.operation2.getAllVariableDeclarations()) {
                    if (!((String)diff2).contains(variableDeclaration.getVariableName())) continue;
                    matchingVariableDeclarations.add(variableDeclaration);
                }
                if (matchingVariableDeclarations.size() > 0) {
                    matchingReplacement = null;
                    for (Replacement replacement : replacementInfo.getReplacements()) {
                        if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                        int indexOf1 = s1.indexOf(replacement.getAfter());
                        int n = s2.indexOf(replacement.getAfter());
                        int n2 = indexOf1 + replacement.getAfter().length();
                        int characterIndex2 = n + replacement.getAfter().length();
                        boolean isVariableDeclarationReplacement = n2 < s1.length() && s1.charAt(n2) == '=' && characterIndex2 < s2.length() && s2.charAt(characterIndex2) == '=';
                        if (isVariableDeclarationReplacement || this.operation1.getVariableDeclaration(replacement.getBefore()) == null || this.operation2.getVariableDeclaration(replacement.getAfter()) == null) continue;
                        matchingReplacement = replacement;
                        break;
                    }
                    if (matchingReplacement != null) {
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(((Replacement)matchingReplacement).getAfter());
                        StringBuilder concat = new StringBuilder();
                        int counter = 0;
                        for (VariableDeclaration variableDeclaration : matchingVariableDeclarations) {
                            linkedHashSet.add(variableDeclaration.getVariableName());
                            concat.append(variableDeclaration.getVariableName());
                            if (counter < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++counter;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement(((Replacement)matchingReplacement).getBefore(), linkedHashSet);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                            replacementInfo.getReplacements().remove(matchingReplacement);
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        StringBuilder concat = new StringBuilder();
                        int counter = 0;
                        for (VariableDeclaration variableDeclaration : matchingVariableDeclarations) {
                            linkedHashSet.add(variableDeclaration.getVariableName());
                            concat.append(variableDeclaration.getVariableName());
                            if (counter < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++counter;
                        }
                        if (concat.toString().equals(diff2)) {
                            AddVariableReplacement addVariableReplacement = new AddVariableReplacement(linkedHashSet);
                            replacementInfo.getReplacements().add(addVariableReplacement);
                            return true;
                        }
                    }
                    if (this.operation1.getVariableDeclaration((String)diff1) != null) {
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        StringBuilder concat = new StringBuilder();
                        int counter = 0;
                        for (VariableDeclaration variableDeclaration : matchingVariableDeclarations) {
                            linkedHashSet.add(variableDeclaration.getVariableName());
                            concat.append(variableDeclaration.getVariableName());
                            if (counter < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++counter;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement((String)diff1, linkedHashSet);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private Replacement getMatchingReplacement(ReplacementInfo replacementInfo, UMLOperationDiff operationDiff) {
        Replacement matchingReplacement = null;
        for (Replacement replacement : replacementInfo.getReplacements()) {
            if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) {
                for (UMLParameterDiff parameterDiff : operationDiff.getParameterDiffList()) {
                    if (!parameterDiff.isNameChanged() || !replacement.getBefore().equals(parameterDiff.getRemovedParameter().getName()) || !replacement.getAfter().equals(parameterDiff.getAddedParameter().getName())) continue;
                    matchingReplacement = replacement;
                    break;
                }
            }
            if (matchingReplacement == null) continue;
            break;
        }
        return matchingReplacement;
    }

    private boolean classInstanceCreationWithEverythingReplaced(AbstractCodeFragment statement1, AbstractCodeFragment statement2, ReplacementInfo replacementInfo, Map<String, String> parameterToArgumentMap) {
        String string1 = statement1.getString();
        String string2 = statement2.getString();
        if (UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(string1)) {
            string1 = string1.substring(0, string1.indexOf("\n"));
        }
        if (UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(string2)) {
            string2 = string2.substring(0, string2.indexOf("\n"));
        }
        if (string1.contains("=") && string1.endsWith("\n") && string2.startsWith("return ") && string2.endsWith("\n")) {
            int n;
            boolean typeReplacement = false;
            boolean compatibleTypes = false;
            boolean classInstanceCreationReplacement = false;
            String assignment1 = string1.substring(string1.indexOf("=") + 1, string1.lastIndexOf("\n"));
            String assignment2 = string2.substring(7, string2.lastIndexOf("\n"));
            UMLType type1 = null;
            UMLType type2 = null;
            ObjectCreation objectCreation1 = null;
            AbstractCall objectCreation2 = null;
            LinkedHashMap<String, String> argumentToParameterMap = new LinkedHashMap<String, String>();
            Map<String, List<ObjectCreation>> creationMap1 = statement1.getCreationMap();
            for (String string : creationMap1.keySet()) {
                if (!string.equals(assignment1)) continue;
                objectCreation1 = creationMap1.get(string).get(0);
                type1 = objectCreation1.getType();
            }
            Map<String, List<ObjectCreation>> creationMap2 = statement2.getCreationMap();
            for (String creation2 : creationMap2.keySet()) {
                if (!creation2.equals(assignment2)) continue;
                objectCreation2 = creationMap2.get(creation2).get(0);
                type2 = ((ObjectCreation)objectCreation2).getType();
                for (String argument : objectCreation2.getArguments()) {
                    if (!parameterToArgumentMap.containsKey(argument)) continue;
                    argumentToParameterMap.put(parameterToArgumentMap.get(argument), argument);
                }
            }
            boolean bl = false;
            if (type1 != null && type2 != null) {
                compatibleTypes = type1.compatibleTypes(type2);
                n = Math.min(objectCreation1.getArguments().size(), objectCreation2.getArguments().size());
            }
            int replacedArguments = 0;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains(replacement.getBefore() + "(") || !string2.contains(replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if (objectCreation1 != null && objectCreation2 != null && objectCreation1.getArguments().contains(replacement.getBefore()) && (objectCreation2.getArguments().contains(replacement.getAfter()) || objectCreation2.getArguments().contains(argumentToParameterMap.get(replacement.getAfter())))) {
                    ++replacedArguments;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            return typeReplacement && !compatibleTypes && replacedArguments == n && classInstanceCreationReplacement;
        }
        if (string1.startsWith("return ") && string1.endsWith("\n") && string2.contains("=") && string2.endsWith("\n")) {
            int n;
            boolean typeReplacement = false;
            boolean compatibleTypes = false;
            boolean classInstanceCreationReplacement = false;
            String assignment1 = string1.substring(7, string1.lastIndexOf("\n"));
            String assignment2 = string2.substring(string2.indexOf("=") + 1, string2.lastIndexOf("\n"));
            UMLType type1 = null;
            UMLType type2 = null;
            ObjectCreation objectCreation1 = null;
            AbstractCall objectCreation2 = null;
            LinkedHashMap<String, String> argumentToParameterMap = new LinkedHashMap<String, String>();
            Map<String, List<ObjectCreation>> creationMap1 = statement1.getCreationMap();
            for (String string : creationMap1.keySet()) {
                if (!string.equals(assignment1)) continue;
                objectCreation1 = creationMap1.get(string).get(0);
                type1 = objectCreation1.getType();
            }
            Map<String, List<ObjectCreation>> creationMap2 = statement2.getCreationMap();
            for (String creation2 : creationMap2.keySet()) {
                if (!creation2.equals(assignment2)) continue;
                objectCreation2 = (ObjectCreation)((List)creationMap2.get(creation2)).get(0);
                type2 = ((ObjectCreation)objectCreation2).getType();
                for (String argument : objectCreation2.getArguments()) {
                    if (!parameterToArgumentMap.containsKey(argument)) continue;
                    argumentToParameterMap.put(parameterToArgumentMap.get(argument), argument);
                }
            }
            boolean bl = false;
            if (type1 != null && type2 != null) {
                compatibleTypes = type1.compatibleTypes(type2);
                n = Math.min(objectCreation1.getArguments().size(), objectCreation2.getArguments().size());
            }
            int replacedArguments = 0;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains(replacement.getBefore() + "(") || !string2.contains(replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if (objectCreation1 != null && objectCreation2 != null && objectCreation1.getArguments().contains(replacement.getBefore()) && (objectCreation2.getArguments().contains(replacement.getAfter()) || objectCreation2.getArguments().contains(argumentToParameterMap.get(replacement.getAfter())))) {
                    ++replacedArguments;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            return typeReplacement && !compatibleTypes && replacedArguments == n && classInstanceCreationReplacement;
        }
        return false;
    }

    private boolean variableAssignmentWithEverythingReplaced(AbstractCodeFragment statement1, AbstractCodeFragment statement2, ReplacementInfo replacementInfo) {
        String string1 = statement1.getString();
        String string2 = statement2.getString();
        if (UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(string1)) {
            string1 = string1.substring(0, string1.indexOf("\n"));
        }
        if (UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(string2)) {
            string2 = string2.substring(0, string2.indexOf("\n"));
        }
        if (string1.contains("=") && string1.endsWith("\n") && string2.contains("=") && string2.endsWith("\n")) {
            boolean typeReplacement = false;
            boolean variableRename = false;
            boolean classInstanceCreationReplacement = false;
            String variableName1 = string1.substring(0, string1.indexOf("="));
            String variableName2 = string2.substring(0, string2.indexOf("="));
            String assignment1 = string1.substring(string1.indexOf("=") + 1, string1.lastIndexOf("\n"));
            String assignment2 = string2.substring(string2.indexOf("=") + 1, string2.lastIndexOf("\n"));
            Map<String, List<ObjectCreation>> creationMap1 = statement1.getCreationMap();
            Map<String, List<ObjectCreation>> creationMap2 = statement2.getCreationMap();
            boolean compatibleTypes = this.isCompatibleTypes(assignment1, assignment2, creationMap1, creationMap2);
            OperationInvocation inv1 = null;
            OperationInvocation inv2 = null;
            Map<String, List<OperationInvocation>> methodInvocationMap1 = statement1.getMethodInvocationMap();
            for (String invocation1 : methodInvocationMap1.keySet()) {
                if (!invocation1.equals(assignment1)) continue;
                inv1 = methodInvocationMap1.get(invocation1).get(0);
            }
            Map<String, List<OperationInvocation>> methodInvocationMap2 = statement2.getMethodInvocationMap();
            for (String invocation2 : methodInvocationMap2.keySet()) {
                if (!invocation2.equals(assignment2)) continue;
                inv2 = methodInvocationMap2.get(invocation2).get(0);
            }
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains(replacement.getBefore() + "(") || !string2.contains(replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) && (variableName1.equals(replacement.getBefore()) || variableName1.endsWith(" " + replacement.getBefore())) && (variableName2.equals(replacement.getAfter()) || variableName2.endsWith(" " + replacement.getAfter()))) {
                    variableRename = true;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            if (typeReplacement && !compatibleTypes && variableRename && classInstanceCreationReplacement) {
                return true;
            }
            if (variableRename && inv1 != null && inv2 != null && inv1.differentExpressionNameAndArguments(inv2)) {
                if (inv1.getArguments().size() > inv2.getArguments().size()) {
                    for (String argument : inv1.getArguments()) {
                        List<OperationInvocation> argumentInvocations = methodInvocationMap1.get(argument);
                        if (argumentInvocations == null) continue;
                        for (OperationInvocation argumentInvocation : argumentInvocations) {
                            if (argumentInvocation.differentExpressionNameAndArguments(inv2)) continue;
                            return false;
                        }
                    }
                } else if (inv1.getArguments().size() < inv2.getArguments().size()) {
                    for (String argument : inv2.getArguments()) {
                        List<OperationInvocation> argumentInvocations = methodInvocationMap2.get(argument);
                        if (argumentInvocations == null) continue;
                        for (OperationInvocation argumentInvocation : argumentInvocations) {
                            if (inv1.differentExpressionNameAndArguments(argumentInvocation)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isCompatibleTypes(String assignment1, String assignment2, Map<String, List<ObjectCreation>> creationMap1, Map<String, List<ObjectCreation>> creationMap2) {
        boolean compatibleTypes = false;
        UMLType type1 = null;
        UMLType type2 = null;
        for (String creation1 : creationMap1.keySet()) {
            if (!creation1.equals(assignment1)) continue;
            type1 = creationMap1.get(creation1).get(0).getType();
        }
        for (String creation2 : creationMap2.keySet()) {
            if (!creation2.equals(assignment2)) continue;
            type2 = creationMap2.get(creation2).get(0).getType();
        }
        if (type1 != null && type2 != null) {
            compatibleTypes = type1.compatibleTypes(type2);
        }
        return compatibleTypes;
    }

    private boolean isCallChain(Collection<List<? extends AbstractCall>> calls) {
        if (calls.size() > 1) {
            AbstractCall current = null;
            int chainLength = 0;
            for (List<? extends AbstractCall> list : calls) {
                AbstractCall previous = current;
                current = list.get(0);
                if (current == null || previous == null) continue;
                if (previous.getExpression() != null && previous.getExpression().equals(current.actualString())) {
                    ++chainLength;
                    continue;
                }
                return false;
            }
            return chainLength == calls.size() - 1;
        }
        return false;
    }

    private boolean variableDeclarationsWithEverythingReplaced(List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, ReplacementInfo replacementInfo) {
        if (variableDeclarations1.size() == 1 && variableDeclarations2.size() == 1) {
            boolean typeReplacement = false;
            boolean variableRename = false;
            boolean methodInvocationReplacement = false;
            boolean nullInitializer = false;
            boolean zeroArgumentClassInstantiation = false;
            boolean classInstantiationArgumentReplacement = false;
            UMLType type1 = variableDeclarations1.get(0).getType();
            UMLType type2 = variableDeclarations2.get(0).getType();
            AbstractExpression initializer1 = variableDeclarations1.get(0).getInitializer();
            AbstractExpression initializer2 = variableDeclarations2.get(0).getInitializer();
            if (initializer1 == null && initializer2 == null) {
                nullInitializer = true;
            } else if (initializer1 != null && initializer2 != null) {
                boolean bl = nullInitializer = initializer1.getExpression().equals("Null") && initializer2.getExpression().equals("Null");
                if (initializer1.getCreationMap().size() == 1 && initializer2.getCreationMap().size() == 1) {
                    ObjectCreation creation1 = initializer1.getCreationMap().values().iterator().next().get(0);
                    ObjectCreation creation2 = initializer2.getCreationMap().values().iterator().next().get(0);
                    if (creation1.getArguments().size() == 0 && creation2.getArguments().size() == 0) {
                        zeroArgumentClassInstantiation = true;
                    } else if (creation1.getArguments().size() == 1 && creation2.getArguments().size() == 1) {
                        String argument1 = creation1.getArguments().get(0);
                        String argument2 = creation2.getArguments().get(0);
                        for (Replacement replacement : replacementInfo.getReplacements()) {
                            if (!replacement.getBefore().equals(argument1) || !replacement.getAfter().equals(argument2)) continue;
                            classInstantiationArgumentReplacement = true;
                            break;
                        }
                    }
                }
            }
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) && variableDeclarations1.get(0).getVariableName().equals(replacement.getBefore()) && variableDeclarations2.get(0).getVariableName().equals(replacement.getAfter())) {
                    variableRename = true;
                    continue;
                }
                if (replacement instanceof MethodInvocationReplacement) {
                    MethodInvocationReplacement invocationReplacement = (MethodInvocationReplacement)replacement;
                    if (initializer1 != null && invocationReplacement.getInvokedOperationBefore().actualString().equals(initializer1.getString()) && initializer2 != null && invocationReplacement.getInvokedOperationAfter().actualString().equals(initializer2.getString())) {
                        methodInvocationReplacement = true;
                    }
                    if (initializer1 == null || !initializer1.getExpression().equals(replacement.getBefore()) || initializer2 == null || !initializer2.getExpression().equals(replacement.getAfter())) continue;
                    methodInvocationReplacement = true;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || initializer1 == null || !initializer1.getExpression().equals(replacement.getBefore()) || initializer2 == null || !initializer2.getExpression().equals(replacement.getAfter())) continue;
                methodInvocationReplacement = true;
            }
            return typeReplacement && !type1.compatibleTypes(type2) && variableRename && (methodInvocationReplacement || nullInitializer || zeroArgumentClassInstantiation || classInstantiationArgumentReplacement);
        }
        return false;
    }

    private void replaceVariablesWithArguments(Map<String, List<? extends AbstractCall>> callMap, Set<String> calls, Map<String, String> parameterToArgumentMap) {
        if (this.isCallChain(callMap.values())) {
            for (String parameter : parameterToArgumentMap.keySet()) {
                String argument;
                if (parameter.equals(argument = parameterToArgumentMap.get(parameter))) continue;
                LinkedHashSet<String> toBeAdded = new LinkedHashSet<String>();
                for (String call : calls) {
                    String afterReplacement;
                    if (call.equals(afterReplacement = ReplacementUtil.performArgumentReplacement(call, parameter, argument))) continue;
                    toBeAdded.add(afterReplacement);
                    List<? extends AbstractCall> oldCalls = callMap.get(call);
                    ArrayList<AbstractCall> newCalls = new ArrayList<AbstractCall>();
                    for (AbstractCall abstractCall : oldCalls) {
                        AbstractCall abstractCall2 = abstractCall.update(parameter, argument);
                        newCalls.add(abstractCall2);
                    }
                    callMap.put(afterReplacement, newCalls);
                }
                calls.addAll(toBeAdded);
            }
        } else {
            LinkedHashSet finalNewCalls = new LinkedHashSet();
            for (String parameter : parameterToArgumentMap.keySet()) {
                String argument;
                if (parameter.equals(argument = parameterToArgumentMap.get(parameter))) continue;
                LinkedHashSet<String> toBeAdded = new LinkedHashSet<String>();
                for (String call : calls) {
                    String afterReplacement;
                    if (call.equals(afterReplacement = ReplacementUtil.performArgumentReplacement(call, parameter, argument))) continue;
                    toBeAdded.add(afterReplacement);
                    List<? extends AbstractCall> oldCalls = callMap.get(call);
                    ArrayList<AbstractCall> newCalls = new ArrayList<AbstractCall>();
                    for (AbstractCall abstractCall : oldCalls) {
                        AbstractCall newCall = abstractCall.update(parameter, argument);
                        newCalls.add(newCall);
                    }
                    callMap.put(afterReplacement, newCalls);
                }
                finalNewCalls.addAll(toBeAdded);
            }
            calls.addAll(finalNewCalls);
        }
    }

    private Set<Replacement> replacementsWithinMethodInvocations(String s1, String s2, Set<String> set1, Set<String> set2, Map<String, List<? extends AbstractCall>> methodInvocationMap, VariableReplacementWithMethodInvocation.Direction direction) {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (String element1 : set1) {
            if (!s1.contains(element1) || s1.equals(element1) || s1.equals("this." + element1) || s1.equals("_" + element1)) continue;
            int startIndex1 = s1.indexOf(element1);
            String substringBeforeIndex1 = s1.substring(0, startIndex1);
            String substringAfterIndex1 = s1.substring(startIndex1 + element1.length());
            for (String element2 : set2) {
                VariableReplacementWithMethodInvocation r;
                if (element2.endsWith(substringAfterIndex1) && substringAfterIndex1.length() > 1) {
                    element2 = element2.substring(0, element2.indexOf(substringAfterIndex1));
                }
                if (!s2.contains(element2) || s2.equals(element2)) continue;
                int startIndex2 = s2.indexOf(element2);
                String substringBeforeIndex2 = s2.substring(0, startIndex2);
                String substringAfterIndex2 = s2.substring(startIndex2 + element2.length());
                List<? extends AbstractCall> methodInvocationList = null;
                if (direction.equals((Object)VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION)) {
                    methodInvocationList = methodInvocationMap.get(element2);
                } else if (direction.equals((Object)VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE)) {
                    methodInvocationList = methodInvocationMap.get(element1);
                }
                if (substringBeforeIndex1.equals(substringBeforeIndex2) && !substringAfterIndex1.isEmpty() && !substringAfterIndex2.isEmpty() && methodInvocationList != null) {
                    r = new VariableReplacementWithMethodInvocation(element1, element2, (OperationInvocation)methodInvocationList.get(0), direction);
                    replacements.add(r);
                    continue;
                }
                if (!substringAfterIndex1.equals(substringAfterIndex2) || substringBeforeIndex1.isEmpty() || substringBeforeIndex2.isEmpty() || methodInvocationList == null) continue;
                r = new VariableReplacementWithMethodInvocation(element1, element2, (OperationInvocation)methodInvocationList.get(0), direction);
                replacements.add(r);
            }
        }
        return replacements;
    }

    private Replacement variableReplacementWithinMethodInvocations(String s1, String s2, Set<String> variables1, Set<String> variables2) {
        for (String variable1 : variables1) {
            if (!s1.contains(variable1) || s1.equals(variable1) || s1.equals("this." + variable1) || s1.equals("_" + variable1)) continue;
            int startIndex1 = s1.indexOf(variable1);
            String substringBeforeIndex1 = s1.substring(0, startIndex1);
            String substringAfterIndex1 = s1.substring(startIndex1 + variable1.length());
            for (String variable2 : variables2) {
                if (variable2.endsWith(substringAfterIndex1) && substringAfterIndex1.length() > 1) {
                    variable2 = variable2.substring(0, variable2.indexOf(substringAfterIndex1));
                }
                if (!s2.contains(variable2) || s2.equals(variable2)) continue;
                int startIndex2 = s2.indexOf(variable2);
                String substringBeforeIndex2 = s2.substring(0, startIndex2);
                String substringAfterIndex2 = s2.substring(startIndex2 + variable2.length());
                if (!substringBeforeIndex1.equals(substringBeforeIndex2) || !substringAfterIndex1.equals(substringAfterIndex2)) continue;
                return new Replacement(variable1, variable2, Replacement.ReplacementType.VARIABLE_NAME);
            }
        }
        return null;
    }

    private boolean equalAfterArgumentMerge(String s1, String s2, ReplacementInfo replacementInfo) {
        LinkedHashMap commonVariableReplacementMap = new LinkedHashMap();
        for (Replacement replacement : replacementInfo.getReplacements()) {
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
            String key = replacement.getAfter();
            if (commonVariableReplacementMap.containsKey(key)) {
                ((Set)commonVariableReplacementMap.get(key)).add(replacement);
                int index = ((String)s1).indexOf(key);
                if (index == -1) continue;
                if (((String)s1).charAt(index + key.length()) == ',') {
                    s1 = ((String)s1).substring(0, index) + ((String)s1).substring(index + key.length() + 1);
                    continue;
                }
                if (index <= 0 || ((String)s1).charAt(index - 1) != ',') continue;
                s1 = ((String)s1).substring(0, index - 1) + ((String)s1).substring(index + key.length());
                continue;
            }
            LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
            replacements.add(replacement);
            commonVariableReplacementMap.put(key, replacements);
        }
        if (((String)s1).equals(s2)) {
            for (String key : commonVariableReplacementMap.keySet()) {
                Set replacements = (Set)commonVariableReplacementMap.get(key);
                if (replacements.size() <= 1) continue;
                replacementInfo.getReplacements().removeAll(replacements);
                LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                for (Replacement replacement : replacements) {
                    mergedVariables.add(replacement.getBefore());
                }
                MergeVariableReplacement merge = new MergeVariableReplacement(mergedVariables, key);
                replacementInfo.getReplacements().add(merge);
            }
            return true;
        }
        return false;
    }

    private boolean variablesStartWithSameCase(String s1, String s2, Map<String, String> parameterToArgumentMap) {
        if (parameterToArgumentMap.containsValue(s2)) {
            return true;
        }
        if (s1.length() > 0 && s2.length() > 0) {
            if (Character.isUpperCase(s1.charAt(0)) && Character.isUpperCase(s2.charAt(0))) {
                return true;
            }
            if (Character.isLowerCase(s1.charAt(0)) && Character.isLowerCase(s2.charAt(0))) {
                return true;
            }
            if (s1.charAt(0) == '_' && s2.charAt(0) == '_') {
                return true;
            }
            return s1.charAt(0) == '(' || s2.charAt(0) == '(';
        }
        return false;
    }

    public static boolean containsMethodSignatureOfAnonymousClass(String s) {
        String[] lines = s.split("\\n");
        return s.contains(" -> ") && lines.length > 1;
    }

    private void findReplacements(Set<String> strings1, Set<String> strings2, ReplacementInfo replacementInfo, Replacement.ReplacementType type) throws RefactoringMinerTimedOutException {
        block25: {
            Replacement replacement;
            Object distancenormalized;
            LinkedHashSet<Replacement> r;
            double distancenormalized2;
            Replacement replacement2;
            String temp;
            int distanceRaw;
            boolean containsMethodSignatureOfAnonymousClass2;
            TreeMap<Double, Replacement> replacementMap;
            TreeMap globalReplacementMap = new TreeMap();
            TreeMap replacementCache = new TreeMap();
            if (strings1.size() <= strings2.size()) {
                for (String s1 : strings1) {
                    replacementMap = new TreeMap<Double, Replacement>();
                    for (String s2 : strings2) {
                        if (Thread.interrupted()) {
                            throw new RefactoringMinerTimedOutException();
                        }
                        boolean containsMethodSignatureOfAnonymousClass1 = UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s1);
                        if (containsMethodSignatureOfAnonymousClass1 != (containsMethodSignatureOfAnonymousClass2 = UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s2)) && this.operation1.getVariableDeclaration(s1) == null && this.operation2.getVariableDeclaration(s2) == null || (distanceRaw = StringDistance.editDistance(temp = ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), s1, s2), replacementInfo.getArgumentizedString2())) < 0 || distanceRaw >= replacementInfo.getRawDistance()) continue;
                        replacement2 = new Replacement(s1, s2, type);
                        distancenormalized2 = (double)distanceRaw / (double)Math.max(temp.length(), replacementInfo.getArgumentizedString2().length());
                        replacementMap.put(distancenormalized2, replacement2);
                        if (replacementCache.containsKey(distancenormalized2)) {
                            ((Set)replacementCache.get(distancenormalized2)).add(replacement2);
                        } else {
                            r = new LinkedHashSet<Replacement>();
                            r.add(replacement2);
                            replacementCache.put(distancenormalized2, r);
                        }
                        if (distanceRaw != 0) continue;
                        break;
                    }
                    if (replacementMap.isEmpty()) continue;
                    distancenormalized = (Double)replacementMap.firstEntry().getKey();
                    replacement = (Replacement)replacementMap.firstEntry().getValue();
                    if (globalReplacementMap.containsKey(distancenormalized)) {
                        ((Set)globalReplacementMap.get(distancenormalized)).add(replacement);
                    } else {
                        LinkedHashSet<Replacement> r2 = new LinkedHashSet<Replacement>();
                        r2.add(replacement);
                        globalReplacementMap.put(distancenormalized, r2);
                    }
                    if ((Double)distancenormalized != 0.0) continue;
                    break;
                }
            } else {
                for (String s2 : strings2) {
                    replacementMap = new TreeMap();
                    for (String s1 : strings1) {
                        if (Thread.interrupted()) {
                            throw new RefactoringMinerTimedOutException();
                        }
                        boolean containsMethodSignatureOfAnonymousClass1 = UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s1);
                        if (containsMethodSignatureOfAnonymousClass1 != (containsMethodSignatureOfAnonymousClass2 = UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(s2)) && this.operation1.getVariableDeclaration(s1) == null && this.operation2.getVariableDeclaration(s2) == null || (distanceRaw = StringDistance.editDistance(temp = ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), s1, s2), replacementInfo.getArgumentizedString2())) < 0 || distanceRaw >= replacementInfo.getRawDistance()) continue;
                        replacement2 = new Replacement(s1, s2, type);
                        distancenormalized2 = (double)distanceRaw / (double)Math.max(temp.length(), replacementInfo.getArgumentizedString2().length());
                        replacementMap.put(distancenormalized2, replacement2);
                        if (replacementCache.containsKey(distancenormalized2)) {
                            ((Set)replacementCache.get(distancenormalized2)).add(replacement2);
                        } else {
                            r = new LinkedHashSet();
                            r.add(replacement2);
                            replacementCache.put(distancenormalized2, r);
                        }
                        if (distanceRaw != 0) continue;
                        break;
                    }
                    if (replacementMap.isEmpty()) continue;
                    distancenormalized = (Double)replacementMap.firstEntry().getKey();
                    replacement = (Replacement)replacementMap.firstEntry().getValue();
                    if (globalReplacementMap.containsKey(distancenormalized)) {
                        ((Set)globalReplacementMap.get(distancenormalized)).add(replacement);
                    } else {
                        LinkedHashSet<Replacement> r3 = new LinkedHashSet<Replacement>();
                        r3.add(replacement);
                        globalReplacementMap.put(distancenormalized, r3);
                    }
                    if ((Double)replacementMap.firstEntry().getKey() != 0.0) continue;
                    break;
                }
            }
            if (globalReplacementMap.isEmpty()) break block25;
            Double distancenormalized3 = (Double)globalReplacementMap.firstEntry().getKey();
            if (distancenormalized3 == 0.0) {
                Set replacements = (Set)globalReplacementMap.firstEntry().getValue();
                for (Replacement replacement3 : replacements) {
                    replacementInfo.addReplacement(replacement3);
                    replacementInfo.setArgumentizedString1(ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), replacement3.getBefore(), replacement3.getAfter()));
                }
            } else {
                LinkedHashSet<String> processedBefores = new LinkedHashSet<String>();
                for (Set replacements : globalReplacementMap.values()) {
                    for (Replacement replacement4 : replacements) {
                        if (!processedBefores.contains(replacement4.getBefore())) {
                            replacementInfo.addReplacement(replacement4);
                            replacementInfo.setArgumentizedString1(ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), replacement4.getBefore(), replacement4.getAfter()));
                            processedBefores.add(replacement4.getBefore());
                            continue;
                        }
                        block7: for (Set replacements2 : replacementCache.values()) {
                            for (Replacement replacement22 : replacements2) {
                                if (!replacement22.getAfter().equals(replacement4.getAfter()) || replacement22.equals(replacement4)) continue;
                                replacementInfo.addReplacement(replacement22);
                                replacementInfo.setArgumentizedString1(ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), replacementInfo.getArgumentizedString2(), replacement22.getBefore(), replacement22.getAfter()));
                                processedBefores.add(replacement22.getBefore());
                                continue block7;
                            }
                        }
                    }
                }
            }
        }
    }

    private void inlinedVariableAssignment(StatementObject statement, List<StatementObject> nonMappedLeavesT2) {
        for (AbstractCodeMapping mapping : this.getMappings()) {
            mapping.inlinedVariableAssignment(statement, nonMappedLeavesT2, this.refactorings);
        }
    }

    private boolean isExpressionOfAnotherMethodInvocation(AbstractCall invocation, Map<String, List<? extends AbstractCall>> invocationMap) {
        for (String key : invocationMap.keySet()) {
            List<? extends AbstractCall> invocations = invocationMap.get(key);
            for (AbstractCall abstractCall : invocations) {
                if (abstractCall.equals(invocation) || abstractCall.getExpression() == null || !abstractCall.getExpression().equals(invocation.actualString())) continue;
                for (String argument : abstractCall.getArguments()) {
                    if (!invocationMap.containsKey(argument)) continue;
                    List<? extends AbstractCall> argumentInvocations = invocationMap.get(argument);
                    for (AbstractCall abstractCall2 : argumentInvocations) {
                        if (!abstractCall2.identicalName(invocation) || !abstractCall2.equalArguments(invocation)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean containsExtractOperationRefactoring(UMLOperation extractedOperation) {
        if (this.classDiff != null) {
            return this.classDiff.containsExtractOperationRefactoring(this.operation1, extractedOperation);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull UMLOperationBodyMapper operationBodyMapper) {
        int otherEditDistance;
        int otherExactMatches;
        void var5_12;
        void var4_8;
        if (operationBodyMapper == null) {
            UMLOperationBodyMapper.$$$reportNull$$$0(0);
        }
        int thisCallChainIntersectionSum = 0;
        for (AbstractCodeMapping abstractCodeMapping : this.mappings) {
            if (!(abstractCodeMapping instanceof LeafMapping)) continue;
            thisCallChainIntersectionSum += ((LeafMapping)abstractCodeMapping).callChainIntersection().size();
        }
        int otherCallChainIntersectionSum = 0;
        for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.mappings) {
            if (!(abstractCodeMapping instanceof LeafMapping)) continue;
            otherCallChainIntersectionSum += ((LeafMapping)abstractCodeMapping).callChainIntersection().size();
        }
        if (thisCallChainIntersectionSum != otherCallChainIntersectionSum) {
            return -Integer.compare(thisCallChainIntersectionSum, otherCallChainIntersectionSum);
        }
        int n = this.mappingsWithoutBlocks();
        for (AbstractCodeMapping abstractCodeMapping : this.getMappings()) {
            if (!abstractCodeMapping.isIdenticalWithExtractedVariable() && !abstractCodeMapping.isIdenticalWithInlinedVariable()) continue;
            ++var4_8;
        }
        int n2 = operationBodyMapper.mappingsWithoutBlocks();
        for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
            if (!mapping.isIdenticalWithExtractedVariable() && !mapping.isIdenticalWithInlinedVariable()) continue;
            ++var5_12;
        }
        if (var4_8 != var5_12) {
            return -Integer.compare((int)var4_8, (int)var5_12);
        }
        int n3 = this.exactMatches();
        if (n3 != (otherExactMatches = operationBodyMapper.exactMatches())) {
            return -Integer.compare(n3, otherExactMatches);
        }
        int thisEditDistance = this.editDistance();
        if (thisEditDistance != (otherEditDistance = operationBodyMapper.editDistance())) {
            return Integer.compare(thisEditDistance, otherEditDistance);
        }
        int thisOperationNameEditDistance = this.operationNameEditDistance();
        int otherOperationNameEditDistance = operationBodyMapper.operationNameEditDistance();
        return Integer.compare(thisOperationNameEditDistance, otherOperationNameEditDistance);
    }

    public int operationNameEditDistance() {
        return StringDistance.editDistance(this.operation1.getName(), this.operation2.getName());
    }

    public int exactMatches() {
        int count = 0;
        for (AbstractCodeMapping mapping : this.getMappings()) {
            if (!mapping.isExact() || !mapping.getFragment1().countableStatement() || !mapping.getFragment2().countableStatement() || mapping.getFragment1().getString().equals("try")) continue;
            ++count;
        }
        return count;
    }

    public int mappingsWithoutBlocks() {
        int count = 0;
        for (AbstractCodeMapping mapping : this.getMappings()) {
            if (!mapping.getFragment1().countableStatement() || !mapping.getFragment2().countableStatement()) continue;
            ++count;
        }
        return count;
    }

    private int editDistance() {
        int count = 0;
        for (AbstractCodeMapping mapping : this.getMappings()) {
            String s2;
            String s1;
            if (mapping.isIdenticalWithExtractedVariable() || mapping.isIdenticalWithInlinedVariable() || (s1 = this.preprocessInput1(mapping.getFragment1(), mapping.getFragment2())).equals(s2 = this.preprocessInput2(mapping.getFragment1(), mapping.getFragment2()))) continue;
            count += StringDistance.editDistance(s1, s2);
        }
        return count;
    }

    private int inconsistentVariableMappingCount(AbstractCodeFragment statement1, AbstractCodeFragment statement2, VariableDeclaration v1, VariableDeclaration v2) {
        int count = 0;
        if (v1 != null && v2 != null) {
            for (AbstractCodeMapping mapping : this.mappings) {
                List<VariableDeclaration> variableDeclarations1 = mapping.getFragment1().getVariableDeclarations();
                List<VariableDeclaration> variableDeclarations2 = mapping.getFragment2().getVariableDeclarations();
                if (variableDeclarations1.contains(v1) && variableDeclarations2.size() > 0 && !variableDeclarations2.contains(v2)) {
                    ++count;
                }
                if (variableDeclarations2.contains(v2) && variableDeclarations1.size() > 0 && !variableDeclarations1.contains(v1)) {
                    ++count;
                }
                if (!mapping.isExact()) continue;
                boolean containsMapping = true;
                if (!(statement1 instanceof CompositeStatementObject) || !(statement2 instanceof CompositeStatementObject) || !statement1.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT)) continue;
                CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
                CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
                containsMapping = comp1.contains(mapping.getFragment1()) && comp2.contains(mapping.getFragment2());
            }
        }
        return count;
    }

    private String preprocessInput1(AbstractCodeFragment leaf1, AbstractCodeFragment leaf2) {
        return this.preprocessInput(leaf1, leaf2);
    }

    private String preprocessInput2(AbstractCodeFragment leaf1, AbstractCodeFragment leaf2) {
        return this.preprocessInput(leaf2, leaf1);
    }

    private String preprocessInput(AbstractCodeFragment leaf1, AbstractCodeFragment leaf2) {
        String argumentizedString = leaf1.getArgumentizedString();
        if (leaf1 instanceof StatementObject && leaf2 instanceof AbstractExpression && argumentizedString.startsWith("return ") && argumentizedString.endsWith("\n")) {
            argumentizedString = argumentizedString.substring("return ".length(), argumentizedString.lastIndexOf("\n"));
        }
        return argumentizedString;
    }

    public Set<AbstractCodeMapping> getMappings() {
        return this.mappings;
    }

    public List<StatementObject> getNonMappedLeavesT1() {
        return this.nonMappedLeavesT1;
    }

    public List<StatementObject> getNonMappedLeavesT2() {
        return this.nonMappedLeavesT2;
    }

    private boolean isTemporaryVariableAssignment(StatementObject statement) {
        return false;
    }

    public List<CompositeStatementObject> getNonMappedInnerNodesT1() {
        return this.nonMappedInnerNodesT1;
    }

    public int nonMappedElementsT1() {
        int nonMappedInnerNodeCount = 0;
        for (CompositeStatementObject composite : this.getNonMappedInnerNodesT1()) {
            if (!composite.countableStatement()) continue;
            ++nonMappedInnerNodeCount;
        }
        int nonMappedLeafCount = 0;
        for (StatementObject statement : this.getNonMappedLeavesT1()) {
            if (!statement.countableStatement()) continue;
            ++nonMappedLeafCount;
        }
        return nonMappedLeafCount + nonMappedInnerNodeCount;
    }

    public List<CompositeStatementObject> getNonMappedInnerNodesT2() {
        return this.nonMappedInnerNodesT2;
    }

    public int nonMappedElementsT2() {
        int nonMappedInnerNodeCount = 0;
        for (CompositeStatementObject composite : this.getNonMappedInnerNodesT2()) {
            if (!composite.countableStatement()) continue;
            ++nonMappedInnerNodeCount;
        }
        int nonMappedLeafCount = 0;
        for (StatementObject statement : this.getNonMappedLeavesT2()) {
            if (!statement.countableStatement() || this.isTemporaryVariableAssignment(statement)) continue;
            ++nonMappedLeafCount;
        }
        return nonMappedLeafCount + nonMappedInnerNodeCount;
    }

    public int nonMappedLeafElementsT2() {
        int nonMappedLeafCount = 0;
        for (StatementObject statement : this.getNonMappedLeavesT2()) {
            if (!statement.countableStatement() || this.isTemporaryVariableAssignment(statement)) continue;
            ++nonMappedLeafCount;
        }
        return nonMappedLeafCount;
    }

    public Set<Refactoring> getRefactorings() {
        VariableReplacementAnalysis analysis = new VariableReplacementAnalysis(this, this.refactorings, this.classDiff);
        this.refactorings.addAll(analysis.getVariableRenames());
        this.refactorings.addAll(analysis.getVariableMerges());
        this.refactorings.addAll(analysis.getVariableSplits());
        this.candidateAttributeRenames.addAll(analysis.getCandidateAttributeRenames());
        this.candidateAttributeMerges.addAll(analysis.getCandidateAttributeMerges());
        this.candidateAttributeSplits.addAll(analysis.getCandidateAttributeSplits());
        TypeReplacementAnalysis typeAnalysis = new TypeReplacementAnalysis(this.getMappings());
        this.refactorings.addAll(typeAnalysis.getChangedTypes());
        return this.refactorings;
    }

    public Set<Refactoring> getRefactoringsAfterPostProcessing() {
        return this.refactorings;
    }

    public int nonMappedElementsT2CallingAddedOperation(List<UMLOperation> addedOperations) {
        int nonMappedInnerNodeCount = 0;
        for (CompositeStatementObject composite : this.getNonMappedInnerNodesT2()) {
            if (!composite.countableStatement()) continue;
            Map<String, List<OperationInvocation>> methodInvocationMap = composite.getMethodInvocationMap();
            for (String key : methodInvocationMap.keySet()) {
                block2: for (OperationInvocation invocation : methodInvocationMap.get(key)) {
                    for (UMLOperation operation : addedOperations) {
                        if (!invocation.matchesOperation(operation, this.operation2.variableTypeMap(), this.modelDiff)) continue;
                        ++nonMappedInnerNodeCount;
                        continue block2;
                    }
                }
            }
        }
        int nonMappedLeafCount = 0;
        for (StatementObject statement : this.getNonMappedLeavesT2()) {
            if (!statement.countableStatement()) continue;
            Map<String, List<OperationInvocation>> methodInvocationMap = statement.getMethodInvocationMap();
            for (String key : methodInvocationMap.keySet()) {
                block6: for (OperationInvocation invocation : methodInvocationMap.get(key)) {
                    for (UMLOperation operation : addedOperations) {
                        if (!invocation.matchesOperation(operation, this.operation2.variableTypeMap(), this.modelDiff)) continue;
                        ++nonMappedLeafCount;
                        continue block6;
                    }
                }
            }
        }
        return nonMappedLeafCount + nonMappedInnerNodeCount;
    }

    public int nonMappedElementsT1CallingRemovedOperation(List<UMLOperation> removedOperations) {
        int nonMappedInnerNodeCount = 0;
        for (CompositeStatementObject composite : this.getNonMappedInnerNodesT1()) {
            if (!composite.countableStatement()) continue;
            Map<String, List<OperationInvocation>> methodInvocationMap = composite.getMethodInvocationMap();
            for (String key : methodInvocationMap.keySet()) {
                block2: for (OperationInvocation invocation : methodInvocationMap.get(key)) {
                    for (UMLOperation operation : removedOperations) {
                        if (!invocation.matchesOperation(operation, this.operation1.variableTypeMap(), this.modelDiff)) continue;
                        ++nonMappedInnerNodeCount;
                        continue block2;
                    }
                }
            }
        }
        int nonMappedLeafCount = 0;
        for (StatementObject statement : this.getNonMappedLeavesT1()) {
            if (!statement.countableStatement()) continue;
            Map<String, List<OperationInvocation>> methodInvocationMap = statement.getMethodInvocationMap();
            for (String key : methodInvocationMap.keySet()) {
                block6: for (OperationInvocation invocation : methodInvocationMap.get(key)) {
                    for (UMLOperation operation : removedOperations) {
                        if (!invocation.matchesOperation(operation, this.operation1.variableTypeMap(), this.modelDiff)) continue;
                        ++nonMappedLeafCount;
                        continue block6;
                    }
                }
            }
        }
        return nonMappedLeafCount + nonMappedInnerNodeCount;
    }

    public Set<MethodInvocationReplacement> getMethodInvocationRenameReplacements() {
        LinkedHashSet<MethodInvocationReplacement> replacements = new LinkedHashSet<MethodInvocationReplacement>();
        for (AbstractCodeMapping mapping : this.getMappings()) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.METHOD_INVOCATION_NAME) && !replacement.getType().equals((Object)Replacement.ReplacementType.METHOD_INVOCATION_NAME_AND_ARGUMENT)) continue;
                replacements.add((MethodInvocationReplacement)replacement);
            }
        }
        return replacements;
    }

    public Set<CandidateAttributeRefactoring> getCandidateAttributeRenames() {
        return this.candidateAttributeRenames;
    }

    public Set<CandidateMergeVariableRefactoring> getCandidateAttributeMerges() {
        return this.candidateAttributeMerges;
    }

    public Set<CandidateSplitVariableRefactoring> getCandidateAttributeSplits() {
        return this.candidateAttributeSplits;
    }

    public Set<Replacement> getReplacements() {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (AbstractCodeMapping mapping : this.getMappings()) {
            replacements.addAll(mapping.getReplacements());
        }
        return replacements;
    }

    public double normalizedEditDistance() {
        double editDistance = 0.0;
        double maxLength = 0.0;
        for (AbstractCodeMapping mapping : this.getMappings()) {
            String s2;
            String s1;
            if (mapping.isIdenticalWithExtractedVariable() || mapping.isIdenticalWithInlinedVariable() || (s1 = this.preprocessInput1(mapping.getFragment1(), mapping.getFragment2())).equals(s2 = this.preprocessInput2(mapping.getFragment1(), mapping.getFragment2()))) continue;
            editDistance += (double)StringDistance.editDistance(s1, s2);
            maxLength += (double)Math.max(s1.length(), s2.length());
        }
        return editDistance / maxLength;
    }

    public List<AbstractCodeMapping> getExactMatches() {
        ArrayList<AbstractCodeMapping> exactMatches = new ArrayList<AbstractCodeMapping>();
        for (AbstractCodeMapping mapping : this.getMappings()) {
            if (!mapping.isExact() || !mapping.getFragment1().countableStatement() || !mapping.getFragment2().countableStatement() || mapping.getFragment1().getString().equals("try")) continue;
            exactMatches.add(mapping);
        }
        return exactMatches;
    }

    public Set<Replacement> getReplacementsInvolvingMethodInvocation() {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (AbstractCodeMapping mapping : this.getMappings()) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (!(replacement instanceof MethodInvocationReplacement) && !(replacement instanceof VariableReplacementWithMethodInvocation) && !replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION)) continue;
                replacements.add(replacement);
            }
        }
        return replacements;
    }

    public void addChildMapper(UMLOperationBodyMapper mapper) {
        this.childMappers.add(mapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationBodyMapper", "org/jetbrains/research/kotlinrminer/ide/decomposition/UMLOperationBodyMapper", "compareTo"));
    }

    private static class ReplacementInfo {
        private String argumentizedString1;
        private final String argumentizedString2;
        private int rawDistance;
        private final Set<Replacement> replacements;
        private final List<? extends AbstractCodeFragment> statements1;
        private final List<? extends AbstractCodeFragment> statements2;

        public ReplacementInfo(String argumentizedString1, String argumentizedString2, List<? extends AbstractCodeFragment> statements1, List<? extends AbstractCodeFragment> statements2) {
            this.argumentizedString1 = argumentizedString1;
            this.argumentizedString2 = argumentizedString2;
            this.statements1 = statements1;
            this.statements2 = statements2;
            this.rawDistance = StringDistance.editDistance(argumentizedString1, argumentizedString2);
            this.replacements = new LinkedHashSet<Replacement>();
        }

        public String getArgumentizedString1() {
            return this.argumentizedString1;
        }

        public String getArgumentizedString2() {
            return this.argumentizedString2;
        }

        public void setArgumentizedString1(String string) {
            this.argumentizedString1 = string;
            this.rawDistance = StringDistance.editDistance(this.argumentizedString1, this.argumentizedString2);
        }

        public int getRawDistance() {
            return this.rawDistance;
        }

        public void addReplacement(Replacement r) {
            this.replacements.add(r);
        }

        public void addReplacements(Set<Replacement> replacementsToBeAdded) {
            this.replacements.addAll(replacementsToBeAdded);
        }

        public void removeReplacements(Set<Replacement> replacementsToBeRemoved) {
            this.replacements.removeAll(replacementsToBeRemoved);
        }

        public Set<Replacement> getReplacements() {
            return this.replacements;
        }

        public List<Replacement> getReplacements(Replacement.ReplacementType type) {
            ArrayList<Replacement> replacements = new ArrayList<Replacement>();
            for (Replacement replacement : this.replacements) {
                if (!replacement.getType().equals((Object)type)) continue;
                replacements.add(replacement);
            }
            return replacements;
        }
    }
}

