/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.common.replacement.ConsistentReplacementDetector;
import org.jetbrains.research.kotlinrminer.common.replacement.MergeVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.common.replacement.SplitVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableReferenceExtractor;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.VariableDeclarationReplacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.VariableReplacementWithMethodInvocation;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLParameterDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateMergeVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateSplitVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeVariableTypeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.InlineVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MergeVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.SplitVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;

public class VariableReplacementAnalysis {
    private final Set<AbstractCodeMapping> mappings;
    private final List<StatementObject> nonMappedLeavesT1;
    private final List<StatementObject> nonMappedLeavesT2;
    private final List<CompositeStatementObject> nonMappedInnerNodesT1;
    private final List<CompositeStatementObject> nonMappedInnerNodesT2;
    private final UMLOperation operation1;
    private final UMLOperation operation2;
    private final List<UMLOperationBodyMapper> childMappers;
    private final Set<Refactoring> refactorings;
    private final UMLOperation callSiteOperation;
    private final UMLOperationDiff operationDiff;
    private final UMLClassBaseDiff classDiff;
    private final Set<RenameVariableRefactoring> variableRenames = new LinkedHashSet<RenameVariableRefactoring>();
    private final Set<MergeVariableRefactoring> variableMerges = new LinkedHashSet<MergeVariableRefactoring>();
    private final Set<SplitVariableRefactoring> variableSplits = new LinkedHashSet<SplitVariableRefactoring>();
    private final Set<CandidateAttributeRefactoring> candidateAttributeRenames = new LinkedHashSet<CandidateAttributeRefactoring>();
    private final Set<CandidateMergeVariableRefactoring> candidateAttributeMerges = new LinkedHashSet<CandidateMergeVariableRefactoring>();
    private final Set<CandidateSplitVariableRefactoring> candidateAttributeSplits = new LinkedHashSet<CandidateSplitVariableRefactoring>();

    public VariableReplacementAnalysis(UMLOperationBodyMapper mapper, Set<Refactoring> refactorings, UMLClassBaseDiff classDiff) {
        this.mappings = mapper.getMappings();
        this.nonMappedLeavesT1 = mapper.getNonMappedLeavesT1();
        this.nonMappedLeavesT2 = mapper.getNonMappedLeavesT2();
        this.nonMappedInnerNodesT1 = mapper.getNonMappedInnerNodesT1();
        this.nonMappedInnerNodesT2 = mapper.getNonMappedInnerNodesT2();
        this.operation1 = mapper.getOperation1();
        this.operation2 = mapper.getOperation2();
        this.childMappers = new ArrayList<UMLOperationBodyMapper>();
        this.childMappers.addAll(mapper.getChildMappers());
        UMLOperationBodyMapper parentMapper = mapper.getParentMapper();
        if (parentMapper != null) {
            this.childMappers.addAll(parentMapper.getChildMappers());
        }
        this.refactorings = refactorings;
        this.callSiteOperation = mapper.getCallSiteOperation();
        this.operationDiff = classDiff != null ? classDiff.getOperationDiff(this.operation1, this.operation2) : null;
        this.classDiff = classDiff;
        this.findVariableSplits();
        this.findVariableMerges();
        this.findConsistentVariableRenames();
        this.findParametersWrappedInLocalVariables();
        this.findAttributeExtractions();
    }

    private static boolean returnVariableMapping(AbstractCodeMapping mapping, Replacement replacement) {
        return mapping.getFragment1().getString().equals("return " + replacement.getBefore() + "\n") && mapping.getFragment2().getString().equals("return " + replacement.getAfter() + "\n");
    }

    public static String prepareLine(String line) {
        if ((line = line.trim()).startsWith("@Nullable")) {
            line = line.substring(9);
            line = line.trim();
        }
        if (line.startsWith("override")) {
            line = line.substring(9);
            line = line.trim();
        }
        if (line.contains("throws ")) {
            line = line.substring(0, line.indexOf("throws "));
        }
        return line;
    }

    private static boolean cyclicRename(Set<Replacement> finalConsistentRenames, Replacement replacement) {
        for (Replacement r : finalConsistentRenames) {
            if (replacement.getAfter().equals(r.getBefore())) {
                return true;
            }
            if (!replacement.getBefore().equals(r.getAfter())) continue;
            return true;
        }
        return false;
    }

    public static boolean bothFragmentsUseVariable(VariableDeclaration v1, AbstractCodeMapping mapping) {
        return mapping.getFragment1().getVariables().contains(v1.getVariableName()) && mapping.getFragment2().getVariables().contains(v1.getVariableName());
    }

    private static boolean containsVariableDeclarationWithName(Set<VariableDeclaration> variableDeclarations, String variableName) {
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private void findAttributeExtractions() {
        if (this.classDiff != null) {
            for (AbstractCodeMapping mapping : this.mappings) {
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.involvesVariable()) continue;
                    for (UMLAttribute addedAttribute : this.classDiff.getAddedAttributes()) {
                        VariableDeclaration variableDeclaration = addedAttribute.getVariableDeclaration();
                        if (!addedAttribute.getName().equals(replacement.getAfter()) || variableDeclaration.getInitializer() == null || !variableDeclaration.getInitializer().getString().equals(replacement.getBefore())) continue;
                        ExtractAttributeRefactoring refactoring = new ExtractAttributeRefactoring(addedAttribute, this.classDiff.getOriginalClass(), this.classDiff.getNextClass());
                        refactoring.addReference(mapping);
                        this.refactorings.add(refactoring);
                    }
                }
            }
        }
    }

    private void findParametersWrappedInLocalVariables() {
        for (StatementObject statement : this.nonMappedLeavesT2) {
            for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
                AbstractExpression initializer = declaration.getInitializer();
                if (initializer == null) continue;
                for (String key : initializer.getCreationMap().keySet()) {
                    List<ObjectCreation> creations = initializer.getCreationMap().get(key);
                    for (ObjectCreation creation : creations) {
                        for (String argument : creation.arguments) {
                            AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v2 = this.getVariableDeclaration2(new Replacement("", argument, Replacement.ReplacementType.VARIABLE_NAME));
                            AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v1 = this.getVariableDeclaration1(new Replacement(declaration.getVariableName(), "", Replacement.ReplacementType.VARIABLE_NAME));
                            if (v2 == null || v1 == null) continue;
                            Set<AbstractCodeMapping> references = VariableReferenceExtractor.findReferences(v1.getKey(), v2.getKey(), this.mappings);
                            RenameVariableRefactoring ref = new RenameVariableRefactoring(v1.getKey(), v2.getKey(), v1.getValue(), v2.getValue(), references);
                            if (this.existsConflictingExtractVariableRefactoring(ref) || this.existsConflictingMergeVariableRefactoring(ref) || this.existsConflictingSplitVariableRefactoring(ref)) continue;
                            this.variableRenames.add(ref);
                            if (v1.getKey().getType().equals(v2.getKey().getType()) && v1.getKey().getType().equalsQualified(v2.getKey().getType())) continue;
                            ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(v1.getKey(), v2.getKey(), v1.getValue(), v2.getValue(), references);
                            refactoring.addRelatedRefactoring(ref);
                            this.refactorings.add(refactoring);
                        }
                    }
                }
            }
        }
    }

    public Set<RenameVariableRefactoring> getVariableRenames() {
        return this.variableRenames;
    }

    public Set<MergeVariableRefactoring> getVariableMerges() {
        return this.variableMerges;
    }

    public Set<SplitVariableRefactoring> getVariableSplits() {
        return this.variableSplits;
    }

    public Set<CandidateAttributeRefactoring> getCandidateAttributeRenames() {
        return this.candidateAttributeRenames;
    }

    public Set<CandidateMergeVariableRefactoring> getCandidateAttributeMerges() {
        return this.candidateAttributeMerges;
    }

    public Set<CandidateSplitVariableRefactoring> getCandidateAttributeSplits() {
        return this.candidateAttributeSplits;
    }

    private void findVariableSplits() {
        LinkedHashMap splitMap = new LinkedHashMap();
        LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap = new LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>>();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (replacement instanceof SplitVariableReplacement) {
                    SplitVariableReplacement split = (SplitVariableReplacement)replacement;
                    if (splitMap.containsKey(split)) {
                        ((Set)splitMap.get(split)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                    mappings.add(mapping);
                    splitMap.put(split, mappings);
                    continue;
                }
                if (replacement instanceof VariableReplacementWithMethodInvocation) {
                    VariableReplacementWithMethodInvocation variableReplacement = (VariableReplacementWithMethodInvocation)replacement;
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                for (StatementObject statement : this.nonMappedLeavesT1) {
                    OperationInvocation invocation;
                    AbstractExpression initializer;
                    VariableDeclaration variableDeclaration = statement.getVariableDeclaration(replacement.getBefore());
                    if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
                    VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(initializer.getString(), replacement.getAfter(), invocation, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                }
            }
        }
        for (StatementObject statement : this.nonMappedLeavesT1) {
            for (String parameterName : this.operation2.getParameterNameList()) {
                String expression;
                OperationInvocation invocation;
                Object initializer;
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(parameterName);
                if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = ((AbstractCodeFragment)initializer).invocationCoveringEntireFragment()) == null || (expression = invocation.getExpression()) == null) continue;
                VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(((AbstractExpression)initializer).getString(), parameterName, invocation, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                this.processVariableReplacementWithMethodInvocation(variableReplacement, null, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
            }
        }
        for (String key : variableInvocationExpressionMap.keySet()) {
            Map map = (Map)variableInvocationExpressionMap.get(key);
            LinkedHashSet mappings = new LinkedHashSet();
            LinkedHashSet splitVariables = new LinkedHashSet();
            for (VariableReplacementWithMethodInvocation replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getAfter()))) continue;
                splitVariables.add(replacement.getAfter());
                mappings.addAll((Collection)map.get(replacement));
            }
            if (splitVariables.size() <= 0) continue;
            SplitVariableReplacement split = new SplitVariableReplacement(key, splitVariables);
            splitMap.put(split, mappings);
        }
        for (SplitVariableReplacement split : splitMap.keySet()) {
            LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<UMLOperation> splitVariableOperations = new LinkedHashSet<UMLOperation>();
            for (String variableName : split.getSplitVariables()) {
                AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> declaration = this.getVariableDeclaration2(split, variableName);
                if (declaration == null) continue;
                splitVariables.add(declaration.getKey());
                splitVariableOperations.add(declaration.getValue());
            }
            AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> oldVariable = this.getVariableDeclaration1(split);
            if (splitVariables.size() > 1 && splitVariables.size() == split.getSplitVariables().size() && oldVariable != null) {
                UMLOperation operationAfter = (UMLOperation)splitVariableOperations.iterator().next();
                SplitVariableRefactoring refactoring = new SplitVariableRefactoring(oldVariable.getKey(), splitVariables, oldVariable.getValue(), operationAfter, (Set)splitMap.get(split));
                if (this.existsConflictingExtractVariableRefactoring(refactoring) || this.existsConflictingParameterRenameInOperationDiff(refactoring)) continue;
                this.variableSplits.add(refactoring);
                continue;
            }
            CandidateSplitVariableRefactoring candidate = new CandidateSplitVariableRefactoring(split.getBefore(), split.getSplitVariables(), this.operation1, this.operation2, (Set)splitMap.get(split));
            this.candidateAttributeSplits.add(candidate);
        }
    }

    private void processVariableReplacementWithMethodInvocation(VariableReplacementWithMethodInvocation variableReplacement, AbstractCodeMapping mapping, Map<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction direction) {
        String expression = variableReplacement.getInvokedOperation().getExpression();
        if (expression != null && variableReplacement.getDirection().equals((Object)direction)) {
            if (variableInvocationExpressionMap.containsKey(expression)) {
                Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>> map = variableInvocationExpressionMap.get(expression);
                if (map.containsKey(variableReplacement)) {
                    if (mapping != null) {
                        map.get(variableReplacement).add(mapping);
                    }
                } else {
                    LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                    if (mapping != null) {
                        mappings.add(mapping);
                    }
                    map.put(variableReplacement, mappings);
                }
            } else {
                LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                if (mapping != null) {
                    mappings.add(mapping);
                }
                LinkedHashMap<VariableReplacementWithMethodInvocation, LinkedHashSet<AbstractCodeMapping>> map = new LinkedHashMap<VariableReplacementWithMethodInvocation, LinkedHashSet<AbstractCodeMapping>>();
                map.put(variableReplacement, mappings);
                variableInvocationExpressionMap.put(expression, map);
            }
        }
    }

    private void findVariableMerges() {
        Object merge;
        Object mergedVariables;
        LinkedHashSet mappings;
        Map map;
        LinkedHashMap mergeMap = new LinkedHashMap();
        LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap = new LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>>();
        LinkedHashMap variableInvocationVariableMap = new LinkedHashMap();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                LinkedHashSet<AbstractCodeMapping> mappings2;
                if (replacement instanceof MergeVariableReplacement) {
                    MergeVariableReplacement merge2 = (MergeVariableReplacement)replacement;
                    if (mergeMap.containsKey(merge2)) {
                        ((Set)mergeMap.get(merge2)).add(mapping);
                        continue;
                    }
                    mappings2 = new LinkedHashSet<AbstractCodeMapping>();
                    mappings2.add(mapping);
                    mergeMap.put(merge2, mappings2);
                    continue;
                }
                if (replacement instanceof VariableReplacementWithMethodInvocation) {
                    VariableReplacementWithMethodInvocation variableReplacement = (VariableReplacementWithMethodInvocation)replacement;
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                for (StatementObject statement : this.nonMappedLeavesT2) {
                    OperationInvocation invocation;
                    AbstractExpression initializer;
                    VariableDeclaration variableDeclaration = statement.getVariableDeclaration(replacement.getBefore());
                    if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
                    VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(replacement.getBefore(), initializer.getString(), invocation, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                }
                if (!replacement.getAfter().contains(".")) continue;
                String compositeVariable = replacement.getAfter().substring(0, replacement.getAfter().indexOf("."));
                if (variableInvocationVariableMap.containsKey(compositeVariable)) {
                    Map map2 = (Map)variableInvocationVariableMap.get(compositeVariable);
                    if (map2.containsKey(replacement)) {
                        ((Set)map2.get(replacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings3 = new LinkedHashSet<AbstractCodeMapping>();
                    mappings3.add(mapping);
                    map2.put(replacement, mappings3);
                    continue;
                }
                mappings2 = new LinkedHashSet();
                mappings2.add(mapping);
                LinkedHashMap<Replacement, LinkedHashSet<AbstractCodeMapping>> map3 = new LinkedHashMap<Replacement, LinkedHashSet<AbstractCodeMapping>>();
                map3.put(replacement, mappings2);
                variableInvocationVariableMap.put(compositeVariable, map3);
            }
        }
        for (StatementObject statement : this.nonMappedLeavesT2) {
            for (String parameterName : this.operation1.getParameterNameList()) {
                OperationInvocation invocation;
                Object initializer;
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(parameterName);
                if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = ((AbstractCodeFragment)initializer).invocationCoveringEntireFragment()) == null) continue;
                VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(parameterName, ((AbstractExpression)initializer).getString(), invocation, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                this.processVariableReplacementWithMethodInvocation(variableReplacement, null, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
            }
        }
        for (String key : variableInvocationExpressionMap.keySet()) {
            map = (Map)variableInvocationExpressionMap.get(key);
            mappings = new LinkedHashSet();
            mergedVariables = new LinkedHashSet<String>();
            for (Replacement replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getBefore()))) continue;
                mergedVariables.add(replacement.getBefore());
                mappings.addAll((Collection)map.get(replacement));
            }
            if (mergedVariables.size() <= 0) continue;
            merge = new MergeVariableReplacement((Set<String>)mergedVariables, key);
            mergeMap.put(merge, mappings);
        }
        for (String key : variableInvocationVariableMap.keySet()) {
            map = (Map)variableInvocationVariableMap.get(key);
            mappings = new LinkedHashSet();
            mergedVariables = new LinkedHashSet();
            for (Replacement replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getBefore()))) continue;
                mergedVariables.add(replacement.getBefore());
                mappings.addAll((Collection)map.get(replacement));
            }
            if (mergedVariables.size() <= 0) continue;
            merge = new MergeVariableReplacement((Set<String>)mergedVariables, key);
            mergeMap.put(merge, mappings);
        }
        for (MergeVariableReplacement merge3 : mergeMap.keySet()) {
            LinkedHashSet<VariableDeclaration> mergedVariables2 = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<UMLOperation> mergedVariableOperations = new LinkedHashSet<UMLOperation>();
            for (String variableName : merge3.getMergedVariables()) {
                AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> declaration = this.getVariableDeclaration1(merge3, variableName);
                if (declaration == null) continue;
                mergedVariables2.add(declaration.getKey());
                mergedVariableOperations.add(declaration.getValue());
            }
            AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> newVariable = this.getVariableDeclaration2(merge3);
            if (mergedVariables2.size() > 1 && mergedVariables2.size() == merge3.getMergedVariables().size() && newVariable != null) {
                UMLOperation operationBefore = (UMLOperation)mergedVariableOperations.iterator().next();
                MergeVariableRefactoring refactoring = new MergeVariableRefactoring(mergedVariables2, newVariable.getKey(), operationBefore, newVariable.getValue(), (Set)mergeMap.get(merge3));
                if (this.existsConflictingInlineVariableRefactoring(refactoring) || this.existsConflictingParameterRenameInOperationDiff(refactoring)) continue;
                this.variableMerges.add(refactoring);
                continue;
            }
            CandidateMergeVariableRefactoring candidate = new CandidateMergeVariableRefactoring(merge3.getMergedVariables(), merge3.getAfter(), this.operation1, this.operation2, (Set)mergeMap.get(merge3));
            this.candidateAttributeMerges.add(candidate);
        }
    }

    private void findConsistentVariableRenames() {
        AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v2;
        AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v1;
        Map<Replacement, Set<AbstractCodeMapping>> variableDeclarationReplacementOccurrenceMap = this.getVariableDeclarationReplacementOccurrenceMap();
        Set<Replacement> allConsistentVariableDeclarationRenames = this.allConsistentRenames(variableDeclarationReplacementOccurrenceMap);
        for (Replacement replacement : allConsistentVariableDeclarationRenames) {
            RenameVariableRefactoring ref;
            VariableDeclarationReplacement vdReplacement = (VariableDeclarationReplacement)replacement;
            Set<AbstractCodeMapping> set = variableDeclarationReplacementOccurrenceMap.get(vdReplacement);
            if (set.size() > 1 && this.consistencyCheck(vdReplacement.getVariableDeclaration1(), vdReplacement.getVariableDeclaration2(), set) || set.size() == 1 && this.replacementInLocalVariableDeclaration(vdReplacement.getVariableNameReplacement(), set)) {
                ref = new RenameVariableRefactoring(vdReplacement.getVariableDeclaration1(), vdReplacement.getVariableDeclaration2(), vdReplacement.getOperation1(), vdReplacement.getOperation2(), set);
                if (this.existsConflictingExtractVariableRefactoring(ref) || this.existsConflictingMergeVariableRefactoring(ref) || this.existsConflictingSplitVariableRefactoring(ref)) continue;
                this.variableRenames.add(ref);
                if (vdReplacement.getVariableDeclaration1().getType().equals(vdReplacement.getVariableDeclaration2().getType()) && vdReplacement.getVariableDeclaration1().getType().equalsQualified(vdReplacement.getVariableDeclaration2().getType())) continue;
                ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(vdReplacement.getVariableDeclaration1(), vdReplacement.getVariableDeclaration2(), vdReplacement.getOperation1(), vdReplacement.getOperation2(), set);
                refactoring.addRelatedRefactoring(ref);
                this.refactorings.add(refactoring);
                continue;
            }
            ref = new RenameVariableRefactoring(vdReplacement.getVariableDeclaration1(), vdReplacement.getVariableDeclaration2(), vdReplacement.getOperation1(), vdReplacement.getOperation2(), set);
            this.refactorings.remove(ref);
        }
        Map<Replacement, Set<AbstractCodeMapping>> replacementOccurrenceMap = this.getReplacementOccurrenceMap(Replacement.ReplacementType.VARIABLE_NAME);
        Set<Replacement> allConsistentRenames = this.allConsistentRenames(replacementOccurrenceMap);
        LinkedHashMap<Replacement, Set<AbstractCodeMapping>> finalConsistentRenames = new LinkedHashMap<Replacement, Set<AbstractCodeMapping>>();
        for (Replacement replacement : allConsistentRenames) {
            v1 = this.getVariableDeclaration1(replacement);
            v2 = this.getVariableDeclaration2(replacement);
            Set<AbstractCodeMapping> set = replacementOccurrenceMap.get(replacement);
            if (set.size() > 1 && v1 != null && v2 != null && this.consistencyCheck(v1.getKey(), v2.getKey(), set) || this.potentialParameterRename(replacement, set) || v1 == null || v2 == null || set.size() == 1 && this.replacementInLocalVariableDeclaration(replacement, set)) {
                finalConsistentRenames.put(replacement, set);
            }
            if (v1 == null || v1.getKey().isParameter() || v2 == null || !v2.getKey().isParameter() || !this.consistencyCheck(v1.getKey(), v2.getKey(), set) || this.operation1.getParameterNameList().contains(v2.getKey().getVariableName())) continue;
            finalConsistentRenames.put(replacement, set);
        }
        for (Replacement replacement : finalConsistentRenames.keySet()) {
            v1 = this.getVariableDeclaration1(replacement);
            v2 = this.getVariableDeclaration2(replacement);
            if (v1 != null && v2 != null) {
                Set variableReferences = (Set)finalConsistentRenames.get(replacement);
                RenameVariableRefactoring ref = new RenameVariableRefactoring(v1.getKey(), v2.getKey(), v1.getValue(), v2.getValue(), variableReferences);
                if (this.existsConflictingExtractVariableRefactoring(ref) || this.existsConflictingMergeVariableRefactoring(ref) || this.existsConflictingSplitVariableRefactoring(ref) || v1.getKey().isVarargsParameter() != v2.getKey().isVarargsParameter()) continue;
                this.variableRenames.add(ref);
                if (v1.getKey().getType().equals(v2.getKey().getType()) && v1.getKey().getType().equalsQualified(v2.getKey().getType())) continue;
                ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(v1.getKey(), v2.getKey(), v1.getValue(), v2.getValue(), variableReferences);
                refactoring.addRelatedRefactoring(ref);
                this.refactorings.add(refactoring);
                continue;
            }
            if (PrefixSuffixUtils.normalize(replacement.getBefore()).equals(PrefixSuffixUtils.normalize(replacement.getAfter())) || this.operation1.getAllVariables().contains(replacement.getAfter()) && !VariableReplacementAnalysis.cyclicRename(finalConsistentRenames.keySet(), replacement) || this.operation2.getAllVariables().contains(replacement.getBefore()) && !VariableReplacementAnalysis.cyclicRename(finalConsistentRenames.keySet(), replacement) || this.fieldAssignmentWithPreviouslyExistingParameter(replacementOccurrenceMap.get(replacement)) || this.fieldAssignmentToPreviouslyExistingAttribute(replacementOccurrenceMap.get(replacement))) continue;
            CandidateAttributeRefactoring candidate = new CandidateAttributeRefactoring(replacement.getBefore(), replacement.getAfter(), this.operation1, this.operation2, replacementOccurrenceMap.get(replacement));
            if (v1 != null) {
                candidate.setOriginalVariableDeclaration(v1.getKey());
            }
            if (v2 != null) {
                candidate.setRenamedVariableDeclaration(v2.getKey());
            }
            this.candidateAttributeRenames.add(candidate);
        }
    }

    private boolean fieldAssignmentToPreviouslyExistingAttribute(Set<AbstractCodeMapping> mappings) {
        if (mappings.size() == 1) {
            AbstractCodeMapping mapping = mappings.iterator().next();
            String fragment1 = mapping.getFragment1().getString();
            String fragment2 = mapping.getFragment2().getString();
            if (fragment1.contains("=") && fragment1.endsWith("\n") && fragment2.contains("=") && fragment2.endsWith("\n")) {
                String value1 = fragment1.substring(fragment1.indexOf("=") + 1, fragment1.lastIndexOf("\n"));
                String value2 = fragment2.substring(fragment2.indexOf("=") + 1, fragment2.lastIndexOf("\n"));
                String attribute1 = PrefixSuffixUtils.normalize(fragment1.substring(0, fragment1.indexOf("=")));
                String attribute2 = PrefixSuffixUtils.normalize(fragment2.substring(0, fragment2.indexOf("=")));
                if (value1.equals(attribute1) && this.classDiff.getOriginalClass().containsAttributeWithName(attribute1) && this.classDiff.getNextClass().containsAttributeWithName(attribute1)) {
                    return true;
                }
                return value2.equals(attribute2) && this.classDiff.getOriginalClass().containsAttributeWithName(attribute2) && this.classDiff.getNextClass().containsAttributeWithName(attribute2);
            }
        }
        return false;
    }

    private boolean fieldAssignmentWithPreviouslyExistingParameter(Set<AbstractCodeMapping> mappings) {
        if (mappings.size() == 1) {
            AbstractCodeMapping mapping = mappings.iterator().next();
            String fragment1 = mapping.getFragment1().getString();
            String fragment2 = mapping.getFragment2().getString();
            if (fragment1.contains("=") && fragment1.endsWith("\n") && fragment2.contains("=") && fragment2.endsWith("\n")) {
                String value1 = fragment1.substring(fragment1.indexOf("=") + 1, fragment1.lastIndexOf("\n"));
                String value2 = fragment2.substring(fragment2.indexOf("=") + 1, fragment2.lastIndexOf("\n"));
                if (this.operation1.getParameterNameList().contains(value1) && this.operation2.getParameterNameList().contains(value1) && this.operationDiff != null) {
                    for (UMLParameter addedParameter : this.operationDiff.getAddedParameters()) {
                        if (!addedParameter.getName().equals(value2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private Map<Replacement, Set<AbstractCodeMapping>> getReplacementOccurrenceMap(Replacement.ReplacementType type) {
        LinkedHashMap<Replacement, Set<AbstractCodeMapping>> map = new LinkedHashMap<Replacement, Set<AbstractCodeMapping>>();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (replacement.getType().equals((Object)type) && !VariableReplacementAnalysis.returnVariableMapping(mapping, replacement) && !mapping.containsReplacement(Replacement.ReplacementType.CONCATENATION) && !this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) && this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) {
                    if (map.containsKey(replacement)) {
                        ((Set)map.get(replacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(replacement, list);
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS)) {
                    String before = replacement.getBefore().contains("[") ? replacement.getBefore().substring(0, replacement.getBefore().indexOf("[")) : replacement.getBefore();
                    String after = replacement.getAfter().contains("[") ? replacement.getAfter().substring(0, replacement.getAfter().indexOf("[")) : replacement.getAfter();
                    Replacement variableReplacement = new Replacement(before, after, Replacement.ReplacementType.VARIABLE_NAME);
                    if (VariableReplacementAnalysis.returnVariableMapping(mapping, replacement) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) continue;
                    if (map.containsKey(variableReplacement)) {
                        ((Set)map.get(variableReplacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(variableReplacement, list);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.METHOD_INVOCATION)) continue;
                MethodInvocationReplacement methodInvocationReplacement = (MethodInvocationReplacement)replacement;
                OperationInvocation invocation1 = methodInvocationReplacement.getInvokedOperationBefore();
                OperationInvocation invocation2 = methodInvocationReplacement.getInvokedOperationAfter();
                if (!invocation1.getName().equals(invocation2.getName()) || invocation1.getArguments().size() != invocation2.getArguments().size()) continue;
                for (int i = 0; i < invocation1.getArguments().size(); ++i) {
                    String argument1 = invocation1.getArguments().get(i);
                    String argument2 = invocation2.getArguments().get(i);
                    if (!argument1.contains("[") && !argument2.contains("[")) continue;
                    String before = argument1.contains("[") ? argument1.substring(0, argument1.indexOf("[")) : argument1;
                    String after = argument2.contains("[") ? argument2.substring(0, argument2.indexOf("[")) : argument2;
                    Replacement variableReplacement = new Replacement(before, after, Replacement.ReplacementType.VARIABLE_NAME);
                    if (VariableReplacementAnalysis.returnVariableMapping(mapping, replacement) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) continue;
                    if (map.containsKey(variableReplacement)) {
                        ((Set)map.get(variableReplacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(variableReplacement, list);
                }
            }
        }
        return map;
    }

    private Map<Replacement, Set<AbstractCodeMapping>> getVariableDeclarationReplacementOccurrenceMap() {
        LinkedHashMap<Replacement, Set<AbstractCodeMapping>> map = new LinkedHashMap<Replacement, Set<AbstractCodeMapping>>();
        for (AbstractCodeMapping abstractCodeMapping : this.mappings) {
            for (Replacement replacement : abstractCodeMapping.getReplacements()) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || VariableReplacementAnalysis.returnVariableMapping(abstractCodeMapping, replacement) || abstractCodeMapping.containsReplacement(Replacement.ReplacementType.CONCATENATION) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(abstractCodeMapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(abstractCodeMapping, replacement)) continue;
                AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v1 = this.getVariableDeclaration1(replacement, abstractCodeMapping);
                AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> v2 = this.getVariableDeclaration2(replacement, abstractCodeMapping);
                if (v1 == null || v2 == null) continue;
                VariableDeclarationReplacement r = new VariableDeclarationReplacement((VariableDeclaration)v1.getKey(), v2.getKey(), (UMLOperation)v1.getValue(), v2.getValue());
                if (map.containsKey(r)) {
                    ((Set)map.get(r)).add(abstractCodeMapping);
                    continue;
                }
                LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                list.add(abstractCodeMapping);
                map.put(r, list);
            }
        }
        if (this.operationDiff != null) {
            ArrayList<UMLParameterDiff> allParameterDiffs = new ArrayList<UMLParameterDiff>();
            for (UMLParameterDiff uMLParameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!uMLParameterDiff.isNameChanged()) continue;
                allParameterDiffs.add(uMLParameterDiff);
            }
            ArrayList<UMLParameterDiff> arrayList = new ArrayList<UMLParameterDiff>();
            block3: for (UMLParameterDiff uMLParameterDiff : allParameterDiffs) {
                for (Replacement replacement : map.keySet()) {
                    VariableDeclarationReplacement vdR = (VariableDeclarationReplacement)replacement;
                    if (!uMLParameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) || !uMLParameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) continue;
                    arrayList.add(uMLParameterDiff);
                    continue block3;
                }
            }
            LinkedHashSet<VariableDeclarationReplacement> linkedHashSet = new LinkedHashSet<VariableDeclarationReplacement>();
            for (UMLParameterDiff parameterDiff : arrayList) {
                for (Replacement replacement : map.keySet()) {
                    VariableDeclarationReplacement vdR = (VariableDeclarationReplacement)replacement;
                    if (parameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) && !parameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) {
                        linkedHashSet.add(vdR);
                        continue;
                    }
                    if (parameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) || !parameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) continue;
                    linkedHashSet.add(vdR);
                }
            }
            for (VariableDeclarationReplacement key : linkedHashSet) {
                map.remove(key);
            }
        }
        return map;
    }

    private boolean containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(Set<Replacement> replacements) {
        for (Replacement replacement : replacements) {
            MethodInvocationReplacement r;
            if (!(replacement instanceof MethodInvocationReplacement) || !(r = (MethodInvocationReplacement)replacement).differentExpressionNameAndArguments()) continue;
            return true;
        }
        return false;
    }

    private boolean replacementNotInsideMethodSignatureOfAnonymousClass(AbstractCodeMapping mapping, Replacement replacement) {
        return true;
    }

    private Set<Replacement> allConsistentRenames(Map<Replacement, Set<AbstractCodeMapping>> replacementOccurrenceMap) {
        Set<Replacement> renames = replacementOccurrenceMap.keySet();
        LinkedHashSet<Replacement> allConsistentRenames = new LinkedHashSet<Replacement>();
        LinkedHashSet allInconsistentRenames = new LinkedHashSet();
        ConsistentReplacementDetector.updateRenames(allConsistentRenames, allInconsistentRenames, renames);
        allConsistentRenames.removeAll(allInconsistentRenames);
        return allConsistentRenames;
    }

    private boolean replacementInLocalVariableDeclaration(Replacement replacement, Set<AbstractCodeMapping> set) {
        VariableDeclaration v1 = null;
        for (AbstractCodeMapping abstractCodeMapping : this.mappings) {
            if (!abstractCodeMapping.getReplacements().contains(replacement)) continue;
            v1 = abstractCodeMapping.getFragment1().searchVariableDeclaration(replacement.getBefore());
            break;
        }
        VariableDeclaration v2 = null;
        for (AbstractCodeMapping mapping : this.mappings) {
            if (!mapping.getReplacements().contains(replacement)) continue;
            v2 = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter());
            break;
        }
        LinkedHashSet<VariableDeclaration> linkedHashSet = new LinkedHashSet<VariableDeclaration>();
        LinkedHashSet<VariableDeclaration> allVariableDeclarations2 = new LinkedHashSet<VariableDeclaration>();
        for (AbstractCodeMapping referenceMapping : set) {
            AbstractCodeFragment statement1 = referenceMapping.getFragment1();
            AbstractCodeFragment statement2 = referenceMapping.getFragment2();
            if (statement1 instanceof CompositeStatementObject && statement2 instanceof CompositeStatementObject && statement1.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT)) {
                CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
                CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
                linkedHashSet.addAll(comp1.getAllVariableDeclarations());
                allVariableDeclarations2.addAll(comp2.getAllVariableDeclarations());
                continue;
            }
            linkedHashSet.addAll(this.operation1.getAllVariableDeclarations());
            allVariableDeclarations2.addAll(this.operation2.getAllVariableDeclarations());
            break;
        }
        return v1 != null && v2 != null && v1.equalVariableDeclarationType(v2) && !VariableReplacementAnalysis.containsVariableDeclarationWithName(linkedHashSet, v2.getVariableName()) && (!VariableReplacementAnalysis.containsVariableDeclarationWithName(allVariableDeclarations2, v1.getVariableName()) || this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) != null) && this.consistencyCheck(v1, v2, set);
    }

    private boolean consistencyCheck(VariableDeclaration v1, VariableDeclaration v2, Set<AbstractCodeMapping> set) {
        return !this.variableAppearsInExtractedMethod(v1, v2) && !this.variableAppearsInTheInitializerOfTheOtherVariable(v1, v2) && !this.inconsistentVariableMapping(v1, v2, set);
    }

    private boolean variableAppearsInTheInitializerOfTheOtherVariable(VariableDeclaration v1, VariableDeclaration v2) {
        return false;
    }

    private boolean inconsistentVariableMapping(VariableDeclaration v1, VariableDeclaration v2, Set<AbstractCodeMapping> set) {
        if (v1 != null && v2 != null) {
            for (AbstractCodeMapping mapping : this.mappings) {
                List<VariableDeclaration> variableDeclarations1 = mapping.getFragment1().getVariableDeclarations();
                List<VariableDeclaration> variableDeclarations2 = mapping.getFragment2().getVariableDeclarations();
                if (variableDeclarations1.contains(v1)) {
                    if (variableDeclarations2.size() > 0 && !variableDeclarations2.contains(v2)) {
                        return true;
                    }
                    if (variableDeclarations2.size() == 0 && v1.getInitializer() != null && mapping.getFragment2().getString().startsWith(v1.getInitializer().getString())) {
                        return true;
                    }
                }
                if (variableDeclarations2.contains(v2)) {
                    if (variableDeclarations1.size() > 0 && !variableDeclarations1.contains(v1)) {
                        return true;
                    }
                    if (variableDeclarations1.size() == 0 && v2.getInitializer() != null && mapping.getFragment1().getString().startsWith(v2.getInitializer().getString())) {
                        return true;
                    }
                }
                if (!mapping.isExact()) continue;
                for (AbstractCodeMapping referenceMapping : set) {
                    AbstractCodeFragment statement1 = referenceMapping.getFragment1();
                    AbstractCodeFragment statement2 = referenceMapping.getFragment2();
                    boolean containsMapping = true;
                    if (statement1 instanceof CompositeStatementObject && statement2 instanceof CompositeStatementObject && statement1.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT)) {
                        CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
                        CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
                        boolean bl = containsMapping = comp1.contains(mapping.getFragment1()) && comp2.contains(mapping.getFragment2());
                    }
                    if (!containsMapping || !VariableReplacementAnalysis.bothFragmentsUseVariable(v1, mapping) && !VariableReplacementAnalysis.bothFragmentsUseVariable(v2, mapping) || this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration1(Replacement replacement) {
        VariableDeclaration vd;
        for (AbstractCodeMapping mapping : this.mappings) {
            if (!mapping.getReplacements().contains(replacement) || (vd = mapping.getFragment1().searchVariableDeclaration(replacement.getBefore())) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, mapping.getOperation1());
        }
        for (UMLParameter parameter : this.operation1.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(replacement.getBefore())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation1);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(replacement.getBefore())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration1(MergeVariableReplacement replacement, String variableName) {
        VariableDeclaration vd;
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd2;
            LinkedHashSet<String> foundMergedVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getMergedVariables().contains(r.getBefore())) continue;
                foundMergedVariables.add(r.getBefore());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundMergedVariables.equals(replacement.getMergedVariables()) || (vd2 = mapping.getFragment1().searchVariableDeclaration(variableName)) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd2, mapping.getOperation1());
        }
        for (UMLParameter parameter : this.operation1.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(variableName)) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation1);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(variableName)) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration2(Replacement replacement) {
        VariableDeclaration vd;
        for (AbstractCodeMapping mapping : this.mappings) {
            if (!mapping.getReplacements().contains(replacement) || (vd = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter())) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, mapping.getOperation2());
        }
        for (UMLParameter parameter : this.operation2.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration2(SplitVariableReplacement replacement, String variableName) {
        VariableDeclaration vd;
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd2;
            if (!mapping.getReplacements().contains(replacement)) continue;
            LinkedHashSet<String> foundSplitVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getSplitVariables().contains(r.getAfter())) continue;
                foundSplitVariables.add(r.getAfter());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundSplitVariables.equals(replacement.getSplitVariables()) || (vd2 = mapping.getFragment2().searchVariableDeclaration(variableName)) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd2, mapping.getOperation2());
        }
        for (UMLParameter parameter : this.operation2.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(variableName)) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(variableName)) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration2(MergeVariableReplacement replacement) {
        VariableDeclaration vd;
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd2;
            LinkedHashSet<String> foundMergedVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getMergedVariables().contains(r.getBefore())) continue;
                foundMergedVariables.add(r.getBefore());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundMergedVariables.equals(replacement.getMergedVariables()) || (vd2 = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter())) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd2, mapping.getOperation2());
        }
        for (UMLParameter parameter : this.operation2.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private boolean variableAppearsInExtractedMethod(VariableDeclaration v1, VariableDeclaration v2) {
        if (v1 != null) {
            for (UMLOperationBodyMapper mapper : this.childMappers) {
                for (AbstractCodeMapping mapping : mapper.getMappings()) {
                    if (!mapping.getFragment1().getVariableDeclarations().contains(v1)) continue;
                    if (v2 != null && v2.getInitializer() != null) {
                        UMLOperation extractedMethod = mapper.getOperation2();
                        Map<String, List<OperationInvocation>> methodInvocationMap = v2.getInitializer().getMethodInvocationMap();
                        for (String key : methodInvocationMap.keySet()) {
                            for (OperationInvocation invocation : methodInvocationMap.get(key)) {
                                if (invocation.matchesOperation(extractedMethod, this.operation2.variableTypeMap(), null)) {
                                    return false;
                                }
                                List<String> initializerVariables = v2.getInitializer().getVariables();
                                for (String variable : initializerVariables) {
                                    for (VariableDeclaration declaration : this.operation2.getAllVariableDeclarations()) {
                                        if (!declaration.getVariableName().equals(variable) || declaration.getInitializer() == null) continue;
                                        Map<String, List<OperationInvocation>> methodInvocationMap2 = declaration.getInitializer().getMethodInvocationMap();
                                        for (String key2 : methodInvocationMap2.keySet()) {
                                            for (OperationInvocation invocation2 : methodInvocationMap2.get(key2)) {
                                                if (!invocation2.matchesOperation(extractedMethod, this.operation2.variableTypeMap(), null)) continue;
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    return true;
                }
                for (StatementObject nonMappedStatement : mapper.getNonMappedLeavesT2()) {
                    VariableDeclaration variableDeclaration2 = nonMappedStatement.getVariableDeclaration(v1.getVariableName());
                    if (variableDeclaration2 == null || !variableDeclaration2.getType().equals(v1.getType())) continue;
                    for (AbstractCodeMapping mapping : mapper.getMappings()) {
                        if (!mapping.getFragment2().equals(nonMappedStatement.getParent()) || !(mapping.getFragment1() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject composite1 = (CompositeStatementObject)mapping.getFragment1();
                        List<StatementObject> leaves1 = composite1.getLeaves();
                        for (StatementObject leaf1 : leaves1) {
                            VariableDeclaration variableDeclaration1 = leaf1.getVariableDeclaration(variableDeclaration2.getVariableName());
                            if (variableDeclaration1 == null) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean existsConflictingParameterRenameInOperationDiff(MergeVariableRefactoring ref) {
        if (this.operationDiff != null) {
            for (UMLParameterDiff parameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!ref.getMergedVariables().contains(parameterDiff.getRemovedParameter().getVariableDeclaration()) || !ref.getNewVariable().equals(parameterDiff.getAddedParameter().getVariableDeclaration())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsConflictingParameterRenameInOperationDiff(SplitVariableRefactoring ref) {
        if (this.operationDiff != null) {
            for (UMLParameterDiff parameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!ref.getSplitVariables().contains(parameterDiff.getAddedParameter().getVariableDeclaration()) || !ref.getOldVariable().equals(parameterDiff.getRemovedParameter().getVariableDeclaration())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsConflictingExtractVariableRefactoring(RenameVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            ExtractVariableRefactoring extractVariableRef;
            if (!(refactoring instanceof ExtractVariableRefactoring) || !(extractVariableRef = (ExtractVariableRefactoring)refactoring).getVariableDeclaration().equals(ref.getRenamedVariable()) || !extractVariableRef.getOperationAfter().equals(ref.getOperationAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingExtractVariableRefactoring(SplitVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            if (!(refactoring instanceof ExtractVariableRefactoring)) continue;
            ExtractVariableRefactoring extractVariableRef = (ExtractVariableRefactoring)refactoring;
            if (!ref.getSplitVariables().contains(extractVariableRef.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingInlineVariableRefactoring(MergeVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            if (!(refactoring instanceof InlineVariableRefactoring)) continue;
            InlineVariableRefactoring inlineVariableRef = (InlineVariableRefactoring)refactoring;
            if (!ref.getMergedVariables().contains(inlineVariableRef.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingMergeVariableRefactoring(RenameVariableRefactoring ref) {
        for (MergeVariableRefactoring merge : this.variableMerges) {
            if (!merge.getOperationBefore().equals(ref.getOperationBefore()) || !merge.getOperationAfter().equals(ref.getOperationAfter()) || !merge.getMergedVariables().contains(ref.getOriginalVariable()) || !merge.getNewVariable().equals(ref.getRenamedVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingSplitVariableRefactoring(RenameVariableRefactoring ref) {
        for (SplitVariableRefactoring split : this.variableSplits) {
            if (!split.getOperationBefore().equals(ref.getOperationBefore()) || !split.getOperationAfter().equals(ref.getOperationAfter()) || !split.getSplitVariables().contains(ref.getRenamedVariable()) || !split.getOldVariable().equals(ref.getOriginalVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean potentialParameterRename(Replacement replacement, Set<AbstractCodeMapping> set) {
        int index2;
        int index1 = this.operation1.getParameterNameList().indexOf(replacement.getBefore());
        if (index1 == -1 && this.callSiteOperation != null) {
            index1 = this.callSiteOperation.getParameterNameList().indexOf(replacement.getBefore());
        }
        if ((index2 = this.operation2.getParameterNameList().indexOf(replacement.getAfter())) == -1 && this.callSiteOperation != null) {
            index2 = this.callSiteOperation.getParameterNameList().indexOf(replacement.getAfter());
        }
        if (this.fieldAssignmentToPreviouslyExistingAttribute(set)) {
            return false;
        }
        if (this.fieldAssignmentWithPreviouslyExistingParameter(set)) {
            return false;
        }
        return index1 >= 0 && index1 == index2;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration1(Replacement replacement, AbstractCodeMapping mapping) {
        VariableDeclaration vd;
        VariableDeclaration vd2;
        if (mapping.getReplacements().contains(replacement) && (vd2 = mapping.getFragment1().searchVariableDeclaration(replacement.getBefore())) != null) {
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd2, mapping.getOperation1());
        }
        for (UMLParameter parameter : this.operation1.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(replacement.getBefore())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation1);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(replacement.getBefore())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation> getVariableDeclaration2(Replacement replacement, AbstractCodeMapping mapping) {
        VariableDeclaration vd;
        VariableDeclaration vd2;
        if (mapping.getReplacements().contains(replacement) && (vd2 = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter())) != null) {
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd2, mapping.getOperation2());
        }
        for (UMLParameter parameter : this.operation2.getParameters()) {
            vd = parameter.getVariableDeclaration();
            if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (UMLParameter parameter : this.callSiteOperation.getParameters()) {
                vd = parameter.getVariableDeclaration();
                if (vd == null || !vd.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, UMLOperation>(vd, this.callSiteOperation);
            }
        }
        return null;
    }
}

