/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition.replacement;

import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class VariableDeclarationReplacement
extends Replacement {
    private final VariableDeclaration v1;
    private final VariableDeclaration v2;
    private final UMLOperation operation1;
    private final UMLOperation operation2;

    public VariableDeclarationReplacement(VariableDeclaration v1, VariableDeclaration v2, UMLOperation operation1, UMLOperation operation2) {
        super(v1.toString() + " | " + v1.getScope(), v2.toString() + " | " + v2.getScope(), Replacement.ReplacementType.VARIABLE_DECLARATION);
        this.v1 = v1;
        this.v2 = v2;
        this.operation1 = operation1;
        this.operation2 = operation2;
    }

    public VariableDeclaration getVariableDeclaration1() {
        return this.v1;
    }

    public VariableDeclaration getVariableDeclaration2() {
        return this.v2;
    }

    public UMLOperation getOperation1() {
        return this.operation1;
    }

    public UMLOperation getOperation2() {
        return this.operation2;
    }

    public Replacement getVariableNameReplacement() {
        return new Replacement(this.v1.getVariableName(), this.v2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.v1 == null ? 0 : this.v1.hashCode());
        result = 31 * result + (this.v2 == null ? 0 : this.v2.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableDeclarationReplacement other = (VariableDeclarationReplacement)obj;
        if (this.v1 == null ? other.v1 != null : !this.v1.equals(other.v1)) {
            return false;
        }
        if (this.v2 == null) {
            return other.v2 == null;
        }
        return this.v2.equals(other.v2);
    }
}

