/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.core.util.BufferRecyclers;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;

public class CodeRange {
    private final String filePath;
    private final int startLine;
    private final int endLine;
    private final int startColumn;
    private final int endColumn;
    private final CodeElementType codeElementType;
    private String description;
    private String codeElement;

    public CodeRange(String filePath, int startLine, int endLine, int startColumn, int endColumn, CodeElementType codeElementType) {
        this.filePath = filePath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.codeElementType = codeElementType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public CodeElementType getCodeElementType() {
        return this.codeElementType;
    }

    public String getDescription() {
        return this.description;
    }

    public CodeRange setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCodeElement() {
        return this.codeElement;
    }

    public CodeRange setCodeElement(String codeElement) {
        this.codeElement = codeElement;
        return this;
    }

    public boolean subsumes(CodeRange other) {
        return this.filePath.equals(other.filePath) && this.startLine <= other.startLine && this.endLine >= other.endLine;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        this.encodeStringProperty(sb, "filePath", this.filePath, false);
        this.encodeIntProperty(sb, "startLine", this.startLine, false);
        this.encodeIntProperty(sb, "endLine", this.endLine, false);
        this.encodeIntProperty(sb, "startColumn", this.startColumn, false);
        this.encodeIntProperty(sb, "endColumn", this.endColumn, false);
        this.encodeStringProperty(sb, "codeElementType", this.codeElementType.name(), false);
        this.encodeStringProperty(sb, "description", this.description, false);
        this.encodeStringProperty(sb, "codeElement", this.escapeQuotes(this.codeElement), true);
        sb.append("}");
        return sb.toString();
    }

    private String escapeQuotes(String s) {
        if (s != null) {
            StringBuilder sb = new StringBuilder();
            JsonStringEncoder encoder = BufferRecyclers.getJsonStringEncoder();
            encoder.quoteAsString((CharSequence)s, sb);
            return sb.toString();
        }
        return s;
    }

    private void encodeStringProperty(StringBuilder sb, String propertyName, String value, boolean last) {
        if (value != null) {
            sb.append("\t").append("\t").append("\"").append(propertyName).append("\"").append(": ").append("\"").append(value).append("\"");
        } else {
            sb.append("\t").append("\t").append("\"").append(propertyName).append("\"").append(": ").append(value);
        }
        this.insertNewLine(sb, last);
    }

    private void encodeIntProperty(StringBuilder sb, String propertyName, int value, boolean last) {
        sb.append("\t").append("\t").append("\"").append(propertyName).append("\"").append(": ").append(value);
        this.insertNewLine(sb, last);
    }

    private void insertNewLine(StringBuilder sb, boolean last) {
        if (last) {
            sb.append("\n");
        } else {
            sb.append(",").append("\n");
        }
    }

    public static CodeRange computeRange(Set<AbstractCodeFragment> codeFragments) {
        String filePath = null;
        int minStartLine = 0;
        int maxEndLine = 0;
        int startColumn = 0;
        int endColumn = 0;
        for (AbstractCodeFragment fragment : codeFragments) {
            LocationInfo info = fragment.getLocationInfo();
            filePath = info.getFilePath();
            if (minStartLine == 0 || info.getStartLine() < minStartLine) {
                minStartLine = info.getStartLine();
                startColumn = info.getStartColumn();
            }
            if (info.getEndLine() <= maxEndLine) continue;
            maxEndLine = info.getEndLine();
            endColumn = info.getEndColumn();
        }
        return new CodeRange(filePath, minStartLine, maxEndLine, startColumn, endColumn, CodeElementType.LIST_OF_STATEMENTS);
    }
}

