/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableReferenceExtractor;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationListDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeAttributeTypeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;

public class UMLAttributeDiff {
    private final UMLAttribute removedAttribute;
    private final UMLAttribute addedAttribute;
    private boolean visibilityChanged;
    private boolean typeChanged;
    private boolean qualifiedTypeChanged;
    private boolean renamed;
    private boolean staticChanged;
    private boolean finalChanged;
    private final List<UMLOperationBodyMapper> operationBodyMapperList;
    private final UMLAnnotationListDiff annotationListDiff;

    public UMLAttributeDiff(UMLAttribute removedAttribute, UMLAttribute addedAttribute, List<UMLOperationBodyMapper> operationBodyMapperList) {
        this.removedAttribute = removedAttribute;
        this.addedAttribute = addedAttribute;
        this.operationBodyMapperList = operationBodyMapperList;
        this.visibilityChanged = false;
        this.typeChanged = false;
        this.renamed = false;
        this.staticChanged = false;
        this.finalChanged = false;
        if (!removedAttribute.getName().equals(addedAttribute.getName())) {
            this.renamed = true;
        }
        if (!removedAttribute.getVisibility().equals(addedAttribute.getVisibility())) {
            this.visibilityChanged = true;
        }
        if (!removedAttribute.getType().equals(addedAttribute.getType())) {
            this.typeChanged = true;
        } else if (!removedAttribute.getType().equalsQualified(addedAttribute.getType())) {
            this.qualifiedTypeChanged = true;
        }
        if (removedAttribute.isStatic() != addedAttribute.isStatic()) {
            this.staticChanged = true;
        }
        if (removedAttribute.isFinal() != addedAttribute.isFinal()) {
            this.finalChanged = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedAttribute.getAnnotations(), addedAttribute.getAnnotations());
    }

    public UMLAttribute getRemovedAttribute() {
        return this.removedAttribute;
    }

    public UMLAttribute getAddedAttribute() {
        return this.addedAttribute;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isVisibilityChanged() {
        return this.visibilityChanged;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isQualifiedTypeChanged() {
        return this.qualifiedTypeChanged;
    }

    public boolean isEmpty() {
        return !this.visibilityChanged && !this.typeChanged && !this.renamed && !this.qualifiedTypeChanged && this.annotationListDiff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedAttribute).append("\n");
        }
        if (this.renamed) {
            sb.append("\t").append("renamed from " + this.removedAttribute.getName() + " to " + this.addedAttribute.getName()).append("\n");
        }
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from " + this.removedAttribute.getVisibility() + " to " + this.addedAttribute.getVisibility()).append("\n");
        }
        if (this.typeChanged || this.qualifiedTypeChanged) {
            sb.append("\t").append("type changed from " + this.removedAttribute.getType() + " to " + this.addedAttribute.getType()).append("\n");
        }
        if (this.staticChanged) {
            sb.append("\t").append("modifier changed from " + (this.removedAttribute.isStatic() ? "static" : "non-static") + " to " + (this.addedAttribute.isStatic() ? "static" : "non-static")).append("\n");
        }
        if (this.finalChanged) {
            sb.append("\t").append("modifier changed from " + (this.removedAttribute.isFinal() ? "final" : "non-final") + " to " + (this.addedAttribute.isFinal() ? "final" : "non-final")).append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffList()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    private Set<Refactoring> getAnnotationRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        for (UMLAnnotation uMLAnnotation : this.annotationListDiff.getAddedAnnotations()) {
        }
        return refactorings;
    }

    public Set<Refactoring> getRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        if (this.changeTypeCondition()) {
            ChangeAttributeTypeRefactoring ref = new ChangeAttributeTypeRefactoring(this.removedAttribute, this.addedAttribute, VariableReferenceExtractor.findReferences(this.removedAttribute.getVariableDeclaration(), this.addedAttribute.getVariableDeclaration(), this.operationBodyMapperList));
            refactorings.add(ref);
        }
        refactorings.addAll(this.getAnnotationRefactorings());
        return refactorings;
    }

    public Set<Refactoring> getRefactorings(Set<CandidateAttributeRefactoring> set) {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        RenameAttributeRefactoring rename = null;
        if (this.isRenamed()) {
            rename = new RenameAttributeRefactoring(this.removedAttribute, this.addedAttribute, set);
            refactorings.add(rename);
        }
        if (this.changeTypeCondition()) {
            ChangeAttributeTypeRefactoring ref = new ChangeAttributeTypeRefactoring(this.removedAttribute, this.addedAttribute, VariableReferenceExtractor.findReferences(this.removedAttribute.getVariableDeclaration(), this.addedAttribute.getVariableDeclaration(), this.operationBodyMapperList));
            refactorings.add(ref);
            if (rename != null) {
                ref.addRelatedRefactoring(rename);
            }
        }
        refactorings.addAll(this.getAnnotationRefactorings());
        return refactorings;
    }

    private boolean changeTypeCondition() {
        return (this.isTypeChanged() || this.isQualifiedTypeChanged()) && !this.enumConstantsDeclaredInTheSameEnumDeclarationType();
    }

    private boolean enumConstantsDeclaredInTheSameEnumDeclarationType() {
        VariableDeclaration removedVariableDeclaration = this.removedAttribute.getVariableDeclaration();
        VariableDeclaration addedVariableDeclaration = this.addedAttribute.getVariableDeclaration();
        return removedVariableDeclaration.isEnumConstant() && addedVariableDeclaration.isEnumConstant() && removedVariableDeclaration.getType().equals(addedVariableDeclaration.getType());
    }
}

