/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class UMLClassDiff
extends UMLClassBaseDiff {
    private final String className;

    public UMLClassDiff(UMLClass originalClass, UMLClass nextClass, UMLModelDiff modelDiff) {
        super(originalClass, nextClass, modelDiff);
        this.className = originalClass.getQualifiedName();
    }

    private void reportAddedOperation(UMLOperation umlOperation) {
        this.addedOperations.add(umlOperation);
    }

    private void reportRemovedOperation(UMLOperation umlOperation) {
        this.removedOperations.add(umlOperation);
    }

    private void reportAddedAttribute(UMLAttribute umlAttribute) {
        this.addedAttributes.add(umlAttribute);
    }

    private void reportRemovedAttribute(UMLAttribute umlAttribute) {
        this.removedAttributes.add(umlAttribute);
    }

    @Override
    protected void processAttributes() {
        UMLAttribute matchingAttribute;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            matchingAttribute = this.nextClass.containsAttribute(attribute);
            if (matchingAttribute != null) continue;
            this.reportRemovedAttribute(attribute);
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            matchingAttribute = this.originalClass.containsAttribute(attribute);
            if (matchingAttribute != null) continue;
            this.reportAddedAttribute(attribute);
        }
    }

    @Override
    protected void processOperations() {
        for (UMLOperation operation : this.originalClass.getOperations()) {
            if (this.nextClass.getOperations().contains(operation)) continue;
            this.reportRemovedOperation(operation);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            if (this.originalClass.getOperations().contains(operation)) continue;
            this.reportAddedOperation(operation);
        }
    }

    @Override
    protected void processAnonymousClasses() {
    }

    @Override
    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
        block0: for (UMLOperation originalOperation : this.originalClass.getOperations()) {
            for (UMLOperation nextOperation : this.nextClass.getOperations()) {
                UMLOperation operation1;
                List<UMLOperationBodyMapper> mappers;
                if (!originalOperation.equalsQualified(nextOperation)) continue;
                if (this.getModelDiff() != null && (mappers = this.getModelDiff().findMappersWithMatchingSignature2(nextOperation)).size() > 0 && !(operation1 = mappers.get(0).getOperation1()).equalSignature(originalOperation) && this.getModelDiff().commonlyImplementedOperations(operation1, nextOperation, this)) {
                    if (this.removedOperations.contains(originalOperation)) continue block0;
                    this.removedOperations.add(originalOperation);
                    continue block0;
                }
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(originalOperation, nextOperation, this);
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(originalOperation, nextOperation, operationBodyMapper.getMappings());
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                this.addOperationBodyMapper(operationBodyMapper);
            }
        }
        for (UMLOperation operation : this.originalClass.getOperations()) {
            if (this.containsMapperForOperation(operation) || !this.nextClass.getOperations().contains(operation) || this.removedOperations.contains(operation)) continue;
            int index = this.nextClass.getOperations().indexOf(operation);
            int lastIndex = this.nextClass.getOperations().lastIndexOf(operation);
            int finalIndex = index;
            if (index != lastIndex && operation.getReturnParameter() != null) {
                double d1 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextClass.getOperations().get(index).getReturnParameter().getType());
                double d2 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextClass.getOperations().get(lastIndex).getReturnParameter().getType());
                if (d2 < d1) {
                    finalIndex = lastIndex;
                }
            }
            UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(operation, this.nextClass.getOperations().get(finalIndex), this);
            UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(operation, this.nextClass.getOperations().get(finalIndex), operationBodyMapper.getMappings());
            this.refactorings.addAll(operationSignatureDiff.getRefactorings());
            this.addOperationBodyMapper(operationBodyMapper);
        }
        ArrayList<UMLOperation> removedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperation> addedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperation addedOperation : this.addedOperations) {
                UMLOperationDiff operationSignatureDiff;
                UMLOperationBodyMapper operationBodyMapper;
                if (removedOperation.equalsIgnoringVisibility(addedOperation)) {
                    operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, this);
                    operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, operationBodyMapper.getMappings());
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    this.addOperationBodyMapper(operationBodyMapper);
                    removedOperationsToBeRemoved.add(removedOperation);
                    addedOperationsToBeRemoved.add(addedOperation);
                    continue;
                }
                if (!removedOperation.equalsIgnoringNameCase(addedOperation)) continue;
                operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, this);
                operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, operationBodyMapper.getMappings());
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring(operationBodyMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(operationBodyMapper);
                removedOperationsToBeRemoved.add(removedOperation);
                addedOperationsToBeRemoved.add(addedOperation);
            }
        }
        this.removedOperations.removeAll(removedOperationsToBeRemoved);
        this.addedOperations.removeAll(addedOperationsToBeRemoved);
    }

    @Override
    protected void checkForAttributeChanges() {
        block0: for (UMLAttribute removedAttribute : this.removedAttributes) {
            for (UMLAttribute addedAttribute : this.addedAttributes) {
                if (!removedAttribute.getName().equals(addedAttribute.getName())) continue;
                continue block0;
            }
        }
    }

    private boolean containsMapperForOperation(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (!mapper.getOperation1().equalsQualified(operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(String className) {
        return this.className.equals(className);
    }

    @Override
    public boolean matches(UMLType type) {
        return this.className.endsWith("." + type.getClassType());
    }
}

