/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.kotlinrminer.common.replacement.ConsistentReplacementDetector;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLFile;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class UMLFileDiff
implements Comparable<UMLFileDiff> {
    protected UMLFile originalFile;
    protected UMLFile nextFile;
    protected List<UMLOperation> addedOperations;
    protected List<UMLOperation> removedOperations;
    private final List<UMLOperationBodyMapper> operationBodyMapperList;
    private final List<UMLOperationDiff> operationDiffList;
    protected List<Refactoring> refactorings;
    private final UMLModelDiff modelDiff;
    private Set<MethodInvocationReplacement> consistentMethodInvocationRenames;

    public UMLFileDiff(UMLFile originalFile, UMLFile nextFile, UMLModelDiff modelDiff) {
        this.originalFile = originalFile;
        this.nextFile = nextFile;
        this.addedOperations = new ArrayList<UMLOperation>();
        this.removedOperations = new ArrayList<UMLOperation>();
        this.operationBodyMapperList = new ArrayList<UMLOperationBodyMapper>();
        this.operationDiffList = new ArrayList<UMLOperationDiff>();
        this.refactorings = new ArrayList<Refactoring>();
        this.modelDiff = modelDiff;
    }

    public void process() throws RefactoringMinerTimedOutException {
        this.processOperations();
        this.createBodyMappers();
        this.checkForOperationSignatureChanges();
    }

    protected void processOperations() {
        for (UMLOperation operation : this.originalFile.getOperations()) {
            if (this.nextFile.getOperations().contains(operation)) continue;
            this.reportRemovedOperation(operation);
        }
        for (UMLOperation operation : this.nextFile.getOperations()) {
            if (this.originalFile.getOperations().contains(operation)) continue;
            this.reportAddedOperation(operation);
        }
    }

    public boolean isEmpty() {
        return this.addedOperations.isEmpty() && this.removedOperations.isEmpty() && this.operationDiffList.isEmpty() && this.operationBodyMapperList.isEmpty();
    }

    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
        for (UMLOperation originalOperation : this.originalFile.getOperations()) {
            for (UMLOperation nextOperation : this.nextFile.getOperations()) {
                if (!originalOperation.equalsQualified(nextOperation)) continue;
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(this, originalOperation, nextOperation);
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(originalOperation, nextOperation, operationBodyMapper.getMappings());
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                this.addOperationBodyMapper(operationBodyMapper);
            }
        }
        for (UMLOperation operation : this.originalFile.getOperations()) {
            if (this.containsMapperForOperation(operation) || !this.nextFile.getOperations().contains(operation) || this.removedOperations.contains(operation)) continue;
            int index = this.nextFile.getOperations().indexOf(operation);
            int lastIndex = this.nextFile.getOperations().lastIndexOf(operation);
            int finalIndex = index;
            if (index != lastIndex && operation.getReturnParameter() != null) {
                double d1 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextFile.getOperations().get(index).getReturnParameter().getType());
                double d2 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextFile.getOperations().get(lastIndex).getReturnParameter().getType());
                if (d2 < d1) {
                    finalIndex = lastIndex;
                }
            }
            UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(this, operation, this.nextFile.getOperations().get(finalIndex));
            UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(operation, this.nextFile.getOperations().get(finalIndex), operationBodyMapper.getMappings());
            this.refactorings.addAll(operationSignatureDiff.getRefactorings());
            this.addOperationBodyMapper(operationBodyMapper);
        }
        ArrayList<UMLOperation> removedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperation> addedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperation addedOperation : this.addedOperations) {
                UMLOperationDiff operationSignatureDiff;
                UMLOperationBodyMapper operationBodyMapper;
                if (removedOperation.equalsIgnoringVisibility(addedOperation)) {
                    operationBodyMapper = new UMLOperationBodyMapper(this, removedOperation, addedOperation);
                    operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, operationBodyMapper.getMappings());
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    this.addOperationBodyMapper(operationBodyMapper);
                    removedOperationsToBeRemoved.add(removedOperation);
                    addedOperationsToBeRemoved.add(addedOperation);
                    continue;
                }
                if (!removedOperation.equalsIgnoringNameCase(addedOperation)) continue;
                operationBodyMapper = new UMLOperationBodyMapper(this, removedOperation, addedOperation);
                operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, operationBodyMapper.getMappings());
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring(operationBodyMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(operationBodyMapper);
                removedOperationsToBeRemoved.add(removedOperation);
                addedOperationsToBeRemoved.add(addedOperation);
            }
        }
        this.removedOperations.removeAll(removedOperationsToBeRemoved);
        this.addedOperations.removeAll(addedOperationsToBeRemoved);
    }

    private Set<MethodInvocationReplacement> findConsistentMethodInvocationRenames() {
        LinkedHashSet<MethodInvocationReplacement> allConsistentMethodInvocationRenames = new LinkedHashSet<MethodInvocationReplacement>();
        LinkedHashSet allInconsistentMethodInvocationRenames = new LinkedHashSet();
        for (UMLOperationBodyMapper bodyMapper : this.operationBodyMapperList) {
            Set<MethodInvocationReplacement> methodInvocationRenames = bodyMapper.getMethodInvocationRenameReplacements();
            ConsistentReplacementDetector.updateRenames(allConsistentMethodInvocationRenames, allInconsistentMethodInvocationRenames, methodInvocationRenames);
        }
        allConsistentMethodInvocationRenames.removeAll(allInconsistentMethodInvocationRenames);
        return allConsistentMethodInvocationRenames;
    }

    private void checkForOperationSignatureChanges() throws RefactoringMinerTimedOutException {
        this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
        if (this.removedOperations.size() <= this.addedOperations.size()) {
            for (UMLOperation removedOperation : this.removedOperations) {
                UMLOperationBodyMapper bestMapper;
                UMLOperation addedOperation2;
                TreeSet<UMLOperationBodyMapper> mapperSet = new TreeSet<UMLOperationBodyMapper>();
                for (UMLOperation addedOperation2 : this.addedOperations) {
                    int maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation2.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation2, maxDifferenceInPosition);
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation = bestMapper.getOperation1();
                addedOperation2 = bestMapper.getOperation2();
                this.addedOperations.remove(addedOperation2);
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation2, bestMapper.getMappings());
                this.operationDiffList.add(operationSignatureDiff);
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation2.getName()) || removedOperation.isConstructor() && addedOperation2.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring(bestMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(bestMapper);
            }
        } else {
            Iterator<UMLOperation> addedOperationIterator = this.addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation removedOperation;
                UMLOperation addedOperation = addedOperationIterator.next();
                TreeSet<UMLOperationBodyMapper> mapperSet = new TreeSet<UMLOperationBodyMapper>();
                Object bestMapper = this.removedOperations.iterator();
                while (bestMapper.hasNext()) {
                    removedOperation = bestMapper.next();
                    int maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation, maxDifferenceInPosition);
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation = ((UMLOperationBodyMapper)bestMapper).getOperation1();
                addedOperation = ((UMLOperationBodyMapper)bestMapper).getOperation2();
                this.removedOperations.remove(removedOperation);
                addedOperationIterator.remove();
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, ((UMLOperationBodyMapper)bestMapper).getMappings());
                this.operationDiffList.add(operationSignatureDiff);
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring((UMLOperationBodyMapper)bestMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper((UMLOperationBodyMapper)bestMapper);
            }
        }
    }

    private int computeAbsoluteDifferenceInPositionWithinClass(UMLOperation removedOperation, UMLOperation addedOperation) {
        int index1 = this.originalFile.getOperations().indexOf(removedOperation);
        int index2 = this.nextFile.getOperations().indexOf(addedOperation);
        return Math.abs(index1 - index2);
    }

    private boolean exactMappings(UMLOperationBodyMapper operationBodyMapper) {
        if (UMLFileDiff.allMappingsAreExactMatches(operationBodyMapper)) {
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                return true;
            }
            if (operationBodyMapper.nonMappedElementsT1() > 0 && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                UMLOperation addedOperation = operationBodyMapper.getOperation2();
                ArrayList<String> nonMappedLeavesT1 = new ArrayList<String>();
                for (StatementObject statementObject : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statementObject.countableStatement()) continue;
                    nonMappedLeavesT1.add(statementObject.getString());
                    for (String string : addedOperation.getParameterNameList()) {
                        if (statementObject.getVariableDeclaration(string) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                int nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation = 0;
                for (UMLOperation operation : this.addedOperations) {
                    if (operation.equals(addedOperation) || operation.getBody() == null) continue;
                    for (StatementObject statement : operation.getBody().getCompositeStatement().getLeaves()) {
                        if (!nonMappedLeavesT1.contains(statement.getString())) continue;
                        ++nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation;
                    }
                }
                return (countableStatements == parameterizedVariableDeclarationStatements || countableStatements == nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation + parameterizedVariableDeclarationStatements) && countableStatements > 0;
            }
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() > 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                UMLOperation removedOperation = operationBodyMapper.getOperation1();
                for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statement.countableStatement()) continue;
                    for (String parameterName : removedOperation.getParameterNameList()) {
                        if (statement.getVariableDeclaration(parameterName) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                return countableStatements == parameterizedVariableDeclarationStatements && countableStatements > 0;
            }
            if ((operationBodyMapper.nonMappedElementsT1() == 1 || operationBodyMapper.nonMappedElementsT2() == 1) && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                StatementObject statementUsingParameterAsInvoker1 = null;
                UMLOperation removedOperation = operationBodyMapper.getOperation1();
                block6: for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statement.countableStatement()) continue;
                    for (String string : removedOperation.getParameterNameList()) {
                        OperationInvocation invocation = statement.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker1 = statement;
                        continue block6;
                    }
                }
                StatementObject statementUsingParameterAsInvoker2 = null;
                UMLOperation addedOperation = operationBodyMapper.getOperation2();
                block8: for (StatementObject statementObject : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statementObject.countableStatement()) continue;
                    for (String string : addedOperation.getParameterNameList()) {
                        OperationInvocation invocation = statementObject.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker2 = statementObject;
                        continue block8;
                    }
                }
                if (statementUsingParameterAsInvoker1 != null && statementUsingParameterAsInvoker2 != null) {
                    for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
                        if (!(abstractCodeMapping.getFragment1() instanceof CompositeStatementObject) || !(abstractCodeMapping.getFragment2() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject parent1 = (CompositeStatementObject)abstractCodeMapping.getFragment1();
                        CompositeStatementObject compositeStatementObject = (CompositeStatementObject)abstractCodeMapping.getFragment2();
                        if (!parent1.getLeaves().contains(statementUsingParameterAsInvoker1) || !compositeStatementObject.getLeaves().contains(statementUsingParameterAsInvoker2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        return mappings > nonMappedElementsT1 && mappings > nonMappedElementsT2 || nonMappedElementsT1 == 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) || mappings == 1 && nonMappedElementsT1 + nonMappedElementsT2 == 1 && operationBodyMapper.getOperation1().getName().equals(operationBodyMapper.getOperation2().getName());
    }

    private boolean mappedElementsMoreThanNonMappedT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(this.addedOperations);
        int nonMappedElementsT2WithoutThoseCallingAddedOperation = nonMappedElementsT2 - nonMappedElementsT2CallingAddedOperation;
        return mappings > nonMappedElementsT2 || mappings >= nonMappedElementsT2WithoutThoseCallingAddedOperation && nonMappedElementsT2CallingAddedOperation >= nonMappedElementsT2WithoutThoseCallingAddedOperation;
    }

    private boolean mappedElementsMoreThanNonMappedT1(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT1CallingRemovedOperation = operationBodyMapper.nonMappedElementsT1CallingRemovedOperation(this.removedOperations);
        int nonMappedElementsT1WithoutThoseCallingRemovedOperation = nonMappedElementsT1 - nonMappedElementsT1CallingRemovedOperation;
        return mappings > nonMappedElementsT1 || mappings >= nonMappedElementsT1WithoutThoseCallingRemovedOperation && nonMappedElementsT1CallingRemovedOperation >= nonMappedElementsT1WithoutThoseCallingRemovedOperation;
    }

    private boolean operationsBeforeAndAfterMatch(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLOperation operationBefore1 = null;
        UMLOperation operationAfter1 = null;
        List<UMLOperation> originalClassOperations = this.originalFile.getOperations();
        for (int i = 0; i < originalClassOperations.size(); ++i) {
            UMLOperation current = originalClassOperations.get(i);
            if (!current.equals(removedOperation)) continue;
            if (i > 0) {
                operationBefore1 = originalClassOperations.get(i - 1);
            }
            if (i >= originalClassOperations.size() - 1) continue;
            operationAfter1 = originalClassOperations.get(i + 1);
        }
        UMLOperation operationBefore2 = null;
        UMLOperation operationAfter2 = null;
        List<UMLOperation> nextClassOperations = this.nextFile.getOperations();
        for (int i = 0; i < nextClassOperations.size(); ++i) {
            UMLOperation current = nextClassOperations.get(i);
            if (!current.equals(addedOperation)) continue;
            if (i > 0) {
                operationBefore2 = nextClassOperations.get(i - 1);
            }
            if (i >= nextClassOperations.size() - 1) continue;
            operationAfter2 = nextClassOperations.get(i + 1);
        }
        boolean operationsBeforeMatch = false;
        if (operationBefore1 != null && operationBefore2 != null) {
            operationsBeforeMatch = operationBefore1.equalParameterTypes(operationBefore2) && operationBefore1.getName().equals(operationBefore2.getName());
        }
        boolean operationsAfterMatch = false;
        if (operationAfter1 != null && operationAfter2 != null) {
            operationsAfterMatch = operationAfter1.equalParameterTypes(operationAfter2) && operationAfter1.getName().equals(operationAfter2.getName());
        }
        return operationsBeforeMatch || operationsAfterMatch;
    }

    private boolean gettersWithDifferentReturnType(UMLOperation removedOperation, UMLOperation addedOperation) {
        return false;
    }

    private boolean compatibleSignatures(UMLOperation removedOperation, UMLOperation addedOperation, int absoluteDifferenceInPosition) {
        return addedOperation.compatibleSignature(removedOperation) || (absoluteDifferenceInPosition == 0 || this.operationsBeforeAndAfterMatch(removedOperation, addedOperation)) && !this.gettersWithDifferentReturnType(removedOperation, addedOperation) && (addedOperation.getParameterTypeList().equals(removedOperation.getParameterTypeList()) || addedOperation.normalizedNameDistance(removedOperation) <= 0.4);
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        int absoluteDifferenceInPosition;
        ArrayList<AbstractCodeMapping> totalMappings;
        UMLOperationBodyMapper operationBodyMapper;
        block5: {
            block3: {
                int mappings;
                block7: {
                    block6: {
                        block4: {
                            operationBodyMapper = new UMLOperationBodyMapper(this, removedOperation, addedOperation);
                            totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
                            mappings = operationBodyMapper.mappingsWithoutBlocks();
                            if (mappings <= 0) break block3;
                            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
                            if (!this.exactMappings(operationBodyMapper)) break block4;
                            mapperSet.add(operationBodyMapper);
                            break block5;
                        }
                        if (!this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) break block6;
                        mapperSet.add(operationBodyMapper);
                        break block5;
                    }
                    if (!this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.isPartOfMethodExtracted(removedOperation, addedOperation)) break block7;
                    mapperSet.add(operationBodyMapper);
                    break block5;
                }
                if (!this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.isPartOfMethodInlined(removedOperation, addedOperation)) break block5;
                mapperSet.add(operationBodyMapper);
                break block5;
            }
            for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames) {
                if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation)) continue;
                mapperSet.add(operationBodyMapper);
                break;
            }
        }
        if (totalMappings.size() > 0) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.singleUnmatchedStatementCallsAddedOperation(operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            }
        }
    }

    private UMLOperationBodyMapper findBestMapper(TreeSet<UMLOperationBodyMapper> mapperSet) {
        UMLOperation bestMapperOperation2;
        ArrayList<UMLOperationBodyMapper> mapperList = new ArrayList<UMLOperationBodyMapper>(mapperSet);
        UMLOperationBodyMapper bestMapper = mapperSet.first();
        UMLOperation bestMapperOperation1 = bestMapper.getOperation1();
        if (bestMapperOperation1.equalReturnParameter(bestMapperOperation2 = bestMapper.getOperation2()) && bestMapperOperation1.getName().equals(bestMapperOperation2.getName()) && bestMapperOperation1.commonParameterTypes(bestMapperOperation2).size() > 0) {
            return bestMapper;
        }
        boolean identicalBodyWithOperation1OfTheBestMapper = this.identicalBodyWithAnotherAddedMethod(bestMapper);
        boolean identicalBodyWithOperation2OfTheBestMapper = this.identicalBodyWithAnotherRemovedMethod(bestMapper);
        for (int i = 1; i < mapperList.size(); ++i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperList.get(i);
            UMLOperation operation2 = mapper.getOperation2();
            List<OperationInvocation> operationInvocations2 = operation2.getAllOperationInvocations();
            boolean anotherMapperCallsOperation2OfTheBestMapper = false;
            for (OperationInvocation invocation : operationInvocations2) {
                if (!invocation.matchesOperation(bestMapper.getOperation2(), operation2.variableTypeMap(), this.modelDiff) || invocation.matchesOperation(bestMapper.getOperation1(), operation2.variableTypeMap(), this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.removedOperations)) continue;
                anotherMapperCallsOperation2OfTheBestMapper = true;
                break;
            }
            UMLOperation operation1 = mapper.getOperation1();
            List<OperationInvocation> operationInvocations1 = operation1.getAllOperationInvocations();
            boolean anotherMapperCallsOperation1OfTheBestMapper = false;
            for (OperationInvocation invocation : operationInvocations1) {
                if (!invocation.matchesOperation(bestMapper.getOperation1(), operation1.variableTypeMap(), this.modelDiff) || invocation.matchesOperation(bestMapper.getOperation2(), operation1.variableTypeMap(), this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.addedOperations)) continue;
                anotherMapperCallsOperation1OfTheBestMapper = true;
                break;
            }
            boolean nextMapperMatchesConsistentRename = this.matchesConsistentMethodInvocationRename(mapper, this.consistentMethodInvocationRenames);
            boolean bestMapperMismatchesConsistentRename = this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames);
            if (bestMapperMismatchesConsistentRename && nextMapperMatchesConsistentRename) {
                bestMapper = mapper;
                break;
            }
            if (anotherMapperCallsOperation2OfTheBestMapper || anotherMapperCallsOperation1OfTheBestMapper) {
                bestMapper = mapper;
                break;
            }
            if (!identicalBodyWithOperation2OfTheBestMapper && !identicalBodyWithOperation1OfTheBestMapper) continue;
            bestMapper = mapper;
            break;
        }
        if (this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames)) {
            return null;
        }
        return bestMapper;
    }

    private boolean operationContainsMethodInvocationWithTheSameNameAndCommonArguments(OperationInvocation invocation, List<UMLOperation> operations) {
        for (UMLOperation operation : operations) {
            List<OperationInvocation> operationInvocations = operation.getAllOperationInvocations();
            for (OperationInvocation operationInvocation : operationInvocations) {
                LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(operationInvocation.getArguments());
                argumentIntersection.retainAll(invocation.getArguments());
                if (operationInvocation.getMethodName().equals(invocation.getMethodName()) && !argumentIntersection.isEmpty()) {
                    return true;
                }
                if (argumentIntersection.size() <= 0 || argumentIntersection.size() != invocation.getArguments().size()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean singleUnmatchedStatementCallsAddedOperation(UMLOperationBodyMapper operationBodyMapper) {
        StatementObject statementT2;
        OperationInvocation invocationT2;
        List<StatementObject> nonMappedLeavesT1 = operationBodyMapper.getNonMappedLeavesT1();
        List<StatementObject> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        if (nonMappedLeavesT1.size() == 1 && nonMappedLeavesT2.size() == 1 && (invocationT2 = (statementT2 = nonMappedLeavesT2.get(0)).invocationCoveringEntireFragment()) != null) {
            for (UMLOperation addedOperation : this.addedOperations) {
                StatementObject statementT1;
                OperationInvocation invocationT1;
                if (!invocationT2.matchesOperation(addedOperation, operationBodyMapper.getOperation2().variableTypeMap(), this.modelDiff) || (invocationT1 = (statementT1 = nonMappedLeavesT1.get(0)).invocationCoveringEntireFragment()) == null || !addedOperation.getAllOperationInvocations().contains(invocationT1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPartOfMethodExtracted(UMLOperation removedOperation, UMLOperation addedOperation) {
        List<OperationInvocation> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<OperationInvocation> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<OperationInvocation> intersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromRemovedOperation = new LinkedHashSet<OperationInvocation>(removedOperationInvocations).size() - intersection.size();
        LinkedHashSet<OperationInvocation> operationInvocationsInMethodsCalledByAddedOperation = new LinkedHashSet<OperationInvocation>();
        for (OperationInvocation addedOperationInvocation : addedOperationInvocations) {
            if (intersection.contains(addedOperationInvocation)) continue;
            for (UMLOperation operation : this.addedOperations) {
                if (operation.equals(addedOperation) || operation.getBody() == null || !addedOperationInvocation.matchesOperation(operation, addedOperation.variableTypeMap(), this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByAddedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<OperationInvocation> newIntersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByAddedOperation);
        LinkedHashSet<OperationInvocation> removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(intersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(newIntersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeIf(invocation -> invocation.getMethodName().startsWith("get"));
        int numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations = newIntersection.size();
        int numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations = numberOfInvocationsMissingFromRemovedOperation - numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations;
        return numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations || numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.size();
    }

    private boolean isPartOfMethodInlined(UMLOperation removedOperation, UMLOperation addedOperation) {
        List<OperationInvocation> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<OperationInvocation> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<OperationInvocation> intersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromAddedOperation = new LinkedHashSet<OperationInvocation>(addedOperationInvocations).size() - intersection.size();
        LinkedHashSet<OperationInvocation> operationInvocationsInMethodsCalledByRemovedOperation = new LinkedHashSet<OperationInvocation>();
        for (OperationInvocation removedOperationInvocation : removedOperationInvocations) {
            if (intersection.contains(removedOperationInvocation)) continue;
            for (UMLOperation operation : this.removedOperations) {
                if (operation.equals(removedOperation) || operation.getBody() == null || !removedOperationInvocation.matchesOperation(operation, removedOperation.variableTypeMap(), this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByRemovedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<OperationInvocation> newIntersection = new LinkedHashSet<OperationInvocation>(addedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByRemovedOperation);
        int numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations = newIntersection.size();
        int numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations = numberOfInvocationsMissingFromAddedOperation - numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations;
        return numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations > numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations;
    }

    public static boolean allMappingsAreExactMatches(UMLOperationBodyMapper operationBodyMapper) {
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int tryMappings = 0;
        int mappingsWithTypeReplacement = 0;
        for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
            if (mapping.getFragment1().getString().equals("try") && mapping.getFragment2().getString().equals("try")) {
                ++tryMappings;
            }
            if (!mapping.containsReplacement(Replacement.ReplacementType.TYPE)) continue;
            ++mappingsWithTypeReplacement;
        }
        if (mappings == operationBodyMapper.exactMatches() + tryMappings) {
            return true;
        }
        return mappings == operationBodyMapper.exactMatches() + tryMappings + mappingsWithTypeReplacement && mappings > mappingsWithTypeReplacement;
    }

    private boolean identicalBodyWithAnotherAddedMethod(UMLOperationBodyMapper mapper) {
        UMLOperation operation1 = mapper.getOperation1();
        List<String> stringRepresentation = operation1.stringRepresentation();
        if (stringRepresentation.size() > 2) {
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getOperation2().equals(addedOperation) || !addedOperation.stringRepresentation().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean identicalBodyWithAnotherRemovedMethod(UMLOperationBodyMapper mapper) {
        UMLOperation operation2 = mapper.getOperation2();
        List<String> stringRepresentation = operation2.stringRepresentation();
        if (stringRepresentation.size() > 2) {
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getOperation1().equals(removedOperation) || !removedOperation.stringRepresentation().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (!mapper.getOperation1().getName().equals(rename.getBefore()) || !mapper.getOperation2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean mismatchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (mapper.getOperation1().getName().equals(rename.getBefore()) && !mapper.getOperation2().getName().equals(rename.getAfter())) {
                return true;
            }
            if (mapper.getOperation1().getName().equals(rename.getBefore()) || !mapper.getOperation2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private void reportAddedOperation(UMLOperation umlOperation) {
        this.addedOperations.add(umlOperation);
    }

    private void reportRemovedOperation(UMLOperation umlOperation) {
        this.removedOperations.add(umlOperation);
    }

    private boolean containsMapperForOperation(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (!mapper.getOperation1().equalsQualified(operation)) continue;
            return true;
        }
        return false;
    }

    public List<UMLOperationBodyMapper> getOperationBodyMapperList() {
        return this.operationBodyMapperList;
    }

    public UMLModelDiff getModelDiff() {
        return this.modelDiff;
    }

    public void addOperationBodyMapper(UMLOperationBodyMapper operationBodyMapper) {
        this.operationBodyMapperList.add(operationBodyMapper);
    }

    @Override
    public int compareTo(@NotNull UMLFileDiff o) {
        if (o == null) {
            UMLFileDiff.$$$reportNull$$$0(0);
        }
        return this.originalFile.getFileName().compareTo(o.originalFile.getFileName());
    }

    public Collection<? extends Refactoring> getRefactorings() {
        return this.refactorings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/research/kotlinrminer/ide/diff/UMLFileDiff", "compareTo"));
    }
}

