/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableReferenceExtractor;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeVariableTypeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;

public class UMLParameterDiff {
    private final UMLParameter removedParameter;
    private final UMLParameter addedParameter;
    private boolean typeChanged;
    private boolean qualifiedTypeChanged;
    private boolean nameChanged;
    private final UMLOperation removedOperation;
    private final UMLOperation addedOperation;
    private final Set<AbstractCodeMapping> mappings;

    public UMLParameterDiff(UMLParameter removedParameter, UMLParameter addedParameter, UMLOperation removedOperation, UMLOperation addedOperation, Set<AbstractCodeMapping> mappings) {
        this.mappings = mappings;
        this.removedParameter = removedParameter;
        this.addedParameter = addedParameter;
        this.typeChanged = false;
        this.nameChanged = false;
        this.removedOperation = removedOperation;
        this.addedOperation = addedOperation;
        if (!removedParameter.getType().equals(addedParameter.getType())) {
            this.typeChanged = true;
        } else if (!removedParameter.getType().equalsQualified(addedParameter.getType())) {
            this.qualifiedTypeChanged = true;
        }
        if (!removedParameter.getName().equals(addedParameter.getName())) {
            this.nameChanged = true;
        }
    }

    public UMLParameter getRemovedParameter() {
        return this.removedParameter;
    }

    public UMLParameter getAddedParameter() {
        return this.addedParameter;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isQualifiedTypeChanged() {
        return this.qualifiedTypeChanged;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeChanged || this.nameChanged || this.qualifiedTypeChanged) {
            sb.append("\t\t").append("parameter ").append(this.removedParameter).append(":").append("\n");
        }
        if (this.typeChanged || this.qualifiedTypeChanged) {
            sb.append("\t\t").append("type changed from ").append(this.removedParameter.getType()).append(" to ").append(this.addedParameter.getType()).append("\n");
        }
        if (this.nameChanged) {
            sb.append("\t\t").append("name changed from ").append(this.removedParameter.getName()).append(" to ").append(this.addedParameter.getName()).append("\n");
        }
        return sb.toString();
    }

    public Set<Refactoring> getRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        VariableDeclaration originalVariable = this.getRemovedParameter().getVariableDeclaration();
        VariableDeclaration newVariable = this.getAddedParameter().getVariableDeclaration();
        Set<AbstractCodeMapping> references = VariableReferenceExtractor.findReferences(originalVariable, newVariable, this.mappings);
        RenameVariableRefactoring renameRefactoring = null;
        if (this.isNameChanged() && !this.inconsistentReplacement(originalVariable, newVariable)) {
            renameRefactoring = new RenameVariableRefactoring(originalVariable, newVariable, this.removedOperation, this.addedOperation, references);
            refactorings.add(renameRefactoring);
        }
        if ((this.isTypeChanged() || this.isQualifiedTypeChanged()) && !this.inconsistentReplacement(originalVariable, newVariable)) {
            ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(originalVariable, newVariable, this.removedOperation, this.addedOperation, references);
            if (renameRefactoring != null) {
                refactoring.addRelatedRefactoring(renameRefactoring);
            }
            refactorings.add(refactoring);
        }
        return refactorings;
    }

    private boolean inconsistentReplacement(VariableDeclaration originalVariable, VariableDeclaration newVariable) {
        if (this.removedOperation.isStatic() || this.addedOperation.isStatic()) {
            for (AbstractCodeMapping mapping : this.mappings) {
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                    if (replacement.getBefore().equals(originalVariable.getVariableName()) && !replacement.getAfter().equals(newVariable.getVariableName())) {
                        return true;
                    }
                    if (replacement.getBefore().equals(originalVariable.getVariableName()) || !replacement.getAfter().equals(newVariable.getVariableName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

