/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public class ExtractSuperClassRefactoring
implements Refactoring {
    private final UMLClass extractedClass;
    private final Set<UMLClass> subclassSet;

    public ExtractSuperClassRefactoring(UMLClass extractedClass, Set<UMLClass> subclassSet) {
        this.extractedClass = extractedClass;
        this.subclassSet = subclassSet;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.extractedClass + " from classes " + this.subclassSet;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.extractedClass.isInterface()) {
            return RefactoringType.EXTRACT_INTERFACE;
        }
        return RefactoringType.EXTRACT_SUPERCLASS;
    }

    public UMLClass getExtractedClass() {
        return this.extractedClass;
    }

    public Set<String> getSubclassSet() {
        LinkedHashSet<String> subclassSet = new LinkedHashSet<String>();
        for (UMLClass umlClass : this.subclassSet) {
            subclassSet.add(umlClass.getQualifiedName());
        }
        return subclassSet;
    }

    public Set<UMLClass> getUMLSubclassSet() {
        return new LinkedHashSet<UMLClass>(this.subclassSet);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLClass umlClass : this.subclassSet) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)umlClass.getLocationInfo().getFilePath(), (Object)umlClass.getQualifiedName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getExtractedClass().getLocationInfo().getFilePath(), (Object)this.getExtractedClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLClass subclass : this.subclassSet) {
            ranges.add(subclass.codeRange().setDescription("sub-type declaration").setCodeElement(subclass.getQualifiedName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.extractedClass.codeRange().setDescription("extracted super-type declaration").setCodeElement(this.extractedClass.getQualifiedName()));
        return ranges;
    }
}

