/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class InlineOperationRefactoring
implements Refactoring {
    private final UMLOperation inlinedOperation;
    private final UMLOperation targetOperationAfterInline;
    private final UMLOperation targetOperationBeforeInline;
    private final List<OperationInvocation> inlinedOperationInvocations;
    private final Set<Replacement> replacements;
    private final Set<AbstractCodeFragment> inlinedCodeFragmentsFromInlinedOperation;
    private final Set<AbstractCodeFragment> inlinedCodeFragmentsInTargetOperation;
    private final UMLOperationBodyMapper bodyMapper;

    public InlineOperationRefactoring(UMLOperationBodyMapper bodyMapper, UMLOperation targetOperationBeforeInline, List<OperationInvocation> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.inlinedOperation = bodyMapper.getOperation1();
        this.targetOperationAfterInline = bodyMapper.getOperation2();
        this.targetOperationBeforeInline = targetOperationBeforeInline;
        this.inlinedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.inlinedCodeFragmentsFromInlinedOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.inlinedCodeFragmentsInTargetOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.inlinedCodeFragmentsFromInlinedOperation.add(mapping.getFragment1());
            this.inlinedCodeFragmentsInTargetOperation.add(mapping.getFragment2());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(" ");
        sb.append(this.inlinedOperation);
        if (this.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION)) {
            sb.append(" inlined to ");
            sb.append(this.targetOperationAfterInline);
            sb.append(" in class ");
            sb.append(this.getClassName());
        } else if (this.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION)) {
            sb.append(" moved from class ");
            sb.append(this.inlinedOperation.getClassName());
            sb.append(" to class ");
            sb.append(this.getTargetOperationAfterInline().getClassName());
            sb.append(" & inlined to ");
            sb.append(this.getTargetOperationAfterInline());
        }
        return sb.toString();
    }

    private String getClassName() {
        return this.targetOperationAfterInline.getClassName();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getTargetOperationBeforeInline().getClassName().equals(this.getInlinedOperation().getClassName())) {
            return RefactoringType.MOVE_AND_INLINE_OPERATION;
        }
        return RefactoringType.INLINE_OPERATION;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getInlinedOperation() {
        return this.inlinedOperation;
    }

    public UMLOperation getTargetOperationAfterInline() {
        return this.targetOperationAfterInline;
    }

    public UMLOperation getTargetOperationBeforeInline() {
        return this.targetOperationBeforeInline;
    }

    public List<OperationInvocation> getInlinedOperationInvocations() {
        return this.inlinedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public Set<AbstractCodeFragment> getInlinedCodeFragments() {
        return this.inlinedCodeFragmentsInTargetOperation;
    }

    public CodeRange getTargetOperationCodeRangeBeforeInline() {
        return this.targetOperationBeforeInline.codeRange();
    }

    public CodeRange getTargetOperationCodeRangeAfterInline() {
        return this.targetOperationAfterInline.codeRange();
    }

    public CodeRange getInlinedOperationCodeRange() {
        return this.inlinedOperation.codeRange();
    }

    public CodeRange getInlinedCodeRangeFromInlinedOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsFromInlinedOperation);
    }

    public CodeRange getInlinedCodeRangeInTargetOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsInTargetOperation);
    }

    public Set<CodeRange> getInlinedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (OperationInvocation invocation : this.inlinedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getInlinedOperation().getLocationInfo().getFilePath(), (Object)this.getInlinedOperation().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getTargetOperationBeforeInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationBeforeInline().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getTargetOperationAfterInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationAfterInline().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getInlinedOperationCodeRange().setDescription("inlined method declaration").setCodeElement(this.inlinedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.inlinedCodeFragmentsFromInlinedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("inlined code from inlined method declaration"));
        }
        ranges.add(this.getTargetOperationCodeRangeBeforeInline().setDescription("target method declaration before inline").setCodeElement(this.targetOperationBeforeInline.toString()));
        for (OperationInvocation operationInvocation : this.inlinedOperationInvocations) {
            ranges.add(operationInvocation.codeRange().setDescription("inlined method invocation").setCodeElement(operationInvocation.actualString()));
        }
        for (StatementObject statementObject : this.bodyMapper.getNonMappedLeavesT1()) {
            ranges.add(statementObject.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT1()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getTargetOperationCodeRangeAfterInline().setDescription("target method declaration after inline").setCodeElement(this.targetOperationAfterInline.toString()));
        for (AbstractCodeFragment inlinedCodeFragment : this.inlinedCodeFragmentsInTargetOperation) {
            ranges.add(inlinedCodeFragment.codeRange().setDescription("inlined code in target method declaration"));
        }
        return ranges;
    }
}

