/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class MergeVariableRefactoring
implements Refactoring {
    private final Set<VariableDeclaration> mergedVariables;
    private final VariableDeclaration newVariable;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> variableReferences;

    public MergeVariableRefactoring(Set<VariableDeclaration> mergedVariables, VariableDeclaration newVariable, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> variableReferences) {
        this.mergedVariables = mergedVariables;
        this.newVariable = newVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
    }

    public Set<VariableDeclaration> getMergedVariables() {
        return this.mergedVariables;
    }

    public VariableDeclaration getNewVariable() {
        return this.newVariable;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getVariableReferences() {
        return this.variableReferences;
    }

    private boolean allVariablesAreParameters() {
        for (VariableDeclaration declaration : this.mergedVariables) {
            if (declaration.isParameter()) continue;
            return false;
        }
        return this.newVariable.isParameter();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.allVariablesAreParameters()) {
            return RefactoringType.MERGE_PARAMETER;
        }
        return RefactoringType.MERGE_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        return this.getName() + "\t" + this.mergedVariables + " to " + this.newVariable + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mergedVariables == null ? 0 : this.mergedVariables.hashCode());
        result = 31 * result + (this.newVariable == null ? 0 : this.newVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeVariableRefactoring other = (MergeVariableRefactoring)obj;
        if (this.mergedVariables == null ? other.mergedVariables != null : !this.mergedVariables.equals(other.mergedVariables)) {
            return false;
        }
        if (this.newVariable == null ? other.newVariable != null : !this.newVariable.equals(other.newVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null) {
            return other.operationBefore == null;
        }
        return this.operationBefore.equals(other.operationBefore);
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration mergedVariable : this.mergedVariables) {
            ranges.add(mergedVariable.codeRange().setDescription("merged variable declaration").setCodeElement(mergedVariable.toString()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newVariable.codeRange().setDescription("new variable declaration").setCodeElement(this.newVariable.toString()));
        return ranges;
    }
}

