/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;

public class PullUpAttributeRefactoring
extends MoveAttributeRefactoring {
    public PullUpAttributeRefactoring(UMLAttribute originalAttribute, UMLAttribute movedAttribute) {
        super(originalAttribute, movedAttribute);
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.getOriginalAttribute().toQualifiedString() + " from class " + this.getSourceClassName() + " to " + this.getMovedAttribute().toQualifiedString() + " from class " + this.getTargetClassName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.PULL_UP_ATTRIBUTE;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedAttribute.codeRange().setDescription("pulled up attribute declaration").setCodeElement(this.movedAttribute.toString()));
        return ranges;
    }
}

