/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;

public class RenameAttributeRefactoring
implements Refactoring {
    private final UMLAttribute originalAttribute;
    private final UMLAttribute renamedAttribute;
    private final Set<CandidateAttributeRefactoring> attributeRenames;
    private final String classNameBefore;
    private final String classNameAfter;

    public RenameAttributeRefactoring(UMLAttribute originalAttribute, UMLAttribute renamedAttribute, Set<CandidateAttributeRefactoring> attributeRenames) {
        this.originalAttribute = originalAttribute;
        this.renamedAttribute = renamedAttribute;
        this.classNameBefore = originalAttribute.getClassName();
        this.classNameAfter = renamedAttribute.getClassName();
        this.attributeRenames = attributeRenames;
    }

    public UMLAttribute getOriginalAttribute() {
        return this.originalAttribute;
    }

    public UMLAttribute getRenamedAttribute() {
        return this.renamedAttribute;
    }

    public Set<CandidateAttributeRefactoring> getAttributeRenames() {
        return this.attributeRenames;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.RENAME_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        return this.getName() + "\t" + this.originalAttribute.getVariableDeclaration() + " to " + this.renamedAttribute.getVariableDeclaration() + " in class " + this.classNameAfter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classNameAfter == null ? 0 : this.classNameAfter.hashCode());
        result = 31 * result + (this.classNameBefore == null ? 0 : this.classNameBefore.hashCode());
        result = 31 * result + (this.originalAttribute == null || this.originalAttribute.getVariableDeclaration() == null ? 0 : this.originalAttribute.getVariableDeclaration().hashCode());
        result = 31 * result + (this.renamedAttribute == null || this.renamedAttribute.getVariableDeclaration() == null ? 0 : this.renamedAttribute.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameAttributeRefactoring other = (RenameAttributeRefactoring)obj;
        if (this.classNameAfter == null ? other.classNameAfter != null : !this.classNameAfter.equals(other.classNameAfter)) {
            return false;
        }
        if (this.classNameBefore == null ? other.classNameBefore != null : !this.classNameBefore.equals(other.classNameBefore)) {
            return false;
        }
        if (this.originalAttribute == null ? other.originalAttribute != null : (this.originalAttribute.getVariableDeclaration() == null ? other.originalAttribute.getVariableDeclaration() != null : !this.originalAttribute.getVariableDeclaration().equals(other.originalAttribute.getVariableDeclaration()))) {
            return false;
        }
        if (this.renamedAttribute == null) {
            return other.renamedAttribute == null;
        }
        if (this.renamedAttribute.getVariableDeclaration() == null) {
            return other.renamedAttribute.getVariableDeclaration() == null;
        }
        return this.renamedAttribute.getVariableDeclaration().equals(other.renamedAttribute.getVariableDeclaration());
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRenamedAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalAttribute.getVariableDeclaration().codeRange().setDescription("original attribute declaration").setCodeElement(this.originalAttribute.getVariableDeclaration().toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedAttribute.getVariableDeclaration().codeRange().setDescription("renamed attribute declaration").setCodeElement(this.renamedAttribute.getVariableDeclaration().toString()));
        return ranges;
    }
}

