/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class RenameOperationRefactoring
implements Refactoring {
    private final UMLOperation originalOperation;
    private final UMLOperation renamedOperation;
    private final Set<Replacement> replacements;
    private UMLOperationBodyMapper bodyMapper;

    public RenameOperationRefactoring(UMLOperationBodyMapper bodyMapper) {
        this.bodyMapper = bodyMapper;
        this.originalOperation = bodyMapper.getOperation1();
        this.renamedOperation = bodyMapper.getOperation2();
        this.replacements = bodyMapper.getReplacements();
    }

    public RenameOperationRefactoring(UMLOperation originalOperation, UMLOperation renamedOperation) {
        this.originalOperation = originalOperation;
        this.renamedOperation = renamedOperation;
        this.replacements = new LinkedHashSet<Replacement>();
    }

    private static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.originalOperation + " renamed to " + this.renamedOperation + " in class " + this.getClassName();
    }

    private String getClassName() {
        String sourceClassName = this.originalOperation.getClassName();
        String targetClassName = this.renamedOperation.getClassName();
        boolean targetIsAnonymousInsideSource = false;
        if (targetClassName.startsWith(sourceClassName + ".")) {
            String targetClassNameSuffix = targetClassName.substring(sourceClassName.length() + 1);
            targetIsAnonymousInsideSource = RenameOperationRefactoring.isNumeric(targetClassNameSuffix);
        }
        return sourceClassName.equals(targetClassName) || targetIsAnonymousInsideSource ? sourceClassName : targetClassName;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.RENAME_METHOD;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getOriginalOperation() {
        return this.originalOperation;
    }

    public UMLOperation getRenamedOperation() {
        return this.renamedOperation;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public CodeRange getSourceOperationCodeRangeBeforeRename() {
        return this.originalOperation.codeRange();
    }

    public CodeRange getTargetOperationCodeRangeAfterRename() {
        return this.renamedOperation.codeRange();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalOperation().getLocationInfo().getFilePath(), (Object)this.getOriginalOperation().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRenamedOperation().getLocationInfo().getFilePath(), (Object)this.getRenamedOperation().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalOperation.codeRange().setDescription("original method declaration").setCodeElement(this.originalOperation.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedOperation.codeRange().setDescription("renamed method declaration").setCodeElement(this.renamedOperation.toString()));
        return ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.renamedOperation == null ? 0 : this.renamedOperation.hashCode());
        result = 31 * result + (this.renamedOperation == null ? 0 : this.renamedOperation.getLocationInfo().hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.getLocationInfo().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameOperationRefactoring other = (RenameOperationRefactoring)obj;
        if (this.renamedOperation == null) {
            if (other.renamedOperation != null) {
                return false;
            }
        } else {
            if (!this.renamedOperation.equals(other.renamedOperation)) {
                return false;
            }
            if (!this.renamedOperation.getLocationInfo().equals(other.renamedOperation.getLocationInfo())) {
                return false;
            }
        }
        if (this.originalOperation == null) {
            return other.originalOperation == null;
        }
        if (!this.originalOperation.equals(other.originalOperation)) {
            return false;
        }
        return this.originalOperation.getLocationInfo().equals(other.originalOperation.getLocationInfo());
    }
}

