/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.RenamePattern;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLCompanionObject;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public abstract class UMLAbstractClass {
    protected LocationInfo locationInfo;
    protected String packageName;
    protected String name;
    protected List<UMLOperation> operations = new ArrayList<UMLOperation>();
    protected List<UMLAttribute> attributes = new ArrayList<UMLAttribute>();
    protected List<UMLCompanionObject> companionObjects = new ArrayList<UMLCompanionObject>();

    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public void addOperation(UMLOperation operation) {
        this.operations.add(operation);
    }

    public void addAttribute(UMLAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void addCompanionObject(UMLCompanionObject operation) {
        this.companionObjects.add(operation);
    }

    public List<UMLOperation> getOperations() {
        return this.operations;
    }

    public List<UMLAttribute> getAttributes() {
        return this.attributes;
    }

    public List<UMLCompanionObject> getCompanionObjects() {
        return this.companionObjects;
    }

    public UMLOperation operationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.equalSignature(operation)) continue;
            return originalOperation;
        }
        return null;
    }

    public boolean containsOperationWithTheSameSignatureIgnoringChangedTypes(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            boolean operationEmptyBody;
            boolean originalOperationEmptyBody;
            if (!originalOperation.equalSignatureIgnoringChangedTypes(operation) || (originalOperationEmptyBody = originalOperation.getBody() == null || originalOperation.hasEmptyBody()) != (operationEmptyBody = operation.getBody() == null || operation.hasEmptyBody())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameName(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.getName().equals(operation.getName())) continue;
            return true;
        }
        return false;
    }

    public UMLAttribute attributeWithTheSameNameIgnoringChangedType(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.equalsIgnoringChangedType(attribute)) continue;
            return originalAttribute;
        }
        return null;
    }

    public boolean containsAttributeWithTheSameNameIgnoringChangedType(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.equalsIgnoringChangedType(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithTheSameName(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.getName().equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithName(String attributeName) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributesAndOperationsWithCommonNames(UMLAbstractClass umlClass) {
        LinkedHashSet<UMLOperation> commonOperations = new LinkedHashSet<UMLOperation>();
        int totalOperations = 0;
        for (UMLOperation operation : this.operations) {
            if (operation.isConstructor()) continue;
            ++totalOperations;
            if (!umlClass.containsOperationWithTheSameName(operation)) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            if (operation.isConstructor()) continue;
            ++totalOperations;
            if (!this.containsOperationWithTheSameName(operation)) continue;
            commonOperations.add(operation);
        }
        LinkedHashSet<UMLAttribute> commonAttributes = new LinkedHashSet<UMLAttribute>();
        int totalAttributes = 0;
        for (UMLAttribute attribute : this.attributes) {
            ++totalAttributes;
            if (!umlClass.containsAttributeWithTheSameName(attribute)) continue;
            commonAttributes.add(attribute);
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            ++totalAttributes;
            if (!this.containsAttributeWithTheSameName(attribute)) continue;
            commonAttributes.add(attribute);
        }
        if (this.isTestClass() && umlClass.isTestClass()) {
            return (double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) || commonOperations.containsAll(this.operations);
        }
        if (this.isSingleAbstractMethodInterface() && umlClass.isSingleAbstractMethodInterface()) {
            return commonOperations.size() == totalOperations;
        }
        return (double)commonOperations.size() >= Math.floor((double)totalOperations / 2.0) && (commonAttributes.size() > 2 || totalAttributes == 0) || (double)commonAttributes.size() >= Math.floor((double)totalAttributes / 2.0) && (commonOperations.size() > 2 || totalOperations == 0) || commonOperations.size() == totalOperations && commonOperations.size() > 2 && this.attributes.size() == umlClass.attributes.size() || commonOperations.size() == totalOperations && commonOperations.size() > 2 && totalAttributes == 1;
    }

    public boolean hasSameAttributesAndOperations(UMLAbstractClass umlClass) {
        if (this.attributes.size() != umlClass.attributes.size()) {
            return false;
        }
        if (this.operations.size() != umlClass.operations.size()) {
            return false;
        }
        for (UMLOperation operation : this.operations) {
            if (umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation)) continue;
            return false;
        }
        for (UMLOperation operation : umlClass.operations) {
            if (this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation)) continue;
            return false;
        }
        for (UMLAttribute attribute : this.attributes) {
            if (umlClass.containsAttributeWithTheSameNameIgnoringChangedType(attribute)) continue;
            return false;
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            if (this.containsAttributeWithTheSameNameIgnoringChangedType(attribute)) continue;
            return false;
        }
        return true;
    }

    public boolean isTestClass() {
        for (UMLOperation operation : this.operations) {
            if (!operation.hasTestAnnotation()) continue;
            return true;
        }
        return false;
    }

    public List<UMLAttribute> attributesOfType(String targetClass) {
        ArrayList<UMLAttribute> attributesOfType = new ArrayList<UMLAttribute>();
        for (UMLAttribute attribute : this.attributes) {
            if (!targetClass.endsWith("." + attribute.getType().getClassType()) && !targetClass.equals(attribute.getType().getClassType())) continue;
            attributesOfType.add(attribute);
        }
        return attributesOfType;
    }

    public boolean hasCommonAttributesAndOperations(UMLAbstractClass umlClass) {
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(this.name, umlClass.name);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(this.name, umlClass.name);
        RenamePattern pattern = null;
        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
            int endIndexS1;
            int beginIndexS1 = this.name.indexOf(commonPrefix) + commonPrefix.length();
            String diff1 = beginIndexS1 > (endIndexS1 = this.name.lastIndexOf(commonSuffix)) ? "" : this.name.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = umlClass.name.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = umlClass.name.lastIndexOf(commonSuffix);
            String diff2 = beginIndexS2 > endIndexS2 ? "" : umlClass.name.substring(beginIndexS2, endIndexS2);
            pattern = new RenamePattern(diff1, diff2);
        }
        LinkedHashSet<UMLOperation> commonOperations = new LinkedHashSet<UMLOperation>();
        int totalOperations = 0;
        for (UMLOperation operation : this.operations) {
            if (operation.isConstructor()) continue;
            ++totalOperations;
            if (!umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !umlClass.containsOperationWithTheSameRenamePattern(operation, pattern.reverse()))) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            if (operation.isConstructor()) continue;
            ++totalOperations;
            if (!this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !this.containsOperationWithTheSameRenamePattern(operation, pattern))) continue;
            commonOperations.add(operation);
        }
        LinkedHashSet<UMLAttribute> commonAttributes = new LinkedHashSet<UMLAttribute>();
        int totalAttributes = 0;
        for (UMLAttribute attribute : this.attributes) {
            ++totalAttributes;
            if (!umlClass.containsAttributeWithTheSameNameIgnoringChangedType(attribute) && (pattern == null || !umlClass.containsAttributeWithTheSameRenamePattern(attribute, pattern.reverse()))) continue;
            commonAttributes.add(attribute);
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            ++totalAttributes;
            if (!this.containsAttributeWithTheSameNameIgnoringChangedType(attribute) && (pattern == null || !this.containsAttributeWithTheSameRenamePattern(attribute, pattern))) continue;
            commonAttributes.add(attribute);
        }
        if (this.isTestClass() && umlClass.isTestClass()) {
            return (double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) || commonOperations.containsAll(this.operations);
        }
        if (this.isSingleAbstractMethodInterface() && umlClass.isSingleAbstractMethodInterface()) {
            return commonOperations.size() == totalOperations;
        }
        return (double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) && (commonAttributes.size() > 2 || totalAttributes == 0) || (double)commonOperations.size() > Math.floor((double)totalOperations / 3.0 * 2.0) && (commonAttributes.size() >= 2 || totalAttributes == 0) || (double)commonAttributes.size() > Math.floor((double)totalAttributes / 2.0) && (commonOperations.size() > 2 || totalOperations == 0) || commonOperations.size() == totalOperations && commonOperations.size() > 2 && this.attributes.size() == umlClass.attributes.size() || commonOperations.size() == totalOperations && commonOperations.size() > 2 && totalAttributes == 1;
    }

    public boolean containsAttributeWithTheSameRenamePattern(UMLAttribute attribute, RenamePattern pattern) {
        if (pattern == null) {
            return false;
        }
        for (UMLAttribute originalAttribute : this.attributes) {
            String originalAttributeNameAfterReplacement;
            String originalAttributeName = originalAttribute.getName();
            if (!originalAttributeName.contains(pattern.getBefore()) || !(originalAttributeNameAfterReplacement = originalAttributeName.replace(pattern.getBefore(), pattern.getAfter())).equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameRenamePattern(UMLOperation operation, RenamePattern pattern) {
        if (pattern == null) {
            return false;
        }
        for (UMLOperation originalOperation : this.operations) {
            String originalOperationNameAfterReplacement;
            String originalOperationName = originalOperation.getName();
            if (!originalOperationName.contains(pattern.getBefore()) || !(originalOperationNameAfterReplacement = originalOperationName.replace(pattern.getBefore(), pattern.getAfter())).equals(operation.getName())) continue;
            return true;
        }
        return false;
    }

    public UMLOperation operationWithTheSameSignatureIgnoringChangedTypes(UMLOperation operation) {
        ArrayList<UMLOperation> matchingOperations = new ArrayList<UMLOperation>();
        for (UMLOperation originalOperation : this.operations) {
            boolean operationEmptyBody;
            boolean originalOperationEmptyBody;
            boolean matchesOperation = this.isInterface() ? originalOperation.equalSignatureIgnoringChangedTypes(operation) : originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation);
            if (!matchesOperation || (originalOperationEmptyBody = originalOperation.getBody() == null || originalOperation.hasEmptyBody()) != (operationEmptyBody = operation.getBody() == null || operation.hasEmptyBody())) continue;
            matchingOperations.add(originalOperation);
        }
        if (matchingOperations.size() == 1) {
            return (UMLOperation)matchingOperations.get(0);
        }
        if (matchingOperations.size() > 1) {
            int minDistance = StringDistance.editDistance(((UMLOperation)matchingOperations.get(0)).toString(), operation.toString());
            UMLOperation matchingOperation = (UMLOperation)matchingOperations.get(0);
            for (int i = 1; i < matchingOperations.size(); ++i) {
                int distance = StringDistance.editDistance(((UMLOperation)matchingOperations.get(i)).toString(), operation.toString());
                if (distance >= minDistance) continue;
                minDistance = distance;
                matchingOperation = (UMLOperation)matchingOperations.get(i);
            }
            return matchingOperation;
        }
        return null;
    }

    public abstract boolean isSingleAbstractMethodInterface();

    public abstract boolean isInterface();

    public String getSourceFile() {
        return this.locationInfo.getFilePath();
    }

    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }
}

