/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;

public class UMLAnnotation
implements Serializable,
LocationInfoProvider {
    private final LocationInfo locationInfo;
    private final String typeName;
    private final Map<String, AbstractExpression> memberValuePairs = new LinkedHashMap<String, AbstractExpression>();
    private AbstractExpression value;

    public UMLAnnotation(KtFile cu, String filePath, KtAnnotation annotation) {
        this.typeName = annotation.getName();
        this.locationInfo = new LocationInfo(cu, filePath, (KtElement)annotation, CodeElementType.ANNOTATION);
        List ktAnnotationEntries = annotation.getEntries();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AbstractExpression getValue() {
        return this.value;
    }

    public Map<String, AbstractExpression> getMemberValuePairs() {
        return this.memberValuePairs;
    }

    public boolean isMarkerAnnotation() {
        return this.value == null && this.memberValuePairs.isEmpty();
    }

    public boolean isSingleMemberAnnotation() {
        return this.value != null;
    }

    public boolean isNormalAnnotation() {
        return this.memberValuePairs.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(this.typeName);
        if (this.value != null) {
            sb.append("(");
            sb.append(this.value.getExpression());
            sb.append(")");
        }
        if (!this.memberValuePairs.isEmpty()) {
            sb.append("(");
            int i = 0;
            for (String key : this.memberValuePairs.keySet()) {
                sb.append(key).append(" = ").append(this.memberValuePairs.get(key).getExpression());
                if (i < this.memberValuePairs.size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.memberValuePairsHashCode();
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.getExpression().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLAnnotation other = (UMLAnnotation)obj;
        if (!this.memberValuePairsEquals(other)) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.getExpression().equals(other.value.getExpression());
    }

    private boolean memberValuePairsEquals(UMLAnnotation other) {
        int otherSize;
        Map<String, AbstractExpression> m = other.memberValuePairs;
        int thisSize = this.memberValuePairs.size();
        if (thisSize != (otherSize = other.memberValuePairs.size())) {
            return false;
        }
        for (Map.Entry<String, AbstractExpression> entry : this.memberValuePairs.entrySet()) {
            String thisKey = entry.getKey();
            AbstractExpression thisValue = entry.getValue();
            if (!(thisValue == null ? m.get(thisKey) != null || !m.containsKey(thisKey) : !thisValue.getExpression().equals(m.get(thisKey).getExpression()))) continue;
            return false;
        }
        return true;
    }

    private int memberValuePairsHashCode() {
        int h = 0;
        for (Map.Entry<String, AbstractExpression> entry : this.memberValuePairs.entrySet()) {
            h += (entry.getKey() == null ? 0 : entry.getKey().hashCode()) ^ (entry.getValue() == null ? 0 : entry.getValue().getExpression().hashCode());
        }
        return h;
    }
}

