/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLFileDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClassMatcher;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLFile;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLGeneralization;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLObject;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLRealization;

public class UMLModel {
    private final Set<String> repositoryDirectories;
    private final List<UMLClass> classList;
    private final List<UMLObject> objectList;
    private final List<UMLGeneralization> generalizationList;
    private final List<UMLRealization> realizationList;
    private final List<UMLFile> fileList;

    public UMLModel(Set<String> repositoryDirectories) {
        this.repositoryDirectories = repositoryDirectories;
        this.classList = new ArrayList<UMLClass>();
        this.objectList = new ArrayList<UMLObject>();
        this.generalizationList = new ArrayList<UMLGeneralization>();
        this.realizationList = new ArrayList<UMLRealization>();
        this.fileList = new ArrayList<UMLFile>();
    }

    public void addClass(UMLClass umlClass) {
        this.classList.add(umlClass);
    }

    public void addObject(UMLObject umlObject) {
        this.objectList.add(umlObject);
    }

    public void addGeneralization(UMLGeneralization umlGeneralization) {
        this.generalizationList.add(umlGeneralization);
    }

    public void addRealization(UMLRealization umlRealization) {
        this.realizationList.add(umlRealization);
    }

    public void addFile(UMLFile umlFile) {
        this.fileList.add(umlFile);
    }

    public UMLClass getClass(UMLClass umlClassFromOtherModel) {
        for (UMLClass umlClass : this.classList) {
            if (!umlClass.equals(umlClassFromOtherModel)) continue;
            return umlClass;
        }
        return null;
    }

    public UMLFile getFile(UMLFile umlFileFromOtherModel) {
        for (UMLFile umlFile : this.fileList) {
            if (!umlFile.equals(umlFileFromOtherModel)) continue;
            return umlFile;
        }
        return null;
    }

    public List<UMLClass> getClassList() {
        return this.classList;
    }

    public List<UMLGeneralization> getGeneralizationList() {
        return this.generalizationList;
    }

    public UMLGeneralization matchGeneralization(UMLGeneralization otherGeneralization) {
        for (UMLGeneralization generalization : this.generalizationList) {
            String otherParentComparedString;
            if (!generalization.getChild().equals(otherGeneralization.getChild())) continue;
            String thisParent = generalization.getParent();
            String otherParent = otherGeneralization.getParent();
            String thisParentComparedString = thisParent.contains(".") ? thisParent.substring(thisParent.lastIndexOf(".") + 1) : thisParent;
            if (!thisParentComparedString.equals(otherParentComparedString = otherParent.contains(".") ? otherParent.substring(otherParent.lastIndexOf(".") + 1) : otherParent)) continue;
            return generalization;
        }
        return null;
    }

    public UMLModelDiff diff(UMLModel umlModel) throws RefactoringMinerTimedOutException {
        return this.diff(umlModel, Collections.emptyMap());
    }

    public UMLModelDiff diff(UMLModel umlModel, Map<String, String> renamedFileHints) throws RefactoringMinerTimedOutException {
        UMLModelDiff modelDiff = new UMLModelDiff();
        for (UMLClass umlClass : this.classList) {
            if (umlModel.classList.contains(umlClass)) continue;
            modelDiff.reportRemovedClass(umlClass);
        }
        for (UMLClass umlClass : umlModel.classList) {
            if (this.classList.contains(umlClass)) continue;
            modelDiff.reportAddedClass(umlClass);
        }
        for (UMLClass umlClass : this.classList) {
            if (!umlModel.classList.contains(umlClass)) continue;
            UMLClassDiff classDiff = new UMLClassDiff(umlClass, umlModel.getClass(umlClass), modelDiff);
            classDiff.process();
            if (classDiff.isEmpty()) continue;
            modelDiff.addUMLClassDiff(classDiff);
        }
        for (UMLGeneralization umlGeneralization : this.generalizationList) {
            if (umlModel.generalizationList.contains(umlGeneralization)) continue;
            modelDiff.reportRemovedGeneralization(umlGeneralization);
        }
        for (UMLGeneralization umlGeneralization : umlModel.generalizationList) {
            if (this.generalizationList.contains(umlGeneralization)) continue;
            modelDiff.reportAddedGeneralization(umlGeneralization);
        }
        modelDiff.checkForGeneralizationChanges();
        for (UMLRealization umlRealization : this.realizationList) {
            if (umlModel.realizationList.contains(umlRealization)) continue;
            modelDiff.reportRemovedRealization(umlRealization);
        }
        for (UMLFile umlFile : this.fileList) {
            if (!umlModel.fileList.contains(umlFile)) continue;
            UMLFileDiff fileDiff = new UMLFileDiff(umlFile, umlModel.getFile(umlFile), modelDiff);
            fileDiff.process();
            if (fileDiff.isEmpty()) continue;
            modelDiff.addUmlFileDiff(fileDiff);
        }
        modelDiff.checkForMovedClasses(renamedFileHints, umlModel.repositoryDirectories, new UMLClassMatcher.Move());
        modelDiff.checkForRenamedClasses(renamedFileHints, new UMLClassMatcher.Rename());
        modelDiff.checkForRenamedClasses(renamedFileHints, new UMLClassMatcher.RelaxedRename());
        return modelDiff;
    }
}

