/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractStatement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationBody;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLJavadoc;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLTypeParameter;

public class UMLOperation
implements Comparable<UMLOperation>,
Serializable,
LocationInfoProvider {
    private final LocationInfo locationInfo;
    private final String name;
    private final List<UMLParameter> parameters;
    private final List<UMLTypeParameter> typeParameters;
    private final List<UMLAnnotation> annotations;
    private String visibility;
    private boolean isAbstract;
    private String className;
    private boolean isConstructor;
    private boolean isFinal;
    private boolean isStatic;
    private boolean emptyBody;
    private OperationBody operationBody;
    private UMLJavadoc javadoc;

    public UMLOperation(String name, LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
        this.name = name;
        this.parameters = new ArrayList<UMLParameter>();
        this.typeParameters = new ArrayList<UMLTypeParameter>();
        this.annotations = new ArrayList<UMLAnnotation>();
    }

    private static boolean equivalentNames(UMLOperation operation1, UMLOperation operation2) {
        boolean equalReturn;
        boolean bl = equalReturn = operation1.equalReturnParameter(operation2) && operation1.getParametersWithoutReturnType().size() > 0 && operation2.getParametersWithoutReturnType().size() > 0;
        if (operation1.name.startsWith(operation2.name) && !operation2.name.equals("get") && !operation2.name.equals("set") && !operation2.name.equals("print")) {
            String suffix1 = operation1.name.substring(operation2.name.length());
            String className2 = operation2.className.contains(".") ? operation2.className.substring(operation2.className.lastIndexOf(".") + 1) : operation2.className;
            return operation2.name.length() > operation1.name.length() - operation2.name.length() || equalReturn || className2.contains(suffix1);
        }
        return false;
    }

    public List<UMLTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void addTypeParameter(UMLTypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean hasEmptyBody() {
        return this.emptyBody;
    }

    public void setEmptyBody(boolean emptyBody) {
        this.emptyBody = emptyBody;
    }

    public OperationBody getBody() {
        return this.operationBody;
    }

    public void setBody(OperationBody body) {
        this.operationBody = body;
    }

    public boolean hasTestAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("Test")) continue;
            return true;
        }
        return false;
    }

    public boolean testAnnotationCheck(UMLOperation operation) {
        if (this.hasTestAnnotation() && !operation.hasTestAnnotation()) {
            return false;
        }
        return this.hasTestAnnotation() || !operation.hasTestAnnotation();
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    public List<String> getAllVariables() {
        if (this.operationBody != null) {
            return this.operationBody.getAllVariables();
        }
        return new ArrayList<String>();
    }

    public List<VariableDeclaration> getAllVariableDeclarations() {
        if (this.operationBody != null) {
            return this.operationBody.getAllVariableDeclarations();
        }
        return new ArrayList<VariableDeclaration>();
    }

    public VariableDeclaration getVariableDeclaration(String variableName) {
        if (this.operationBody != null) {
            return this.operationBody.getVariableDeclaration(variableName);
        }
        return null;
    }

    public Map<String, UMLType> variableTypeMap() {
        LinkedHashMap<String, UMLType> variableTypeMap = new LinkedHashMap<String, UMLType>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            variableTypeMap.put(parameter.getName(), parameter.getType());
        }
        for (VariableDeclaration declaration : this.getAllVariableDeclarations()) {
            variableTypeMap.put(declaration.getVariableName(), declaration.getType());
        }
        return variableTypeMap;
    }

    public int statementCount() {
        if (this.operationBody != null) {
            return this.operationBody.statementCount();
        }
        return 0;
    }

    public String getNonQualifiedClassName() {
        return this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1) : this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addParameter(UMLParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<UMLParameter> getParameters() {
        return this.parameters;
    }

    public UMLParameter getReturnParameter() {
        for (UMLParameter parameter : this.parameters) {
            if (!parameter.getKind().equals("return")) continue;
            return parameter;
        }
        return null;
    }

    public List<VariableDeclaration> getParameterDeclarationList() {
        ArrayList<VariableDeclaration> parameterDeclarationList = new ArrayList<VariableDeclaration>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterDeclarationList.add(parameter.getVariableDeclaration());
        }
        return parameterDeclarationList;
    }

    public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration parameterDeclaration : this.getParameterDeclarationList()) {
            if (!parameterDeclaration.getScope().subsumes(location)) continue;
            variableDeclarations.add(parameterDeclaration);
        }
        if (this.operationBody != null) {
            variableDeclarations.addAll(this.operationBody.getVariableDeclarationsInScope(location));
        }
        return variableDeclarations;
    }

    public boolean equalReturnParameter(UMLOperation operation) {
        UMLParameter thisReturnParameter = this.getReturnParameter();
        UMLParameter otherReturnParameter = operation.getReturnParameter();
        if (thisReturnParameter != null && otherReturnParameter != null) {
            return thisReturnParameter.equals(otherReturnParameter);
        }
        return thisReturnParameter == null && otherReturnParameter == null;
    }

    public boolean equalQualifiedReturnParameter(UMLOperation operation) {
        UMLParameter thisReturnParameter = this.getReturnParameter();
        UMLParameter otherReturnParameter = operation.getReturnParameter();
        if (thisReturnParameter != null && otherReturnParameter != null) {
            return thisReturnParameter.equalsQualified(otherReturnParameter);
        }
        return thisReturnParameter == null && otherReturnParameter == null;
    }

    public boolean equalSignature(UMLOperation operation) {
        boolean equalParameterTypes = this.getParameterTypeList().equals(operation.getParameterTypeList());
        boolean compatibleParameterTypes = false;
        if (!equalParameterTypes) {
            List<UMLType> thisParameterTypeList = this.getParameterTypeList();
            List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
            if (thisParameterTypeList.size() != 0 && thisParameterTypeList.size() == otherParameterTypeList.size()) {
                int compatibleTypes = 0;
                int equalTypes = 0;
                for (int i = 0; i < thisParameterTypeList.size(); ++i) {
                    UMLType thisParameterType = thisParameterTypeList.get(i);
                    UMLType otherParameterType = otherParameterTypeList.get(i);
                    if (thisParameterType != null && otherParameterType != null && thisParameterType.getClassType() != null && otherParameterType.getClassType() != null) {
                        if ((thisParameterType.getClassType().endsWith("." + otherParameterType.getClassType()) || otherParameterType.getClassType().endsWith("." + thisParameterType.getClassType())) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension()) {
                            ++compatibleTypes;
                        } else if (thisParameterType.equals(otherParameterType)) {
                            ++equalTypes;
                        }
                    }
                    if (equalTypes + compatibleTypes != thisParameterTypeList.size()) continue;
                    compatibleParameterTypes = true;
                }
            }
        }
        return this.name.equals(operation.name) && this.equalTypeParameters(operation) && (equalParameterTypes || compatibleParameterTypes) && this.equalReturnParameter(operation);
    }

    public boolean equalSignatureIgnoringOperationName(UMLOperation operation) {
        return this.visibility.equals(operation.visibility) && this.isAbstract == operation.isAbstract && this.isFinal == operation.isFinal && this.isStatic == operation.isStatic && this.parameters.equals(operation.parameters) && this.equalTypeParameters(operation);
    }

    public boolean equalSignatureIgnoringChangedTypes(UMLOperation operation) {
        if (!(this.isConstructor && operation.isConstructor || this.equivalentName(operation))) {
            return false;
        }
        if (this.isAbstract != operation.isAbstract) {
            return false;
        }
        if (this.parameters.size() != operation.parameters.size()) {
            return false;
        }
        if (!this.equalTypeParameters(operation)) {
            return false;
        }
        int i = 0;
        for (UMLParameter thisParameter : this.parameters) {
            UMLParameter otherParameter;
            if (!thisParameter.equals(otherParameter = operation.parameters.get(i)) && !thisParameter.equalsExcludingType(otherParameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public OperationInvocation isDelegate() {
        List<AbstractStatement> statements;
        if (this.getBody() != null && (statements = this.getBody().getCompositeStatement().getStatements()).size() == 1 && statements.get(0) instanceof StatementObject) {
            StatementObject statement = (StatementObject)statements.get(0);
            Map<String, List<OperationInvocation>> operationInvocationMap = statement.getMethodInvocationMap();
            for (String key : operationInvocationMap.keySet()) {
                List<OperationInvocation> operationInvocations = operationInvocationMap.get(key);
                for (OperationInvocation operationInvocation : operationInvocations) {
                    if (!operationInvocation.matchesOperation(this, this.variableTypeMap(), null) && !operationInvocation.getMethodName().equals(this.getName())) continue;
                    return operationInvocation;
                }
            }
        }
        return null;
    }

    public boolean isGetter() {
        if (this.getBody() != null) {
            StatementObject statement;
            List<AbstractStatement> statements = this.getBody().getCompositeStatement().getStatements();
            List<UMLParameter> parameters = this.getParametersWithoutReturnType();
            if (statements.size() == 1 && statements.get(0) instanceof StatementObject && (statement = (StatementObject)statements.get(0)).getString().startsWith("return ")) {
                for (String variable : statement.getVariables()) {
                    if (statement.getString().equals("return " + variable + "\n") && parameters.size() == 0) {
                        return true;
                    }
                    if (statement.getString().equals("return " + variable + ".keySet()\n") && parameters.size() == 0) {
                        return true;
                    }
                    if (!statement.getString().equals("return " + variable + ".values()\n") || parameters.size() != 0) continue;
                    return true;
                }
                UMLParameter returnParameter = this.getReturnParameter();
                if ((this.name.startsWith("is") || this.name.startsWith("has")) && parameters.size() == 0 && returnParameter != null && returnParameter.getType().getClassType().equals("Boolean")) {
                    return true;
                }
                return statement.getString().equals("return Null\n");
            }
        }
        return false;
    }

    public boolean equalSignatureWithIdenticalNameIgnoringChangedTypes(UMLOperation operation) {
        if (!(this.isConstructor && operation.isConstructor || this.name.equals(operation.name))) {
            return false;
        }
        if (this.isAbstract != operation.isAbstract) {
            return false;
        }
        if (this.parameters.size() != operation.parameters.size()) {
            return false;
        }
        if (!this.equalTypeParameters(operation)) {
            return false;
        }
        int i = 0;
        for (UMLParameter thisParameter : this.parameters) {
            UMLParameter otherParameter;
            if (!thisParameter.equals(otherParameter = operation.parameters.get(i)) && !thisParameter.equalsExcludingType(otherParameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equivalentName(UMLOperation operation) {
        return this.name.equals(operation.name) || UMLOperation.equivalentNames(this, operation) || UMLOperation.equivalentNames(operation, this);
    }

    public double normalizedNameDistance(UMLOperation operation) {
        String s1 = this.getName().toLowerCase();
        String s2 = operation.getName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public List<String> stringRepresentation() {
        if (this.operationBody != null) {
            return this.operationBody.stringRepresentation();
        }
        return new ArrayList<String>();
    }

    public List<UMLParameter> getParametersWithoutReturnType() {
        ArrayList<UMLParameter> params = new ArrayList<UMLParameter>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            params.add(parameter);
        }
        return params;
    }

    public List<UMLType> commonParameterTypes(UMLOperation operation) {
        ArrayList<UMLType> commonParameterTypes = new ArrayList<UMLType>();
        List<UMLType> thisParameterTypeList = this.getParameterTypeList();
        List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
        int min = Math.min(thisParameterTypeList.size(), otherParameterTypeList.size());
        for (int i = 0; i < min; ++i) {
            UMLType otherParameterType;
            UMLType thisParameterType = thisParameterTypeList.get(i);
            if (!thisParameterType.equals(otherParameterType = otherParameterTypeList.get(i))) continue;
            commonParameterTypes.add(thisParameterType);
        }
        return commonParameterTypes;
    }

    public List<UMLType> getParameterTypeList() {
        ArrayList<UMLType> parameterTypeList = new ArrayList<UMLType>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterTypeList.add(parameter.getType());
        }
        return parameterTypeList;
    }

    public List<String> getParameterNameList() {
        ArrayList<String> parameterNameList = new ArrayList<String>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterNameList.add(parameter.getName());
        }
        return parameterNameList;
    }

    public int getNumberOfNonVarargsParameters() {
        int counter = 0;
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return") || parameter.isVarargs()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean hasVarargsParameter() {
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return") || !parameter.isVarargs()) continue;
            return true;
        }
        return false;
    }

    public boolean overridesObject() {
        return this.isHashCode() || this.isToString() || this.isClone() || this.isCompareTo();
    }

    public boolean equalsIgnoringVisibility(UMLOperation operation) {
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
        return this.className.equals(operation.className) && this.name.equals(operation.name) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    public boolean equalsIgnoringNameCase(UMLOperation operation) {
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
        return this.className.equals(operation.className) && this.name.equalsIgnoreCase(operation.name) && this.visibility.equals(operation.visibility) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLOperation) {
            UMLOperation operation = (UMLOperation)o;
            boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
            boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
            return this.className.equals(operation.className) && this.name.equals(operation.name) && this.visibility.equals(operation.visibility) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
        }
        return false;
    }

    public boolean equalsQualified(UMLOperation operation) {
        if (this.className.equals(operation.className) && this.name.equals(operation.name) && this.visibility.equals(operation.visibility) && this.isAbstract == operation.isAbstract && this.equalTypeParameters(operation)) {
            UMLParameter thisReturnParameter = this.getReturnParameter();
            UMLParameter otherReturnParameter = operation.getReturnParameter();
            if (thisReturnParameter != null && otherReturnParameter != null && !thisReturnParameter.getType().equalsQualified(otherReturnParameter.getType())) {
                return false;
            }
            List<UMLType> thisParameterTypeList = this.getParameterTypeList();
            List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
            if (thisParameterTypeList.size() != otherParameterTypeList.size()) {
                return false;
            }
            for (int i = 0; i < thisParameterTypeList.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypeList.get(i);
                if (thisParameterType.equalsQualified(otherParameterType = otherParameterTypeList.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.isAbstract ? 1231 : 1237);
        result = 31 * result + (thisEmptyBody ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.visibility == null ? 0 : this.visibility.hashCode());
        result = 31 * result + this.typeParameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.visibility);
        sb.append(" ");
        if (this.isAbstract) {
            sb.append("abstract");
            sb.append(" ");
        }
        sb.append(this.name);
        UMLParameter returnParameter = this.getReturnParameter();
        ArrayList<UMLParameter> parameters = new ArrayList<UMLParameter>(this.parameters);
        parameters.remove(returnParameter);
        sb.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            UMLParameter parameter = (UMLParameter)parameters.get(i);
            if (!parameter.getKind().equals("in")) continue;
            sb.append(parameter);
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (returnParameter != null) {
            sb.append(" : ");
            sb.append(returnParameter);
        }
        return sb.toString();
    }

    public String toQualifiedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.visibility);
        sb.append(" ");
        if (this.isAbstract) {
            sb.append("abstract");
            sb.append(" ");
        }
        sb.append(this.name);
        UMLParameter returnParameter = this.getReturnParameter();
        ArrayList<UMLParameter> parameters = new ArrayList<UMLParameter>(this.parameters);
        parameters.remove(returnParameter);
        sb.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            UMLParameter parameter = (UMLParameter)parameters.get(i);
            if (!parameter.getKind().equals("in")) continue;
            sb.append(parameter.toQualifiedString());
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (returnParameter != null) {
            sb.append(" : ");
            sb.append(returnParameter.toQualifiedString());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLOperation operation) {
        return this.toString().compareTo(operation.toString());
    }

    public boolean equalParameters(UMLOperation operation) {
        return this.equalReturnParameter(operation) && this.getParameters().equals(operation.getParameters());
    }

    public boolean equalParameterTypes(UMLOperation operation) {
        return this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    private boolean equalTypeParameters(UMLOperation operation) {
        return this.typeParameters.equals(operation.typeParameters);
    }

    public boolean equalParameterNames(UMLOperation operation) {
        return this.equalReturnParameter(operation) && this.getParameterNameList().equals(operation.getParameterNameList());
    }

    public boolean overloadedParameters(UMLOperation operation) {
        return this.equalReturnParameter(operation) && (this.getParameters().containsAll(operation.getParameters()) || operation.getParameters().containsAll(this.getParameters()));
    }

    public boolean overloadedParameterTypes(UMLOperation operation) {
        return this.equalReturnParameter(operation) && (this.getParameterTypeList().containsAll(operation.getParameterTypeList()) || operation.getParameterTypeList().containsAll(this.getParameterTypeList()));
    }

    public boolean replacedParameterTypes(UMLOperation operation) {
        List<UMLType> thisParameterTypes = this.getParameterTypeList();
        List<UMLType> otherParameterTypes = operation.getParameterTypeList();
        if (thisParameterTypes.size() == otherParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < thisParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        if (thisParameterTypes.size() > otherParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < otherParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        if (otherParameterTypes.size() > thisParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < thisParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        return false;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    private boolean isHashCode() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("hashCode") && this.getReturnParameter().getType().getClassType().equals("Int") && parameterTypeList.size() == 0;
    }

    private boolean isToString() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("toString") && this.getReturnParameter().getType().getClassType().equals("String") && parameterTypeList.size() == 0;
    }

    private boolean isClone() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("clone") && this.getReturnParameter().getType().getClassType().equals("Object") && parameterTypeList.size() == 0;
    }

    private boolean isCompareTo() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("compareTo") && this.getReturnParameter().getType().getClassType().equals("Int") && parameterTypeList.size() == 1;
    }

    public boolean compatibleSignature(UMLOperation removedOperation) {
        return this.equalParameterTypes(removedOperation) || this.overloadedParameterTypes(removedOperation) || this.replacedParameterTypes(removedOperation) || this.equalParameterNames(removedOperation);
    }

    public boolean hasTwoParametersWithTheSameType() {
        List<UMLType> parameterTypes = this.getParameterTypeList();
        if (parameterTypes.size() == 2) {
            return parameterTypes.get(0).equals(parameterTypes.get(1));
        }
        return false;
    }

    public Map<String, Set<String>> aliasedAttributes() {
        if (this.operationBody != null && this.isConstructor) {
            List<String> parameterNames = this.getParameterNameList();
            Map<String, Set<String>> map = this.operationBody.aliasedAttributes();
            LinkedHashSet<String> keysToBeRemoved = new LinkedHashSet<String>();
            for (String key : map.keySet()) {
                if (parameterNames.contains(key)) continue;
                keysToBeRemoved.add(key);
            }
            for (String key : keysToBeRemoved) {
                map.remove(key);
            }
            return map;
        }
        return new LinkedHashMap<String, Set<String>>();
    }

    public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        if (this.operationBody != null) {
            return this.operationBody.loopWithVariables(currentElementName, collectionName);
        }
        return null;
    }

    public List<OperationInvocation> getAllOperationInvocations() {
        if (this.operationBody != null) {
            return this.operationBody.getAllOperationInvocations();
        }
        return new ArrayList<OperationInvocation>();
    }

    public List<LambdaExpressionObject> getAllLambdas() {
        if (this.operationBody != null) {
            return this.operationBody.getAllLambdas();
        }
        return new ArrayList<LambdaExpressionObject>();
    }
}

